/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.VCircle;
import fr.inria.zvtm.glyphs.VEllipse;
import fr.inria.zvtm.glyphs.VImage;
import fr.inria.zvtm.glyphs.VPolygon;
import fr.inria.zvtm.glyphs.VRectangle;
import fr.inria.zvtm.glyphs.VRoundRect;
import fr.inria.zvtm.glyphs.VShape;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class GlyphUtils {
    public static Shape getJava2DShape(Glyph g) {
        if (g instanceof VEllipse) {
            VEllipse el1 = (VEllipse)g;
            return new Ellipse2D.Double(el1.vx - el1.getWidth(), el1.vy - el1.getHeight(), el1.getWidth() * 2.0, el1.getHeight() * 2.0);
        }
        if (g instanceof VRectangle) {
            VRectangle el1 = (VRectangle)g;
            return new Rectangle2D.Double(el1.vx - el1.getWidth(), el1.vy - el1.getHeight(), el1.getWidth() * 2.0, el1.getHeight() * 2.0);
        }
        if (g instanceof VRoundRect) {
            VRoundRect el1 = (VRoundRect)g;
            return new RoundRectangle2D.Double(el1.vx - el1.getWidth(), el1.vy - el1.getHeight(), el1.getWidth() * 2.0, el1.getHeight() * 2.0, el1.getArcWidth(), el1.getArcHeight());
        }
        if (g instanceof VCircle) {
            return new Ellipse2D.Double(g.vx - g.getSize(), g.vy - g.getSize(), g.getSize() * 2.0, g.getSize() * 2.0);
        }
        if (g instanceof VShape) {
            VShape sh1 = (VShape)g;
            double vertexAngle = sh1.getOrient();
            float[] vertices = sh1.getVertices();
            int[] xcoords = new int[vertices.length];
            int[] ycoords = new int[vertices.length];
            double size = g.getSize();
            for (int j = 0; j < vertices.length - 1; ++j) {
                xcoords[j] = (int)Math.round(sh1.vx + size * Math.cos(vertexAngle) * (double)vertices[j]);
                ycoords[j] = (int)Math.round(sh1.vy + size * Math.sin(vertexAngle) * (double)vertices[j]);
                vertexAngle += Math.PI * 2 / (double)vertices.length;
            }
            xcoords[vertices.length - 1] = (int)Math.round(sh1.vx + size * Math.cos(vertexAngle) * (double)vertices[vertices.length - 1]);
            ycoords[vertices.length - 1] = (int)Math.round(sh1.vy + size * Math.sin(vertexAngle) * (double)vertices[vertices.length - 1]);
            return new Polygon(xcoords, ycoords, vertices.length);
        }
        if (g instanceof VPolygon) {
            VPolygon pg1 = (VPolygon)g;
            Point2D.Double[] vertices = pg1.getVertices();
            int[] xcoords = new int[vertices.length];
            int[] ycoords = new int[vertices.length];
            for (int j = 0; j < vertices.length; ++j) {
                xcoords[j] = (int)Math.round(pg1.vx + vertices[j].x);
                ycoords[j] = (int)Math.round(pg1.vy + vertices[j].y);
            }
            return new Polygon(xcoords, ycoords, vertices.length);
        }
        if (g instanceof VImage) {
            VImage im1 = (VImage)g;
            return new Rectangle2D.Double(im1.vx - im1.getWidth(), im1.vy - im1.getHeight(), im1.getWidth() * 2.0, im1.getHeight() * 2.0);
        }
        return new Rectangle2D.Double(g.vx, g.vy, 1.0, 1.0);
    }

    public static Glyph basicClone(Glyph g) {
        if (g instanceof Cloneable) {
            return (Glyph)g.clone();
        }
        return null;
    }
}

