/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferencingType;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.statements.Port_Utility;
import org.eclipse.titan.designer.AST.TTCN3.statements.Start_Component_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class UnusedStartedFuncRetVal
extends BaseModuleCodeSmellSpotter {
    private static final String PROBLEM = "Return type of function type `{0}'' is `{1}'', which does not have the `done'' extension attibute.When the test component terminates the returnes value cannot be retrived with a `done'' operation";

    public UnusedStartedFuncRetVal() {
        super(CodeSmellType.UNUSED_STARTED_FUNCTION_RETURN_VALUES);
    }

    @Override
    public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        if (node instanceof Start_Component_Statement) {
            CompilationTimeStamp timestamp = CompilationTimeStamp.getBaseTimestamp();
            Start_Component_Statement s = (Start_Component_Statement)node;
            Component_Type compType = Port_Utility.checkComponentReference((CompilationTimeStamp)timestamp, (Statement)s, (IValue)s.getComponent(), (boolean)false, (boolean)false);
            Assignment assignment = s.getFunctionInstanceReference().getRefdAssignment(timestamp, false);
            if (assignment == null) {
                return;
            }
            switch (assignment.getAssignmentType()) {
                case A_FUNCTION: 
                case A_FUNCTION_RTEMP: 
                case A_FUNCTION_RVAL: {
                    break;
                }
                default: {
                    return;
                }
            }
            Def_Function function = (Def_Function)assignment;
            Component_Type runsOnType = function.getRunsOnType(timestamp);
            if (compType == null || runsOnType == null || !function.isStartable()) {
                return;
            }
            switch (function.getAssignmentType()) {
                case A_FUNCTION_RTEMP: {
                    break;
                }
                case A_FUNCTION_RVAL: {
                    Type type = function.getType(timestamp);
                    boolean returnTypeCorrect = false;
                    while (!returnTypeCorrect) {
                        if (type.hasDoneAttribute()) {
                            returnTypeCorrect = true;
                            break;
                        }
                        if (!(type instanceof IReferencingType)) break;
                        ReferenceChain refChain = ReferenceChain.getInstance((String)"Circular reference chain: `{0}''", (boolean)true);
                        IType refd = ((IReferencingType)type).getTypeRefd(timestamp, (IReferenceChain)refChain);
                        refChain.release();
                        if (type == refd) break;
                        type = refd;
                    }
                    if (returnTypeCorrect) break;
                    String msg = MessageFormat.format(PROBLEM, function.getDescription(), function.getType(timestamp).getTypename());
                    problems.report(s.getFunctionInstanceReference().getLocation(), msg);
                    break;
                }
            }
        }
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
        ret.add(Start_Component_Statement.class);
        return ret;
    }
}

