/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.statements.SelectCase;
import org.eclipse.titan.designer.AST.TTCN3.statements.SelectCase_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.SelectCases;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstances;
import org.eclipse.titan.designer.AST.TTCN3.types.Integer_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Referenced_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class SelectWithNumbersSorted
extends BaseModuleCodeSmellSpotter {
    private static final String ERR_MSG = "Select cases are not listed in incremental order.";
    private final CompilationTimeStamp timestamp = CompilationTimeStamp.getBaseTimestamp();

    public SelectWithNumbersSorted() {
        super(CodeSmellType.SELECT_WITH_NUMBERS_SORTED);
    }

    @Override
    protected void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        if (!(node instanceof SelectCase_Statement)) {
            return;
        }
        SelectCase_Statement s = (SelectCase_Statement)node;
        Value v = s.getExpression();
        if (v == null || v.getIsErroneous(this.timestamp)) {
            return;
        }
        SelectCases scs = s.getSelectCases();
        if (scs == null || scs.getSelectCaseArray() == null) {
            return;
        }
        for (SelectCase sc : scs.getSelectCaseArray()) {
            if (!sc.hasElse()) continue;
            return;
        }
        IType itype = v.getExpressionGovernor(this.timestamp, Expected_Value_type.EXPECTED_TEMPLATE);
        if (itype instanceof Referenced_Type) {
            itype = itype.getTypeRefdLast(this.timestamp);
        }
        if (itype == null || !(itype instanceof Integer_Type)) {
            return;
        }
        CaseVisitorInteger caseVisitorInteger = new CaseVisitorInteger();
        scs.accept((ASTVisitor)caseVisitorInteger);
        List<Long> usedIntegerItems = caseVisitorInteger.getItemsUsed();
        if (caseVisitorInteger.containsUnfoldable()) {
            return;
        }
        if (!this.checkIfIntegerCasesSorted(usedIntegerItems).booleanValue()) {
            problems.report(s.getLocation(), ERR_MSG);
        }
    }

    private Boolean checkIfIntegerCasesSorted(List<Long> usedIntegerItems) {
        for (int i = 0; i < usedIntegerItems.size() - 1; ++i) {
            if (usedIntegerItems.get(i) <= usedIntegerItems.get(i + 1)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
        ret.add(SelectCase_Statement.class);
        return ret;
    }

    private final class CaseVisitorInteger
    extends ASTVisitor {
        private List<Long> itemsUsed = new ArrayList<Long>();
        private boolean foundUnfoldable = false;

        private CaseVisitorInteger() {
        }

        public List<Long> getItemsUsed() {
            return this.itemsUsed;
        }

        public boolean containsUnfoldable() {
            return this.foundUnfoldable;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof SelectCases) {
                return 3;
            }
            if (node instanceof SelectCase) {
                return 3;
            }
            if (node instanceof TemplateInstances) {
                return 3;
            }
            if (node instanceof TemplateInstance) {
                TemplateInstance ti = (TemplateInstance)node;
                IValue val = ti.getTemplateBody().getValue();
                if (val == null || val.getIsErroneous(SelectWithNumbersSorted.this.timestamp) || val.isUnfoldable(SelectWithNumbersSorted.this.timestamp)) {
                    this.foundUnfoldable = true;
                    return 2;
                }
                if (val instanceof Integer_Value) {
                    Long id = ((Integer_Value)val).getValue();
                    this.itemsUsed.add(id);
                }
                return 1;
            }
            return 1;
        }
    }
}

