/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.gui.layouts.algorithms;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titanium.error.ErrorMessage;
import org.eclipse.titanium.graph.components.NodeDescriptor;
import org.eclipse.titanium.graph.gui.layouts.algorithms.HierarcicalLayoutAlgorithm;
import org.eclipse.titanium.metrics.IMetricEnum;
import org.eclipse.titanium.metrics.preferences.PreferenceManager;
import org.eclipse.titanium.metrics.utils.ModuleMetricsWrapper;
import org.eclipse.titanium.metrics.utils.WrapperStore;

public class MetricLayoutAlgorithm
implements HierarcicalLayoutAlgorithm<NodeDescriptor> {
    private static final int LEVELS = 10;
    private static final double EPSILON = Math.pow(10.0, -6.0);
    private Map<NodeDescriptor, Double> values;
    private Map<NodeDescriptor, Integer> levels;
    private Collection<NodeDescriptor> nodes;
    private Set<NodeDescriptor> badNodes;
    private IMetricEnum chosenMetric;
    private Double minValue;
    private Double maxValue;
    private int filledLevels;
    private int[] nodeCount;

    public MetricLayoutAlgorithm(IMetricEnum metric, Collection<NodeDescriptor> nodes) {
        this.nodes = new HashSet<NodeDescriptor>(nodes);
        this.chosenMetric = metric;
    }

    private void init() {
        this.values = new HashMap<NodeDescriptor, Double>();
        this.levels = new HashMap<NodeDescriptor, Integer>();
        this.badNodes = new HashSet<NodeDescriptor>();
        this.minValue = Double.POSITIVE_INFINITY;
        this.maxValue = Double.NEGATIVE_INFINITY;
        this.filledLevels = 0;
        if (!PreferenceManager.isEnabledOnModuleGraph(this.chosenMetric)) {
            ErrorReporter.logError((String)"Error during metric layout generating: The requested metric is not enabled. Only enabled metrics can be chosen!");
            ErrorMessage.show("Error", "The chosen metric must be enabled for calculation in the properties.Have you enabled it?", 1);
            return;
        }
        Iterator<NodeDescriptor> it = this.nodes.iterator();
        while (it.hasNext()) {
            NodeDescriptor node = it.next();
            ModuleMetricsWrapper wrapper = WrapperStore.getWrapper(node.getProject());
            Number val = wrapper.getValue(this.chosenMetric, node.getName());
            if (val == null) {
                it.remove();
                this.badNodes.add(node);
                continue;
            }
            Double tempVal = Double.valueOf(val.toString());
            if (tempVal == null) continue;
            this.values.put(node, tempVal);
            if (this.minValue > tempVal) {
                this.minValue = tempVal;
            }
            if (!(this.maxValue < tempVal)) continue;
            this.maxValue = tempVal;
        }
    }

    private void genLevels() {
        this.filledLevels = this.badNodes.isEmpty() ? 0 : 1;
        double step = (this.maxValue - this.minValue) / 10.0;
        double actBound = this.minValue + step;
        for (int actLevel = 0; actLevel < 10; ++actLevel) {
            Iterator<NodeDescriptor> it = this.nodes.iterator();
            boolean isEmpty = true;
            while (it.hasNext()) {
                NodeDescriptor node = it.next();
                Double value = this.values.get(node);
                if (value == null || !(value < actBound) && !(Math.abs(value - actBound) <= EPSILON)) continue;
                this.levels.put(node, this.filledLevels);
                it.remove();
                isEmpty = false;
            }
            if (!isEmpty) {
                ++this.filledLevels;
            }
            actBound += step;
        }
        this.genLevelNumbers();
    }

    private void genLevelNumbers() {
        this.nodeCount = new int[this.filledLevels];
        for (int i = 0; i < this.filledLevels; ++i) {
            this.nodeCount[i] = 0;
        }
        int badNodeCount = this.badNodes.size();
        if (badNodeCount != 0) {
            this.nodeCount[0] = badNodeCount;
        }
        Iterator<Integer> iterator = this.levels.values().iterator();
        while (iterator.hasNext()) {
            int actIndex;
            int n = actIndex = iterator.next().intValue();
            this.nodeCount[n] = this.nodeCount[n] + 1;
        }
    }

    @Override
    public int getNumberOfLevels() {
        return this.filledLevels;
    }

    @Override
    public Map<NodeDescriptor, Integer> getLevels() {
        return this.levels;
    }

    @Override
    public int[] getNumberOfNodesPerLevel() {
        return this.nodeCount;
    }

    @Override
    public Set<NodeDescriptor> getIsolateNodes() {
        return this.badNodes;
    }

    @Override
    public void run() {
        this.init();
        this.genLevels();
    }
}

