/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.search;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.titan.log.viewer.models.FilterPattern;
import org.eclipse.titan.log.viewer.parsers.data.LogRecord;
import org.eclipse.titan.log.viewer.utils.Constants;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class SearchPattern {
    private FilterPattern filterPattern;
    private IWorkingSet[] workingSets;
    private int scope;

    public SearchPattern(String searchString, boolean isCaseSensitive, boolean isRegularExpression, Map<String, Boolean> events, Map<FilterPattern.Field, Boolean> limitTo, int scope, IWorkingSet[] workingsets) {
        this.filterPattern = new FilterPattern(searchString, limitTo, isCaseSensitive, isRegularExpression);
        this.filterPattern.setEventsToFilter(events, true, false);
        this.scope = scope;
        this.workingSets = workingsets;
    }

    public SearchPattern(FilterPattern filterPattern, int scope, IWorkingSet[] workingsets) {
        this.filterPattern = filterPattern;
        this.scope = scope;
        this.workingSets = workingsets;
    }

    public SortedMap<String, Boolean> getEvents() {
        return this.filterPattern.getEventsToFilter();
    }

    public String getSearchString() {
        return this.filterPattern.getFilterExpression();
    }

    public Map<FilterPattern.Field, Boolean> getLimitTo() {
        return this.filterPattern.getFieldsToFilter();
    }

    public boolean isCaseSensitive() {
        return this.filterPattern.isCaseSensitive();
    }

    public boolean isRegularExpression() {
        return this.filterPattern.isRegularExpression();
    }

    public IWorkingSet[] getWorkingSets() {
        return this.workingSets;
    }

    public int getScope() {
        return this.scope;
    }

    public boolean match(LogRecord record) {
        return this.filterPattern.match(record);
    }

    /*
     * WARNING - void declaration
     */
    public void store(IDialogSettings settings) {
        settings.put("searchString", this.filterPattern.getFilterExpression());
        settings.put("isCaseSensitive", this.filterPattern.isCaseSensitive());
        settings.put("isRegularExpression", this.filterPattern.isRegularExpression());
        for (Map.Entry<String, Boolean> entry : this.filterPattern.getEventsToFilter().entrySet()) {
            settings.put(entry.getKey(), entry.getValue().booleanValue());
        }
        for (Map.Entry<Object, Boolean> entry : this.filterPattern.getFieldsToFilter().entrySet()) {
            settings.put(((FilterPattern.Field)((Object)entry.getKey())).toString(), entry.getValue().booleanValue());
        }
        settings.put("scope", this.scope);
        if (this.workingSets != null) {
            void var3_7;
            String[] wsIds = new String[this.workingSets.length];
            boolean bl = false;
            while (var3_7 < this.workingSets.length) {
                wsIds[var3_7] = this.workingSets[var3_7].getName();
                ++var3_7;
            }
            settings.put("workingSets", wsIds);
        } else {
            settings.put("workingSets", new String[0]);
        }
    }

    public static SearchPattern create(IDialogSettings settings) {
        String loadedSearchString = settings.get("searchString");
        boolean loadedIsCaseSensitive = settings.getBoolean("isCaseSensitive");
        boolean loadedIsRegularExpression = settings.getBoolean("isRegularExpression");
        TreeMap<String, Boolean> loadedEvents = new TreeMap<String, Boolean>();
        for (String entry : Constants.EVENT_CATEGORIES.keySet()) {
            loadedEvents.put(entry, settings.getBoolean(entry));
        }
        HashMap<FilterPattern.Field, Boolean> loadedLimitTo = new HashMap<FilterPattern.Field, Boolean>();
        loadedLimitTo.put(FilterPattern.Field.SOURCE_INFO, settings.getBoolean(FilterPattern.Field.SOURCE_INFO.toString()));
        loadedLimitTo.put(FilterPattern.Field.MESSAGE, settings.getBoolean(FilterPattern.Field.MESSAGE.toString()));
        FilterPattern loadedFilterPattern = new FilterPattern(loadedSearchString, loadedLimitTo, loadedIsCaseSensitive, loadedIsRegularExpression);
        loadedFilterPattern.setEventsToFilter(loadedEvents, true, false);
        String[] wsIds = settings.getArray("workingSets");
        IWorkingSet[] workingSets = null;
        if (wsIds != null && wsIds.length > 0) {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            workingSets = new IWorkingSet[wsIds.length];
            for (int i = 0; workingSets != null && i < wsIds.length; ++i) {
                workingSets[i] = workingSetManager.getWorkingSet(wsIds[i]);
                if (workingSets[i] != null) continue;
                workingSets = null;
            }
        }
        return new SearchPattern(loadedFilterPattern, settings.getInt("scope"), workingSets);
    }
}

