/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.layout;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.graph.Graph;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections15.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateLayout<V, E>
implements Layout<V, E>,
IterativeContext {
    protected Layout<V, E> delegate;
    protected Map<Layout<V, E>, Point2D> layouts = new HashMap<Layout<V, E>, Point2D>();

    public AggregateLayout(Layout<V, E> delegate) {
        this.delegate = delegate;
    }

    public Layout<V, E> getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Layout<V, E> delegate) {
        this.delegate = delegate;
    }

    public void put(Layout<V, E> layout, Point2D center) {
        this.layouts.put(layout, center);
    }

    public Point2D get(Layout<V, E> layout) {
        return this.layouts.get(layout);
    }

    public void remove(Layout<V, E> layout) {
        this.layouts.remove(layout);
    }

    public void removeAll() {
        this.layouts.clear();
    }

    @Override
    public Graph<V, E> getGraph() {
        return this.delegate.getGraph();
    }

    @Override
    public Dimension getSize() {
        return this.delegate.getSize();
    }

    @Override
    public void initialize() {
        this.delegate.initialize();
        for (Layout<V, E> layout : this.layouts.keySet()) {
            layout.initialize();
        }
    }

    @Override
    public boolean isLocked(V v) {
        boolean locked = false;
        for (Layout<V, E> layout : this.layouts.keySet()) {
            locked |= layout.isLocked(v);
        }
        return locked |= this.delegate.isLocked(v);
    }

    @Override
    public void lock(V v, boolean state) {
        for (Layout<V, E> layout : this.layouts.keySet()) {
            if (!layout.getGraph().getVertices().contains(v)) continue;
            layout.lock(v, state);
        }
        this.delegate.lock(v, state);
    }

    @Override
    public void reset() {
        for (Layout<V, E> layout : this.layouts.keySet()) {
            layout.reset();
        }
        this.delegate.reset();
    }

    @Override
    public void setGraph(Graph<V, E> graph) {
        this.delegate.setGraph(graph);
    }

    @Override
    public void setInitializer(Transformer<V, Point2D> initializer) {
        this.delegate.setInitializer(initializer);
    }

    @Override
    public void setLocation(V v, Point2D location) {
        boolean wasInSublayout = false;
        for (Layout<V, E> layout : this.layouts.keySet()) {
            if (!layout.getGraph().getVertices().contains(v)) continue;
            Point2D center = this.layouts.get(layout);
            Dimension d = layout.getSize();
            AffineTransform at = AffineTransform.getTranslateInstance(-center.getX() + (double)(d.width / 2), -center.getY() + (double)(d.height / 2));
            Point2D localLocation = at.transform(location, null);
            layout.setLocation(v, localLocation);
            wasInSublayout = true;
        }
        if (!wasInSublayout && this.getGraph().getVertices().contains(v)) {
            this.delegate.setLocation(v, location);
        }
    }

    @Override
    public void setSize(Dimension d) {
        this.delegate.setSize(d);
    }

    public Map<Layout<V, E>, Point2D> getLayouts() {
        return this.layouts;
    }

    public Point2D transform(V v) {
        boolean wasInSublayout = false;
        for (Layout<V, E> layout : this.layouts.keySet()) {
            if (!layout.getGraph().getVertices().contains(v)) continue;
            wasInSublayout = true;
            Point2D center = this.layouts.get(layout);
            Dimension d = layout.getSize();
            AffineTransform at = AffineTransform.getTranslateInstance(center.getX() - (double)(d.width / 2), center.getY() - (double)(d.height / 2));
            return at.transform((Point2D)layout.transform(v), null);
        }
        if (!wasInSublayout) {
            return (Point2D)this.delegate.transform(v);
        }
        return null;
    }

    @Override
    public boolean done() {
        boolean done = true;
        for (Layout<V, E> layout : this.layouts.keySet()) {
            if (!(layout instanceof IterativeContext)) continue;
            done &= ((IterativeContext)((Object)layout)).done();
        }
        if (this.delegate instanceof IterativeContext) {
            done &= ((IterativeContext)((Object)this.delegate)).done();
        }
        return done;
    }

    @Override
    public void step() {
        IterativeContext context;
        for (Layout<V, E> layout : this.layouts.keySet()) {
            IterativeContext context2;
            if (!(layout instanceof IterativeContext) || (context2 = (IterativeContext)((Object)layout)).done()) continue;
            context2.step();
        }
        if (this.delegate instanceof IterativeContext && !(context = (IterativeContext)((Object)this.delegate)).done()) {
            context.step();
        }
    }
}

