/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.wizards.projectFormat;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.path.TITANPathUtilities;
import org.eclipse.titan.common.path.TitanURIUtil;
import org.eclipse.titan.common.utils.IOUtils;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.core.TITANNature;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.properties.data.DOMErrorHandlerImpl;
import org.eclipse.titan.designer.properties.data.ProjectBuildPropertyData;
import org.eclipse.titan.designer.properties.data.ProjectDocumentHandlingUtility;
import org.eclipse.titan.designer.properties.data.ProjectFileHandler;
import org.eclipse.titan.designer.wizards.projectFormat.EditPathVariableDialog;
import org.eclipse.titan.designer.wizards.projectFormat.NewPathVariableDialog;
import org.eclipse.titan.designer.wizards.projectFormat.NewProjectNameDialog;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.progress.IProgressConstants;
import org.osgi.framework.Bundle;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;
import org.xml.sax.SAXException;

public class TpdImporter {
    private static final String CREATING_PROJECT = "creating project";
    private static final String CREATION_FAILED = "Project creation failed";
    private static final String TPD_XSD = "schema/TPD.xsd";
    private DOMImplementationLS domImplLS;
    private LSParser parser;
    private DOMConfiguration config;
    private Map<String, String> finalProjectNames = new HashMap<String, String>();
    private Map<URI, Document> projectsToImport = new HashMap<URI, Document>();
    private List<URI> importChain = new ArrayList<URI>();
    private boolean wasAutoBuilding;
    private Shell shell;
    private final boolean headless;
    private List<String> searchPaths;
    private Map<String, String> tpdNameAttrMap = new HashMap<String, String>();
    private Map<String, String> tpdURIMap = new HashMap<String, String>();

    public TpdImporter(Shell shell, boolean headless) {
        this.shell = shell;
        this.headless = headless;
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        this.wasAutoBuilding = description.isAutoBuilding();
        description.setAutoBuilding(false);
        try {
            ResourcesPlugin.getWorkspace().setDescription(description);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)"while disabling autobuild on the workspace", (Throwable)e);
        }
        Activator.getDefault().pauseHandlingResourceChanges();
    }

    public boolean internalFinish(String projectFile, boolean isSkipExistingProjects, boolean isOpenPropertiesForAllImports, List<IProject> projectsCreated, IProgressMonitor monitor, List<String> searchPaths) {
        List<IProject> projectsToBeConfigured;
        IProject project;
        if (projectFile == null || "".equals(projectFile.trim())) {
            return false;
        }
        if (searchPaths != null) {
            this.searchPaths = new ArrayList<String>(searchPaths);
        }
        System.setProperty("org.w3c.dom.DOMImplementationSourceList", "com.sun.org.apache.xerces.internal.dom.DOMImplementationSourceImpl");
        DOMImplementationRegistry registry = null;
        try {
            registry = DOMImplementationRegistry.newInstance();
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((String)("While importing from `" + projectFile + "'"), (Throwable)e);
            this.activatePreviousSettings();
            return false;
        }
        DOMImplementation domImpl = registry.getDOMImplementation("LS 3.0");
        this.domImplLS = (DOMImplementationLS)((Object)domImpl);
        this.parser = this.domImplLS.createLSParser((short)1, "http://www.w3.org/2001/XMLSchema");
        this.config = this.parser.getDomConfig();
        DOMErrorHandlerImpl errorHandler = new DOMErrorHandlerImpl();
        this.config.setParameter("error-handler", errorHandler);
        this.config.setParameter("validate", Boolean.TRUE);
        this.config.setParameter("schema-type", "http://www.w3.org/2001/XMLSchema");
        this.config.setParameter("well-formed", Boolean.TRUE);
        this.config.setParameter("validate-if-schema", Boolean.TRUE);
        Validator tpdValidator = null;
        try {
            Schema tpdXsd = TpdImporter.getTPDSchema();
            tpdValidator = tpdXsd.newValidator();
        }
        catch (Exception e) {
            ErrorReporter.INTERNAL_ERROR((String)e.getMessage());
        }
        URI resolvedProjectFileURI = TITANPathUtilities.convertToAbsoluteURI((String)projectFile, (URI)null);
        if (!this.loadURIDocuments(resolvedProjectFileURI, tpdValidator)) {
            return false;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        progress.setTaskName("Loading data");
        SubMonitor projectCreationMonitor = progress.newChild(1);
        projectCreationMonitor.beginTask("Creating required projects", this.projectsToImport.size());
        HashMap<URI, IProject> projectMap = new HashMap<URI, IProject>();
        for (URI uRI : this.projectsToImport.keySet()) {
            Document actualDocument = this.projectsToImport.get(uRI);
            project = this.createProject(actualDocument.getDocumentElement(), uRI.equals(resolvedProjectFileURI) || !isSkipExistingProjects);
            if (project == null) {
                projectCreationMonitor.worked(1);
                continue;
            }
            projectsCreated.add(project);
            projectMap.put(uRI, project);
            try {
                project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "loadLocation"), uRI.getPath().toString());
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While loading referenced project from `" + uRI.getPath() + "'"), (Throwable)e);
            }
            projectCreationMonitor.worked(1);
        }
        projectCreationMonitor.done();
        SubMonitor normalInformationLoadingMonitor = progress.newChild(1);
        normalInformationLoadingMonitor.beginTask("Loading directly stored project information", this.projectsToImport.size());
        for (URI file : this.projectsToImport.keySet()) {
            Element mainElement;
            if (!projectMap.containsKey(file)) {
                normalInformationLoadingMonitor.worked(1);
                continue;
            }
            project = (IProject)projectMap.get(file);
            IPath projectFileFolderPath = new Path(file.getPath()).removeLastSegments(1);
            URI projectFileFolderURI = URIUtil.toURI((IPath)projectFileFolderPath);
            Document actualDocument = this.projectsToImport.get(file);
            if (this.searchPaths != null && !this.searchPaths.isEmpty()) {
                String tpdNameAttrVal = this.tpdNameAttrMap.get(project.getName());
                String tpdURIVal = this.tpdURIMap.get(project.getName());
                if (tpdNameAttrVal != null) {
                    try {
                        project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "useTpdName"), tpdNameAttrVal);
                    }
                    catch (CoreException coreException) {
                        ErrorReporter.logExceptionStackTrace((String)("While setting `useTpdName' for project `" + project.getName() + "'"), (Throwable)coreException);
                    }
                }
                if (tpdURIVal != null) {
                    try {
                        project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "origTpdURI"), tpdURIVal);
                    }
                    catch (CoreException coreException) {
                        ErrorReporter.logExceptionStackTrace((String)("While setting `origTpdURI' for project `" + project.getName() + "'"), (Throwable)coreException);
                    }
                }
            }
            if (!this.loadProjectDataFromNode(mainElement = actualDocument.getDocumentElement(), project, projectFileFolderURI)) {
                return false;
            }
            normalInformationLoadingMonitor.worked(1);
        }
        normalInformationLoadingMonitor.done();
        IPath iPath = new Path(resolvedProjectFileURI.getPath()).removeLastSegments(1);
        URI mainProjectFileFolderURI = URIUtil.toURI((IPath)iPath);
        List<Node> packedProjects = this.loadPackedProjects(this.projectsToImport.get(resolvedProjectFileURI));
        SubMonitor packedInformationLoadingMonitor = progress.newChild(1);
        packedInformationLoadingMonitor.beginTask("Loading packed project information", packedProjects.size());
        for (Node node : packedProjects) {
            IProject project2 = this.createProject(node, false);
            if (project2 == null) {
                packedInformationLoadingMonitor.worked(1);
                continue;
            }
            projectsCreated.add(project2);
            try {
                project2.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "loadLocation"), resolvedProjectFileURI.toString());
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While loading packed project `" + project2.getName() + "'"), (Throwable)e);
            }
            if (!this.loadProjectDataFromNode(node, project2, mainProjectFileFolderURI)) {
                return false;
            }
            packedInformationLoadingMonitor.worked(1);
        }
        packedInformationLoadingMonitor.done();
        IProject mainProject = (IProject)projectMap.get(resolvedProjectFileURI);
        if (mainProject == null) {
            progress.done();
            return false;
        }
        try {
            mainProject.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "useTpdName"), mainProject.getName() + ".tpd");
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While setting `useTpdName' for project `" + mainProject.getName() + "'"), (Throwable)e);
        }
        ArrayList<1> jobs = new ArrayList<1>();
        if (isOpenPropertiesForAllImports) {
            projectsToBeConfigured = projectsCreated;
        } else {
            projectsToBeConfigured = new ArrayList<IProject>();
            projectsToBeConfigured.add(mainProject);
        }
        if (!this.headless) {
            for (final IProject iProject : projectsToBeConfigured) {
                WorkspaceJob loadJob = new WorkspaceJob("Property initilizer for " + iProject.getName()){

                    public IStatus runInWorkspace(IProgressMonitor monitor) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn(null, (IAdaptable)iProject, (String)"org.eclipse.titan.designer.properties.pages.ProjectBuildPropertyPage", null, null);
                                if (dialog != null) {
                                    dialog.open();
                                }
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                loadJob.setUser(false);
                loadJob.setSystem(true);
                loadJob.setRule(iProject.getWorkspace().getRuleFactory().refreshRule((IResource)iProject));
                loadJob.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
                loadJob.schedule();
                jobs.add(loadJob);
            }
            for (WorkspaceJob workspaceJob : jobs) {
                try {
                    workspaceJob.join();
                }
                catch (InterruptedException e) {
                    ErrorReporter.logExceptionStackTrace((String)("Interrupted while performing: " + workspaceJob.getName()), (Throwable)e);
                }
            }
        }
        this.activatePreviousSettings();
        progress.done();
        return true;
    }

    public static void validateTpd(File tpdFile) throws IOException, SAXException {
        Schema tpdXsd = TpdImporter.getTPDSchema();
        Validator validator = tpdXsd.newValidator();
        validator.validate(new StreamSource(tpdFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema getTPDSchema() throws IOException, SAXException {
        Schema schema;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.titan.designer");
        InputStream xsdInputStream = null;
        try {
            xsdInputStream = FileLocator.openStream((Bundle)bundle, (IPath)new Path(TPD_XSD), (boolean)false);
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema result = factory.newSchema(new StreamSource(xsdInputStream));
            xsdInputStream.close();
            schema = result;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(xsdInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)xsdInputStream);
        return schema;
    }

    private void activatePreviousSettings() {
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        if (description.isAutoBuilding() != this.wasAutoBuilding) {
            description.setAutoBuilding(this.wasAutoBuilding);
            try {
                ResourcesPlugin.getWorkspace().setDescription(description);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("Resetting autobuild settings to" + this.wasAutoBuilding), (Throwable)e);
            }
        }
        Activator.getDefault().resumeHandlingResourceChanges();
    }

    private List<Node> loadPackedProjects(Document document) {
        NodeList referencedProjectsList = document.getDocumentElement().getChildNodes();
        Node packed = ProjectFileHandler.getNodebyName(referencedProjectsList, "PackedReferencedProjects");
        if (packed == null) {
            return new ArrayList<Node>();
        }
        ArrayList<Node> result = new ArrayList<Node>();
        NodeList projects = packed.getChildNodes();
        int size = projects.getLength();
        for (int i = 0; i < size; ++i) {
            Node referencedProjectNode = projects.item(i);
            if (!"PackedReferencedProject".equals(referencedProjectNode.getNodeName())) continue;
            result.add(referencedProjectNode);
        }
        return result;
    }

    private boolean loadProjectDataFromNode(Node mainElement, IProject project, URI projectFileFolderURI) {
        NodeList mainNodes = mainElement.getChildNodes();
        Node referencedProjectsNode = ProjectFileHandler.getNodebyName(mainNodes, "ReferencedProjects");
        if (referencedProjectsNode != null && !this.loadReferencedProjectsData(referencedProjectsNode, project)) {
            return false;
        }
        Node pathVariablesNode = ProjectFileHandler.getNodebyName(mainNodes, "PathVariables");
        if (pathVariablesNode != null && !this.loadPathVariables(pathVariablesNode, project.getName())) {
            return false;
        }
        Node foldersNode = ProjectFileHandler.getNodebyName(mainNodes, "Folders");
        if (foldersNode != null && !this.loadFoldersData(foldersNode, project, projectFileFolderURI)) {
            return false;
        }
        Node filesNode = ProjectFileHandler.getNodebyName(mainNodes, "Files");
        if (filesNode != null && !this.loadFilesData(filesNode, project, projectFileFolderURI)) {
            return false;
        }
        ProjectDocumentHandlingUtility.createDocument(project);
        return this.loadConfigurationData(project, mainNodes);
    }

    private boolean loadReferencedProjectsData(Node referencedProjectsNode, IProject project) {
        NodeList referencedProjectsList = referencedProjectsNode.getChildNodes();
        ArrayList<IProject> referencedProjects = new ArrayList<IProject>();
        int size = referencedProjectsList.getLength();
        for (int i = 0; i < size; ++i) {
            IProject tempProject;
            NamedNodeMap attributeMap;
            Node referencedProjectNode = referencedProjectsList.item(i);
            if (referencedProjectNode.getNodeType() != 1 || (attributeMap = referencedProjectNode.getAttributes()) == null) continue;
            Node nameNode = attributeMap.getNamedItem("name");
            if (nameNode == null) {
                this.displayError("Import failed", "Error while importing project " + project.getName() + " the name attribute of the " + i + " th referenced project is missing");
                return false;
            }
            String projectName = nameNode.getTextContent();
            String realProjectName = this.finalProjectNames.get(projectName);
            if (realProjectName != null && realProjectName.length() > 0) {
                tempProject = ResourcesPlugin.getWorkspace().getRoot().getProject(realProjectName);
                referencedProjects.add(tempProject);
                continue;
            }
            tempProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            referencedProjects.add(tempProject);
        }
        try {
            IProjectDescription description = project.getDescription();
            description.setReferencedProjects(referencedProjects.toArray(new IProject[referencedProjects.size()]));
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While setting project references for `" + project.getName() + "'"), (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean loadFoldersData(Node foldersNode, IProject project, URI projectFileFolderURI) {
        URI projectLocationURI = project.getLocationURI();
        NodeList folderNodeList = foldersNode.getChildNodes();
        int size = folderNodeList.getLength();
        for (int i = 0; i < size; ++i) {
            NamedNodeMap attributeMap;
            Node folderItem = folderNodeList.item(i);
            if (folderItem.getNodeType() != 1 || (attributeMap = folderItem.getAttributes()) == null) continue;
            Node projectRelativePathNode = attributeMap.getNamedItem("projectRelativePath");
            if (projectRelativePathNode == null) {
                this.displayError("Import failed", "Error while importing project " + project.getName() + " the project relative path attribute of the " + i + " th folder is missing");
                return false;
            }
            String projectRelativePath = projectRelativePathNode.getTextContent();
            Node relativeURINode = attributeMap.getNamedItem("relativeURI");
            Node rawURINode = attributeMap.getNamedItem("rawURI");
            IFolder folder = project.getFolder(projectRelativePath);
            if (!folder.exists()) {
                try {
                    File tmpFolder;
                    URI absoluteURI;
                    if (relativeURINode != null) {
                        String relativeLocation = relativeURINode.getTextContent();
                        absoluteURI = TITANPathUtilities.convertToAbsoluteURI((String)relativeLocation, (URI)projectFileFolderURI);
                        if (absoluteURI == null) continue;
                        if (TitanURIUtil.isPrefix((URI)projectLocationURI, (URI)absoluteURI)) {
                            folder.create(false, true, null);
                            continue;
                        }
                        tmpFolder = new File(absoluteURI);
                        if (tmpFolder.exists()) {
                            folder.createLink(absoluteURI, 16, null);
                            continue;
                        }
                        ErrorReporter.logError((String)("Error while importing folders into project `" + project.getName() + "'. Folder `" + absoluteURI + "' does not exist"));
                        continue;
                    }
                    if (rawURINode != null) {
                        String rawLocation = rawURINode.getTextContent();
                        absoluteURI = TITANPathUtilities.convertToAbsoluteURI((String)rawLocation, (URI)projectFileFolderURI);
                        if (TitanURIUtil.isPrefix((URI)projectLocationURI, (URI)absoluteURI)) {
                            folder.create(false, true, null);
                            continue;
                        }
                        tmpFolder = new File(absoluteURI);
                        if (tmpFolder.exists()) {
                            folder.createLink(absoluteURI, 16, null);
                            continue;
                        }
                        ErrorReporter.logError((String)("Error while importing folders into project `" + project.getName() + "'. Folder `" + absoluteURI + "' does not exist"));
                        continue;
                    }
                    TITANDebugConsole.getConsole().newMessageStream().println("Cannot create the resource " + folder.getFullPath().toString() + " the location information is missing or corrupted");
                }
                catch (CoreException coreException) {}
                continue;
            }
            ErrorReporter.logWarning((String)("Folder to be imported `" + folder.getName() + "' already exists in project `" + project.getName() + "'"));
        }
        return true;
    }

    private boolean loadFilesData(Node filesNode, IProject project, URI projectFileFolderURI) {
        NodeList fileNodeList = filesNode.getChildNodes();
        int size = fileNodeList.getLength();
        for (int i = 0; i < size; ++i) {
            NamedNodeMap attributeMap;
            Node fileItem = fileNodeList.item(i);
            if (fileItem.getNodeType() != 1 || (attributeMap = fileItem.getAttributes()) == null) continue;
            Node projectRelativePathNode = attributeMap.getNamedItem("projectRelativePath");
            if (projectRelativePathNode == null) {
                this.displayError("Import failed", "Error while importing project " + project.getName() + " some attributes of the " + i + " th file are missing");
                continue;
            }
            String projectRelativePath = projectRelativePathNode.getTextContent();
            Node relativeURINode = attributeMap.getNamedItem("relativeURI");
            Node rawURINode = attributeMap.getNamedItem("rawURI");
            IFile targetFile = project.getFile(projectRelativePath);
            if (targetFile.exists()) continue;
            try {
                File file;
                URI absoluteURI;
                if (relativeURINode != null) {
                    String relativeLocation = relativeURINode.getTextContent();
                    absoluteURI = TITANPathUtilities.convertToAbsoluteURI((String)relativeLocation, (URI)projectFileFolderURI);
                    if (absoluteURI == null) continue;
                    file = new File(absoluteURI);
                    if (file.exists()) {
                        targetFile.createLink(absoluteURI, 16, null);
                        continue;
                    }
                    ErrorReporter.logError((String)("Error while importing files into project `" + project.getName() + "'. File `" + absoluteURI + "' does not exist"));
                    continue;
                }
                if (rawURINode != null) {
                    String rawURI = rawURINode.getTextContent();
                    absoluteURI = TITANPathUtilities.convertToAbsoluteURI((String)rawURI, (URI)projectFileFolderURI);
                    if (absoluteURI == null) continue;
                    file = new File(absoluteURI);
                    if (file.exists()) {
                        targetFile.createLink(absoluteURI, 16, null);
                        continue;
                    }
                    ErrorReporter.logError((String)("Error while importing files into project `" + project.getName() + "'. File `" + absoluteURI + "' does not exist"));
                    continue;
                }
                TITANDebugConsole.getConsole().newMessageStream().println("Can not create the resource " + targetFile.getFullPath().toString() + " the location information is missing or corrupted");
                continue;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While creating link for `" + targetFile + "'"), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private boolean loadPathVariables(Node rootNode, String projectName) {
        final IPathVariableManager pathVariableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
        NodeList variableNodes = rootNode.getChildNodes();
        int size = variableNodes.getLength();
        for (int i = 0; i < size; ++i) {
            NamedNodeMap attributeMap;
            Node variable = variableNodes.item(i);
            if (variable.getNodeType() != 1 || (attributeMap = variable.getAttributes()) == null) continue;
            Node nameNode = attributeMap.getNamedItem("name");
            Node valueNode = attributeMap.getNamedItem("value");
            if (nameNode == null || valueNode == null) {
                this.displayError("Import failed", "Error while importing project " + projectName + " some attributes of a path variable are missing");
                return false;
            }
            final String variableName = nameNode.getTextContent();
            final String variableValue = valueNode.getTextContent();
            if (this.headless || this.shell == null) {
                try {
                    pathVariableManager.setURIValue(variableName, URIUtil.toURI((String)variableValue));
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((String)("While setting path variable `" + variableName + "' in headless mode"), (Throwable)e);
                }
                continue;
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (pathVariableManager.isDefined(variableName)) {
                            EditPathVariableDialog dialog;
                            URI uri = pathVariableManager.getURIValue(variableName);
                            if (!variableValue.equals(URIUtil.toPath((URI)uri)) && 0 == (dialog = new EditPathVariableDialog(TpdImporter.this.shell, variableName, uri, URIUtil.toURI((String)variableValue))).open()) {
                                URI actualValue = dialog.getActualValue();
                                pathVariableManager.setURIValue(variableName, actualValue);
                            }
                        } else {
                            NewPathVariableDialog dialog = new NewPathVariableDialog(TpdImporter.this.shell, variableName, URIUtil.toURI((String)variableValue));
                            if (0 == dialog.open()) {
                                URI actualValue = dialog.getActualValue();
                                pathVariableManager.setURIValue(variableName, actualValue);
                            }
                        }
                    }
                    catch (CoreException e) {
                        ErrorReporter.logExceptionStackTrace((String)("While setting path variable `" + variableName + "' in GUI mode"), (Throwable)e);
                    }
                }
            });
        }
        return true;
    }

    private boolean loadConfigurationData(IProject project, NodeList mainNodes) {
        Document targetDocument = ProjectDocumentHandlingUtility.getDocument(project);
        Node activeConfigurationNode = ProjectFileHandler.getNodebyName(mainNodes, "ActiveConfiguration");
        String activeConfiguration = "Default";
        activeConfiguration = activeConfigurationNode != null ? activeConfigurationNode.getTextContent() : "Default";
        try {
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "org.eclipse.titan.designer.activeConfiguration"), activeConfiguration);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While setting `" + activeConfiguration + "' as configuration for project `" + project.getName() + "'"), (Throwable)e);
        }
        this.removeConfigurationNodes(targetDocument.getDocumentElement());
        Element targetActiveConfiguration = targetDocument.createElement("ActiveConfiguration");
        targetActiveConfiguration.appendChild(targetDocument.createTextNode(activeConfiguration));
        targetDocument.getDocumentElement().appendChild(targetActiveConfiguration);
        Element targetConfigurationsRoot = targetDocument.createElement("Configurations");
        targetDocument.getDocumentElement().appendChild(targetConfigurationsRoot);
        Node configurationsNode = ProjectFileHandler.getNodebyName(mainNodes, "Configurations");
        if (configurationsNode == null) {
            ProjectDocumentHandlingUtility.saveDocument(project);
            ProjectBuildPropertyData.setProjectAlreadyExported(project, false);
            ProjectFileHandler handler = new ProjectFileHandler(project);
            handler.loadProjectSettingsFromDocument(targetDocument);
            return true;
        }
        NodeList configurationsNodeList = configurationsNode.getChildNodes();
        int size = configurationsNodeList.getLength();
        for (int i = 0; i < size; ++i) {
            NamedNodeMap attributeMap;
            Node configurationNode = configurationsNodeList.item(i);
            if (configurationNode.getNodeType() != 1 || (attributeMap = configurationNode.getAttributes()) == null) continue;
            Node nameNode = attributeMap.getNamedItem("name");
            if (nameNode == null) {
                this.displayError("Import failed", "Error while importing project " + project.getName() + " the name attribute of a referenced project is missing");
                return false;
            }
            String configurationName = nameNode.getTextContent();
            if ("Default".equals(configurationName)) {
                this.copyConfigurationData(targetDocument.getDocumentElement(), configurationNode);
                continue;
            }
            Element targetConfiguration = targetDocument.createElement("Configuration");
            targetConfiguration.setAttribute("name", configurationName);
            targetConfigurationsRoot.appendChild(targetConfiguration);
            this.copyConfigurationData(targetConfiguration, configurationNode);
        }
        ProjectDocumentHandlingUtility.saveDocument(project);
        ProjectBuildPropertyData.setProjectAlreadyExported(project, false);
        ProjectFileHandler handler = new ProjectFileHandler(project);
        handler.loadProjectSettingsFromDocument(targetDocument);
        return true;
    }

    private void removeConfigurationNodes(Node rootNode) {
        NodeList rootNodeList = rootNode.getChildNodes();
        Node tempNode = ProjectFileHandler.getNodebyName(rootNodeList, "Configurations");
        if (tempNode != null) {
            rootNode.removeChild(tempNode);
        }
        if ((tempNode = ProjectFileHandler.getNodebyName(rootNodeList, "ProjectProperties")) != null) {
            rootNode.removeChild(tempNode);
        }
        if ((tempNode = ProjectFileHandler.getNodebyName(rootNodeList, "FolderProperties")) != null) {
            rootNode.removeChild(tempNode);
        }
        if ((tempNode = ProjectFileHandler.getNodebyName(rootNodeList, "FileProperties")) != null) {
            rootNode.removeChild(tempNode);
        }
        if ((tempNode = ProjectFileHandler.getNodebyName(rootNodeList, "ActiveConfiguration")) != null) {
            rootNode.removeChild(tempNode);
        }
    }

    private void copyConfigurationData(Element targetRoot, Node sourceRoot) {
        Document document = targetRoot.getOwnerDocument();
        NodeList rootList = sourceRoot.getChildNodes();
        Node targetNode = null;
        int size = rootList.getLength();
        for (int i = 0; i < size; ++i) {
            Node tempNode = rootList.item(i);
            String nodeName = tempNode.getNodeName();
            if (!"ProjectProperties".equals(nodeName) && !"FolderProperties".equals(nodeName) && !"FileProperties".equals(nodeName)) continue;
            targetNode = document.importNode(tempNode, true);
            ProjectFileHandler.clearNode(targetNode);
            targetRoot.appendChild(targetNode);
        }
    }

    private IProject createProject(Node mainElement, boolean treatExistingProjectAsError) {
        String originalProjectName;
        NodeList mainNodes = mainElement.getChildNodes();
        Node projectNameNode = ProjectFileHandler.getNodebyName(mainNodes, "ProjectName");
        if (null == projectNameNode) {
            TITANDebugConsole.getConsole().newMessageStream().println("The name of the project could not be found in the project descriptor, it will not be created.");
            return null;
        }
        String projectName = originalProjectName = projectNameNode.getFirstChild().getTextContent();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project.exists()) {
            if (!treatExistingProjectAsError || this.headless) {
                if (!project.isOpen()) {
                    try {
                        project.open(null);
                    }
                    catch (CoreException e) {
                        ErrorReporter.logError((String)("An existing project with the name " + projectName + " cannot be opened!"));
                    }
                }
                ErrorReporter.logWarning((String)("A project with the name " + projectName + " already exists, skipping it!"));
                return null;
            }
            ProjectSelector temp = new ProjectSelector(projectName);
            Display.getDefault().syncExec((Runnable)temp);
            if (temp.cancelled) {
                return null;
            }
            projectName = temp.getProjectName();
            project = temp.getProject();
        }
        this.finalProjectNames.put(originalProjectName, projectName);
        project = this.createNewProject(project, projectName);
        if (project == null) {
            TITANDebugConsole.getConsole().newMessageStream().println("There was an error while creating the project " + projectName);
            return null;
        }
        try {
            TITANNature.addTITANBuilderToProject(project);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While adding builder to `" + project.getName() + "'"), (Throwable)e);
        }
        return project;
    }

    private boolean loadURIDocuments(URI file, Validator validator) {
        if (this.projectsToImport.containsKey(file)) {
            return true;
        }
        if (!"file".equals(file.getScheme()) && !"".equals(file.getScheme())) {
            ErrorReporter.logError((String)("Loading of project information is only supported for local files right now. " + file.toString() + " could not be loaded"));
            return false;
        }
        Document document = this.getDocumentFromFile(file.getPath());
        if (document == null) {
            StringBuilder builder = new StringBuilder("It was not possible to load the imported project file: '" + file.toString() + "'\n");
            for (int i = this.importChain.size() - 1; i >= 0; --i) {
                builder.append("imported by: '");
                builder.append(this.importChain.get(i).toString());
                builder.append("'\n");
            }
            ErrorReporter.logError((String)builder.toString());
            return false;
        }
        if (validator != null) {
            try {
                validator.validate(new StreamSource(new File(file)));
            }
            catch (Exception e) {
                ErrorReporter.logExceptionStackTrace((String)("Error while importing from file " + file + ": " + System.getProperty("line.separator")), (Throwable)e);
                return false;
            }
        }
        ProjectFileHandler.clearNode(document);
        this.projectsToImport.put(file, document);
        Element mainElement = document.getDocumentElement();
        NodeList mainNodes = mainElement.getChildNodes();
        Node referencedProjectsNode = ProjectFileHandler.getNodebyName(mainNodes, "ReferencedProjects");
        if (referencedProjectsNode == null) {
            return true;
        }
        IPath projectFileFolderPath = new Path(file.getPath()).removeLastSegments(1);
        NodeList referencedProjectsList = referencedProjectsNode.getChildNodes();
        boolean result = true;
        int size = referencedProjectsList.getLength();
        for (int i = 0; i < size; ++i) {
            NamedNodeMap attributeMap;
            Node referencedProjectNode = referencedProjectsList.item(i);
            if (referencedProjectNode.getNodeType() != 1 || (attributeMap = referencedProjectNode.getAttributes()) == null) continue;
            Node nameNode = attributeMap.getNamedItem("name");
            if (nameNode == null) {
                this.displayError("Import failed", "Error while importing from file " + file + " the name attribute of a referenced project is missing");
                return false;
            }
            String projectName = nameNode.getTextContent();
            Node locationNode = attributeMap.getNamedItem("projectLocationURI");
            if (locationNode == null) {
                this.displayError("Import failed", "Error while importing from file " + file + " the location attribute of the referenced project " + projectName + " is not given.");
                return false;
            }
            String unresolvedProjectLocationURI = locationNode.getTextContent();
            URI absoluteURI = TITANPathUtilities.convertToAbsoluteURI((String)unresolvedProjectLocationURI, (URI)URIUtil.toURI((IPath)projectFileFolderPath));
            Node tpdNameNode = attributeMap.getNamedItem("tpdName");
            String fileName = tpdNameNode != null ? tpdNameNode.getTextContent() : projectName + ".tpd";
            this.tpdNameAttrMap.put(projectName, fileName);
            if (this.searchPaths != null && !this.searchPaths.isEmpty()) {
                File f = new File(absoluteURI);
                Path unresolvedProjectLocationURIPath = new Path(unresolvedProjectLocationURI);
                if (!(unresolvedProjectLocationURIPath.isAbsolute() || f.exists() && !f.isDirectory())) {
                    Iterator<String> iterator = this.searchPaths.iterator();
                    while (iterator.hasNext()) {
                        String systemPath;
                        String path;
                        String filePath = path = iterator.next();
                        if (path.charAt(path.length() - 1) != '/') {
                            filePath = filePath + "/";
                        }
                        if (!(f = new File(systemPath = new Path(filePath = filePath + fileName).toOSString())).exists() || f.isDirectory()) continue;
                        absoluteURI = URIUtil.toURI((String)systemPath);
                        this.tpdURIMap.put(projectName, unresolvedProjectLocationURI);
                        break;
                    }
                }
            }
            if (absoluteURI != null && !"file".equals(absoluteURI.getScheme())) {
                StringBuilder builder = new StringBuilder("Loading of project information is only supported for local files right now. " + absoluteURI.toString() + " could not be loaded\n");
                for (int j = this.importChain.size() - 1; j >= 0; --j) {
                    builder.append("imported by: '");
                    builder.append(this.importChain.get(j).toString());
                    builder.append("'\n");
                }
                ErrorReporter.logError((String)builder.toString());
                continue;
            }
            this.importChain.add(file);
            result &= this.loadURIDocuments(absoluteURI, validator);
            this.importChain.remove(this.importChain.size() - 1);
        }
        return result;
    }

    private void displayError(String title, String message) {
        if (!this.headless) {
            ErrorReporter.parallelErrorDisplayInMessageDialog((String)title, (String)message);
        }
        ErrorReporter.logError((String)message);
    }

    public Document getDocumentFromFile(String file) {
        LSInput lsInput = this.domImplLS.createLSInput();
        Document document = null;
        try {
            FileInputStream istream = new FileInputStream(file);
            lsInput.setByteStream(istream);
            document = this.parser.parse(lsInput);
            istream.close();
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((String)("While getting the document from `" + file + "'"), (Throwable)e);
        }
        return document;
    }

    IProject createNewProject(final IProject newProjectHandle, String name) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription description = workspace.newProjectDescription(name);
        TITANNature.addTITANNatureToProject(description);
        if (this.headless) {
            try {
                this.createProject(description, newProjectHandle, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While creating project `" + newProjectHandle.getName() + "'"), (Throwable)e);
            }
        } else {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                            protected void execute(IProgressMonitor monitor) throws CoreException {
                                TpdImporter.this.createProject(description, newProjectHandle, monitor);
                            }
                        };
                        new ProgressMonitorDialog(null).run(true, true, (IRunnableWithProgress)op);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    catch (InvocationTargetException e) {
                        TpdImporter.this.displayError(TpdImporter.CREATION_FAILED, e.getMessage());
                        ErrorReporter.logExceptionStackTrace((String)("While creating project `" + newProjectHandle.getName() + "'"), (Throwable)e);
                        return;
                    }
                }
            });
        }
        IProject newProject = newProjectHandle;
        return newProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        try {
            progress.setTaskName(CREATING_PROJECT);
            projectHandle.create(description, (IProgressMonitor)progress.newChild(1));
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open(128, (IProgressMonitor)progress.newChild(1));
            projectHandle.refreshLocal(1, (IProgressMonitor)progress.newChild(1));
        }
        finally {
            progress.done();
        }
    }

    class ProjectSelector
    implements Runnable {
        private String projectName;
        private IProject project = null;
        private boolean cancelled = false;

        public ProjectSelector(String projectName) {
            this.projectName = projectName;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public IProject getProject() {
            return this.project;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public void run() {
            NewProjectNameDialog dialog = new NewProjectNameDialog(TpdImporter.this.shell, this.projectName);
            if (dialog.open() == 0) {
                this.projectName = dialog.getName();
                this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
                if (this.project.exists()) {
                    this.cancelled = true;
                }
            } else {
                this.cancelled = true;
            }
        }
    }
}

