/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.parsers.ttcn3parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BufferedTokenStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.IntStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.UnbufferedCharStream;
import org.antlr.v4.runtime.atn.ATNSimulator;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionContextCache;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.dfa.DFA;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.Interval;
import org.eclipse.titan.common.parsers.SyntacticErrorStorage;
import org.eclipse.titan.common.parsers.TITANMarker;
import org.eclipse.titan.common.parsers.TitanListener;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.parsers.ISourceAnalyzer;
import org.eclipse.titan.designer.parsers.ttcn3parser.PreprocessedTokenStream;
import org.eclipse.titan.designer.parsers.ttcn3parser.Ttcn3Lexer;
import org.eclipse.titan.designer.parsers.ttcn3parser.Ttcn3Parser;
import org.eclipse.titan.designer.properties.data.PreprocessorSymbolsOptionsData;

public class TTCN3Analyzer
implements ISourceAnalyzer {
    private List<TITANMarker> warnings;
    private List<TITANMarker> unsupportedConstructs;
    private Interval rootInterval;
    private TTCN3Module actualTtc3Module;
    private List<SyntacticErrorStorage> mErrorsStored = null;

    @Override
    public List<SyntacticErrorStorage> getErrorStorage() {
        return this.mErrorsStored;
    }

    @Override
    public List<TITANMarker> getWarnings() {
        return this.warnings;
    }

    @Override
    public List<TITANMarker> getUnsupportedConstructs() {
        return this.unsupportedConstructs;
    }

    @Override
    public TTCN3Module getModule() {
        return this.actualTtc3Module;
    }

    @Override
    public Interval getRootInterval() {
        return this.rootInterval;
    }

    @Override
    public void parse(IFile aFile, String aCode) {
        int rootInt;
        Reader reader;
        if (aCode != null) {
            reader = new StringReader(aCode);
            rootInt = aCode.length();
        } else if (aFile != null) {
            IFileStore store;
            try {
                InputStreamReader temp = new InputStreamReader(aFile.getContents());
                if (!aFile.getCharset().equals(temp.getEncoding())) {
                    try {
                        temp.close();
                    }
                    catch (IOException e) {
                        ErrorReporter.logWarningExceptionStackTrace((Exception)e);
                    }
                    temp = new InputStreamReader(aFile.getContents(), aFile.getCharset());
                }
                reader = new BufferedReader(temp);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                return;
            }
            catch (UnsupportedEncodingException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
                return;
            }
            try {
                store = EFS.getStore((URI)aFile.getLocationURI());
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                return;
            }
            IFileInfo fileInfo = store.fetchInfo();
            rootInt = (int)fileInfo.getLength();
        } else {
            return;
        }
        this.parse(reader, rootInt, aFile);
    }

    public void parse(File aFile) {
        BufferedReader bufferedReader;
        try {
            bufferedReader = new BufferedReader(new FileReader(aFile));
        }
        catch (FileNotFoundException e) {
            return;
        }
        int fileLength = (int)aFile.length();
        this.parse(bufferedReader, fileLength, null);
    }

    private void parse(Reader aReader, int aFileLength, IFile aEclipseFile) {
        UnbufferedCharStream charStream = new UnbufferedCharStream(aReader);
        Ttcn3Lexer lexer = new Ttcn3Lexer((CharStream)charStream);
        lexer.setCommentTodo(true);
        lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
        lexer.initRootInterval(aFileLength);
        TitanListener lexerListener = new TitanListener();
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)lexerListener);
        BufferedTokenStream tokens = new BufferedTokenStream((TokenSource)lexer);
        Ttcn3Parser parser = new Ttcn3Parser((TokenStream)tokens);
        parser.setBuildParseTree(false);
        PreprocessedTokenStream preprocessor = null;
        if (aEclipseFile != null && "ttcnpp".equals(aEclipseFile.getFileExtension())) {
            lexer.setTTCNPP();
            preprocessor = new PreprocessedTokenStream((TokenSource)lexer);
            preprocessor.setActualFile(aEclipseFile);
            if (aEclipseFile.getProject() != null) {
                preprocessor.setMacros(PreprocessorSymbolsOptionsData.getTTCN3PreprocessorDefines(aEclipseFile.getProject()));
            }
            parser = new Ttcn3Parser((TokenStream)preprocessor);
            preprocessor.setActualLexer(lexer);
            preprocessor.setParser(parser);
        }
        if (aEclipseFile != null) {
            lexer.setActualFile(aEclipseFile);
            parser.setActualFile(aEclipseFile);
            parser.setProject(aEclipseFile.getProject());
        }
        parser.setLexer(lexer);
        parser.removeErrorListeners();
        TitanListener parserListener = new TitanListener();
        parser.addErrorListener((ANTLRErrorListener)parserListener);
        DFA[] decisionToDFA = ((ParserATNSimulator)parser.getInterpreter()).decisionToDFA;
        parser.setInterpreter((ATNSimulator)new ParserATNSimulator((Parser)parser, parser.getATN(), decisionToDFA, new PredictionContextCache()));
        try {
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            parser.pr_TTCN3File();
            this.warnings = parser.getWarnings();
            this.mErrorsStored = lexerListener.getErrorsStored();
            this.mErrorsStored.addAll(parserListener.getErrorsStored());
        }
        catch (RecognitionException recognitionException) {
            // empty catch block
        }
        if (!this.warnings.isEmpty() || !this.mErrorsStored.isEmpty()) {
            try {
                UnbufferedCharStream charStream2 = new UnbufferedCharStream(aReader);
                lexer.setInputStream((IntStream)charStream2);
                parser.reset();
                parserListener.reset();
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
                parser.pr_TTCN3File();
                this.warnings = parser.getWarnings();
                this.mErrorsStored = lexerListener.getErrorsStored();
                this.mErrorsStored.addAll(parserListener.getErrorsStored());
            }
            catch (RecognitionException recognitionException) {
                // empty catch block
            }
        }
        this.unsupportedConstructs = parser.getUnsupportedConstructs();
        this.rootInterval = lexer.getRootInterval();
        this.actualTtc3Module = parser.getModule();
        if (preprocessor != null) {
            this.mErrorsStored.addAll(preprocessor.getErrorStorage());
            this.warnings.addAll(preprocessor.getWarnings());
            this.unsupportedConstructs.addAll(preprocessor.getUnsupportedConstructs());
            if (this.actualTtc3Module != null) {
                this.actualTtc3Module.setIncludedFiles(preprocessor.getIncludedFiles());
                this.actualTtc3Module.setInactiveCodeLocations(preprocessor.getInactiveCodeLocations());
            }
        }
        try {
            aReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

