/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.parsers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.Interval;
import org.eclipse.titan.common.parsers.SyntacticErrorStorage;
import org.eclipse.titan.common.parsers.TITANMarker;
import org.eclipse.titan.common.parsers.cfg.CfgAnalyzer;
import org.eclipse.titan.common.parsers.cfg.CfgDefinitionInformation;
import org.eclipse.titan.common.parsers.cfg.CfgLocation;
import org.eclipse.titan.common.parsers.cfg.CfgParseResult;
import org.eclipse.titan.common.path.PathConverter;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.MarkerHandler;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.core.ProjectBasedBuilder;
import org.eclipse.titan.designer.core.TITANNature;
import org.eclipse.titan.designer.editors.EditorTracker;
import org.eclipse.titan.designer.editors.GlobalIntervalHandler;
import org.eclipse.titan.designer.editors.ISemanticTITANEditor;
import org.eclipse.titan.designer.editors.configeditor.ConfigEditor;
import org.eclipse.titan.designer.editors.configeditor.ConfigFoldingSupport;
import org.eclipse.titan.designer.editors.configeditor.ConfigTextEditor;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.OutdatedFileCollector;
import org.eclipse.titan.designer.parsers.ParserMarkerSupport;
import org.eclipse.ui.progress.IProgressConstants;

public final class ProjectConfigurationParser {
    private static final String SOURCE_ANALYSING = "Analysing the config file";
    private static final String PARSING = "parsing";
    private IProject project;
    protected Map<IFile, String> uptodateFiles;
    private Set<IFile> highlySyntaxErroneousFiles;
    protected Map<IFile, String> fileMap;
    protected Map<String, CfgDefinitionInformation> definitions;
    private AtomicInteger analyzersRunning = new AtomicInteger();
    private volatile WorkspaceJob lastAnalyzes = null;

    public ProjectConfigurationParser(IProject project) {
        this.project = project;
        this.uptodateFiles = new ConcurrentHashMap<IFile, String>();
        this.highlySyntaxErroneousFiles = Collections.synchronizedSet(new HashSet());
        this.fileMap = new ConcurrentHashMap<IFile, String>();
        this.definitions = new ConcurrentHashMap<String, CfgDefinitionInformation>();
    }

    public Map<String, CfgDefinitionInformation> getAllDefinitions() {
        return this.definitions;
    }

    public boolean isFileKnown(IFile file) {
        return this.fileMap.get(file) != null;
    }

    public WorkspaceJob reportOutdating(final IFile outdatedFile) {
        WorkspaceJob op = new WorkspaceJob("Reporting outdate for: " + outdatedFile.getName()){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                if (ProjectConfigurationParser.this.uptodateFiles.containsKey(outdatedFile)) {
                    ProjectConfigurationParser.this.uptodateFiles.remove(outdatedFile);
                }
                return Status.OK_STATUS;
            }
        };
        op.setPriority(20);
        op.setSystem(true);
        op.setUser(false);
        op.setRule((ISchedulingRule)outdatedFile);
        op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
        op.schedule();
        return op;
    }

    public WorkspaceJob reportOutdating(final List<IFile> outdatedFiles) {
        WorkspaceJob op = new WorkspaceJob("Reporting outdate for " + outdatedFiles.size() + " files"){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                for (IFile file : outdatedFiles) {
                    if (!ProjectConfigurationParser.this.uptodateFiles.containsKey(file)) continue;
                    ProjectConfigurationParser.this.uptodateFiles.remove(file);
                }
                return Status.OK_STATUS;
            }
        };
        op.setPriority(20);
        op.setSystem(true);
        op.setUser(false);
        op.setRule((ISchedulingRule)this.project);
        op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
        op.schedule();
        return op;
    }

    private void removedReferencestoRemovedFiles() {
        ArrayList<IFile> filesToRemove = new ArrayList<IFile>();
        for (IFile file : this.fileMap.keySet()) {
            if (file.isAccessible()) continue;
            this.uptodateFiles.remove(file);
            filesToRemove.add(file);
        }
        for (IFile file : filesToRemove) {
            this.fileMap.remove(file);
        }
    }

    private IStatus internalDoAnalyzeSyntactically(IProgressMonitor monitor) {
        this.removedReferencestoRemovedFiles();
        IContainer[] workingDirectories = ProjectBasedBuilder.getProjectBasedBuilder(this.project).getWorkingDirectoryResources(false);
        OutdatedFileCollector visitor = new OutdatedFileCollector(workingDirectories, this.uptodateFiles, this.highlySyntaxErroneousFiles);
        try {
            this.project.accept((IResourceVisitor)visitor);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        List<IFile> filesToCheck = visitor.getCFGFilesToCheck();
        for (IFile file : this.uptodateFiles.keySet()) {
            MarkerHandler.markAllMarkersForRemoval((IResource)file, "org.eclipse.titan.designer.ontheflySemanticMarker");
            MarkerHandler.markAllMarkersForRemoval((IResource)file, "org.eclipse.titan.designer.ontheflyMixedMarker");
        }
        for (IFile file : filesToCheck) {
            this.removeMarkersAndDefinitions(file);
        }
        monitor.beginTask(PARSING, -1);
        ArrayList<CfgParseResult.Macro> macros = new ArrayList<CfgParseResult.Macro>();
        Map<String, String> env = System.getenv();
        ArrayList<IFile> filesChecked = new ArrayList<IFile>();
        while (!filesToCheck.isEmpty()) {
            IFile file = filesToCheck.get(0);
            if (!filesChecked.contains(file)) {
                if (!monitor.isCanceled()) {
                    if (!file.isAccessible()) {
                        TITANDebugConsole.println("The file " + file.getLocationURI() + " does not seem to exist.");
                    } else if (!this.uptodateFiles.containsKey(file)) {
                        monitor.subTask(file.getProjectRelativePath().toOSString());
                        this.fileBasedAnalysis(file, macros, filesToCheck, filesChecked);
                    }
                }
                monitor.worked(1);
                filesChecked.add(file);
            }
            filesToCheck.remove(0);
        }
        filesToCheck.clear();
        this.checkMacroErrors(macros, this.definitions, env);
        monitor.done();
        for (IFile file : this.uptodateFiles.keySet()) {
            MarkerHandler.removeAllOnTheFlyMarkedMarkers((IResource)file);
        }
        for (IFile file : filesToCheck) {
            if (this.uptodateFiles.containsKey(file)) continue;
            MarkerHandler.removeAllOnTheFlyMarkedMarkers((IResource)file);
        }
        return Status.OK_STATUS;
    }

    private void removeMarkersAndDefinitions(IFile aFile) {
        MarkerHandler.markAllOnTheFlyMarkersForRemoval((IResource)aFile);
        MarkerHandler.markAllTaskMarkersForRemoval(aFile);
        Set<Map.Entry<String, CfgDefinitionInformation>> entries = this.definitions.entrySet();
        Iterator<Map.Entry<String, CfgDefinitionInformation>> mapIter = entries.iterator();
        while (mapIter.hasNext()) {
            Map.Entry<String, CfgDefinitionInformation> entry = mapIter.next();
            CfgDefinitionInformation info = entry.getValue();
            List list = info.getLocations();
            Iterator listIter = list.iterator();
            while (listIter.hasNext()) {
                CfgLocation location = (CfgLocation)listIter.next();
                if (!location.getFile().equals(aFile)) continue;
                listIter.remove();
            }
            if (!list.isEmpty()) continue;
            mapIter.remove();
        }
    }

    public WorkspaceJob analyzeAll() {
        if (!this.project.isAccessible() || !TITANNature.hasTITANNature(this.project)) {
            return null;
        }
        WorkspaceJob op = new WorkspaceJob(SOURCE_ANALYSING){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IProgressMonitor internalMonitor;
                Object object = internalMonitor = monitor == null ? new NullProgressMonitor() : monitor;
                if (internalMonitor.isCanceled()) {
                    ProjectConfigurationParser.this.analyzersRunning.decrementAndGet();
                    return Status.CANCEL_STATUS;
                }
                int priority = this.getThread().getPriority();
                try {
                    this.getThread().setPriority(1);
                    ProjectConfigurationParser.this.internalDoAnalyzeSyntactically(internalMonitor);
                }
                finally {
                    this.getThread().setPriority(priority);
                    ProjectConfigurationParser.this.analyzersRunning.decrementAndGet();
                }
                return Status.OK_STATUS;
            }
        };
        op.setPriority(30);
        op.setSystem(true);
        op.setUser(false);
        op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
        op.setRule((ISchedulingRule)this.project);
        if (this.analyzersRunning.get() > 0 && this.lastAnalyzes != null && this.lastAnalyzes.getState() != 4) {
            this.lastAnalyzes.cancel();
        }
        op.schedule();
        this.lastAnalyzes = op;
        this.analyzersRunning.incrementAndGet();
        return this.lastAnalyzes;
    }

    private void fileBasedAnalysis(IFile file, List<CfgParseResult.Macro> aMacros, List<IFile> aFilesToCheck, List<IFile> aFilesChecked) {
        String oldConfigFilePath;
        List warnings = null;
        List errorsStored = null;
        IDocument document = null;
        ISemanticTITANEditor tempEditor = null;
        List<ISemanticTITANEditor> editors = null;
        if (EditorTracker.containsKey(file)) {
            editors = EditorTracker.getEditor(file);
            tempEditor = editors.get(0);
            document = tempEditor.getDocument();
        }
        ConfigTextEditor editor = null;
        if (tempEditor instanceof ConfigTextEditor) {
            editor = (ConfigTextEditor)tempEditor;
        }
        if ((oldConfigFilePath = this.fileMap.get(file)) != null) {
            this.fileMap.remove(file);
        }
        CfgAnalyzer cfgAnalyzer = new CfgAnalyzer();
        cfgAnalyzer.parse(file, document == null ? null : document.get());
        CfgParseResult cfgParseResult = cfgAnalyzer.getCfgParseResult();
        errorsStored = cfgAnalyzer.getErrorStorage();
        warnings = cfgParseResult.getWarnings();
        aMacros.addAll(cfgParseResult.getMacros());
        this.definitions.putAll(cfgParseResult.getDefinitions());
        List includeFilenames = cfgParseResult.getIncludeFiles();
        for (String includeFilename : includeFilenames) {
            IFile includeFile;
            IPath includeFilePath = PathConverter.getProjectRelativePath((IFile)file, (String)includeFilename);
            if (includeFilePath == null || (includeFile = this.project.getFile(includeFilePath)) == null || this.uptodateFiles.containsKey(includeFile) || aFilesChecked.contains(includeFile) || aFilesToCheck.contains(includeFile)) continue;
            this.removeMarkersAndDefinitions(includeFile);
            aFilesToCheck.add(includeFile);
        }
        if (editor != null && editor.getDocument() != null) {
            ConfigEditor parentEditor = editor.getParentEditor();
            if (errorsStored == null || errorsStored.isEmpty()) {
                parentEditor.setParseTreeRoot(cfgParseResult.getParseTreeRoot());
                parentEditor.setTokens(cfgParseResult.getTokens());
                parentEditor.refresh(cfgAnalyzer);
                parentEditor.setErrorMessage(null);
            } else if (errorsStored.size() > 1) {
                parentEditor.setErrorMessage("There were " + errorsStored.size() + " problems found while parsing");
            } else {
                parentEditor.setErrorMessage("There was 1 problem found while parsing");
            }
        }
        this.fileMap.put(file, file.getFullPath().toOSString());
        this.uptodateFiles.put(file, file.getFullPath().toOSString());
        if (document != null) {
            GlobalIntervalHandler.putInterval(document, (Interval)cfgAnalyzer.getRootInterval());
        }
        if (warnings != null) {
            for (TITANMarker marker : warnings) {
                if (!file.isAccessible()) continue;
                Location location = new Location((IResource)file, marker.getLine(), marker.getOffset(), marker.getEndOffset());
                location.reportExternalProblem(marker.getMessage(), marker.getSeverity(), "org.eclipse.titan.designer.ontheflySyntacticMarker");
            }
        }
        if (errorsStored != null && !errorsStored.isEmpty()) {
            int errorLevel;
            String reportLevel = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportErrorsInExtensionSyntax", "warning", null);
            if ("error".equals(reportLevel)) {
                errorLevel = 2;
            } else if ("warning".equals(reportLevel)) {
                errorLevel = 1;
            } else {
                return;
            }
            for (int i = 0; i < errorsStored.size(); ++i) {
                ParserMarkerSupport.createOnTheFlySyntacticMarker(file, (SyntacticErrorStorage)errorsStored.get(i), errorLevel);
            }
        }
        if (document != null && editors != null) {
            ConfigFoldingSupport foldingSupport = new ConfigFoldingSupport();
            IDocument tempDocument = document;
            final List<ISemanticTITANEditor> editors2 = editors;
            final List<Position> positions = foldingSupport.calculatePositions(tempDocument);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    for (ISemanticTITANEditor editor : editors2) {
                        editor.updateFoldingStructure(positions);
                        editor.invalidateTextPresentation();
                    }
                }
            });
        }
    }

    private String getDefinitionValue(String aDefinition, Map<String, CfgDefinitionInformation> aDefines, Map<String, String> aEnv) {
        if (aDefines != null && aDefines.containsKey(aDefinition)) {
            return aDefines.get(aDefinition).getValue();
        }
        if (aEnv != null && aEnv.containsKey(aDefinition)) {
            return aEnv.get(aDefinition);
        }
        return null;
    }

    public void checkMacroErrors(List<CfgParseResult.Macro> aMacros, Map<String, CfgDefinitionInformation> aDefines, Map<String, String> aEnv) {
        for (CfgParseResult.Macro macro : aMacros) {
            IFile file;
            String value = this.getDefinitionValue(macro.getMacroName(), aDefines, aEnv);
            if (value != null || (file = macro.getFile()) == null || !file.isAccessible()) continue;
            TITANMarker marker = macro.getErrorMarker();
            Location location = new Location((IResource)file, marker.getLine(), marker.getOffset(), marker.getEndOffset());
            location.reportExternalProblem(marker.getMessage(), marker.getSeverity(), "org.eclipse.titan.designer.ontheflySyntacticMarker");
        }
    }
}

