/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.asn1editor;

import java.io.Reader;
import java.io.StringReader;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.UnbufferedCharStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.Interval;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.editors.GeneralPairMatcher;
import org.eclipse.titan.designer.editors.GlobalIntervalHandler;
import org.eclipse.titan.designer.editors.HeuristicalIntervalDetector;
import org.eclipse.titan.designer.editors.IReferenceParser;
import org.eclipse.titan.designer.editors.asn1editor.ASN1ReferencePairMatcher;
import org.eclipse.titan.designer.parsers.asn1parser.ASN1Listener;
import org.eclipse.titan.designer.parsers.asn1parser.Asn1Lexer;
import org.eclipse.titan.designer.parsers.asn1parser.Asn1Parser;
import org.eclipse.titan.designer.parsers.asn1parser.ModuleLevelTokenStreamTracker;
import org.eclipse.titan.designer.parsers.asn1parser.TokenWithIndexAndSubTokensFactory;

public final class ASN1ReferenceParser
implements IReferenceParser {
    private int ofs;

    @Override
    public final void setErrorReporting(boolean reportErrors) {
    }

    public final int getReplacementOffset() {
        return this.ofs;
    }

    @Override
    public final Reference findReferenceForCompletion(IFile file, int offset, IDocument document) {
        Reference reference = null;
        this.ofs = offset - 1;
        if (-1 == this.ofs) {
            return reference;
        }
        try {
            char currentChar = document.getChar(this.ofs);
            if (']' == currentChar || ')' == currentChar || '}' == currentChar) {
                return reference;
            }
            ASN1ReferencePairMatcher pairMatcher = new ASN1ReferencePairMatcher();
            this.ofs = this.referenceStartOffset(this.ofs, document, pairMatcher);
            if (-1 == this.ofs) {
                return reference;
            }
            ++this.ofs;
            String toBeParsed = document.get(this.ofs, offset - this.ofs);
            ASN1ReferenceParser refAnalyzer = this.newInstance();
            reference = refAnalyzer.parseReference(file, toBeParsed, document.getLineOfOffset(this.ofs), this.ofs);
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        return reference;
    }

    @Override
    public final Reference findReferenceForOpening(IFile file, int offset, IDocument document) {
        Reference reference = null;
        this.ofs = offset - 1;
        if (-1 == this.ofs) {
            return reference;
        }
        try {
            ASN1ReferencePairMatcher pairMatcher = new ASN1ReferencePairMatcher();
            this.ofs = this.referenceStartOffset(this.ofs, document, pairMatcher);
            ++this.ofs;
            int endoffset = offset;
            if (endoffset >= document.getLength()) {
                return reference;
            }
            char currentChar = document.getChar(endoffset);
            while (endoffset < document.getLength() && (Character.isLetterOrDigit(currentChar) || currentChar == '(' || currentChar == '_' || currentChar == '-') && currentChar != '(') {
                if (++endoffset >= document.getLength()) {
                    return reference;
                }
                currentChar = document.getChar(endoffset);
            }
            String toBeParsed = document.get(this.ofs, endoffset - this.ofs);
            ASN1ReferenceParser refAnalyzer = this.newInstance();
            reference = refAnalyzer.parseReference(file, toBeParsed, document.getLineOfOffset(this.ofs) + 1, this.ofs);
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        return reference;
    }

    private final int referenceStartOffset(int offset, IDocument document, GeneralPairMatcher pairMatcher) throws BadLocationException {
        int temporalOffset;
        Interval rootInterval = GlobalIntervalHandler.getInterval(document);
        if (rootInterval == null) {
            rootInterval = new HeuristicalIntervalDetector().buildIntervals(document);
            GlobalIntervalHandler.putInterval(document, rootInterval);
        }
        char currentChar = document.getChar(temporalOffset);
        Interval interval = null;
        boolean foundWhiteSpaces = false;
        boolean foundDot = false;
        for (temporalOffset = offset; temporalOffset > 0; --temporalOffset) {
            if (rootInterval != null) {
                interval = rootInterval.getSmallestEnclosingInterval(temporalOffset);
            }
            currentChar = document.getChar(temporalOffset);
            if (interval != null && (Interval.interval_type.SINGLELINE_COMMENT.equals((Object)interval.getType()) || Interval.interval_type.MULTILINE_COMMENT.equals((Object)interval.getType()))) {
                temporalOffset = interval.getStartOffset();
                continue;
            }
            if (currentChar == '}') {
                if (foundWhiteSpaces && !foundDot) break;
                foundWhiteSpaces = false;
                foundDot = false;
                IRegion pair = pairMatcher.match(document, temporalOffset + 1);
                if (pair == null) {
                    return -1;
                }
                temporalOffset = pair.getOffset();
                continue;
            }
            if ('-' == currentChar || '_' == currentChar || Character.isLetterOrDigit(currentChar)) {
                if (foundWhiteSpaces && !foundDot) break;
                foundWhiteSpaces = false;
                foundDot = false;
                continue;
            }
            if ('.' == currentChar) {
                foundDot = true;
                continue;
            }
            if (' ' != currentChar && '\t' != currentChar && '\n' != currentChar && '\r' != currentChar) break;
            foundWhiteSpaces = true;
        }
        return temporalOffset;
    }

    private Reference parseReference(IFile file, String input, int line, int offset) {
        Reference reference = null;
        StringReader reader = new StringReader(input);
        UnbufferedCharStream charStream = new UnbufferedCharStream((Reader)reader);
        Asn1Lexer lexer = new Asn1Lexer((CharStream)charStream);
        lexer.setTokenFactory(new TokenWithIndexAndSubTokensFactory(true));
        ASN1Listener lexerListener = new ASN1Listener();
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)lexerListener);
        ModuleLevelTokenStreamTracker tracker = new ModuleLevelTokenStreamTracker((TokenSource)lexer);
        tracker.discard(2);
        tracker.discard(98);
        tracker.discard(97);
        Asn1Parser parser = new Asn1Parser((TokenStream)tracker);
        parser.setProject(file.getProject());
        parser.setActualFile(file);
        parser.setLine(line);
        parser.setOffset(offset);
        parser.setBuildParseTree(false);
        ASN1Listener parserListener = new ASN1Listener();
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)parserListener);
        reference = parser.pr_parseReference().reference;
        return reference;
    }

    private ASN1ReferenceParser newInstance() {
        return new ASN1ReferenceParser();
    }
}

