/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.ASN1Type;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.ASN1.Type_Assignment;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ValueRange;
import org.eclipse.titan.designer.AST.TTCN3.templates.Value_Range_Template;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubType;
import org.eclipse.titan.designer.AST.TTCN3.values.Real_Value;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class Float_Type
extends ASN1Type {
    private static final String REALVALUEEXPECTED = "REAL value was expected";
    private static final String FLOATVALUEEXPECTED = "float value was expected";
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for type `float''";
    private static final String LENGTHRESTRICTIONNOTALLOWED = "Length restriction is not allowed for type `float''";
    private static final String INCORRECTBOUNDARIES = "The lower boundary is higher than the upper boundary";

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_REAL;
    }

    @Override
    public IASN1Type newInstance() {
        return new Float_Type();
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return IType.Type_type.TYPE_REAL.equals((Object)temp.getTypetype());
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        if (this.isErroneous) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.getTypetype();
    }

    @Override
    public String getTypename() {
        return "float";
    }

    @Override
    public String getOutlineIcon() {
        return "float.gif";
    }

    @Override
    public SubType.SubType_type getSubtypeType() {
        return SubType.SubType_type.ST_FLOAT;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.parseAttributes(timestamp);
        if (this.constraints != null) {
            this.constraints.check(timestamp);
        }
        this.checkSubtypeRestrictions(timestamp);
    }

    @Override
    public void checkThisValue(CompilationTimeStamp timestamp, IValue value, IType.ValueCheckingOptions valueCheckingOptions) {
        super.checkThisValue(timestamp, value, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return;
            }
        }
        if (value.isAsn()) {
            IType lastType;
            if (IValue.Value_type.REFERENCED_VALUE.equals((Object)value.getValuetype()) && !(lastType = last.getMyGovernor().getTypeRefdLast(timestamp)).getIsErroneous(timestamp) && !IType.Type_type.TYPE_REAL.equals((Object)lastType.getTypetype())) {
                value.getLocation().reportSemanticError(REALVALUEEXPECTED);
                value.setIsErroneous(true);
                return;
            }
            switch (last.getValuetype()) {
                case REAL_VALUE: {
                    break;
                }
                case UNDEFINED_BLOCK: {
                    last = last.setValuetype(timestamp, IValue.Value_type.SEQUENCE_VALUE);
                    Identifier identifier = new Identifier(Identifier.Identifier_type.ID_ASN, "REAL");
                    Assignment assignment = this.getMyScope().getAssignmentsScope().getLocalAssignmentByID(timestamp, identifier);
                    ((Type_Assignment)assignment).getType(timestamp).checkThisValue(timestamp, last, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_CONSTANT, false, false, true, false, valueCheckingOptions.str_elem));
                    last = last.setValuetype(timestamp, IValue.Value_type.REAL_VALUE);
                    break;
                }
                case INTEGER_VALUE: {
                    last.setValuetype(timestamp, IValue.Value_type.REAL_VALUE);
                    break;
                }
                case EXPRESSION_VALUE: 
                case MACRO_VALUE: {
                    break;
                }
                default: {
                    last.getLocation().reportSemanticError(REALVALUEEXPECTED);
                    last.setIsErroneous(true);
                    break;
                }
            }
        } else {
            switch (last.getValuetype()) {
                case REAL_VALUE: {
                    break;
                }
                case EXPRESSION_VALUE: 
                case MACRO_VALUE: {
                    break;
                }
                default: {
                    value.getLocation().reportSemanticError(FLOATVALUEEXPECTED);
                    value.setIsErroneous(true);
                }
            }
        }
        if (valueCheckingOptions.sub_check && this.subType != null) {
            this.subType.checkThisValue(timestamp, last);
        }
        value.setLastTimeChecked(timestamp);
    }

    @Override
    public void checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        if (this.getIsErroneous(timestamp)) {
            return;
        }
        if (ITTCN3Template.Template_type.VALUE_RANGE.equals((Object)template.getTemplatetype())) {
            ValueRange range = ((Value_Range_Template)template).getValueRange();
            IValue lower = this.checkBoundary(timestamp, range.getMin());
            IValue upper = this.checkBoundary(timestamp, range.getMax());
            if (lower != null && upper != null && ((Real_Value)lower).getValue() > ((Real_Value)upper).getValue()) {
                template.getLocation().reportSemanticError(INCORRECTBOUNDARIES);
            }
        } else {
            template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName()));
        }
        if (template.getLengthRestriction() != null) {
            template.getLocation().reportSemanticError(LENGTHRESTRICTIONNOTALLOWED);
        }
    }

    private IValue checkBoundary(CompilationTimeStamp timestamp, Value value) {
        if (value == null) {
            return null;
        }
        value.setMyGovernor(this);
        IValue temp = this.checkThisValueRef(timestamp, value);
        this.checkThisValue(timestamp, temp, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false, false, true, false, false));
        temp = temp.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
        switch (temp.getValuetype()) {
            case REAL_VALUE: {
                break;
            }
            default: {
                temp = null;
            }
        }
        return temp;
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("float");
    }
}

