/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.statements.Port_Utility;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.types.PortTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Signature_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TypeSet;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Reply_Statement
extends Statement {
    private static final String REPLYONMESSAGEPORT = "Procedure-based operation `reply'' is not applicable to a message-based port of type `{0}''";
    private static final String UNKNOWNINCOMINGSIGNATURE = "Cannot determine the type of the signature";
    private static final String INCOMINGSIGNATURENOTPRESENT = "Signature `{0}'' is not present on the incoming list of port type `{1}''";
    private static final String NOINCOMINGSIGNATURES = "Port type `{0}'' does not have any incoming signatures";
    private static final String FULLNAMEPART1 = ".portreference";
    private static final String FULLNAMEPART2 = ".sendparameter";
    private static final String FULLNAMEPART3 = ".replyvalue";
    private static final String FULLNAMEPART4 = ".to";
    private static final String STATEMENT_NAME = "reply";
    private final Reference portReference;
    private final TemplateInstance parameter;
    private final Value replyValue;
    private final IValue toClause;

    public Reply_Statement(Reference portReference, TemplateInstance parameter, Value replyValue, IValue toClause) {
        this.portReference = portReference;
        this.parameter = parameter;
        this.replyValue = replyValue;
        this.toClause = toClause;
        if (portReference != null) {
            portReference.setFullNameParent(this);
        }
        if (parameter != null) {
            parameter.setFullNameParent(this);
        }
        if (replyValue != null) {
            replyValue.setFullNameParent(this);
        }
        if (toClause != null) {
            toClause.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_REPLY;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.portReference == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.parameter == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.replyValue == child) {
            return builder.append(FULLNAMEPART3);
        }
        if (this.toClause == child) {
            return builder.append(FULLNAMEPART4);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.portReference != null) {
            this.portReference.setMyScope(scope);
        }
        if (this.parameter != null) {
            this.parameter.setMyScope(scope);
        }
        if (this.replyValue != null) {
            this.replyValue.setMyScope(scope);
        }
        if (this.toClause != null) {
            this.toClause.setMyScope(scope);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        Port_Type portType = Port_Utility.checkPortReference(timestamp, this, this.portReference);
        IType signature = null;
        boolean signatureDetermined = false;
        if (portType != null) {
            PortTypeBody portTypeBody = portType.getPortBody();
            TypeSet inSignatures = portTypeBody.getInSignatures();
            if (PortTypeBody.OperationModes.OP_Message.equals((Object)portTypeBody.getOperationMode())) {
                this.portReference.getLocation().reportSemanticError(MessageFormat.format(REPLYONMESSAGEPORT, portType.getTypename()));
            } else if (inSignatures != null) {
                if (inSignatures.getNofTypes() == 1) {
                    signature = inSignatures.getTypeByIndex(0);
                } else {
                    signature = Port_Utility.getOutgoingType(timestamp, this.parameter);
                    if (signature == null) {
                        this.parameter.getLocation().reportSemanticError(UNKNOWNINCOMINGSIGNATURE);
                    } else if (!inSignatures.hasType(timestamp, signature)) {
                        this.parameter.getLocation().reportSemanticError(MessageFormat.format(INCOMINGSIGNATURENOTPRESENT, signature.getTypename(), portType.getTypename()));
                    }
                }
                signatureDetermined = true;
            } else {
                this.portReference.getLocation().reportSemanticError(MessageFormat.format(NOINCOMINGSIGNATURES, portType.getTypename()));
            }
        }
        if (!signatureDetermined) {
            signature = Port_Utility.getOutgoingType(timestamp, this.parameter);
        }
        if (signature != null) {
            this.parameter.check(timestamp, signature);
            signature = signature.getTypeRefdLast(timestamp);
            Type returnType = null;
            switch (signature.getTypetype()) {
                case TYPE_SIGNATURE: {
                    if (((Signature_Type)signature).isNonblocking()) {
                        this.getLocation().reportSemanticError(MessageFormat.format("Operation `reply'' is not applicable to non-blocking signature `{0}''", signature.getTypename()));
                    } else {
                        returnType = ((Signature_Type)signature).getSignatureReturnType();
                    }
                    if (this.replyValue != null) {
                        if (returnType != null) break;
                        String message = MessageFormat.format("Unexpected return value. Signature `{0}'' does not have return type", signature.getTypename());
                        this.replyValue.getLocation().reportSemanticError(message);
                        break;
                    }
                    if (returnType == null) break;
                    this.getLocation().reportSemanticError(MessageFormat.format("Missing return value. Signature `{0}'' returns type `{1}''", signature.getTypename(), returnType.getTypename()));
                    break;
                }
                default: {
                    this.parameter.getLocation().reportSemanticError(MessageFormat.format("The type of parameter is `{0}'', which is not a signature", signature.getTypename()));
                }
            }
            if (this.replyValue != null && returnType != null) {
                this.replyValue.setMyGovernor(returnType);
                IValue temp = returnType.checkThisValueRef(timestamp, this.replyValue);
                returnType.checkThisValue(timestamp, temp, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false, false, true, false, false));
            }
            Port_Utility.checkToClause(timestamp, this, portType, this.toClause);
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        if (this.toClause != null) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(142);
        return result;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.portReference != null) {
            this.portReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.portReference.getLocation());
        }
        if (this.parameter != null) {
            this.parameter.updateSyntax(reparser, false);
            reparser.updateLocation(this.parameter.getLocation());
        }
        if (this.replyValue != null) {
            this.replyValue.updateSyntax(reparser, false);
            reparser.updateLocation(this.replyValue.getLocation());
        }
        if (this.toClause instanceof IIncrementallyUpdateable) {
            ((IIncrementallyUpdateable)((Object)this.toClause)).updateSyntax(reparser, false);
            reparser.updateLocation(this.toClause.getLocation());
        } else if (this.toClause != null) {
            throw new ReParseException();
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.portReference != null) {
            this.portReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.parameter != null) {
            this.parameter.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.replyValue != null) {
            this.replyValue.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.toClause != null) {
            this.toClause.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.portReference != null && !this.portReference.accept(v)) {
            return false;
        }
        if (this.parameter != null && !this.parameter.accept(v)) {
            return false;
        }
        if (this.replyValue != null && !this.replyValue.accept(v)) {
            return false;
        }
        return this.toClause == null || this.toClause.accept(v);
    }
}

