/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.types.Signature_Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public abstract class Parameter_Redirect
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable {
    protected static final String SIGNATUREWITHOUTPARAMETERS = "Parameter redirect cannot be used because signature `{0}'' does not have parameters";
    private Location location = NULL_Location.INSTANCE;
    protected CompilationTimeStamp lastTimeChecked;

    @Override
    public final void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public final Location getLocation() {
        return this.location;
    }

    public abstract void checkErroneous(CompilationTimeStamp var1);

    public final void checkVariableReference(CompilationTimeStamp timestamp, Reference reference, IType type) {
        if (reference == null) {
            return;
        }
        IType variableType = reference.checkVariableReference(timestamp);
        if (type != null && variableType != null && !type.isIdentical(timestamp, variableType)) {
            String message = MessageFormat.format("Type mismatch in parameter redirect: A variable of type `{0}'' was expected instead of `{1}''", type.getTypename(), variableType.getTypename());
            reference.getLocation().reportSemanticError(message);
            return;
        }
        Assignment assignment = reference.getRefdAssignment(timestamp, true);
        if (assignment != null) {
            switch (assignment.getAssignmentType()) {
                case A_PAR_VAL: 
                case A_PAR_VAL_OUT: 
                case A_PAR_VAL_INOUT: {
                    ((FormalParameter)assignment).setWritten();
                    break;
                }
                case A_VAR: {
                    ((Def_Var)assignment).setWritten();
                    break;
                }
                case A_PAR_TEMP_OUT: 
                case A_PAR_TEMP_INOUT: {
                    ((FormalParameter)assignment).setWritten();
                    break;
                }
                case A_VAR_TEMPLATE: {
                    ((Def_Var_Template)assignment).setWritten();
                    break;
                }
            }
        }
    }

    public abstract void check(CompilationTimeStamp var1, Signature_Type var2, boolean var3);
}

