/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.attributes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IIdentifierContainer;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.attributes.SingleWithAttribute;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class MultipleWithAttributes
implements ILocateableNode,
IIncrementallyUpdateable,
IIdentifierContainer,
IVisitableNode {
    private List<SingleWithAttribute> attributes;
    private Location location = NULL_Location.INSTANCE;

    public void addAttribute(SingleWithAttribute attribute) {
        if (attribute != null) {
            if (this.attributes == null) {
                this.attributes = new ArrayList<SingleWithAttribute>(1);
            }
            this.attributes.add(attribute);
        }
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public int getNofElements() {
        if (this.attributes == null) {
            return 0;
        }
        return this.attributes.size();
    }

    public SingleWithAttribute getAttribute(int index) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(index);
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.attributes != null) {
            int size = this.attributes.size();
            for (int i = 0; i < size; ++i) {
                SingleWithAttribute temp = this.attributes.get(i);
                temp.updateSyntax(reparser, false);
                reparser.updateLocation(temp.getLocation());
            }
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.attributes == null) {
            return;
        }
        for (SingleWithAttribute attr : this.attributes) {
            attr.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    public boolean accept(ASTVisitor v) {
        switch (v.visit(this)) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        if (this.attributes != null) {
            for (SingleWithAttribute attr : this.attributes) {
                if (attr.accept(v)) continue;
                return false;
            }
        }
        return v.leave(this) != 2;
    }
}

