/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.types;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.ASN1Type;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.ASN1.values.RelativeObjectIdentifier_Value;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class RelativeObjectIdentifier_Type
extends ASN1Type {
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for type `oid''";
    private static final String LENGTHRESTRICTIONNOTALLOWED = "Length restriction is not allowed for type `objid''";

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_ROID;
    }

    @Override
    public IASN1Type newInstance() {
        return new RelativeObjectIdentifier_Type();
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        return IType.Type_type.TYPE_OBJECTID;
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return IType.Type_type.TYPE_ROID.equals((Object)temp.getTypetype()) || !otherType.isAsn() && IType.Type_type.TYPE_OBJECTID.equals((Object)temp.getTypetype());
    }

    @Override
    public String getTypename() {
        return "objid";
    }

    @Override
    public String getOutlineIcon() {
        return "objid.gif";
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (null != this.constraints) {
            this.constraints.check(timestamp);
        }
    }

    @Override
    public void checkThisValue(CompilationTimeStamp timestamp, IValue value, IType.ValueCheckingOptions valueCheckingOptions) {
        value.setIsErroneous(false);
        super.checkThisValue(timestamp, value, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (null == last || last.getIsErroneous(timestamp)) {
            return;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return;
            }
        }
        switch (last.getValuetype()) {
            case RELATIVEOBJECTIDENTIFIER_VALUE: {
                ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                ((RelativeObjectIdentifier_Value)last).checkROID(timestamp, referenceChain);
                referenceChain.release();
                break;
            }
            case UNDEFINED_BLOCK: {
                last = last.setValuetype(timestamp, IValue.Value_type.RELATIVEOBJECTIDENTIFIER_VALUE);
                ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                ((RelativeObjectIdentifier_Value)last).checkROID(timestamp, referenceChain);
                referenceChain.release();
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                value.getLocation().reportSemanticError("RELATIVE-OID value was expected");
                value.setIsErroneous(true);
            }
        }
        if (valueCheckingOptions.sub_check && null != this.subType) {
            this.subType.checkThisValue(timestamp, last);
        }
        value.setLastTimeChecked(timestamp);
    }

    @Override
    public void checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName()));
        if (null != template.getLengthRestriction()) {
            template.getLocation().reportSemanticError(LENGTHRESTRICTIONNOTALLOWED);
        }
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("relative object identifier");
    }
}

