/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.types;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.ASN1Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Sequence_Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Set_Type;
import org.eclipse.titan.designer.AST.ASN1.types.CTs_EE_CTs;
import org.eclipse.titan.designer.AST.ASN1.types.ComponentType;
import org.eclipse.titan.designer.AST.ASN1.types.ComponentTypeList;
import org.eclipse.titan.designer.AST.ASN1.types.RegularComponentType;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class ComponentsOfComponentType
extends ComponentType {
    private static final String FULLNAMEPART = ".<ComponentsOfType>";
    private static final String SEQUENCEEXPECTED = "COMPONENTS OF in a SEQUENCE type shall refer to another SEQUENCE type instead of `{0}''";
    private static final String SETEXPECTED = "COMPONENTS OF in a SET type shall refer to another SET type instead of `{0}''";
    private final ASN1Type componentsOfType;
    private CompilationTimeStamp trCompsofTimestamp;
    private ComponentTypeList componentTypes;

    public ComponentsOfComponentType(ASN1Type componentsOfType) {
        this.componentsOfType = componentsOfType;
        if (null != componentsOfType) {
            componentsOfType.setFullNameParent(this);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.componentsOfType == child) {
            return builder.append(FULLNAMEPART);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (null != this.componentsOfType) {
            this.componentsOfType.setMyScope(scope);
        }
        if (null != this.componentTypes) {
            this.componentTypes.setMyScope(scope);
        }
    }

    @Override
    public int getNofComps() {
        if (null != this.componentTypes) {
            return this.componentTypes.getNofComps();
        }
        return 0;
    }

    @Override
    public CompField getCompByIndex(int index) {
        if (null != this.componentTypes) {
            return this.componentTypes.getCompByIndex(index);
        }
        return null;
    }

    @Override
    public boolean hasCompWithName(Identifier identifier) {
        if (null != this.componentTypes) {
            return this.componentTypes.hasCompWithName(identifier);
        }
        return false;
    }

    @Override
    public CompField getCompByName(Identifier identifier) {
        if (null != this.componentTypes) {
            return this.componentTypes.getCompByName(identifier);
        }
        return null;
    }

    @Override
    public void trCompsof(CompilationTimeStamp timestamp, IReferenceChain referenceChain, boolean isSet) {
        CTs_EE_CTs tempCtss;
        if (null != this.trCompsofTimestamp && !this.trCompsofTimestamp.isLess(timestamp)) {
            return;
        }
        if (null == this.componentsOfType) {
            return;
        }
        IType type = this.componentsOfType.getTypeRefdLast(timestamp);
        if (type.getIsErroneous(timestamp)) {
            return;
        }
        switch (type.getTypetype()) {
            case TYPE_ASN1_SET: {
                if (!isSet) {
                    this.getLocation().reportSemanticError(MessageFormat.format(SEQUENCEEXPECTED, type.getFullName()));
                    this.trCompsofTimestamp = timestamp;
                    return;
                }
                referenceChain.markState();
                if (referenceChain.add(this.componentsOfType)) {
                    ((ASN1_Set_Type)type).trCompsof(timestamp, referenceChain);
                }
                referenceChain.previousState();
                tempCtss = ((ASN1_Set_Type)type).components;
                break;
            }
            case TYPE_ASN1_SEQUENCE: {
                if (isSet) {
                    this.getLocation().reportSemanticError(MessageFormat.format(SETEXPECTED, type.getFullName()));
                    this.trCompsofTimestamp = timestamp;
                    return;
                }
                referenceChain.markState();
                if (referenceChain.add(this.componentsOfType)) {
                    ((ASN1_Sequence_Type)type).trCompsof(timestamp, referenceChain);
                }
                referenceChain.previousState();
                tempCtss = ((ASN1_Sequence_Type)type).components;
                break;
            }
            default: {
                this.trCompsofTimestamp = timestamp;
                return;
            }
        }
        if (timestamp.equals(this.trCompsofTimestamp)) {
            return;
        }
        this.componentTypes = new ComponentTypeList();
        type.check(timestamp);
        for (int i = 0; i < tempCtss.getNofRootComps(); ++i) {
            CompField compfield = tempCtss.getRootCompByIndex(i).newInstance();
            compfield.setLocation(this.location);
            RegularComponentType componentType = new RegularComponentType(compfield);
            componentType.setLocation(this.location);
            this.componentTypes.addComponentType(componentType);
        }
        this.componentTypes.setMyScope(this.componentsOfType.getMyScope());
        this.componentTypes.setFullNameParent(this);
        this.trCompsofTimestamp = timestamp;
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.componentsOfType != null) {
            this.componentsOfType.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.componentsOfType == null || this.componentsOfType.accept(v);
    }
}

