/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.types;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.ASN1Type;
import org.eclipse.titan.designer.AST.ASN1.types.ComponentTypeList;
import org.eclipse.titan.designer.AST.ASN1.types.ExtensionAndException;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class CTs_EE_CTs
extends ASTNode {
    public static final String DUPLICATECOMPONENTFIRST = "{0} `{1}'' was first defined here";
    public static final String DUPLICATECOMPONENTREPEATED = "Duplicate {0} identifier in {1}: `{2}'' was declared here again";
    private final ComponentTypeList componentTypeList1;
    private final ExtensionAndException extensionAndException;
    private final ComponentTypeList componentTypeList2;
    private ASN1Type myType;
    private CompilationTimeStamp lastTimeChecked;
    protected ArrayList<CompField> components = new ArrayList();
    private HashMap<String, CompField> componentsMap = new HashMap();

    public CTs_EE_CTs(ComponentTypeList componentTypeList1, ExtensionAndException extensionAndException, ComponentTypeList componentTypeList2) {
        this.componentTypeList1 = null != componentTypeList1 ? componentTypeList1 : new ComponentTypeList();
        this.extensionAndException = extensionAndException;
        this.componentTypeList2 = null != componentTypeList2 ? componentTypeList2 : new ComponentTypeList();
        this.componentTypeList1.setFullNameParent(this);
        if (null != extensionAndException) {
            extensionAndException.setFullNameParent(this);
        }
        this.componentTypeList2.setFullNameParent(this);
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        this.componentTypeList1.setMyScope(scope);
        if (null != this.extensionAndException) {
            this.extensionAndException.setMyScope(scope);
        }
        this.componentTypeList2.setMyScope(scope);
    }

    public void setMyType(ASN1Type type) {
        this.myType = type;
    }

    public int getNofComps() {
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        return this.components.size();
    }

    public int getNofRootComps() {
        return this.componentTypeList1.getNofComps() + this.componentTypeList2.getNofComps();
    }

    public CompField getCompByIndex(int index) {
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        return this.components.get(index);
    }

    public CompField getRootCompByIndex(int index) {
        int cts1Size = this.componentTypeList1.getNofComps();
        if (index < cts1Size) {
            return this.componentTypeList1.getCompByIndex(index);
        }
        return this.componentTypeList2.getCompByIndex(index - cts1Size);
    }

    public boolean hasCompWithName(Identifier identifier) {
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        return this.componentsMap.containsKey(identifier.getName());
    }

    public CompField getCompByName(Identifier identifier) {
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        return this.componentsMap.get(identifier.getName());
    }

    public void trCompsof(CompilationTimeStamp timestamp, IReferenceChain referenceChain, boolean inEllipsis) {
        boolean isSet = IType.Type_type.TYPE_ASN1_SET.equals((Object)this.myType.getTypetype());
        if (inEllipsis) {
            if (null != this.extensionAndException) {
                this.extensionAndException.trCompsof(timestamp, referenceChain, isSet);
            }
        } else {
            this.componentTypeList1.trCompsof(timestamp, referenceChain, isSet);
            this.componentTypeList2.trCompsof(timestamp, referenceChain, isSet);
        }
    }

    public boolean hasEllipsis() {
        return null != this.extensionAndException;
    }

    public void check(CompilationTimeStamp timestamp) {
        int i;
        String componentName;
        String typeName;
        Module module;
        if (null != this.lastTimeChecked && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        if (null != this.myScope && null != this.lastTimeChecked && null != (module = this.myScope.getModuleScope()) && module.getSkippedFromSemanticChecking()) {
            this.lastTimeChecked = timestamp;
            return;
        }
        if (null == this.myType) {
            return;
        }
        if (null == this.components) {
            this.components = new ArrayList();
            this.componentsMap = new HashMap();
        }
        this.lastTimeChecked = timestamp;
        this.components.clear();
        this.componentsMap.clear();
        switch (this.myType.getTypetype()) {
            case TYPE_ASN1_SEQUENCE: {
                typeName = "SEQUENCE";
                componentName = "Component";
                break;
            }
            case TYPE_ASN1_SET: {
                typeName = "SET";
                componentName = "Component";
                break;
            }
            case TYPE_ASN1_CHOICE: {
                typeName = "CHOICE";
                componentName = "Alternative";
                break;
            }
            default: {
                typeName = "<unknown>";
                componentName = "component";
            }
        }
        for (i = 0; i < this.componentTypeList1.getNofComps(); ++i) {
            this.checkComponentField(this.componentTypeList1.getCompByIndex(i), typeName, componentName);
        }
        if (null != this.extensionAndException) {
            for (i = 0; i < this.extensionAndException.getNofComps(); ++i) {
                this.checkComponentField(this.extensionAndException.getCompByIndex(i), typeName, componentName);
            }
        }
        for (i = 0; i < this.componentTypeList2.getNofComps(); ++i) {
            this.checkComponentField(this.componentTypeList2.getCompByIndex(i), typeName, componentName);
        }
        this.components.trimToSize();
        for (CompField componentField : this.components) {
            Type type = componentField.getType();
            type.setParentType(this.myType);
            componentField.check(timestamp);
        }
    }

    protected void checkComponentField(CompField componentField, String typeName, String componentName) {
        Identifier identifier = componentField.getIdentifier();
        String name = identifier.getName();
        if (this.componentsMap.containsKey(name)) {
            Location tempLocation = this.componentsMap.get(name).getIdentifier().getLocation();
            tempLocation.reportSingularSemanticError(MessageFormat.format(DUPLICATECOMPONENTFIRST, componentName, identifier.getDisplayName()));
            identifier.getLocation().reportSingularSemanticError(MessageFormat.format(DUPLICATECOMPONENTREPEATED, componentName, typeName, identifier.getDisplayName()));
        } else {
            this.componentsMap.put(name, componentField);
            this.components.add(componentField);
            if (!identifier.getHasValid(Identifier.Identifier_type.ID_TTCN)) {
                identifier.getLocation().reportSingularSemanticWarning(MessageFormat.format("The identifier `{0}'' is not reachable from TTCN-3", identifier.getDisplayName()));
            }
        }
    }

    public List<CompField> getComponentsWithPrefix(String prefix) {
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        ArrayList<CompField> compFields = new ArrayList<CompField>();
        for (int i = 0; i < this.components.size(); ++i) {
            if (!this.components.get(i).getIdentifier().getName().startsWith(prefix)) continue;
            compFields.add(this.components.get(i));
        }
        return compFields;
    }

    public Object[] getOutlineChildren() {
        int i;
        int size;
        ArrayList<CompField> result = new ArrayList<CompField>();
        if (null != this.componentTypeList1) {
            size = this.componentTypeList1.getNofComps();
            for (i = 0; i < size; ++i) {
                result.add(this.componentTypeList1.getCompByIndex(i));
            }
        }
        if (null != this.componentTypeList2) {
            size = this.componentTypeList2.getNofComps();
            for (i = 0; i < size; ++i) {
                result.add(this.componentTypeList2.getCompByIndex(i));
            }
        }
        return result.toArray();
    }

    public void getEnclosingField(int offset, ReferenceFinder rf) {
        for (CompField field : this.components) {
            if (!field.getLocation().containsOffset(offset) && !field.getIdentifier().getLocation().containsOffset(offset)) continue;
            rf.type = this.myType;
            rf.fieldId = field.getIdentifier();
            field.getType().getEnclosingField(offset, rf);
            return;
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.componentTypeList1 != null) {
            this.componentTypeList1.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.extensionAndException != null) {
            this.extensionAndException.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.componentTypeList2 != null) {
            this.componentTypeList2.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.componentTypeList1 != null && !this.componentTypeList1.accept(v)) {
            return false;
        }
        if (this.extensionAndException != null && !this.extensionAndException.accept(v)) {
            return false;
        }
        return this.componentTypeList2 == null || this.componentTypeList2.accept(v);
    }
}

