/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.sew.launcher.workflow;

import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.efm.sew.launcher.workflow.Director;
import org.eclipse.efm.sew.launcher.workflow.DirectorCustomImpl;
import org.eclipse.efm.sew.launcher.workflow.IWorkflowConfigurationConstants;
import org.eclipse.efm.sew.launcher.workflow.WorkspaceCustomImpl;
import org.eclipse.efm.sew.launcher.workflow.common.CommonFactory;
import org.eclipse.efm.sew.launcher.workflow.common.ConsoleLogFormatCustomImpl;
import org.eclipse.efm.sew.launcher.workflow.common.ConsoleVerboseKind;
import org.eclipse.efm.sew.launcher.workflow.common.DeveloperTuningOptionCustomImpl;
import org.eclipse.efm.sew.launcher.workflow.common.ManifestCustomImpl;
import org.eclipse.efm.sew.launcher.workflow.common.ShellModeCustomImpl;
import org.eclipse.efm.sew.launcher.workflow.common.SymbexOption;
import org.eclipse.efm.sew.launcher.workflow.impl.WorkflowImpl;
import org.eclipse.efm.sew.launcher.workflow.util.PrettyPrintWriter;

public class WorkflowCustomImpl
extends WorkflowImpl
implements IWorkflowConfigurationConstants {
    private static final String WORKFLOW_HEADER = "@sew< workflow , 1.0 >:";
    private static final String WORKFLOW_FOOTER = "//EOF of @sew< workflow , 1.0 >:";
    private static final String WORKFLOW_COMMENT = "Symbolic Execution Workflow\nDiversity Tool Configuration\nCEA - LIST";

    public WorkflowCustomImpl() {
    }

    public WorkflowCustomImpl(String name) {
        this.setName(name);
    }

    public WorkflowCustomImpl(String name, String description) {
        this.setName(name);
        this.setDescription(description);
    }

    public static WorkflowCustomImpl create(ILaunchConfiguration configuration, IPath rootPath) {
        String str;
        String modelAnalysis;
        boolean enabledExtension;
        WorkflowCustomImpl workflow = new WorkflowCustomImpl();
        workflow.setComment(WORKFLOW_COMMENT);
        WorkspaceCustomImpl workspace = WorkspaceCustomImpl.create(configuration, rootPath);
        workflow.setWorkspace(workspace);
        try {
            enabledExtension = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_EXTENSION", false);
        }
        catch (CoreException e) {
            e.printStackTrace();
            enabledExtension = false;
        }
        DirectorCustomImpl director = DirectorCustomImpl.create(workflow, configuration, enabledExtension);
        try {
            modelAnalysis = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_MODEL_ANALYSIS", "Exploration");
        }
        catch (CoreException e) {
            e.printStackTrace();
            modelAnalysis = "Exploration";
        }
        switch (modelAnalysis) {
            case "Exploration": {
                director.setName("exploration");
                break;
            }
            case "Transition Coverage": {
                director.setName("transition#coverage");
                break;
            }
            case "Behavior Selection": {
                director.setName("behavior#selection");
                break;
            }
            default: {
                director.setName("offline#testing");
            }
        }
        director.setDescription("as main execution objective");
        workflow.getDirector().add((Object)director);
        if (enabledExtension) {
            director = DirectorCustomImpl.createSecond(workflow, configuration);
            director.setName("extension");
            director.setDescription("of execution for trace generation");
            workflow.getDirector().add((Object)director);
        }
        SymbexOption symbexOption = CommonFactory.eINSTANCE.createSymbexOption();
        workflow.setSymbexOption(symbexOption);
        try {
            str = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_CONSOLE_LOG_VERBOSE_LEVEL", "MINIMUM");
        }
        catch (CoreException e) {
            e.printStackTrace();
            str = "MINIMUM";
        }
        ConsoleVerboseKind verbose = ConsoleVerboseKind.get(str);
        if (verbose == null) {
            verbose = ConsoleVerboseKind.MINIMUM;
        }
        ConsoleLogFormatCustomImpl console = ConsoleLogFormatCustomImpl.create(verbose);
        workflow.setConsole(console);
        ShellModeCustomImpl shellMode = ShellModeCustomImpl.create(configuration);
        workflow.setShellMode(shellMode);
        DeveloperTuningOptionCustomImpl devTuning = DeveloperTuningOptionCustomImpl.createWorkflow(configuration);
        workflow.setDeveloperTuning(devTuning);
        return workflow;
    }

    public void toWriter(IPath filePath) {
        try {
            FileWriter buffer = new FileWriter(filePath.toOSString());
            PrettyPrintWriter writer = new PrettyPrintWriter(buffer);
            this.toWriter(writer);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void toWriter(PrettyPrintWriter writer) {
        DeveloperTuningOptionCustomImpl devTuning;
        ShellModeCustomImpl shellMode;
        ConsoleLogFormatCustomImpl console;
        SymbexOption symbexMode;
        writer.appendEol2(WORKFLOW_HEADER);
        writer.commentLine(this.getComment());
        writer.appendTab("workflow");
        String str = this.getName();
        if (str != null) {
            writer.append(' ').append(str);
        }
        if ((str = this.getDescription()) != null) {
            writer.append(" '").append(str).append("'");
        }
        writer.appendEol(" {");
        PrettyPrintWriter writer2 = writer.itab2();
        ManifestCustomImpl manifest = (ManifestCustomImpl)this.getManifest();
        if (manifest != null) {
            manifest.toWriter(writer2);
        }
        ((WorkspaceCustomImpl)this.getWorkspace()).toWriter(writer2);
        if (!this.getDirector().isEmpty()) {
            for (Director director : this.getDirector()) {
                ((DirectorCustomImpl)director).toWriter(writer2);
            }
        }
        if ((symbexMode = this.getSymbexOption()) != null) {
            writer.appendTab2Eol("symbex 'option' [");
            writer.appendTab3Eol("separation_of_pc_disjunction = false");
            writer.appendTab3Eol("check_pathcondition_satisfiability = true");
            writer.appendTab3Eol("constraint_solver = 'CVC4'  // Z3");
            writer.appendTab2Eol("] // end symbex");
        }
        if ((console = (ConsoleLogFormatCustomImpl)this.getConsole()) != null) {
            console.toWriter(writer2);
        }
        if ((shellMode = (ShellModeCustomImpl)this.getShellMode()) != null) {
            shellMode.toWriter(writer2);
        }
        if ((devTuning = (DeveloperTuningOptionCustomImpl)this.getDeveloperTuning()) != null) {
            devTuning.toWriter(writer2);
        }
        writer.appendTabEol("}");
        writer.appendEol_Eol(WORKFLOW_FOOTER);
        writer.appendEol().appendEol("/*").appendEol("# Grammar Reference").appendEol2("\n## Trace Specification\n- [*] , use for ANY element\n- com_element_id ::= <port_name_id> | <signal_name_id>\n- com = <com_element_id>\n- input = <com_element_id>\n- output = <com_element_id>\n- input#env = <com_element_id>\n- output#env = <com_element_id>\n\n- variable = <variable_name_id>\n- newfresh = <variable_name_id>\n- state = <state_name_id>\n- transition = <transition_name_id>\n- statemachine = <statemachine_name_id>").appendEol2("\n## Trace Format Specification\n- line#wrap#width = 80\n- line#wrap#separator = \"\\n\\\t\"\n\n// %1% --> ec#id\n// %2% --> ec#eval\n// %3% --> ec#hight\n// %4% --> ec#width\n// %5% --> ec#weight\n// %6% --> statemachine configuration i.e. control node\n- context#ufid = \"ctx< %1% > %6%\"\n\n// %1% --> trace number\n// %2% --> execution context leaf identifier\n- header = \"TRACE NUMBER %1%\"\n- end    = \"\"\n- init#begin = \"\\t// Initialization parameter values:\"\n- init#end   = \"\\n\"\n\n// %1% --> string message\n// %2% --> execution context identifier\n- comment   = \"//%1%\"\n- separator = \"%1%\"\n- newline   = \"\n%1%\"\n\n// %1% --> step identifier\n// %2% --> execution context identifier\n- step#begin = \"\\t#step#begin %1%\"\n- step#end   = \"\\t#step#end %1%\"\n\n// %1% --> condition\n// %2% --> execution context identifier\n- path#condition = \"\\tPC: %1%\"\n- path#timed#condition = \"\\tPtC: %1%\"\n- node#condition = \"\\tNC: %1%\"\n- node#timed#condition = \"\\tNtC: %1%\"\n\n// %1% --> machine runtime pid\n// %2% --> machine container identifier\n// %3% --> port | signal | variable | machine | transition | routine\n// %4% --> value\n- time   = \"\\t%4%\"\n- assign = \"\\t%2%:%3% = %4%\"\n- newfresh = \"\\tnewfresh %2%->%3%( %4% )\"\n- input  = \"\\tinput  %2%->%3%( %4% )\"\n- output = \"\\toutput %2%->%3%( %4% )\"\n- input#env  = \"\\tINPUT  %2%->%3%( %4% )\"\n- output#env = \"\\tOUTPUT %2%->%3%( %4% )\"").appendEol("*/");
    }
}

