/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.engine;

public class SpeedCoupling {
    static final int NB_SPEED_POINTS = 4;
    private float minSpeed = 200.0f;
    private long lagTime = 100L;
    private long reducTime = 500L;
    private float coefIncStep = 0.05f;
    private float coefDecStep = 0.0f;
    long[] _cursor_time = new long[4];
    int[] _cursor_x = new int[4];
    int[] _cursor_y = new int[4];
    long _prev_time;
    float[] _speeds = new float[3];
    float _speed_coef = 0.0f;
    float _mspeed = 0.0f;
    float _mspeedX = 0.0f;
    float _mspeedY = 0.0f;

    public void setTimeParameters(long lag_time, long reduc_time) {
        this.lagTime = lag_time;
        this.reducTime = reduc_time;
    }

    public void setSpeedParameters(float min_speed) {
        this.minSpeed = min_speed;
    }

    public void setCoefParameters(float coef_inc, float coef_dec) {
        this.coefIncStep = coef_inc;
        this.coefDecStep = coef_dec;
    }

    public void addPoint(int x, int y, long currentTime) {
        int i;
        for (i = 1; i < 4; ++i) {
            this._cursor_time[i - 1] = this._cursor_time[i];
            this._cursor_x[i - 1] = this._cursor_x[i];
            this._cursor_y[i - 1] = this._cursor_y[i];
        }
        this._cursor_time[3] = currentTime;
        this._cursor_x[3] = x;
        this._cursor_y[3] = y;
        for (i = 0; i < this._speeds.length; ++i) {
            this._speeds[i] = this._cursor_time[i + 1] != this._cursor_time[i] ? (float)Math.sqrt((this._cursor_x[i + 1] - this._cursor_x[i]) * (this._cursor_x[i + 1] - this._cursor_x[i]) + (this._cursor_y[i + 1] - this._cursor_y[i]) * (this._cursor_y[i + 1] - this._cursor_y[i])) / (float)(this._cursor_time[i + 1] - this._cursor_time[i]) : 0.0f;
        }
        this._prev_time = System.currentTimeMillis();
        float ms = 0.0f;
        for (int i2 = 0; i2 < this._speeds.length; ++i2) {
            ms += this._speeds[i2];
        }
        this._mspeed = ms = ms / (float)this._speeds.length * 1000.0f;
        this._mspeedX = this._cursor_x[3] - this._cursor_x[0];
        this._mspeedY = this._cursor_y[3] - this._cursor_y[0];
        if (ms == 0.0f) {
            this._mspeedY = 0.0f;
            this._mspeedX = 0.0f;
        } else {
            float norm = (float)Math.sqrt(this._mspeedX * this._mspeedX + this._mspeedY * this._mspeedY);
            if (norm == 0.0f) {
                this._mspeedY = 0.0f;
                this._mspeedX = 0.0f;
            } else {
                this._mspeedX = ms / norm * this._mspeedX;
                this._mspeedY = ms / norm * this._mspeedY;
            }
        }
        this._speed_coef = ms > this.minSpeed ? (this._speed_coef += this.coefIncStep) : (this._speed_coef -= this.coefDecStep);
        if (this._speed_coef > 1.0f) {
            this._speed_coef = 1.0f;
        }
        if (this._speed_coef < 0.0f) {
            this._speed_coef = 0.0f;
        }
    }

    public float getMeanSpeed() {
        return this._mspeed;
    }

    public float getMeanSpeedVecX() {
        return this._mspeedX;
    }

    public float getMeanSpeedVecY() {
        return this._mspeedY;
    }

    public float getCoef() {
        long diff_time = System.currentTimeMillis() - this._prev_time;
        if (diff_time > this.lagTime) {
            this._speed_coef = diff_time < this.lagTime + this.reducTime ? (this._speed_coef -= this._speed_coef * ((float)(diff_time - this.lagTime) / (float)this.reducTime)) : 0.0f;
        }
        return this._speed_coef;
    }
}

