/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.executors;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.common.actions.MergeLog;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.cfg.ConfigFileHandler;
import org.eclipse.titan.common.path.PathConverter;
import org.eclipse.titan.common.path.PathUtil;
import org.eclipse.titan.common.path.TITANPathUtilities;
import org.eclipse.titan.common.utils.IOUtils;
import org.eclipse.titan.common.utils.StringUtils;
import org.eclipse.titan.executor.Activator;
import org.eclipse.titan.executor.HostController;
import org.eclipse.titan.executor.TITANConsole;
import org.eclipse.titan.executor.designerconnection.DynamicLinkingHelper;
import org.eclipse.titan.executor.designerconnection.EnvironmentHelper;
import org.eclipse.titan.executor.executors.ExecuteDialog;
import org.eclipse.titan.executor.executors.HostJob;
import org.eclipse.titan.executor.graphics.ImageCache;
import org.eclipse.titan.executor.properties.FieldEditorPropertyPage;
import org.eclipse.titan.executor.tabpages.maincontroller.BaseMainControllerTab;
import org.eclipse.titan.executor.views.executormonitor.ExecutorStorage;
import org.eclipse.titan.executor.views.executormonitor.LaunchStorage;
import org.eclipse.titan.executor.views.executormonitor.MainControllerElement;
import org.eclipse.titan.executor.views.notification.Notification;
import org.eclipse.titan.executor.views.testexecution.ExecutedTestcase;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.progress.IProgressConstants;

public abstract class BaseExecutor {
    protected static final boolean CREATE_TEMP_CFG = false;
    public static final String PADDEDDATETIMEFORMAT = "%1$tF %1$tH:%1$tM:%1$tS.%1$tL000";
    public static final String DATETIMEFORMAT = "%1$tF %1$tH:%1$tM:%1$tS.%2$06d";
    public static final String MAIN_CONTROLLER = "Main Controller";
    protected static final String CONFIGFILEPATH_NULL = "Could not launch beacuse the configuration file's path is null";
    protected static final String ENVVARS_NULL = "Could not launch beacuse the environmental variables are not available";
    protected static final String NO_HOSTCONTROLLER_SPECIFIED = "No Host Controller was specified on this launch configuration's Host Controllers page";
    private static final String EMPTY_EXECUTION_FAILED_TITLE = "Execution failed";
    private static final String EMPTY_EXECUTION_FAILED_TEXT = "The configuration file selected does not have anything to execute";
    protected Map<String, String> environmentalVariables;
    private List<HostController> hostControllers;
    protected boolean appendEnvironmentalVariables = false;
    protected String projectName;
    protected IProject project;
    protected String workingdirectoryPath;
    protected String executablePath;
    protected String configFilePath;
    protected boolean automaticExecuteSectionExecution;
    protected List<String> availableTestcases;
    protected List<String> availableControlParts;
    protected List<String> availableTestSetNames;
    protected List<List<String>> availableTestSetContents;
    protected boolean executionStarted = false;
    protected boolean consoleLogging;
    protected boolean severityLevelExtraction;
    protected int maximumNotificationCount;
    protected boolean verdictExtraction;
    protected boolean keepTemporarilyGeneratedConfigFiles;
    protected boolean logFileNameDefined = false;
    protected String mLogFileName = null;
    protected boolean logFilesMerged = false;
    protected String mcPort;
    protected String mcHost = "NULL";
    protected String label = "Base Executor";
    protected MainControllerElement mainControllerRoot;
    private ILaunch launchStarted;
    protected ArrayList<ExecutedTestcase> executedTests = new ArrayList();
    private LinkedList<Notification> notifications = new LinkedList();
    protected String lastTimeSelection;
    protected int lastTimeSelectionTime = 1;
    protected ExecuteDialog.ExecutableType lastTimeSelectionType = ExecuteDialog.ExecutableType.NONE;
    protected File temporalConfigFile;
    private List<HostJob> innerHostControllers = new CopyOnWriteArrayList<HostJob>();

    public BaseExecutor(ILaunchConfiguration configuration) throws CoreException {
        int size;
        this.projectName = configuration.getAttribute("org.eclipse.titan.executor.projectName", "");
        this.project = DynamicLinkingHelper.getProject(this.projectName);
        String projectLocation = null == this.project ? "" : this.project.getLocation().toOSString();
        this.workingdirectoryPath = this.resolvePathFromAttribute(configuration, projectLocation, "org.eclipse.titan.executor.workingdirectoryPath");
        this.executablePath = this.resolvePathFromAttribute(configuration, projectLocation, "org.eclipse.titan.executor.executableFilePath");
        this.configFilePath = this.resolvePathFromAttribute(configuration, projectLocation, "org.eclipse.titan.executor.configurationFilePath");
        this.automaticExecuteSectionExecution = configuration.getAttribute("org.eclipse.titan.executor.executeConfigurationFileOnLaunch", false);
        this.environmentalVariables = configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, (Map)null);
        this.appendEnvironmentalVariables = configuration.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
        this.availableControlParts = configuration.getAttribute("availableControlParts", (List)null);
        this.availableTestcases = configuration.getAttribute("availableTestcases", (List)null);
        this.availableTestSetNames = configuration.getAttribute("testsetNames", (List)null);
        if (null != this.availableTestSetNames) {
            this.availableTestSetContents = new ArrayList<List<String>>();
            for (String testsetName : this.availableTestSetNames) {
                this.availableTestSetContents.add(configuration.getAttribute("testcasesOf" + testsetName, (List)null));
            }
        }
        this.consoleLogging = configuration.getAttribute("org.eclipse.titan.executor.consoleLogging", true);
        boolean testcaseRefreshOnStart = configuration.getAttribute("org.eclipse.titan.executor.testcaseRefreshOnStart", true);
        this.severityLevelExtraction = configuration.getAttribute("org.eclipse.titan.executor.severityLevelExtraction", true);
        this.maximumNotificationCount = configuration.getAttribute("org.eclipse.titan.executor.maximumNotificationLineCount", 1000);
        this.verdictExtraction = configuration.getAttribute("org.eclipse.titan.executor.verdictExtraction", true);
        this.keepTemporarilyGeneratedConfigFiles = configuration.getAttribute("org.eclipse.titan.executor.keepTemporarilyGeneratedConfigurationFiles", true);
        String nullString = null;
        this.lastTimeSelection = configuration.getAttribute("lastTimeSelection", nullString);
        this.lastTimeSelectionTime = configuration.getAttribute("lastTimeSelectionTime", 1);
        int tempLastSelectionType = configuration.getAttribute("lastTimeSelectionType", 0);
        this.lastTimeSelectionType = ExecuteDialog.ExecutableType.getExecutableType(tempLastSelectionType);
        List hostNames = configuration.getAttribute("org.eclipse.titan.executor.hostNames", (List)null);
        List hostWorkingDirectories = configuration.getAttribute("org.eclipse.titan.executor.hostWorkingDirectories", (List)null);
        List hostExecutables = configuration.getAttribute("org.eclipse.titan.executor.hostExecutables", (List)null);
        List hostCommands = configuration.getAttribute("org.eclipse.titan.executor.hostCommands", (List)null);
        if (null != hostNames && null != hostWorkingDirectories && null != hostCommands && null != hostExecutables && (size = hostNames.size()) > 0 && size == hostWorkingDirectories.size() && size == hostExecutables.size() && size == hostCommands.size()) {
            this.hostControllers = new ArrayList<HostController>(size);
            for (int i = 0; i < size; ++i) {
                this.hostControllers.add(new HostController((String)hostNames.get(i), (String)hostWorkingDirectories.get(i), (String)hostExecutables.get(i), (String)hostCommands.get(i)));
            }
        }
        if (null != this.executablePath && this.executablePath.length() > 0 && testcaseRefreshOnStart) {
            BaseMainControllerTab.ExecutableCalculationHelper helper = BaseMainControllerTab.checkExecutable(configuration, this.project, URIUtil.toURI((String)this.executablePath));
            if (helper.executableFileIsValid && helper.executableIsExecutable) {
                helper.availableTestcases.toArray(new String[helper.availableTestcases.size()]);
            }
            if (null == this.availableTestcases) {
                this.availableTestcases = helper.availableTestcases;
            } else {
                for (String testcase : helper.availableTestcases) {
                    if (testcase.endsWith(".control")) {
                        if (this.availableControlParts.contains(testcase)) continue;
                        this.availableControlParts.add(testcase);
                        continue;
                    }
                    if (this.availableTestcases.contains(testcase)) continue;
                    this.availableTestcases.add(testcase);
                }
            }
        }
        this.label = configuration.getName();
        try {
            this.label = this.label + " [ " + configuration.getType().getName() + " ]";
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }

    private String resolvePathFromAttribute(ILaunchConfiguration configuration, String projectLocation, String attribute) throws CoreException {
        String path = configuration.getAttribute(attribute, (String)null);
        if (!StringUtils.isNullOrEmpty((String)path)) {
            URI uri = TITANPathUtilities.resolvePathURI((String)path, (String)projectLocation);
            path = URIUtil.toPath((URI)uri).toOSString();
        }
        return path;
    }

    public void dispose() {
        this.disposeHostControllers();
    }

    protected final void disposeHostControllers() {
        for (HostJob job : this.innerHostControllers) {
            job.dispose();
        }
        this.innerHostControllers.clear();
    }

    protected final void saveLastTimeUsageInfo() {
        if (null == this.launchStarted) {
            return;
        }
        ILaunchConfiguration configuration = this.launchStarted.getLaunchConfiguration();
        if (null == configuration) {
            return;
        }
        try {
            ILaunchConfigurationWorkingCopy copy = configuration.getWorkingCopy();
            copy.setAttribute("lastTimeSelection", this.lastTimeSelection);
            copy.setAttribute("lastTimeSelectionTime", this.lastTimeSelectionTime);
            copy.setAttribute("lastTimeSelectionType", this.lastTimeSelectionType.getValue());
            copy.doSave();
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }

    protected final void addNotifications(List<Notification> notificationList) {
        if (0 != this.maximumNotificationCount && (float)(this.notifications.size() + notificationList.size()) > (float)this.maximumNotificationCount * 1.2f) {
            if (notificationList.size() > this.maximumNotificationCount) {
                this.notifications.clear();
            } else {
                while (this.notifications.size() + notificationList.size() > this.maximumNotificationCount - 1) {
                    this.notifications.removeFirst();
                }
            }
        }
        this.notifications.addAll(notificationList);
    }

    protected final void addNotification(Notification notification) {
        this.notifications.add(notification);
        if (this.maximumNotificationCount != 0 && (float)this.notifications.size() > (float)this.maximumNotificationCount * 1.2f) {
            while (this.notifications.size() > this.maximumNotificationCount - 1) {
                this.notifications.removeFirst();
            }
        }
    }

    public void startSession(ILaunch launch) {
        this.launchStarted = launch;
        this.deleteLogFiles();
        if (LaunchStorage.getLaunchElementMap().containsKey(launch)) {
            this.mainControllerRoot = new MainControllerElement(MAIN_CONTROLLER, this);
            LaunchStorage.getLaunchElementMap().get(launch).addChildToEnd(this.mainControllerRoot);
        }
        ExecutorStorage.getExecutorMap().put(launch, this);
        if (Activator.getMainView() != null) {
            Activator.getMainView().expandToLevel(this.mainControllerRoot, 0);
            Activator.getMainView().refreshAll();
        }
        this.saveLastTimeUsageInfo();
    }

    public final MainControllerElement mainControllerRoot() {
        return this.mainControllerRoot;
    }

    public final void mainControllerRoot(MainControllerElement element) {
        this.mainControllerRoot = element;
    }

    public final ILaunch getLaunchStarted() {
        return this.launchStarted;
    }

    public final List<ExecutedTestcase> executedTests() {
        return this.executedTests;
    }

    public final LinkedList<Notification> notifications() {
        return this.notifications;
    }

    public abstract boolean isTerminated();

    public abstract IProcess getProcess();

    public abstract void terminate(boolean var1);

    protected void shutdownSession() {
        if (!this.executionStarted) {
            return;
        }
        this.mergeLogFiles();
        if (this.project == null) {
            return;
        }
        WorkspaceJob op = new WorkspaceJob("Refreshing the project `" + this.project.getName() + "' to discover log files"){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                try {
                    BaseExecutor.this.project.refreshLocal(2, null);
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                }
                return Status.OK_STATUS;
            }
        };
        op.setPriority(20);
        op.setSystem(true);
        op.setUser(false);
        op.setRule((ISchedulingRule)this.project);
        op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
        op.schedule();
    }

    public final void startHostControllers() {
        if (this.hostControllers == null || this.hostControllers.isEmpty()) {
            this.addNotification(new Notification(new Formatter().format(PADDEDDATETIMEFORMAT, new Date()).toString(), "", "", NO_HOSTCONTROLLER_SPECIFIED));
            return;
        }
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        Map<String, String> env = pb.environment();
        if (!this.appendEnvironmentalVariables) {
            env.clear();
        }
        if (this.environmentalVariables != null) {
            try {
                EnvironmentHelper.resolveVariables(env, this.environmentalVariables);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        }
        EnvironmentHelper.setTitanPath(env);
        EnvironmentHelper.set_LICENSE_FILE_PATH(env);
        IProject actualProject = DynamicLinkingHelper.getProject(this.projectName);
        if (actualProject != null) {
            EnvironmentHelper.set_LD_LIBRARY_PATH(actualProject, env);
        }
        MessageConsoleStream stream = TITANConsole.getConsole().newMessageStream();
        for (int i = 0; i < this.hostControllers.size(); ++i) {
            URI path;
            StringBuilder hostControllerLabel = new StringBuilder("Host Controller instance " + (i + 1));
            HostController controller = this.hostControllers.get(i);
            String command = controller.command();
            command = command.replace("%Host", controller.host());
            boolean oldStyleWorkingDir = true;
            if (actualProject == null) {
                path = URIUtil.toURI((String)controller.workingdirectory());
            } else {
                path = URIUtil.toURI((String)controller.workingdirectory());
                if (!path.isAbsolute()) {
                    oldStyleWorkingDir = false;
                    path = TITANPathUtilities.resolvePathURI((String)controller.workingdirectory(), (String)actualProject.getLocation().toOSString());
                }
            }
            String workingDirResult = PathConverter.convert((String)(oldStyleWorkingDir ? controller.workingdirectory() : URIUtil.toPath((URI)path).toOSString()), (boolean)true, (MessageConsole)TITANConsole.getConsole());
            command = command.replace("%Workingdirectory", workingDirResult);
            boolean oldStyleExecutable = true;
            if (actualProject == null) {
                path = URIUtil.toURI((String)controller.executable());
            } else {
                path = URIUtil.toURI((String)controller.executable());
                if (!path.isAbsolute()) {
                    oldStyleExecutable = false;
                    path = TITANPathUtilities.resolvePathURI((String)controller.executable(), (String)actualProject.getLocation().toOSString());
                }
            }
            String executableResult = PathConverter.convert((String)(oldStyleExecutable ? controller.executable() : URIUtil.toPath((URI)path).toOSString()), (boolean)true, (MessageConsole)TITANConsole.getConsole());
            String result = PathUtil.getRelativePath((String)workingDirResult, (String)executableResult);
            if (!result.equals(executableResult)) {
                result = "./" + result;
            }
            command = command.replace("%Executable", result);
            command = "NULL".equals(this.mcHost) ? command.replace("%MCHost", "0.0.0.0") : command.replace("%MCHost", this.mcHost);
            command = command.replace("%MCPort", this.mcPort);
            ArrayList<String> shellCommand = new ArrayList<String>();
            shellCommand.add("sh");
            shellCommand.add("-c");
            shellCommand.add(command);
            for (String c : shellCommand) {
                stream.print(c + ' ');
            }
            stream.println();
            pb.command(shellCommand);
            if (this.workingdirectoryPath != null) {
                pb.directory(new File(this.workingdirectoryPath));
            }
            try {
                Process proc = pb.start();
                HostJob job = new HostJob(hostControllerLabel.toString(), proc, this);
                this.innerHostControllers.add(job);
                job.setPriority(50);
                job.setUser(true);
                job.schedule();
                continue;
            }
            catch (IOException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
        }
    }

    public MenuManager createMenu(MenuManager manager) {
        return manager;
    }

    protected abstract String getDefaultLogFileName();

    private String getDefaultLogFileDir() {
        return ".";
    }

    private String getLogDir() {
        if (this.logFileNameDefined && this.mLogFileName != null) {
            File file = new File(this.mLogFileName);
            String parent = file.getParent();
            return parent != null ? parent : "";
        }
        return this.getDefaultLogFileDir();
    }

    protected String generateCfgString() {
        StringBuilder builder = new StringBuilder();
        String workingDirRelative = this.getDefaultLogFileDir();
        if (workingDirRelative != null && workingDirRelative.length() != 0) {
            builder.append("\n//This part was added by the TITAN Executor.\n");
            builder.append("[LOGGING]\n");
            builder.append("LogFile := ");
            builder.append("\"./" + workingDirRelative + '/');
            builder.append(this.getDefaultLogFileName());
            builder.append("\"\n\n");
        }
        return builder.toString();
    }

    protected ConfigFileHandler readConfigFile() {
        HashMap<String, String> env;
        if (StringUtils.isNullOrEmpty((String)this.configFilePath)) {
            return null;
        }
        ConfigFileHandler configHandler = new ConfigFileHandler();
        configHandler.readFromFile(this.configFilePath);
        HashMap<String, String> hashMap = env = this.appendEnvironmentalVariables ? new HashMap<String, String>(System.getenv()) : new HashMap();
        if (this.environmentalVariables != null) {
            try {
                EnvironmentHelper.resolveVariables(env, this.environmentalVariables);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        }
        configHandler.setEnvMap(env);
        configHandler.processASTs();
        this.logFileNameDefined = configHandler.isLogFileNameDefined();
        this.mLogFileName = configHandler.getLogFileName();
        return configHandler;
    }

    protected void deleteLogFiles() {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        if (!this.isDeleteLogFilesSet(preferenceStore)) {
            return;
        }
        String workingDirRelative = this.getLogDir();
        if (workingDirRelative == null) {
            return;
        }
        String logFileFolder = this.workingdirectoryPath + File.separator + workingDirRelative + File.separator;
        Path path = new Path(logFileFolder);
        IContainer folder = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)path);
        if (folder == null || !folder.exists()) {
            return;
        }
        StringBuilder filesThatCanNotBeDeleted = new StringBuilder();
        try {
            for (IResource resource : folder.members()) {
                try {
                    if (!(resource instanceof IFile) || !"log".equals(resource.getFileExtension())) continue;
                    resource.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    filesThatCanNotBeDeleted.append(resource.getName());
                    filesThatCanNotBeDeleted.append("\n");
                }
            }
            folder.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            ErrorReporter.parallelErrorDisplayInMessageDialog((String)"Error while deleting log files", (String)"The log folder is not accessible.");
        }
        if (filesThatCanNotBeDeleted.length() > 0) {
            ErrorReporter.parallelErrorDisplayInMessageDialog((String)"Error while deleting log files", (String)("The following log files can not be deleted:\n" + filesThatCanNotBeDeleted.toString()));
        }
    }

    private boolean isDeleteLogFilesSet(IPreferenceStore preferenceStore) {
        return Boolean.parseBoolean(FieldEditorPropertyPage.getOverlayedPreferenceValue(preferenceStore, (IResource)this.project, "org.eclipse.titan.executor.preferences.ExecutorPreferencePage", "deleteLogFiles"));
    }

    private boolean isLogFolderSet(IPreferenceStore preferenceStore) {
        return Boolean.parseBoolean(FieldEditorPropertyPage.getOverlayedPreferenceValue(preferenceStore, (IResource)this.project, "org.eclipse.titan.executor.preferences.ExecutorPreferencePage", "setLogFolder"));
    }

    protected void mergeLogFiles() {
        if (this.logFilesMerged) {
            return;
        }
        this.logFilesMerged = true;
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        if (!this.isAutomaticMergeEnabled(preferenceStore)) {
            return;
        }
        String workingDirRelative = this.getLogDir();
        if (workingDirRelative == null) {
            return;
        }
        String logFileFolder = this.workingdirectoryPath + File.separator + workingDirRelative + File.separator;
        Path path = new Path(logFileFolder);
        IContainer folder = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)path);
        if (folder == null || !folder.exists()) {
            return;
        }
        ArrayList<IFile> filesToMerge = new ArrayList<IFile>();
        try {
            folder.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            for (IResource resource : folder.members()) {
                if (!(resource instanceof IFile) || !"log".equals(resource.getFileExtension())) continue;
                try {
                    if (Boolean.valueOf(resource.getPersistentProperty(MergeLog.MERGED_FILE_PROPERTY)).booleanValue()) continue;
                    filesToMerge.add((IFile)resource);
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                }
            }
        }
        catch (CoreException e) {
            ErrorReporter.parallelErrorDisplayInMessageDialog((String)"Error while merging log files", (String)("The log folder " + logFileFolder + " is not accessible."));
        }
        MergeLog mergeLog = new MergeLog();
        mergeLog.setShowDialog(false);
        mergeLog.run(filesToMerge, false);
    }

    private boolean isAutomaticMergeEnabled(IPreferenceStore preferenceStore) {
        return Boolean.parseBoolean(FieldEditorPropertyPage.getOverlayedPreferenceValue(preferenceStore, (IResource)this.project, "org.eclipse.titan.executor.preferences.ExecutorPreferencePage", "automaticMergeEnabled"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateTemporalCfgFile(String cfgString) {
        boolean result;
        if (StringUtils.isNullOrEmpty((String)cfgString)) {
            return;
        }
        if (!this.keepTemporarilyGeneratedConfigFiles && null != this.temporalConfigFile && this.temporalConfigFile.exists() && !(result = this.temporalConfigFile.delete())) {
            ErrorReporter.logError((String)("The temporal configuration file " + this.temporalConfigFile.getName() + " could not be deleted"));
            return;
        }
        BufferedWriter writer = null;
        try {
            this.temporalConfigFile = File.createTempFile("temporal_", "_XXXXX.cfg", new File(this.workingdirectoryPath));
            if (!this.keepTemporarilyGeneratedConfigFiles) {
                this.temporalConfigFile.deleteOnExit();
            }
            writer = new BufferedWriter(new FileWriter(this.temporalConfigFile));
            writer.write(cfgString);
            IOUtils.closeQuietly((Closeable)writer);
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            this.temporalConfigFile = null;
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
    }

    protected class EmptyExecutionRunnable
    implements Runnable {
        @Override
        public void run() {
            MessageDialog.openError((Shell)new Shell(Display.getDefault()), (String)BaseExecutor.EMPTY_EXECUTION_FAILED_TITLE, (String)BaseExecutor.EMPTY_EXECUTION_FAILED_TEXT);
        }
    }
}

