/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportWizard;
import org.eclipse.team.core.ScmUrlImportDescription;
import org.eclipse.team.core.importing.provisional.IBundleImporter;
import org.eclipse.team.ui.IScmUrlImportWizardPage;
import org.eclipse.team.ui.TeamUI;

public class RepositoryImportWizard
extends Wizard {
    private Map<?, ?> fImportMap;
    private Map<String, IScmUrlImportWizardPage> fIdToPages = new HashMap<String, IScmUrlImportWizardPage>();
    private static final String STORE_SECTION = "RepositoryImportWizard";

    public RepositoryImportWizard(Map<?, ?> importMap) {
        IDialogSettings masterSettings = PDEPlugin.getDefault().getDialogSettings();
        this.setDialogSettings(this.getSettingsSection(masterSettings));
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_PLUGIN_IMPORT_WIZ);
        this.setWindowTitle(PDEUIMessages.ImportWizard_title);
        this.fImportMap = importMap;
    }

    public void addPages() {
        for (Map.Entry<?, ?> entry : this.fImportMap.entrySet()) {
            IBundleImporter importer = (IBundleImporter)entry.getKey();
            String importerId = importer.getId();
            ScmUrlImportDescription[] descriptions = (ScmUrlImportDescription[])entry.getValue();
            IScmUrlImportWizardPage page = this.fIdToPages.get(importerId);
            if (page != null) continue;
            try {
                page = TeamUI.getPages((String)importerId)[0];
            }
            catch (CoreException e) {
                PDEPlugin.log(e);
            }
            if (page == null) continue;
            page.setSelection(descriptions);
            this.fIdToPages.put(importerId, page);
            this.addPage((IWizardPage)page);
        }
    }

    private IDialogSettings getSettingsSection(IDialogSettings master) {
        IDialogSettings setting = master.getSection(STORE_SECTION);
        if (setting == null) {
            setting = master.addNewSection(STORE_SECTION);
        }
        return setting;
    }

    public boolean performFinish() {
        ArrayList<Object> plugins = new ArrayList<Object>();
        IWizardPage[] pages = this.getPages();
        HashMap<IBundleImporter, ScmUrlImportDescription[]> importMap = new HashMap<IBundleImporter, ScmUrlImportDescription[]>();
        int i = 0;
        while (i < pages.length) {
            IScmUrlImportWizardPage page = (IScmUrlImportWizardPage)pages[i];
            if (page.finish()) {
                ScmUrlImportDescription[] descriptions = page.getSelection();
                if (descriptions != null && descriptions.length > 0) {
                    int j = 0;
                    while (j < descriptions.length) {
                        Object plugin;
                        Object importer;
                        if (j == 0 && (importer = descriptions[j].getProperty("BUNDLE_IMPORTER")) instanceof IBundleImporter) {
                            importMap.put((IBundleImporter)importer, descriptions);
                        }
                        if ((plugin = descriptions[j].getProperty("PLUGIN")) != null) {
                            plugins.add(plugin);
                        }
                        ++j;
                    }
                }
            } else {
                return false;
            }
            ++i;
        }
        if (!importMap.isEmpty()) {
            PluginImportWizard.doImportOperation(4, plugins.toArray(new IPluginModelBase[plugins.size()]), false, false, null, importMap);
        }
        return true;
    }
}

