/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.ecore.formalml.infrastructure;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ComCastKind implements Enumerator
{
    NONE(0, "none", "none"),
    UNICAST(1, "unicast", "unicast"),
    ANYCAST(2, "anycast", "anycast"),
    MULTICAST(3, "multicast", "multicast"),
    BROADCAST(4, "broadcast", "broadcast");

    public static final int NONE_VALUE = 0;
    public static final int UNICAST_VALUE = 1;
    public static final int ANYCAST_VALUE = 2;
    public static final int MULTICAST_VALUE = 3;
    public static final int BROADCAST_VALUE = 4;
    private static final ComCastKind[] VALUES_ARRAY;
    public static final List<ComCastKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ComCastKind[]{NONE, UNICAST, ANYCAST, MULTICAST, BROADCAST};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ComCastKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ComCastKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ComCastKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ComCastKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ComCastKind get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return UNICAST;
            }
            case 2: {
                return ANYCAST;
            }
            case 3: {
                return MULTICAST;
            }
            case 4: {
                return BROADCAST;
            }
        }
        return null;
    }

    private ComCastKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

