/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.ecore.formalml.infrastructure.impl;

import org.eclipse.efm.ecore.formalml.infrastructure.Behavior;
import org.eclipse.efm.ecore.formalml.infrastructure.Buffer;
import org.eclipse.efm.ecore.formalml.infrastructure.Channel;
import org.eclipse.efm.ecore.formalml.infrastructure.ChannelDirection;
import org.eclipse.efm.ecore.formalml.infrastructure.ComCastKind;
import org.eclipse.efm.ecore.formalml.infrastructure.ComPoint;
import org.eclipse.efm.ecore.formalml.infrastructure.ComProtocol;
import org.eclipse.efm.ecore.formalml.infrastructure.ComProtocolKind;
import org.eclipse.efm.ecore.formalml.infrastructure.Connector;
import org.eclipse.efm.ecore.formalml.infrastructure.DesignKind;
import org.eclipse.efm.ecore.formalml.infrastructure.InfrastructureFactory;
import org.eclipse.efm.ecore.formalml.infrastructure.InfrastructurePackage;
import org.eclipse.efm.ecore.formalml.infrastructure.InstanceMachine;
import org.eclipse.efm.ecore.formalml.infrastructure.Machine;
import org.eclipse.efm.ecore.formalml.infrastructure.ModelOfComputation;
import org.eclipse.efm.ecore.formalml.infrastructure.ModelOfExecution;
import org.eclipse.efm.ecore.formalml.infrastructure.ModelOfInteraction;
import org.eclipse.efm.ecore.formalml.infrastructure.Modifier;
import org.eclipse.efm.ecore.formalml.infrastructure.Parameter;
import org.eclipse.efm.ecore.formalml.infrastructure.ParameterDirectionKind;
import org.eclipse.efm.ecore.formalml.infrastructure.ParameterSet;
import org.eclipse.efm.ecore.formalml.infrastructure.Port;
import org.eclipse.efm.ecore.formalml.infrastructure.Procedure;
import org.eclipse.efm.ecore.formalml.infrastructure.PropertyDefinition;
import org.eclipse.efm.ecore.formalml.infrastructure.Route;
import org.eclipse.efm.ecore.formalml.infrastructure.Routine;
import org.eclipse.efm.ecore.formalml.infrastructure.Signal;
import org.eclipse.efm.ecore.formalml.infrastructure.SlotProperty;
import org.eclipse.efm.ecore.formalml.infrastructure.System;
import org.eclipse.efm.ecore.formalml.infrastructure.Variable;
import org.eclipse.efm.ecore.formalml.infrastructure.impl.BehaviorImpl;
import org.eclipse.efm.ecore.formalml.infrastructure.impl.BufferImpl;
import org.eclipse.efm.ecore.formalml.infrastructure.impl.ChannelImpl;
import org.eclipse.efm.ecore.formalml.infrastructure.impl.ComPointImpl;
import org.eclipse.efm.ecore.formalml.infrastructure.impl.ComProtocolImpl;
import org.eclipse.efm.ecore.formalml.infrastructure.impl.ConnectorImpl;
import org.eclipse.efm.ecore.formalml.infrastructure.impl.InstanceMachineImpl;
import org.eclipse.efm.ecore.formalml.infrastructure.impl.MachineImpl;
import org.eclipse.efm.ecore.formalml.infrastructure.impl.ModelOfComputationImpl;
import org.eclipse.efm.ecore.formalml.infrastructure.impl.ModelOfExecutionImpl;
import org.eclipse.efm.ecore.formalml.infrastructure.impl.ModelOfInteractionImpl;
import org.eclipse.efm.ecore.formalml.infrastructure.impl.ModifierImpl;
import org.eclipse.efm.ecore.formalml.infrastructure.impl.ParameterImpl;
import org.eclipse.efm.ecore.formalml.infrastructure.impl.ParameterSetImpl;
import org.eclipse.efm.ecore.formalml.infrastructure.impl.PortImpl;
import org.eclipse.efm.ecore.formalml.infrastructure.impl.ProcedureImpl;
import org.eclipse.efm.ecore.formalml.infrastructure.impl.PropertyDefinitionImpl;
import org.eclipse.efm.ecore.formalml.infrastructure.impl.RouteImpl;
import org.eclipse.efm.ecore.formalml.infrastructure.impl.RoutineImpl;
import org.eclipse.efm.ecore.formalml.infrastructure.impl.SignalImpl;
import org.eclipse.efm.ecore.formalml.infrastructure.impl.SlotPropertyImpl;
import org.eclipse.efm.ecore.formalml.infrastructure.impl.SystemImpl;
import org.eclipse.efm.ecore.formalml.infrastructure.impl.VariableImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class InfrastructureFactoryImpl
extends EFactoryImpl
implements InfrastructureFactory {
    public static InfrastructureFactory init() {
        try {
            InfrastructureFactory theInfrastructureFactory = (InfrastructureFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/efm/FormalML/Infrastructure");
            if (theInfrastructureFactory != null) {
                return theInfrastructureFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new InfrastructureFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createMachine();
            }
            case 1: {
                return this.createSystem();
            }
            case 2: {
                return this.createModifier();
            }
            case 3: {
                return this.createPropertyDefinition();
            }
            case 4: {
                return this.createVariable();
            }
            case 5: {
                return this.createBuffer();
            }
            case 6: {
                return this.createPort();
            }
            case 7: {
                return this.createChannel();
            }
            case 8: {
                return this.createSignal();
            }
            case 9: {
                return this.createProcedure();
            }
            case 10: {
                return this.createRoutine();
            }
            case 11: {
                return this.createInstanceMachine();
            }
            case 12: {
                return this.createSlotProperty();
            }
            case 13: {
                return this.createParameter();
            }
            case 14: {
                return this.createParameterSet();
            }
            case 15: {
                return this.createBehavior();
            }
            case 16: {
                return this.createModelOfComputation();
            }
            case 17: {
                return this.createModelOfExecution();
            }
            case 18: {
                return this.createModelOfInteraction();
            }
            case 19: {
                return this.createComProtocol();
            }
            case 20: {
                return this.createRoute();
            }
            case 21: {
                return this.createConnector();
            }
            case 22: {
                return this.createComPoint();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 23: {
                return this.createDesignKindFromString(eDataType, initialValue);
            }
            case 24: {
                return this.createChannelDirectionFromString(eDataType, initialValue);
            }
            case 25: {
                return this.createParameterDirectionKindFromString(eDataType, initialValue);
            }
            case 26: {
                return this.createComProtocolKindFromString(eDataType, initialValue);
            }
            case 27: {
                return this.createComCastKindFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 23: {
                return this.convertDesignKindToString(eDataType, instanceValue);
            }
            case 24: {
                return this.convertChannelDirectionToString(eDataType, instanceValue);
            }
            case 25: {
                return this.convertParameterDirectionKindToString(eDataType, instanceValue);
            }
            case 26: {
                return this.convertComProtocolKindToString(eDataType, instanceValue);
            }
            case 27: {
                return this.convertComCastKindToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Machine createMachine() {
        MachineImpl machine = new MachineImpl();
        return machine;
    }

    @Override
    public System createSystem() {
        SystemImpl system = new SystemImpl();
        return system;
    }

    @Override
    public Modifier createModifier() {
        ModifierImpl modifier = new ModifierImpl();
        return modifier;
    }

    @Override
    public PropertyDefinition createPropertyDefinition() {
        PropertyDefinitionImpl propertyDefinition = new PropertyDefinitionImpl();
        return propertyDefinition;
    }

    @Override
    public Variable createVariable() {
        VariableImpl variable = new VariableImpl();
        return variable;
    }

    @Override
    public Buffer createBuffer() {
        BufferImpl buffer = new BufferImpl();
        return buffer;
    }

    @Override
    public Port createPort() {
        PortImpl port = new PortImpl();
        return port;
    }

    @Override
    public Channel createChannel() {
        ChannelImpl channel = new ChannelImpl();
        return channel;
    }

    @Override
    public Signal createSignal() {
        SignalImpl signal = new SignalImpl();
        return signal;
    }

    @Override
    public Procedure createProcedure() {
        ProcedureImpl procedure = new ProcedureImpl();
        return procedure;
    }

    @Override
    public Routine createRoutine() {
        RoutineImpl routine = new RoutineImpl();
        return routine;
    }

    @Override
    public InstanceMachine createInstanceMachine() {
        InstanceMachineImpl instanceMachine = new InstanceMachineImpl();
        return instanceMachine;
    }

    @Override
    public SlotProperty createSlotProperty() {
        SlotPropertyImpl slotProperty = new SlotPropertyImpl();
        return slotProperty;
    }

    @Override
    public Parameter createParameter() {
        ParameterImpl parameter = new ParameterImpl();
        return parameter;
    }

    @Override
    public ParameterSet createParameterSet() {
        ParameterSetImpl parameterSet = new ParameterSetImpl();
        return parameterSet;
    }

    @Override
    public Behavior createBehavior() {
        BehaviorImpl behavior = new BehaviorImpl();
        return behavior;
    }

    @Override
    public ModelOfComputation createModelOfComputation() {
        ModelOfComputationImpl modelOfComputation = new ModelOfComputationImpl();
        return modelOfComputation;
    }

    @Override
    public ModelOfExecution createModelOfExecution() {
        ModelOfExecutionImpl modelOfExecution = new ModelOfExecutionImpl();
        return modelOfExecution;
    }

    @Override
    public ModelOfInteraction createModelOfInteraction() {
        ModelOfInteractionImpl modelOfInteraction = new ModelOfInteractionImpl();
        return modelOfInteraction;
    }

    @Override
    public ComProtocol createComProtocol() {
        ComProtocolImpl comProtocol = new ComProtocolImpl();
        return comProtocol;
    }

    @Override
    public Route createRoute() {
        RouteImpl route = new RouteImpl();
        return route;
    }

    @Override
    public Connector createConnector() {
        ConnectorImpl connector = new ConnectorImpl();
        return connector;
    }

    @Override
    public ComPoint createComPoint() {
        ComPointImpl comPoint = new ComPointImpl();
        return comPoint;
    }

    public DesignKind createDesignKindFromString(EDataType eDataType, String initialValue) {
        DesignKind result = DesignKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertDesignKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ChannelDirection createChannelDirectionFromString(EDataType eDataType, String initialValue) {
        ChannelDirection result = ChannelDirection.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertChannelDirectionToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ParameterDirectionKind createParameterDirectionKindFromString(EDataType eDataType, String initialValue) {
        ParameterDirectionKind result = ParameterDirectionKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertParameterDirectionKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ComProtocolKind createComProtocolKindFromString(EDataType eDataType, String initialValue) {
        ComProtocolKind result = ComProtocolKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertComProtocolKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ComCastKind createComCastKindFromString(EDataType eDataType, String initialValue) {
        ComCastKind result = ComCastKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertComCastKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public InfrastructurePackage getInfrastructurePackage() {
        return (InfrastructurePackage)this.getEPackage();
    }

    @Deprecated
    public static InfrastructurePackage getPackage() {
        return InfrastructurePackage.eINSTANCE;
    }
}

