/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.ecore.formalml.datatype;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CollectionKind implements Enumerator
{
    VECTOR(0, "vector", "vector"),
    RVECTOR(1, "rvector", "rvector"),
    LIST(2, "list", "list"),
    SET(3, "set", "set"),
    BAG(4, "bag", "bag"),
    FIFO(5, "fifo", "fifo"),
    LIFO(6, "lifo", "lifo");

    public static final int VECTOR_VALUE = 0;
    public static final int RVECTOR_VALUE = 1;
    public static final int LIST_VALUE = 2;
    public static final int SET_VALUE = 3;
    public static final int BAG_VALUE = 4;
    public static final int FIFO_VALUE = 5;
    public static final int LIFO_VALUE = 6;
    private static final CollectionKind[] VALUES_ARRAY;
    public static final List<CollectionKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CollectionKind[]{VECTOR, RVECTOR, LIST, SET, BAG, FIFO, LIFO};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CollectionKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CollectionKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CollectionKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CollectionKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CollectionKind get(int value) {
        switch (value) {
            case 0: {
                return VECTOR;
            }
            case 1: {
                return RVECTOR;
            }
            case 2: {
                return LIST;
            }
            case 3: {
                return SET;
            }
            case 4: {
                return BAG;
            }
            case 5: {
                return FIFO;
            }
            case 6: {
                return LIFO;
            }
        }
        return null;
    }

    private CollectionKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

