/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.glyphs.VText;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultilineText<T>
extends VText {
    private double widthConstraint = Double.POSITIVE_INFINITY;
    private double heightConstraint = Double.POSITIVE_INFINITY;
    private LineBreakMeasurer lbm;
    private AttributedString atText;
    private static final FontRenderContext DEFAULT_FRC = new FontRenderContext(null, false, false);
    TextLayout[] lines;

    public MultilineText(String text) {
        super(text);
        this.initLbm();
    }

    public MultilineText(double x, double y, int z, Color c, String t, short ta, float scale, float alpha) {
        super(x, y, z, c, t, ta, scale, alpha);
        this.initLbm();
        this.processText();
    }

    void initLbm() {
        this.atText = new AttributedString(this.text);
        this.atText.addAttribute(TextAttribute.FONT, this.usesSpecificFont() ? this.getFont() : MultilineText.getMainFont());
        this.lbm = new LineBreakMeasurer(this.atText.getIterator(), DEFAULT_FRC);
        this.processText();
    }

    public void setWidthConstraint(double constraint) {
        this.widthConstraint = constraint;
        this.processText();
        this.invalidate();
    }

    public void setHeightConstraint(double constraint) {
        this.heightConstraint = constraint;
        this.invalidate();
    }

    public double getWidthConstraint() {
        return this.widthConstraint;
    }

    public double getHeightConstraint() {
        return this.heightConstraint;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.atText = new AttributedString(text);
        this.lbm = new LineBreakMeasurer(this.atText.getIterator(), DEFAULT_FRC);
        this.processText();
        this.invalidate();
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.atText.addAttribute(TextAttribute.FONT, this.usesSpecificFont() ? this.getFont() : MultilineText.getMainFont());
        this.lbm = new LineBreakMeasurer(this.atText.getIterator(), DEFAULT_FRC);
        this.processText();
        this.invalidate();
    }

    @Override
    public boolean visibleInRegion(double wb, double nb, double eb, double sb, int i) {
        if (!this.validBounds(i)) {
            return true;
        }
        if (this.vx >= wb && this.vx <= eb && this.vy >= sb && this.vy <= nb) {
            return true;
        }
        if (this.text_anchor == 0) {
            return this.vx <= eb && this.vx + this.pc[i].cw >= wb && this.vy >= sb && this.vy - this.pc[i].ch <= nb;
        }
        if (this.text_anchor == 1) {
            return this.vx - this.pc[i].cw / 2.0 <= eb && this.vx + this.pc[i].cw / 2.0 >= wb && this.vy >= sb && this.vy - this.pc[i].ch <= nb;
        }
        return this.vx - this.pc[i].cw <= eb && this.vx >= wb && this.vy >= sb && this.vy - this.pc[i].ch <= nb;
    }

    @Override
    public boolean containedInRegion(double wb, double nb, double eb, double sb, int i) {
        if (this.vx >= wb && this.vx <= eb && this.vy <= nb && this.vy >= sb) {
            if (this.text_anchor == 0) {
                return this.vx <= eb && this.vx + this.pc[i].cw >= wb && this.vy <= nb && this.vy - this.pc[i].ch >= sb;
            }
            if (this.text_anchor == 1) {
                return this.vx + this.pc[i].cw / 2.0 <= eb && this.vx - this.pc[i].cw / 2.0 >= wb && this.vy <= nb && this.vy - this.pc[i].ch >= sb;
            }
            return this.vx + this.pc[i].cw <= eb && this.vx >= wb && this.vy <= nb && this.vy - this.pc[i].ch >= sb;
        }
        return false;
    }

    @Override
    public boolean coordInside(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        boolean res = false;
        switch (this.text_anchor) {
            case 0: {
                if (!(cvx >= this.vx) || !(cvy <= this.vy) || !(cvx <= this.vx + this.pc[camIndex].cw) || !(cvy >= this.vy - this.pc[camIndex].ch)) break;
                res = true;
                break;
            }
            case 1: {
                if (!(cvx >= this.vx - this.pc[camIndex].cw / 2.0) || !(cvy <= this.vy) || !(cvx <= this.vx + this.pc[camIndex].cw / 2.0) || !(cvy >= this.vy - this.pc[camIndex].ch)) break;
                res = true;
                break;
            }
            default: {
                if (!(cvx <= this.vx) || !(cvy <= this.vy) || !(cvx >= this.vx - this.pc[camIndex].cw) || !(cvy >= this.vy - this.pc[camIndex].ch)) break;
                res = true;
            }
        }
        return res;
    }

    void processText() {
        this.lbm.setPosition(this.atText.getIterator().getBeginIndex());
        int paragraphEnd = this.atText.getIterator().getEndIndex();
        float drawPosY = 0.0f;
        TextLayout line = null;
        Vector<TextLayout> lineV = new Vector<TextLayout>(5);
        while (this.lbm.getPosition() < paragraphEnd && (double)drawPosY <= this.heightConstraint) {
            line = this.lbm.nextLayout((float)this.widthConstraint);
            lineV.add(line);
            drawPosY += line.getAscent() + line.getDescent() + line.getLeading();
        }
        this.lines = lineV.toArray(new TextLayout[lineV.size()]);
    }

    public int getLineCount() {
        return this.lines.length;
    }

    @Override
    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        double trueCoef = (double)this.scaleFactor * this.coef;
        if (trueCoef * (double)this.fontSize > (double)VText.TEXT_AS_LINE_PROJ_COEF || !this.zoomSensitive || !this.pc[i].valid) {
            Rectangle2D lbounds;
            g.setFont(this.font != null ? this.font : MultilineText.getMainFont());
            AffineTransform at = AffineTransform.getTranslateInstance(dx + this.pc[i].cx, dy + this.pc[i].cy);
            if (this.zoomSensitive) {
                at.concatenate(AffineTransform.getScaleInstance(trueCoef, trueCoef));
            }
            g.setTransform(at);
            g.setColor(this.color);
            float drawPosY = 0.0f;
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                for (TextLayout line : this.lines) {
                    drawPosY += line.getAscent();
                    if (this.text_anchor == 0) {
                        line.draw(g, 0.0f, drawPosY);
                    } else if (this.text_anchor == 1) {
                        lbounds = line.getBounds();
                        line.draw(g, (float)(-lbounds.getWidth() / 2.0), drawPosY);
                    } else {
                        lbounds = line.getBounds();
                        line.draw(g, (float)(-lbounds.getWidth()), drawPosY);
                    }
                    drawPosY += line.getDescent() + line.getLeading();
                }
                g.setComposite(acO);
            } else {
                for (TextLayout line : this.lines) {
                    drawPosY += line.getAscent();
                    if (this.text_anchor == 0) {
                        line.draw(g, 0.0f, drawPosY);
                    } else if (this.text_anchor == 1) {
                        lbounds = line.getBounds();
                        line.draw(g, (float)(-lbounds.getWidth() / 2.0), drawPosY);
                    } else {
                        lbounds = line.getBounds();
                        line.draw(g, (float)(-lbounds.getWidth()), drawPosY);
                    }
                    drawPosY += line.getDescent() + line.getLeading();
                }
            }
            g.setTransform(stdT);
            if (!this.pc[i].valid || !this.zoomSensitive && this.coef != this.oldcoef) {
                if (this.widthConstraint == Double.POSITIVE_INFINITY) {
                    double max = this.lines[0].getBounds().getWidth();
                    for (int j = 1; j < this.lines.length; ++j) {
                        if (!(this.lines[j].getBounds().getWidth() > max)) continue;
                        max = this.lines[j].getBounds().getWidth();
                    }
                    if (this.zoomSensitive) {
                        this.pc[i].cw = max * (double)this.scaleFactor;
                        this.pc[i].ch = drawPosY * this.scaleFactor;
                    } else {
                        this.pc[i].cw = max * (double)this.scaleFactor / this.coef;
                        this.pc[i].ch = (double)(drawPosY * this.scaleFactor) / this.coef;
                        this.oldcoef = this.coef;
                    }
                } else if (this.zoomSensitive) {
                    this.pc[i].cw = this.widthConstraint * (double)this.scaleFactor;
                    this.pc[i].ch = drawPosY * this.scaleFactor;
                } else {
                    this.pc[i].cw = this.widthConstraint * (double)this.scaleFactor / this.coef;
                    this.pc[i].ch = (double)(drawPosY * this.scaleFactor) / this.coef;
                }
                this.pc[i].valid = true;
            }
        } else {
            g.setColor(this.color);
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
                g.setComposite(acO);
            } else {
                g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
            }
        }
    }

    @Override
    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
    }

    @Override
    public Object clone() {
        MultilineText<T> res = new MultilineText<T>(this.vx, this.vy, this.vz, this.color, new StringBuffer(this.text).toString(), this.text_anchor, this.getScale(), this.alphaC != null ? this.alphaC.getAlpha() : 1.0f);
        res.cursorInsideColor = this.cursorInsideColor;
        return res;
    }
}

