/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.engine;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.VCursor;
import fr.inria.zvtm.engine.View;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EView
extends View
implements KeyListener {
    JFrame frame = new JFrame();
    JMenuBar jmb;

    protected EView(String viewType, Vector<Camera> v, String t, int w, int h, boolean visible, boolean decorated) {
        this(viewType, v, t, w, h, false, visible, decorated, null);
    }

    protected EView(String viewType, Vector<Camera> v, String t, int w, int h, boolean bar, boolean visible, boolean decorated, JMenuBar mnb) {
        if (!decorated) {
            this.frame.setUndecorated(true);
        }
        this.frame.setDefaultCloseOperation(0);
        if (mnb != null) {
            this.frame.setJMenuBar(mnb);
            this.jmb = mnb;
        }
        this.mouse = new VCursor(this);
        this.name = t;
        this.vt = viewType;
        this.detectMultipleFullFills = VirtualSpaceManager.INSTANCE.defaultMultiFill;
        this.initCameras(v);
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        Container cpane = this.frame.getContentPane();
        cpane.setLayout(gridBag);
        if (bar) {
            EView.buildConstraints(constraints, 0, 0, 1, 1, 100, 90);
            constraints.fill = 1;
            constraints.anchor = 10;
            this.panel = View.getPanelFactory(viewType).getNewInstance(v, this, false);
            this.panel.getComponent().setSize(w, h);
            gridBag.setConstraints(this.panel.getComponent(), constraints);
            cpane.add(this.panel.getComponent());
            EView.buildConstraints(constraints, 0, 1, 1, 1, 0, 0);
            constraints.anchor = 17;
            this.statusBar = new JLabel(" ");
            gridBag.setConstraints(this.statusBar, constraints);
            cpane.add(this.statusBar);
        } else {
            EView.buildConstraints(constraints, 0, 0, 1, 1, 100, 90);
            constraints.fill = 1;
            constraints.anchor = 10;
            this.panel = View.getPanelFactory(viewType).getNewInstance(v, this, false);
            this.panel.getComponent().setSize(w, h);
            gridBag.setConstraints(this.panel.getComponent(), constraints);
            cpane.add(this.panel.getComponent());
        }
        this.frame.setTitle(t);
        WindowAdapter l = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                EView.this.close();
            }

            public void windowActivated(WindowEvent e) {
                EView.this.activate();
            }

            public void windowDeactivated(WindowEvent e) {
                EView.this.deactivate();
            }

            public void windowIconified(WindowEvent e) {
                EView.this.iconify();
            }

            public void windowDeiconified(WindowEvent e) {
                EView.this.deiconify();
            }
        };
        this.frame.addWindowListener(l);
        this.frame.addKeyListener(this);
        this.frame.pack();
        this.frame.setSize(w, h);
        if (visible) {
            this.frame.setVisible(true);
        }
    }

    @Override
    public Component getFrame() {
        return this.frame;
    }

    @Override
    public boolean isSelected() {
        return this.frame == VirtualSpaceManager.INSTANCE.activeJFrame;
    }

    @Override
    public void setLocation(int x, int y) {
        this.frame.setLocation(x, y);
    }

    @Override
    public void setTitle(String t) {
        this.frame.setTitle(t);
    }

    @Override
    public void setSize(int width, int height) {
        this.frame.setSize(width, height);
    }

    @Override
    public void setResizable(boolean resizable) {
        this.frame.setResizable(resizable);
    }

    @Override
    public void setVisible(boolean b) {
        this.frame.setVisible(b);
        if (b) {
            this.activate();
        } else {
            this.deactivate();
        }
    }

    @Override
    public void destroyView() {
        super.destroyView();
        this.panel.stop();
        VirtualSpaceManager.INSTANCE.destroyView(this.name);
        this.frame.dispose();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.isShiftDown()) {
            if (e.isControlDown()) {
                this.panel.evHs[this.panel.activeLayer].Ktype(this.panel, e.getKeyChar(), e.getKeyCode(), 3, e);
            } else {
                this.panel.evHs[this.panel.activeLayer].Ktype(this.panel, e.getKeyChar(), e.getKeyCode(), 1, e);
            }
        } else if (e.isControlDown()) {
            this.panel.evHs[this.panel.activeLayer].Ktype(this.panel, e.getKeyChar(), e.getKeyCode(), 2, e);
        } else {
            this.panel.evHs[this.panel.activeLayer].Ktype(this.panel, e.getKeyChar(), e.getKeyCode(), 0, e);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.isShiftDown()) {
            if (e.isControlDown()) {
                this.panel.evHs[this.panel.activeLayer].Kpress(this.panel, e.getKeyChar(), e.getKeyCode(), 3, e);
            } else {
                this.panel.evHs[this.panel.activeLayer].Kpress(this.panel, e.getKeyChar(), e.getKeyCode(), 1, e);
            }
        } else if (e.isControlDown()) {
            this.panel.evHs[this.panel.activeLayer].Kpress(this.panel, e.getKeyChar(), e.getKeyCode(), 2, e);
        } else {
            this.panel.evHs[this.panel.activeLayer].Kpress(this.panel, e.getKeyChar(), e.getKeyCode(), 0, e);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.isShiftDown()) {
            if (e.isControlDown()) {
                this.panel.evHs[this.panel.activeLayer].Krelease(this.panel, e.getKeyChar(), e.getKeyCode(), 3, e);
            } else {
                this.panel.evHs[this.panel.activeLayer].Krelease(this.panel, e.getKeyChar(), e.getKeyCode(), 1, e);
            }
        } else if (e.isControlDown()) {
            this.panel.evHs[this.panel.activeLayer].Krelease(this.panel, e.getKeyChar(), e.getKeyCode(), 2, e);
        } else {
            this.panel.evHs[this.panel.activeLayer].Krelease(this.panel, e.getKeyChar(), e.getKeyCode(), 0, e);
        }
    }
}

