/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import com.ibm.icu.text.MessageFormat;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.AbstractLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.ClosedProjectFilter;
import org.eclipse.debug.internal.ui.launchConfigurations.CollapseAllLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.CreateLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.DeleteLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.DeletedProjectFilter;
import org.eclipse.debug.internal.ui.launchConfigurations.DuplicateLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.FilterLaunchConfigurationAction;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationPresentationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTabGroupViewer;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTypeFilter;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationView;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.WorkingSetsFilter;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.WorkbenchJob;

public class LaunchConfigurationsDialog
extends TitleAreaDialog
implements ILaunchConfigurationDialog,
IPropertyChangeListener {
    private static ILaunchConfigurationDialog fgCurrentlyVisibleLaunchConfigurationDialog;
    protected static final int ID_LAUNCH_BUTTON = 1025;
    protected static final int ID_CLOSE_BUTTON = 1026;
    protected static final int ID_CANCEL_BUTTON = 1027;
    protected static final int ID_DISCARD_BUTTON = 1028;
    protected static final float MAX_DIALOG_WIDTH_PERCENT = 0.75f;
    protected static final float MAX_DIALOG_HEIGHT_PERCENT = 0.65f;
    protected static final Point DEFAULT_INITIAL_DIALOG_SIZE;
    private static final int[] DEFAULT_SASH_WEIGHTS;
    public static final int LAUNCH_CONFIGURATION_DIALOG_OPEN_ON_LAST_LAUNCHED = 2;
    public static final int LAUNCH_CONFIGURATION_DIALOG_OPEN_ON_SELECTION = 3;
    public static final int LAUNCH_CONFIGURATION_DIALOG_REUSE_OPEN = 4;
    private static final String DELIMITER = ", ";
    private int fOpenMode = 2;
    private boolean fIsShift = false;
    private static final String DIALOG_SASH_WEIGHTS_1 = "org.eclipse.debug.ui.DIALOG_SASH_WEIGHTS_1";
    private static final String DIALOG_SASH_WEIGHTS_2 = "org.eclipse.debug.ui.DIALOG_SASH_WEIGHTS_2";
    private static final String DIALOG_EXPANDED_NODES = "org.eclipse.debug.ui.EXPANDED_NODES";
    private Control fLastControl;
    private Composite fButtonComp;
    private SashForm fSashForm;
    private LaunchConfigurationView fLaunchConfigurationView;
    private LaunchConfigurationTabGroupViewer fTabViewer;
    private ProgressMonitorPart fProgressMonitorPart;
    private LaunchGroupExtension fGroup;
    private Image fBannerImage;
    private IStructuredSelection fInitialSelection;
    private IStatus fInitialStatus;
    private long fActiveRunningOperations = 0L;
    private IAction fDoubleClickAction;
    private ClosedProjectFilter fClosedProjectFilter;
    private DeletedProjectFilter fDeletedProjectFilter;
    private LaunchConfigurationTypeFilter fLCTFilter;
    private WorkingSetsFilter fWorkingSetsFilter;
    protected Set<String> fReservedNames = null;
    private boolean fSetDefaultOnOpen = false;
    private boolean fSettingInput = false;

    static {
        DEFAULT_INITIAL_DIALOG_SIZE = new Point(800, 640);
        DEFAULT_SASH_WEIGHTS = new int[]{190, 610};
    }

    public static ILaunchConfigurationDialog getCurrentlyVisibleLaunchConfigurationDialog() {
        return fgCurrentlyVisibleLaunchConfigurationDialog;
    }

    public static void setCurrentlyVisibleLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        fgCurrentlyVisibleLaunchConfigurationDialog = dialog;
    }

    public LaunchConfigurationsDialog(Shell shell, LaunchGroupExtension group) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setLaunchGroup(group);
    }

    protected void addContent(Composite dialogComp) {
        Composite topComp = new Composite(dialogComp, 0);
        GridData gd = new GridData(1808);
        topComp.setLayoutData((Object)gd);
        GridLayout topLayout = new GridLayout(2, false);
        topLayout.marginHeight = 5;
        topLayout.marginWidth = 5;
        topComp.setLayout((Layout)topLayout);
        this.setTitle(LaunchConfigurationsMessages.LaunchConfigurationDialog_Create__manage__and_run_launch_configurations_8);
        this.setMessage(LaunchConfigurationsMessages.LaunchConfigurationDialog_Ready_to_launch_2);
        this.setModeLabelState();
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        SashForm sash = new SashForm(topComp, 65536);
        sash.setOrientation(256);
        sash.setLayoutData((Object)gd);
        sash.setFont(dialogComp.getFont());
        sash.setVisible(true);
        this.fSashForm = sash;
        Control launchConfigSelectionArea = this.createLaunchConfigurationSelectionArea((Composite)this.fSashForm);
        gd = new GridData(1040);
        launchConfigSelectionArea.setLayoutData((Object)gd);
        Composite editAreaComp = this.createLaunchConfigurationEditArea((Composite)this.fSashForm);
        gd = new GridData(1808);
        editAreaComp.setLayoutData((Object)gd);
        dialogComp.layout(true);
        LaunchConfigurationsDialog.applyDialogFont((Control)dialogComp);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.handleLaunchPressed();
        } else if (buttonId == 1026) {
            this.handleClosePressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected int shouldSaveCurrentConfig() {
        if (this.fTabViewer.isDirty()) {
            if (this.fTabViewer.canSave()) {
                return this.showSaveChangesDialog();
            }
            return this.showUnsavedChangesDialog();
        }
        return 3;
    }

    public boolean close() {
        if (!this.isSafeToClose()) {
            return false;
        }
        this.persistSashWeights();
        this.persistExpansion();
        LaunchConfigurationsDialog.setCurrentlyVisibleLaunchConfigurationDialog(null);
        this.fTabViewer.dispose();
        if (this.fLaunchConfigurationView != null) {
            this.fLaunchConfigurationView.dispose();
        }
        DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        boolean result = super.close();
        this.getBannerImage().dispose();
        return result;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getShellTitle());
    }

    public void create() {
        super.create();
        if (this.fTabViewer.getInput() == null) {
            this.fTabViewer.inputChanged(null);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginLeft = this.convertHorizontalDLUsToPixels(7);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        composite.setFont(font);
        if (this.isHelpAvailable()) {
            this.createHelpControl(composite);
        }
        Composite monitorComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        monitorComposite.setLayout((Layout)layout);
        monitorComposite.setLayoutData((Object)new GridData(768));
        GridLayout pmLayout = new GridLayout();
        this.fProgressMonitorPart = new ProgressMonitorPart(monitorComposite, (Layout)pmLayout, true);
        this.fProgressMonitorPart.setLayoutData((Object)new GridData(768));
        this.fProgressMonitorPart.setFont(font);
        monitorComposite.setVisible(false);
        boolean helpAvailable = this.isHelpAvailable();
        this.setHelpAvailable(false);
        this.fButtonComp = (Composite)super.createButtonBar(composite);
        this.setHelpAvailable(helpAvailable);
        return composite;
    }

    protected void launchButtonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.handleLaunchPressed();
        } else if (buttonId == 1026) {
            this.handleClosePressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Listener listener;
        Listener[] listeners;
        Button button = this.createButton(parent, 1025, this.getLaunchButtonText(), true);
        button.setEnabled(false);
        Listener[] listenerArray = listeners = button.getListeners(13);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            listener = listenerArray[n2];
            button.removeListener(13, listener);
            ++n2;
        }
        listenerArray = listeners = button.getListeners(14);
        n = listeners.length;
        n2 = 0;
        while (n2 < n) {
            listener = listenerArray[n2];
            button.removeListener(14, listener);
            ++n2;
        }
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LaunchConfigurationsDialog.this.setShift((event.stateMask & 0x20000) > 0);
                LaunchConfigurationsDialog.this.handleLaunchPressed();
            }
        });
        this.createButton(parent, 1026, LaunchConfigurationsMessages.LaunchConfigurationDialog_Close_1, false);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.initializeContent();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), this.getHelpContextId());
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogComp = (Composite)super.createDialogArea(parent);
        this.addContent(dialogComp);
        if (this.fLaunchConfigurationView != null) {
            this.fLaunchConfigurationView.updateFilterLabel();
        }
        return dialogComp;
    }

    protected Composite createLaunchConfigurationEditArea(Composite parent) {
        this.setTabViewer(new LaunchConfigurationTabGroupViewer(parent, this));
        return (Composite)this.fTabViewer.getControl();
    }

    protected void createToolbarActions(ToolBarManager tmanager) {
        tmanager.add((IAction)this.getNewAction());
        tmanager.add((IAction)this.getDuplicateAction());
        tmanager.add((IAction)this.getDeleteAction());
        tmanager.add((IContributionItem)new Separator());
        tmanager.add(this.getCollapseAllAction());
        tmanager.add(this.getFilterAction());
        tmanager.update(true);
        DebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected void setShift(boolean isShift) {
        this.fIsShift = isShift;
    }

    protected Control createLaunchConfigurationSelectionArea(Composite parent) {
        Composite comp = new Composite(parent, 0x800000);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        comp.setLayout((Layout)gridLayout);
        comp.setLayoutData((Object)new GridData(1808));
        ViewForm viewForm = new ViewForm(comp, 0x800800);
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolBar = toolBarManager.createControl((Composite)viewForm);
        toolBar.setBackground(parent.getBackground());
        viewForm.setTopLeft((Control)toolBar);
        viewForm.setLayoutData((Object)new GridData(1808));
        Composite viewFormContents = new Composite((Composite)viewForm, 0x800000);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 5;
        viewFormContents.setLayout((Layout)gridLayout);
        viewFormContents.setBackground(parent.getDisplay().getSystemColor(25));
        this.fLaunchConfigurationView = new LaunchConfigurationView(this.getLaunchGroup(), this.createViewerFilters());
        this.fLaunchConfigurationView.createLaunchDialogControl(viewFormContents);
        Text filterText = this.fLaunchConfigurationView.getFilteringTextControl();
        if (filterText != null) {
            filterText.setFocus();
        }
        this.createToolbarActions(toolBarManager);
        this.fDoubleClickAction = new Action(){

            public void run() {
                this.runInternal(false);
            }

            public void runWithEvent(Event event) {
                this.runInternal((event.stateMask & 0x20000) > 0);
            }

            void runInternal(boolean isShift) {
                IStructuredSelection selection = (IStructuredSelection)LaunchConfigurationsDialog.this.fLaunchConfigurationView.getViewer().getSelection();
                Object target = selection.getFirstElement();
                if (target instanceof ILaunchConfiguration) {
                    if (LaunchConfigurationsDialog.this.fTabViewer.canLaunch() & LaunchConfigurationsDialog.this.fTabViewer.canLaunchWithModes() & !LaunchConfigurationsDialog.this.fTabViewer.hasDuplicateDelegates()) {
                        LaunchConfigurationsDialog.this.setShift(isShift);
                        LaunchConfigurationsDialog.this.handleLaunchPressed();
                    }
                } else {
                    LaunchConfigurationsDialog.this.getNewAction().run();
                }
            }
        };
        this.fLaunchConfigurationView.setAction("Double_Click_ActionId", this.fDoubleClickAction);
        Viewer viewer = this.fLaunchConfigurationView.getViewer();
        Control control = viewer.getControl();
        GridData gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        viewForm.setContent((Control)viewFormContents);
        AbstractLaunchConfigurationAction.IConfirmationRequestor requestor = new AbstractLaunchConfigurationAction.IConfirmationRequestor(){

            @Override
            public boolean getConfirmation() {
                int status = LaunchConfigurationsDialog.this.shouldSaveCurrentConfig();
                if (status == 2) {
                    LaunchConfigurationsDialog.this.fTabViewer.handleApplyPressed();
                    return true;
                }
                if (status == 3) {
                    LaunchConfigurationsDialog.this.fTabViewer.handleRevertPressed();
                    return true;
                }
                return false;
            }
        };
        this.getDuplicateAction().setConfirmationRequestor(requestor);
        this.getNewAction().setConfirmationRequestor(requestor);
        ((StructuredViewer)viewer).addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LaunchConfigurationsDialog.this.handleLaunchConfigurationSelectionChanged(event);
                LaunchConfigurationsDialog.this.getNewAction().setEnabled(LaunchConfigurationsDialog.this.getNewAction().isEnabled());
                LaunchConfigurationsDialog.this.getDeleteAction().setEnabled(LaunchConfigurationsDialog.this.getDeleteAction().isEnabled());
                LaunchConfigurationsDialog.this.getDuplicateAction().setEnabled(LaunchConfigurationsDialog.this.getDuplicateAction().isEnabled());
            }
        });
        return comp;
    }

    private ViewerFilter[] createViewerFilters() {
        ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>();
        this.fClosedProjectFilter = new ClosedProjectFilter();
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.PREF_FILTER_LAUNCH_CLOSED")) {
            filters.add(this.fClosedProjectFilter);
        }
        this.fDeletedProjectFilter = new DeletedProjectFilter();
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.PREF_FILTER_LAUNCH_DELETED")) {
            filters.add(this.fDeletedProjectFilter);
        }
        this.fLCTFilter = new LaunchConfigurationTypeFilter();
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.PREF_FILTER_LAUNCH_TYPES")) {
            filters.add(this.fLCTFilter);
        }
        this.fWorkingSetsFilter = new WorkingSetsFilter();
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.PREF_FILTER_WORKING_SETS")) {
            filters.add(this.fWorkingSetsFilter);
        }
        return filters.toArray(new ViewerFilter[filters.size()]);
    }

    public void doInitialTreeSelection() {
        this.fLaunchConfigurationView.getViewer().setSelection((ISelection)this.fInitialSelection);
    }

    @Override
    public String generateName(String name) {
        if (name == null) {
            return this.getLaunchManager().generateLaunchConfigurationName("");
        }
        return this.getLaunchManager().generateLaunchConfigurationName(name);
    }

    public String generateName(String name, Set<String> reservednames) {
        if (name == null) {
            return ((LaunchManager)this.getLaunchManager()).generateUniqueLaunchConfigurationNameFrom("", reservednames);
        }
        return ((LaunchManager)this.getLaunchManager()).generateUniqueLaunchConfigurationNameFrom(name, reservednames);
    }

    @Override
    public ILaunchConfigurationTab getActiveTab() {
        return this.fTabViewer.getActiveTab();
    }

    protected Image getBannerImage() {
        ImageDescriptor descriptor;
        if (this.fBannerImage == null && (descriptor = this.getLaunchGroup().getBannerImageDescriptor()) != null) {
            this.fBannerImage = descriptor.createImage();
        }
        return this.fBannerImage;
    }

    protected AbstractLaunchConfigurationAction getDeleteAction() {
        return (AbstractLaunchConfigurationAction)this.fLaunchConfigurationView.getAction(DeleteLaunchConfigurationAction.ID_DELETE_ACTION);
    }

    protected IAction getFilterAction() {
        return this.fLaunchConfigurationView.getAction(FilterLaunchConfigurationAction.ID_FILTER_ACTION);
    }

    protected IAction getCollapseAllAction() {
        return this.fLaunchConfigurationView.getAction(CollapseAllLaunchConfigurationAction.ID_COLLAPSEALL_ACTION);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.getDialogSettings();
    }

    protected int getDialogBoundsStrategy() {
        return 2;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = DebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        return section;
    }

    protected String getDialogSettingsSectionName() {
        return "org.eclipse.debug.ui.LAUNCH_CONFIGURATIONS_DIALOG_SECTION";
    }

    protected Display getDisplay() {
        Shell shell = this.getShell();
        if (shell != null) {
            return shell.getDisplay();
        }
        return DebugUIPlugin.getStandardDisplay();
    }

    protected AbstractLaunchConfigurationAction getDuplicateAction() {
        return (AbstractLaunchConfigurationAction)this.fLaunchConfigurationView.getAction(DuplicateLaunchConfigurationAction.ID_DUPLICATE_ACTION);
    }

    protected String getHelpContextId() {
        return "org.eclipse.debug.ui.launch_configuration_dialog";
    }

    protected IStatus getInitialStatus() {
        return this.fInitialStatus;
    }

    protected ILaunchConfiguration getLastLaunchedWorkbenchConfiguration() {
        return DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLastLaunch(this.getLaunchGroup().getIdentifier());
    }

    protected String getLaunchButtonText() {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchMode(this.getMode()).getLabel();
    }

    public LaunchGroupExtension getLaunchGroup() {
        return this.fGroup;
    }

    @Override
    public String getMode() {
        return this.getLaunchGroup().getMode();
    }

    protected AbstractLaunchConfigurationAction getNewAction() {
        return (AbstractLaunchConfigurationAction)this.fLaunchConfigurationView.getAction(CreateLaunchConfigurationAction.ID_CREATE_ACTION);
    }

    public Set<String> getReservedNameSet() {
        return this.fReservedNames;
    }

    protected int getOpenMode() {
        return this.fOpenMode;
    }

    public Object getSelectedPage() {
        return this.getActiveTab();
    }

    protected String getShellTitle() {
        String title = null;
        if (this.getLaunchGroup() != null) {
            title = MessageFormat.format((String)LaunchConfigurationsMessages.LaunchConfigurationsDialog_configurations, (Object[])new Object[]{DebugUIPlugin.removeAccelerators(this.getLaunchGroup().getLabel())});
        }
        if (title == null) {
            title = LaunchConfigurationsMessages.LaunchConfigurationDialog_Launch_Configurations_18;
        }
        return title;
    }

    public ILaunchConfigurationTabGroup getTabGroup() {
        if (this.fTabViewer != null) {
            return this.fTabViewer.getTabGroup();
        }
        return null;
    }

    @Override
    public ILaunchConfigurationTab[] getTabs() {
        if (this.getTabGroup() == null) {
            return null;
        }
        return this.getTabGroup().getTabs();
    }

    public LaunchConfigurationTabGroupViewer getTabViewer() {
        return this.fTabViewer;
    }

    protected void handleClosePressed() {
        if (this.fTabViewer.canSave()) {
            int status = this.shouldSaveCurrentConfig();
            if (status != 1 && status != 1028) {
                if (status == 2) {
                    this.fTabViewer.handleApplyPressed();
                }
                this.cancelPressed();
            }
        } else {
            this.cancelPressed();
        }
    }

    protected void handleLaunchConfigurationSelectionChanged(SelectionChangedEvent event) {
        Object input = this.fTabViewer.getInput();
        Object newInput = null;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.size() == 1) {
            newInput = selection.getFirstElement();
        }
        if (!this.isEqual(input, newInput)) {
            ILaunchConfiguration original = this.fTabViewer.getOriginal();
            if (original != null && newInput == null && this.getLaunchManager().getMovedTo(original) != null) {
                return;
            }
            boolean deleted = false;
            if (original != null) {
                deleted = !original.exists();
            }
            boolean renamed = false;
            if (newInput instanceof ILaunchConfiguration) {
                renamed = this.getLaunchManager().getMovedFrom((ILaunchConfiguration)newInput) != null;
            }
            try {
                this.fSettingInput = true;
                if (this.fTabViewer.canSave() && this.fTabViewer.isDirty() && !deleted && !renamed) {
                    int ret;
                    if (this.fLaunchConfigurationView != null) {
                        this.fLaunchConfigurationView.setAutoSelect(false);
                    }
                    if ((ret = this.showUnsavedChangesDialog()) == 2) {
                        this.fTabViewer.handleApplyPressed();
                        this.fTabViewer.setInput(newInput);
                    } else if (ret == 3) {
                        this.fTabViewer.handleRevertPressed();
                        this.fTabViewer.setInput(newInput);
                    } else {
                        this.fLaunchConfigurationView.getViewer().setSelection((ISelection)new StructuredSelection(input));
                    }
                    this.fLaunchConfigurationView.setAutoSelect(true);
                } else {
                    this.fTabViewer.setInput(newInput);
                    if (this.fTabViewer.isDirty()) {
                        this.fTabViewer.handleApplyPressed();
                    }
                }
            }
            finally {
                this.fSettingInput = false;
                this.updateButtons();
                this.updateMessage();
            }
            if (this.getShell() != null && this.getShell().isVisible()) {
                this.resize();
            }
        }
    }

    protected void handleLaunchPressed() {
        ILaunchConfiguration config = this.fTabViewer.getOriginal();
        if (this.fTabViewer.isDirty() && this.fTabViewer.canSave()) {
            config = this.fTabViewer.handleApplyPressed();
        }
        if (config != null) {
            this.close();
            DebugUITools.launch(config, this.getMode(), this.fIsShift);
        }
        this.setShift(false);
    }

    public void handleStatus(IStatus status) {
        IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(status);
        if (handler != null) {
            try {
                handler.handleStatus(status, (Object)this);
                return;
            }
            catch (CoreException e) {
                status = e.getStatus();
            }
        }
        String title = null;
        switch (status.getSeverity()) {
            case 4: {
                title = LaunchConfigurationsMessages.LaunchConfigurationsDialog_Error_1;
                break;
            }
            case 2: {
                title = LaunchConfigurationsMessages.LaunchConfigurationsDialog_Warning_2;
                break;
            }
            default: {
                title = LaunchConfigurationsMessages.LaunchConfigurationsDialog_Information_3;
            }
        }
        ErrorDialog.openError((Shell)this.getShell(), (String)title, null, (IStatus)status);
    }

    protected void initializeBounds() {
        IDialogSettings settings = this.getDialogSettings();
        if (this.fSashForm != null) {
            int w2;
            int w1;
            try {
                w1 = settings.getInt(DIALOG_SASH_WEIGHTS_1);
                if (w1 < 10) {
                    w1 = DEFAULT_SASH_WEIGHTS[0];
                }
                if ((w2 = settings.getInt(DIALOG_SASH_WEIGHTS_2)) < 10) {
                    w2 = DEFAULT_SASH_WEIGHTS[1];
                }
            }
            catch (NumberFormatException numberFormatException) {
                w1 = DEFAULT_SASH_WEIGHTS[0];
                w2 = DEFAULT_SASH_WEIGHTS[1];
            }
            this.fSashForm.setWeights(new int[]{w1, w2});
        }
        super.initializeBounds();
    }

    protected Point getInitialSize() {
        try {
            this.getDialogSettings().getInt("DIALOG_HEIGHT");
            return super.getInitialSize();
        }
        catch (NumberFormatException numberFormatException) {
            return DEFAULT_INITIAL_DIALOG_SIZE;
        }
    }

    protected void doSetDefaults(ILaunchConfigurationWorkingCopy wc) {
        try {
            ILaunchConfigurationTabGroup tabGroup = LaunchConfigurationPresentationManager.getDefault().getTabGroup((ILaunchConfiguration)wc, this.getMode());
            ILaunchConfigurationDialog dialog = LaunchConfigurationsDialog.getCurrentlyVisibleLaunchConfigurationDialog();
            tabGroup.createTabs(dialog, dialog.getMode());
            ILaunchConfigurationTab[] tabs = tabGroup.getTabs();
            int i = 0;
            while (i < tabs.length) {
                tabs[i].setLaunchConfigurationDialog(dialog);
                ++i;
            }
            tabGroup.setDefaults(wc);
            tabGroup.dispose();
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e.getStatus());
        }
    }

    protected void initializeContent() {
        if (this.fSetDefaultOnOpen) {
            try {
                Object o = this.fInitialSelection.getFirstElement();
                if (o instanceof ILaunchConfigurationWorkingCopy) {
                    ILaunchConfigurationWorkingCopy wc = (ILaunchConfigurationWorkingCopy)o;
                    this.doSetDefaults(wc);
                    this.setInitialSelection((IStructuredSelection)new StructuredSelection((Object)wc.doSave()));
                }
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        this.doInitialTreeSelection();
        IStatus status = this.getInitialStatus();
        if (status != null) {
            this.handleStatus(status);
        }
        this.restoreExpansion();
    }

    protected boolean isEqual(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    protected boolean isSafeToClose() {
        return this.fActiveRunningOperations == 0L;
    }

    public int open() {
        ILaunchConfiguration lastLaunchedConfig;
        int mode = this.getOpenMode();
        LaunchConfigurationsDialog.setCurrentlyVisibleLaunchConfigurationDialog(this);
        if (mode == 2 && (lastLaunchedConfig = this.getLastLaunchedWorkbenchConfiguration()) != null) {
            this.setInitialSelection((IStructuredSelection)new StructuredSelection((Object)lastLaunchedConfig));
        }
        return super.open();
    }

    protected void persistExpansion() {
        if (this.fLaunchConfigurationView != null) {
            IDialogSettings settings = this.getDialogSettings();
            TreeItem[] items = this.fLaunchConfigurationView.getTreeViewer().getTree().getItems();
            String value = settings.get(DIALOG_EXPANDED_NODES);
            if (value == null) {
                value = "";
            }
            ArrayList<String> list = new ArrayList<String>();
            String[] persisted = value.split(DELIMITER);
            int i = 0;
            while (i < persisted.length) {
                list.add(persisted[i]);
                ++i;
            }
            String type = "";
            int i2 = 0;
            while (i2 < items.length) {
                type = ((ILaunchConfigurationType)items[i2].getData()).getIdentifier();
                if (!list.contains(type) & items[i2].getExpanded()) {
                    list.add(type);
                } else if (!items[i2].getExpanded()) {
                    list.remove(type);
                }
                ++i2;
            }
            value = "";
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                value = String.valueOf(value) + (String)iter.next() + DELIMITER;
            }
            settings.put(DIALOG_EXPANDED_NODES, value);
        }
    }

    protected void restoreExpansion() {
        IDialogSettings settings;
        String value;
        if (this.fLaunchConfigurationView != null && (value = (settings = this.getDialogSettings()).get(DIALOG_EXPANDED_NODES)) != null) {
            String[] nodes = value.split(DELIMITER);
            TreeItem[] items = this.fLaunchConfigurationView.getTreeViewer().getTree().getItems();
            HashSet<Object> toexpand = new HashSet<Object>();
            if (this.fInitialSelection != null && !this.fInitialSelection.isEmpty()) {
                Object obj = this.fInitialSelection.getFirstElement();
                if (obj instanceof ILaunchConfigurationType) {
                    toexpand.add(obj);
                } else if (obj instanceof ILaunchConfiguration) {
                    try {
                        toexpand.add(((ILaunchConfiguration)obj).getType());
                    }
                    catch (CoreException e) {
                        DebugUIPlugin.log(e);
                    }
                }
            }
            int i = 0;
            while (i < nodes.length) {
                int k = 0;
                while (k < items.length) {
                    ILaunchConfigurationType type = (ILaunchConfigurationType)items[k].getData();
                    if (type.getIdentifier().equals(nodes[i])) {
                        toexpand.add(type);
                    }
                    ++k;
                }
                ++i;
            }
            this.fLaunchConfigurationView.getTreeViewer().setExpandedElements(toexpand.toArray());
        }
    }

    protected void persistSashWeights() {
        IDialogSettings settings = this.getDialogSettings();
        if (this.fSashForm != null) {
            int[] sashWeights = this.fSashForm.getWeights();
            settings.put(DIALOG_SASH_WEIGHTS_1, sashWeights[0] < 10 ? DEFAULT_SASH_WEIGHTS[0] : sashWeights[0]);
            settings.put(DIALOG_SASH_WEIGHTS_2, sashWeights[1] < 10 ? DEFAULT_SASH_WEIGHTS[1] : sashWeights[1]);
        }
    }

    protected void refreshStatus() {
        this.updateMessage();
        this.updateButtons();
    }

    protected void resize() {
        if (this.getTabGroup() != null) {
            Point shell = this.getShell().getSize();
            int maxx = (int)((float)this.getDisplay().getBounds().width * 0.75f);
            int maxy = (int)((float)this.getDisplay().getBounds().height * 0.65f);
            maxx = maxx < LaunchConfigurationsDialog.DEFAULT_INITIAL_DIALOG_SIZE.x ? LaunchConfigurationsDialog.DEFAULT_INITIAL_DIALOG_SIZE.x : maxx;
            maxy = maxy < LaunchConfigurationsDialog.DEFAULT_INITIAL_DIALOG_SIZE.y ? LaunchConfigurationsDialog.DEFAULT_INITIAL_DIALOG_SIZE.y : maxy;
            Point psize = this.getShell().computeSize(-1, maxy);
            if ((psize.x > maxx ? maxx : psize.x) > shell.x || (psize.y > maxy ? maxy : psize.y) > shell.y) {
                this.setShellSize(Math.min(psize.x, maxx), Math.min(psize.y, maxy));
                this.constrainShellSize();
            }
        }
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        if (this.getShell() != null && this.getShell().isVisible()) {
            this.fLastControl = this.getShell().getDisplay().getFocusControl();
            if (this.fLastControl != null && this.fLastControl.getShell() != this.getShell()) {
                this.fLastControl = null;
            }
            this.fProgressMonitorPart.attachToCancelComponent(null);
            this.fProgressMonitorPart.getParent().setVisible(true);
            ++this.fActiveRunningOperations;
            Control[] children = ((Composite)this.fButtonComp.getChildren()[0]).getChildren();
            boolean[] prev = new boolean[children.length + 2];
            prev[0] = this.fTabViewer.getApplyButton().isEnabled();
            prev[1] = this.fTabViewer.getRevertButton().isEnabled();
            int i = 0;
            while (i < children.length) {
                prev[i + 2] = children[i].isEnabled();
                ++i;
            }
            try {
                this.updateRunnnableControls(false, prev);
                ModalContext.run((IRunnableWithProgress)runnable, (boolean)fork, (IProgressMonitor)this.fProgressMonitorPart, (Display)this.getShell().getDisplay());
            }
            finally {
                --this.fActiveRunningOperations;
                this.updateRunnnableControls(true, prev);
                if (this.getShell() != null) {
                    this.fProgressMonitorPart.getParent().setVisible(false);
                    this.fProgressMonitorPart.removeFromCancelComponent(null);
                    if (this.fLastControl != null) {
                        this.fLastControl.setFocus();
                    }
                }
            }
        } else {
            PlatformUI.getWorkbench().getProgressService().run(fork, cancelable, runnable);
        }
    }

    private void updateRunnnableControls(boolean enabled, boolean[] prev) {
        this.fTabViewer.getApplyButton().setEnabled(enabled ? prev[0] : enabled);
        this.fTabViewer.getRevertButton().setEnabled(enabled ? prev[1] : enabled);
        Control[] children = ((Composite)this.fButtonComp.getChildren()[0]).getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].setEnabled(enabled ? prev[i + 2] : enabled);
            ++i;
        }
        this.getDialogArea().setEnabled(enabled);
    }

    @Override
    public void setActiveTab(ILaunchConfigurationTab tab) {
        this.fTabViewer.setActiveTab(tab);
    }

    @Override
    public void setActiveTab(int index) {
        this.fTabViewer.setActiveTab(index);
    }

    public void setInitialSelection(IStructuredSelection selection) {
        this.fInitialSelection = selection;
    }

    public void setInitialStatus(IStatus status) {
        this.fInitialStatus = status;
    }

    public void setDefaultsOnOpen(boolean setDefaults) {
        this.fSetDefaultOnOpen = setDefaults;
    }

    public boolean shouldSetDefaultsOnOpen() {
        return this.fSetDefaultOnOpen;
    }

    protected void setLaunchGroup(LaunchGroupExtension group) {
        this.fGroup = group;
    }

    protected void setModeLabelState() {
        this.setTitleImage(this.getBannerImage());
    }

    @Override
    public void setName(String name) {
        this.fTabViewer.setName(name);
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    public void setOpenMode(int mode) {
        this.fOpenMode = mode;
    }

    protected void setShellSize(int width, int height) {
        Rectangle bounds = this.getShell().getMonitor().getBounds();
        this.getShell().setSize(Math.min(width, bounds.width), Math.min(height, bounds.height));
    }

    protected void setTabViewer(LaunchConfigurationTabGroupViewer viewer) {
        this.fTabViewer = viewer;
    }

    private int showDiscardChangesDialog() {
        StringBuffer buffer = new StringBuffer(MessageFormat.format((String)LaunchConfigurationsMessages.LaunchConfigurationDialog_The_configuration___35, (Object[])new Object[]{this.fTabViewer.getWorkingCopy().getName()}));
        buffer.append(this.fTabViewer.getErrorMesssage());
        buffer.append(LaunchConfigurationsMessages.LaunchConfigurationDialog_Do_you_wish_to_discard_changes_37);
        MessageDialog dialog = new MessageDialog(this.getShell(), LaunchConfigurationsMessages.LaunchConfigurationDialog_Discard_changes__38, null, buffer.toString(), 3, new String[]{LaunchConfigurationsMessages.LaunchConfigurationDialog_Yes_32, LaunchConfigurationsMessages.LaunchConfigurationDialog_No_33}, 1);
        int val = 3;
        if (dialog.open() == 0) {
            if (this.fLaunchConfigurationView != null) {
                this.fLaunchConfigurationView.setAutoSelect(false);
            }
            this.fTabViewer.handleRevertPressed();
            val = 2;
            if (this.fLaunchConfigurationView != null) {
                this.fLaunchConfigurationView.setAutoSelect(true);
            }
        }
        if (val == 3) {
            val = 1028;
        }
        return val;
    }

    private int showSaveChangesDialog() {
        String message = MessageFormat.format((String)LaunchConfigurationsMessages.LaunchConfigurationDialog_The_configuration___29, (Object[])new Object[]{this.fTabViewer.getWorkingCopy().getName()});
        MessageDialog dialog = new MessageDialog(this.getShell(), LaunchConfigurationsMessages.LaunchConfigurationFilteredTree_save_changes, null, message, 3, new String[]{LaunchConfigurationsMessages.LaunchConfigurationDialog_Yes_32, LaunchConfigurationsMessages.LaunchConfigurationDialog_No_33, LaunchConfigurationsMessages.LaunchConfigurationsDialog_c_ancel}, 0);
        int ret = dialog.open();
        int val = 1;
        if (ret == 0 || ret == 1) {
            val = ret == 0 ? 2 : 3;
        }
        return val;
    }

    private int showUnsavedChangesDialog() {
        if (this.fTabViewer.canSave()) {
            return this.showSaveChangesDialog();
        }
        return this.showDiscardChangesDialog();
    }

    @Override
    public void updateButtons() {
        if (!this.fSettingInput) {
            this.getNewAction().setEnabled(this.getNewAction().isEnabled());
            this.getDeleteAction().setEnabled(this.getDeleteAction().isEnabled());
            this.getDuplicateAction().setEnabled(this.getDuplicateAction().isEnabled());
            this.fTabViewer.refresh();
            this.getButton(1025).setEnabled(this.fTabViewer.canLaunch() & this.fTabViewer.canLaunchWithModes() & !this.fTabViewer.hasDuplicateDelegates());
        } else {
            this.fTabViewer.refresh();
        }
    }

    @Override
    public void updateMessage() {
        if (!this.fSettingInput) {
            this.setErrorMessage(this.fTabViewer.getErrorMesssage());
            if (this.fTabViewer.getWarningMessage() != null) {
                this.setMessage(this.fTabViewer.getWarningMessage(), 2);
            } else {
                this.setMessage(this.fTabViewer.getMessage());
            }
        }
    }

    public boolean isTreeSelectionEmpty() {
        return this.fLaunchConfigurationView.getTreeViewer().getSelection().isEmpty();
    }

    public void propertyChange(final PropertyChangeEvent event) {
        WorkbenchJob job = new WorkbenchJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                TreeViewer viewer = LaunchConfigurationsDialog.this.fLaunchConfigurationView.getTreeViewer();
                boolean newvalue = Boolean.valueOf(event.getNewValue().toString());
                if (event.getProperty().equals("org.eclipse.debug.ui.PREF_FILTER_LAUNCH_CLOSED")) {
                    LaunchConfigurationsDialog.this.updateFilter(newvalue, LaunchConfigurationsDialog.this.fClosedProjectFilter);
                } else if (event.getProperty().equals("org.eclipse.debug.ui.PREF_FILTER_LAUNCH_DELETED")) {
                    LaunchConfigurationsDialog.this.updateFilter(newvalue, LaunchConfigurationsDialog.this.fDeletedProjectFilter);
                } else if (event.getProperty().equals("org.eclipse.debug.ui.PREF_FILTER_LAUNCH_TYPES")) {
                    LaunchConfigurationsDialog.this.updateFilter(newvalue, LaunchConfigurationsDialog.this.fLCTFilter);
                } else if (event.getProperty().equals("org.eclipse.debug.ui.PREF_FILTER_WORKING_SETS")) {
                    LaunchConfigurationsDialog.this.updateFilter(newvalue, LaunchConfigurationsDialog.this.fWorkingSetsFilter);
                } else if (event.getProperty().equals("org.eclipse.debug.ui.PREF_FILTER_TYPE_LIST") && DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.PREF_FILTER_LAUNCH_TYPES")) {
                    viewer.refresh();
                    LaunchConfigurationsDialog.this.fLaunchConfigurationView.updateFilterLabel();
                }
                return Status.OK_STATUS;
            }
        };
        job.runInUIThread((IProgressMonitor)new NullProgressMonitor());
    }

    private void updateFilter(boolean state, ViewerFilter filter) {
        TreeViewer viewer = (TreeViewer)this.fLaunchConfigurationView.getViewer();
        if (state) {
            viewer.addFilter(filter);
        } else {
            viewer.removeFilter(filter);
        }
        this.fLaunchConfigurationView.updateFilterLabel();
    }
}

