/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.svg;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.View;
import fr.inria.zvtm.engine.ViewPanel;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.engine.portals.OverviewPortal;
import fr.inria.zvtm.engine.portals.Portal;
import fr.inria.zvtm.event.PortalListener;
import fr.inria.zvtm.event.ViewListener;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.svg.Config;
import fr.inria.zvtm.svg.Viewer;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;

class MainEventHandler
implements ViewListener,
ComponentListener,
PortalListener {
    static float ZOOM_SPEED_COEF = 0.02f;
    static double PAN_SPEED_COEF = 50.0;
    static final float WHEEL_ZOOMIN_COEF = 21.0f;
    static final float WHEEL_ZOOMOUT_COEF = 22.0f;
    static float WHEEL_MM_STEP = 1.0f;
    int lastJPX;
    int lastJPY;
    long lastVX;
    long lastVY;
    Viewer application;
    boolean pcameraStickedToMouse = false;
    boolean regionStickedToMouse = false;
    boolean inPortal = false;
    boolean panning = false;
    boolean selectingRegion = false;
    double x1;
    double y1;
    double x2;
    double y2;
    boolean cursorNearBorder = false;
    Glyph sticked = null;

    MainEventHandler(Viewer app) {
        this.application = app;
    }

    public void press1(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        this.lastJPX = jpx;
        this.lastJPY = jpy;
        if (this.inPortal) {
            if (this.application.nm.ovPortal.coordInsideObservedRegion(jpx, jpy)) {
                this.regionStickedToMouse = true;
            } else {
                this.pcameraStickedToMouse = true;
            }
        } else if (mod == 6) {
            this.selectingRegion = true;
            this.x1 = v.getVCursor().getVSXCoordinate();
            this.y1 = v.getVCursor().getVSYCoordinate();
            v.setDrawRect(true);
        } else {
            this.lastJPX = jpx;
            this.lastJPY = jpy;
            this.panning = true;
            v.setDrawDrag(true);
        }
    }

    public void release1(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        this.regionStickedToMouse = false;
        this.pcameraStickedToMouse = false;
        if (this.selectingRegion) {
            v.setDrawRect(false);
            this.x2 = v.getVCursor().getVSXCoordinate();
            this.y2 = v.getVCursor().getVSYCoordinate();
            if (Math.abs(this.x2 - this.x1) >= 4.0 && Math.abs(this.y2 - this.y1) >= 4.0) {
                this.application.nm.mCamera.getOwningView().centerOnRegion(this.application.nm.mCamera, 300, this.x1, this.y1, this.x2, this.y2);
            }
            this.selectingRegion = false;
        } else if (this.panning) {
            this.application.nm.mCamera.setXspeed(0.0);
            this.application.nm.mCamera.setYspeed(0.0);
            this.application.nm.mCamera.setZspeed(0.0);
            v.setDrawDrag(false);
            this.panning = false;
        }
    }

    public void click1(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
        if (v.lastGlyphEntered() != null) {
            this.application.mView.centerOnGlyph(v.lastGlyphEntered(), v.cams[0], 300, true, 1.0f);
        }
    }

    public void press2(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
    }

    public void release2(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
    }

    public void click2(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
    }

    public void press3(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
    }

    public void release3(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
    }

    public void click3(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
    }

    public void mouseMoved(ViewPanel v, int jpx, int jpy, MouseEvent e) {
    }

    public void mouseDragged(ViewPanel v, int mod, int buttonNumber, int jpx, int jpy, MouseEvent e) {
        if (this.regionStickedToMouse) {
            double a = (this.application.nm.ovCamera.focal + Math.abs(this.application.nm.ovCamera.altitude)) / this.application.nm.ovCamera.focal;
            this.application.nm.mCamera.move((double)Math.round(a * (double)(jpx - this.lastJPX)), (double)Math.round(a * (double)(this.lastJPY - jpy)));
            this.lastJPX = jpx;
            this.lastJPY = jpy;
        } else if (this.pcameraStickedToMouse) {
            double a = (this.application.nm.ovCamera.focal + Math.abs(this.application.nm.ovCamera.altitude)) / this.application.nm.ovCamera.focal;
            this.application.nm.ovCamera.move((double)Math.round(a * (double)(this.lastJPX - jpx)), (double)Math.round(a * (double)(jpy - this.lastJPY)));
            this.application.nm.mCamera.move((double)Math.round(a * (double)(this.lastJPX - jpx)), (double)Math.round(a * (double)(jpy - this.lastJPY)));
            this.lastJPX = jpx;
            this.lastJPY = jpy;
        } else if (this.panning) {
            Camera c = v.cams[0];
            double a = (c.focal + Math.abs(c.altitude)) / c.focal;
            if (mod == 5) {
                this.application.nm.mCamera.setXspeed(0.0);
                this.application.nm.mCamera.setYspeed(0.0);
                this.application.nm.mCamera.setZspeed((double)((float)(this.lastJPY - jpy) * ZOOM_SPEED_COEF));
            } else {
                this.application.nm.mCamera.setXspeed((double)((long)((double)(jpx - this.lastJPX) * (a / PAN_SPEED_COEF))));
                this.application.nm.mCamera.setYspeed((double)((long)((double)(this.lastJPY - jpy) * (a / PAN_SPEED_COEF))));
                this.application.nm.mCamera.setZspeed(0.0);
            }
        }
    }

    public void mouseWheelMoved(ViewPanel v, short wheelDirection, int jpx, int jpy, MouseWheelEvent e) {
        double a = (this.application.nm.mCamera.focal + Math.abs(this.application.nm.mCamera.altitude)) / this.application.nm.mCamera.focal;
        if (wheelDirection == 1) {
            this.application.nm.mCamera.altitudeOffset(a * 22.0);
            VirtualSpaceManager.INSTANCE.repaint();
        } else {
            this.application.nm.mCamera.altitudeOffset(-a * 21.0);
            VirtualSpaceManager.INSTANCE.repaint();
        }
    }

    public void enterGlyph(Glyph g) {
        g.highlight(true, null);
    }

    public void exitGlyph(Glyph g) {
        g.highlight(false, null);
    }

    public void Kpress(ViewPanel v, char c, int code, int mod, KeyEvent e) {
        if (code == 33) {
            this.application.nm.getHigherView();
        } else if (code == 34) {
            this.application.nm.getLowerView();
        } else if (code == 36) {
            this.application.nm.getGlobalView();
        } else if (code == 38) {
            this.application.nm.translateView((short)0);
        } else if (code == 40) {
            this.application.nm.translateView((short)1);
        } else if (code == 37) {
            this.application.nm.translateView((short)2);
        } else if (code == 39) {
            this.application.nm.translateView((short)3);
        }
    }

    public void Ktype(ViewPanel v, char c, int code, int mod, KeyEvent e) {
    }

    public void Krelease(ViewPanel v, char c, int code, int mod, KeyEvent e) {
    }

    public void viewActivated(View v) {
    }

    public void viewDeactivated(View v) {
    }

    public void viewIconified(View v) {
    }

    public void viewDeiconified(View v) {
    }

    public void viewClosing(View v) {
        this.application.exit();
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.application.updatePanelSize();
    }

    public void componentShown(ComponentEvent e) {
    }

    public void enterPortal(Portal p) {
        this.inPortal = true;
        ((OverviewPortal)p).setBorder(Config.OV_INSIDE_BORDER_COLOR);
        VirtualSpaceManager.INSTANCE.repaint();
    }

    public void exitPortal(Portal p) {
        this.inPortal = false;
        ((OverviewPortal)p).setBorder(Config.OV_BORDER_COLOR);
        VirtualSpaceManager.INSTANCE.repaint();
    }
}

