/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.configuration.common.ui.page.supervisor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.efm.execution.configuration.common.ui.api.AbstractConfigurationPage;
import org.eclipse.efm.execution.configuration.common.ui.api.AbstractConfigurationSection;
import org.eclipse.efm.execution.configuration.common.ui.api.IWidgetToolkit;
import org.eclipse.efm.execution.configuration.common.ui.editors.IntegerFieldEditor;
import org.eclipse.swt.widgets.Composite;

public class SupervisorEvaluationLimitsSection
extends AbstractConfigurationSection {
    public SupervisorEvaluationLimitsSection(AbstractConfigurationPage configurationPage) {
        super(configurationPage);
    }

    @Override
    public String getSectionTitle() {
        return "Evaluation limits";
    }

    @Override
    public String getSectionDescription() {
        return "Evaluation limits: max step count or timeout";
    }

    @Override
    protected void createContent(Composite parent, IWidgetToolkit widgetToolkit) {
        IntegerFieldEditor integerField = new IntegerFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_SPECIFICATION_STOP_CRITERIA_STEPS", "&Symbex Step Count :", parent, 1000);
        integerField.setToolTipText("Maximal symbex step (possibly many evaluations by step) (-1 <=> no-limit) during the dynamic process");
        this.addField(integerField);
        integerField = new IntegerFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_SPECIFICATION_STOP_CRITERIA_EVALS", "&Symbex Eval Count :", parent, 1000);
        integerField.setToolTipText("Maximal symbex evaluation count (-1 <=> no-limit) during the dynamic process");
        this.addField(integerField);
        integerField = new IntegerFieldEditor(this.fConfigurationPage, "org.eclipse.efm.execution.core.ATTR_SPECIFICATION_STOP_CRITERIA_TIMEOUT", "&Timeout (seconds) :", parent, -1);
        integerField.setToolTipText("Maximal duration (-1 <=> no-limit) of the symbex dynamic process");
        this.addField(integerField);
        integerField.setEnabled(false);
    }

    @Override
    protected void setDefaultsImpl(ILaunchConfigurationWorkingCopy configuration) {
        String fModelAnalysis;
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_STOP_CRITERIA_NODE", -1);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_STOP_CRITERIA_WIDTH", -1);
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_STOP_CRITERIA_HEIGHT", -1);
        try {
            fModelAnalysis = configuration.getAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_MODEL_ANALYSIS_PROFILE", "");
        }
        catch (CoreException e) {
            e.printStackTrace();
            fModelAnalysis = "";
        }
        if (fModelAnalysis.equals("Transition Coverage")) {
            configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_STOP_CRITERIA_STEPS", -1);
            configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_STOP_CRITERIA_EVALS", -1);
        } else {
            configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_STOP_CRITERIA_STEPS", 1000);
            configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_STOP_CRITERIA_EVALS", 1000);
        }
        configuration.setAttribute("org.eclipse.efm.execution.core.ATTR_SPECIFICATION_STOP_CRITERIA_TIMEOUT", -1);
    }

    @Override
    protected void initializeFromImpl(ILaunchConfiguration configuration) {
    }

    @Override
    protected void performApplyImpl(ILaunchConfigurationWorkingCopy configuration) {
    }

    @Override
    protected boolean isValidImpl(ILaunchConfiguration launchConfig) {
        return true;
    }
}

