/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.core.workflow.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CheckingScopeKind implements Enumerator
{
    GLOBALLY(0, "GLOBALLY", "GLOBALLY"),
    LOCALLY(1, "LOCALLY", "LOCALLY");

    public static final int GLOBALLY_VALUE = 0;
    public static final int LOCALLY_VALUE = 1;
    private static final CheckingScopeKind[] VALUES_ARRAY;
    public static final List<CheckingScopeKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CheckingScopeKind[]{GLOBALLY, LOCALLY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CheckingScopeKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CheckingScopeKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CheckingScopeKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CheckingScopeKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CheckingScopeKind get(int value) {
        switch (value) {
            case 0: {
                return GLOBALLY;
            }
            case 1: {
                return LOCALLY;
            }
        }
        return null;
    }

    private CheckingScopeKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

