/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer.dot;

import fr.inria.zvtm.engine.VirtualSpace;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.ClosedShape;
import fr.inria.zvtm.glyphs.DPath;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.VCircle;
import fr.inria.zvtm.glyphs.VEllipse;
import fr.inria.zvtm.glyphs.VRectangle;
import fr.inria.zvtm.glyphs.VRoundRect;
import fr.inria.zvtm.glyphs.VShape;
import fr.inria.zvtm.glyphs.VText;
import java.awt.Color;
import java.awt.Font;
import java.util.Vector;
import net.claribole.zgrviewer.dot.ArrowEnd;
import net.claribole.zgrviewer.dot.BasicNode;
import net.claribole.zgrviewer.dot.Colors;
import net.claribole.zgrviewer.dot.Edge;
import net.claribole.zgrviewer.dot.Graph;
import net.claribole.zgrviewer.dot.Node;
import net.claribole.zgrviewer.dot.Point;
import net.claribole.zgrviewer.dot.Record;
import net.claribole.zgrviewer.dot.Rectangle;
import net.claribole.zgrviewer.dot.SubGraph;
import net.claribole.zgrviewer.dot.SubRecord;

public class ZgrReader {
    private static int inches = 36;
    private static int spacingPeripheries = 4;
    private static long min;
    private static long max;

    public static void load(Graph graph, VirtualSpaceManager vsm, VirtualSpace vs, boolean meta) {
        long x1 = (long)((double)(graph.bb.x1 / 2L) - graph.margin.x * (double)inches);
        long x2 = (long)((double)(graph.bb.x2 / 2L) + graph.margin.x * (double)inches);
        long y1 = (long)((double)(graph.bb.y1 / 2L) - graph.margin.y * (double)inches);
        long y2 = (long)((double)(graph.bb.y2 / 2L) + graph.margin.y * (double)inches);
        if (graph.bgcolor != null) {
            VRectangle background = new VRectangle(x2 + x1, y2 + y1, 1, x2 - x1, y2 - y1, graph.bgcolor);
            vs.addGlyph(background);
        }
        if (graph.lp != null) {
            ZgrReader.createLabel(graph.label, graph.lp.coords[0], graph.lp.coords[1], graph.fontsize, graph.fontcolor, graph.fontname, vsm, vs, graph);
        }
        ZgrReader.createNodesGlyphs(graph.getNodes(), vsm, vs);
        ZgrReader.createEdgesGlyphs(graph.getEdges(), vsm, vs);
    }

    private static void createNodesGlyphs(Node[] nodes, VirtualSpaceManager vsm, VirtualSpace vs) {
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                Color nodeBorderColor;
                Node node = nodes[i];
                Color nodeFillColor = Colors.transparent;
                if (node.style.getStyle(3)) {
                    nodeBorderColor = nodeFillColor;
                } else if (node.style.getStyle(5)) {
                    if (node.fillcolor == null) {
                        if (node.color == null) {
                            nodeBorderColor = Color.black;
                        } else {
                            nodeFillColor = nodeBorderColor = node.color;
                        }
                    } else {
                        nodeFillColor = node.fillcolor;
                        nodeBorderColor = node.color == null ? nodeFillColor : node.color;
                    }
                } else {
                    nodeBorderColor = node.color == null ? Color.black : node.color;
                }
                if (node instanceof BasicNode) {
                    ZgrReader.createBasicNode((BasicNode)node, vsm, vs, nodeFillColor, nodeBorderColor);
                    continue;
                }
                if (node instanceof Record) {
                    ZgrReader.createRecord((Record)node, vsm, vs, nodeFillColor, nodeBorderColor);
                    continue;
                }
                if (!(node instanceof SubGraph)) continue;
                ZgrReader.createSubGraph((SubGraph)node, vsm, vs, nodeFillColor, nodeBorderColor);
            }
        }
    }

    private static void createSubGraph(SubGraph subgraph, VirtualSpaceManager vsm, VirtualSpace vs, Color fill, Color border) {
        if (subgraph.bb != null) {
            long x1 = subgraph.bb.x1 >> 1;
            long x2 = subgraph.bb.x2 >> 1;
            long y1 = subgraph.bb.y1 >> 1;
            long y2 = subgraph.bb.y2 >> 1;
            VRectangle background = new VRectangle(x2 + x1, y2 + y1, 1, x2 - x1, y2 - y1, fill);
            ((Glyph)background).setBorderColor(border);
            vs.addGlyph(background);
        }
        if (subgraph.lp != null) {
            ZgrReader.createLabel(subgraph.label, subgraph.lp.coords[0], subgraph.lp.coords[1], subgraph.fontsize, subgraph.fontcolor, subgraph.fontname, vsm, vs, subgraph);
        }
        ZgrReader.createNodesGlyphs(subgraph.getNodes(), vsm, vs);
        ZgrReader.createEdgesGlyphs(subgraph.getEdges(), vsm, vs);
    }

    private static void createRecord(Record record, VirtualSpaceManager vsm, VirtualSpace vs, Color fill, Color border) {
        if (record.pos != null) {
            Rectangle[] lines = ZgrReader.findRectsLines(record.rects);
            if (lines != null) {
                int j;
                long x1 = lines[lines.length - 1].x1 >> 1;
                long x2 = lines[lines.length - 1].x2 >> 1;
                long y1 = lines[lines.length - 1].y1 >> 1;
                long y2 = lines[lines.length - 1].y2 >> 1;
                ClosedShape rect = record.style.getStyle(7) ? new VRoundRect(x2 + x1, y2 + y1, 1, x2 - x1, y2 - y1, fill, 20.0, 20.0) : new VRectangle(x2 + x1, y2 + y1, 1, x2 - x1, y2 - y1, fill);
                ((Glyph)rect).setBorderColor(border);
                vs.addGlyph(rect);
                for (j = 0; j < lines.length - 1; ++j) {
                    DPath line = new DPath(lines[j].x1, lines[j].y1, 1, Color.black);
                    line.addSegment(lines[j].x2, lines[j].y2, true);
                    vs.addGlyph(line);
                }
                if (record.subRecords != null) {
                    for (j = 0; j < record.subRecords.length; ++j) {
                        ZgrReader.createSubRecordLabel(record.subRecords[j], vsm, vs);
                    }
                } else {
                    x1 = record.rects[0].x1 >> 1;
                    x2 = record.rects[0].x2 >> 1;
                    y1 = record.rects[0].y1 >> 1;
                    y2 = record.rects[0].y2 >> 1;
                    ZgrReader.createLabel(record.label, x2 + x1, y2 + y1, record.fontsize, record.fontcolor, record.fontname, vsm, vs, record);
                }
            } else {
                ClosedShape rect = record.style.getStyle(7) ? new VRoundRect(record.pos.coords[0], record.pos.coords[1], 1, (long)((double)inches * record.width), (long)((double)inches * record.height), fill, 20.0, 20.0) : new VRectangle(record.pos.coords[0], record.pos.coords[1], 1, (long)((double)inches * record.width), (long)((double)inches * record.height), fill);
                vs.addGlyph(rect);
                ((Glyph)rect).setBorderColor(border);
                ZgrReader.createLabel(record.label, record.pos.coords[0], record.pos.coords[1], record.fontsize, record.fontcolor, record.fontname, vsm, vs, record);
            }
        }
    }

    private static void createBasicNode(BasicNode node, VirtualSpaceManager vsm, VirtualSpace vs, Color fill, Color border) {
        if (node.pos != null) {
            ClosedShape nodeGlyph = null;
            switch (node.shape) {
                case 5: {
                    break;
                }
                case 2: {
                    if (node.peripheries == 1) {
                        nodeGlyph = node.regular ? new VCircle(node.pos.coords[0], node.pos.coords[1], 1, (long)((double)inches * Math.max(node.width, node.height)), fill) : new VEllipse(node.pos.coords[0], node.pos.coords[1], 1, (long)((double)inches * node.width), (long)((double)inches * node.height), fill);
                        ((Glyph)nodeGlyph).setBorderColor(border);
                        break;
                    }
                    if (node.peripheries <= 1) break;
                    ClosedShape primary = node.regular ? new VCircle(node.pos.coords[0], node.pos.coords[1], 1, (long)((double)inches * Math.max(node.width, node.height)), fill) : new VEllipse(node.pos.coords[0], node.pos.coords[1], 1, (long)((double)inches * node.width), (long)((double)inches * node.height), fill);
                    ((Glyph)primary).setBorderColor(border);
                    vs.addGlyph(primary);
                    break;
                }
                case 7: {
                    break;
                }
                case 10: {
                    break;
                }
                case 9: {
                    break;
                }
                case 8: {
                    break;
                }
                case 1: {
                    nodeGlyph = new VRectangle(node.pos.coords[0], node.pos.coords[1], 1, (long)((double)inches * node.width), (long)((double)inches * node.height), Colors.transparent);
                    ((Glyph)nodeGlyph).setBorderColor(Colors.transparent);
                    break;
                }
                case 4: {
                    fill = border;
                    nodeGlyph = new VCircle<BasicNode>(node.pos.coords[0], node.pos.coords[1], 1, (long)((double)inches * Math.max(node.width, node.height)), fill);
                    ((Glyph)nodeGlyph).setBorderColor(border);
                    break;
                }
                case 3: {
                    if (node.sides == 4 && node.skew == 0.0 && node.distortion == 0.0) {
                        if (node.rects != null) {
                            long x1 = node.rects.x1 >> 1;
                            long x2 = node.rects.x2 >> 1;
                            long y1 = node.rects.y1 >> 1;
                            long y2 = node.rects.y2 >> 1;
                            nodeGlyph = new VRectangle(x2 + x1, y2 + y1, 1, x2 - x1, y2 - y1, fill);
                            ((Glyph)nodeGlyph).setBorderColor(border);
                            break;
                        }
                        long x = node.pos.coords[0] >> 1;
                        long y = node.pos.coords[1] >> 1;
                        nodeGlyph = new VRectangle(node.pos.coords[0], node.pos.coords[1], 1, (long)((double)inches * node.width), (long)((double)inches * node.height), fill);
                        ((Glyph)nodeGlyph).setBorderColor(border);
                        break;
                    }
                    System.err.println(node.sides + " - " + node.rects);
                    break;
                }
                case 6: {
                    break;
                }
            }
            if (nodeGlyph != null) {
                vs.addGlyph(nodeGlyph);
                nodeGlyph.setOwner(node);
            }
            ZgrReader.createLabel(node.label, node.pos.coords[0], node.pos.coords[1], node.fontsize, node.fontcolor, node.fontname, vsm, vs, node);
        }
    }

    private static void createSubRecordLabel(SubRecord sub, VirtualSpaceManager vsm, VirtualSpace vs) {
        if (sub.rect != null) {
            long x1 = sub.rect.x1 >> 1;
            long x2 = sub.rect.x2 >> 1;
            long y1 = sub.rect.y1 >> 1;
            long y2 = sub.rect.y2 >> 1;
            ZgrReader.createLabel(sub.label.toString(), x2 + x1, y2 + y1, sub.fontsize, sub.fontcolor, sub.fontname, vsm, vs, sub);
        }
        if (sub.subRecords != null) {
            for (int i = 0; i < sub.subRecords.length; ++i) {
                ZgrReader.createSubRecordLabel(sub.subRecords[i], vsm, vs);
            }
        }
    }

    private static boolean crossing(long l1, long l2, long b1, long b2) {
        long line1 = Math.min(l1, l2);
        long line2 = Math.max(l1, l2);
        long box1 = Math.min(b1, b2);
        long box2 = Math.max(b1, b1);
        if (box2 < line1 || line2 < box1) {
            return false;
        }
        min = Math.min(line1, box1);
        max = Math.max(line2, box2);
        return true;
    }

    private static Rectangle[] findRectsLines(Rectangle[] rects) {
        if (rects != null) {
            Vector<Rectangle> vlines = new Vector<Rectangle>(4 * rects.length);
            long xmin = Long.MAX_VALUE;
            long xmax = Long.MIN_VALUE;
            long ymin = Long.MAX_VALUE;
            long ymax = Long.MIN_VALUE;
            for (int i = 0; i < rects.length; ++i) {
                boolean left = false;
                boolean right = false;
                boolean top = false;
                boolean bottom = false;
                for (int j = 0; j < vlines.size(); ++j) {
                    Rectangle test = (Rectangle)vlines.get(j);
                    if (test.x1 != test.x2) continue;
                    if (test.x1 == rects[i].x1) {
                        left = ZgrReader.crossing(test.y1, test.y2, rects[i].y1, rects[i].y2);
                        if (!left) continue;
                        vlines.set(j, new Rectangle(rects[i].x1, min, rects[i].x1, max));
                        continue;
                    }
                    if (test.x1 == rects[i].x2) {
                        right = ZgrReader.crossing(test.y1, test.y2, rects[i].y1, rects[i].y2);
                        if (!right) continue;
                        vlines.set(j, new Rectangle(rects[i].x2, min, rects[i].x2, max));
                        continue;
                    }
                    if (test.y1 != test.y2) continue;
                    if (test.y1 == rects[i].y1) {
                        top = ZgrReader.crossing(test.x1, test.x2, rects[i].x1, rects[i].x2);
                        if (!top) continue;
                        vlines.set(j, new Rectangle(min, rects[i].y1, max, rects[i].y1));
                        continue;
                    }
                    if (test.y1 != rects[i].y2) continue;
                    bottom = ZgrReader.crossing(test.x1, test.x2, rects[i].x1, rects[i].x2);
                    if (!top) continue;
                    vlines.set(j, new Rectangle(min, rects[i].y2, max, rects[i].y2));
                }
                xmin = Math.min(Math.min(rects[i].x1, rects[i].x2), xmin);
                ymin = Math.min(Math.min(rects[i].y1, rects[i].y2), ymin);
                xmax = Math.max(Math.max(rects[i].x1, rects[i].x2), xmax);
                ymax = Math.max(Math.max(rects[i].y1, rects[i].y2), ymax);
                if (!top) {
                    vlines.add(new Rectangle(rects[i].x1, rects[i].y1, rects[i].x2, rects[i].y1));
                }
                if (!bottom) {
                    vlines.add(new Rectangle(rects[i].x1, rects[i].y2, rects[i].x2, rects[i].y2));
                }
                if (!left) {
                    vlines.add(new Rectangle(rects[i].x1, rects[i].y1, rects[i].x1, rects[i].y2));
                }
                if (right) continue;
                vlines.add(new Rectangle(rects[i].x2, rects[i].y1, rects[i].x2, rects[i].y2));
            }
            Vector<Rectangle> alllines = new Vector<Rectangle>(vlines.size());
            for (int i = 0; i < vlines.size(); ++i) {
                Rectangle test = (Rectangle)vlines.get(i);
                if (test.x1 == test.x2 && (test.x1 == xmin || test.x1 == xmax) || test.y1 == test.y2 && (test.y1 == ymin || test.y2 == ymax)) continue;
                alllines.add(test);
            }
            alllines.add(new Rectangle(xmin, ymin, xmax, ymax));
            Rectangle[] lines = new Rectangle[alllines.size()];
            for (int i = 0; i < lines.length; ++i) {
                lines[i] = (Rectangle)alllines.get(i);
            }
            return lines;
        }
        return null;
    }

    private static void createLabel(String label, long x, long y, double size, Color color, String fontname, VirtualSpaceManager vsm, VirtualSpace vs, Object owner) {
        if (!label.trim().equals("")) {
            String[] texts = label.split("\\\\n");
            int s = new Double(size).intValue();
            int interline = new Double(size * 1.25).intValue();
            for (int k = 0; k < texts.length; ++k) {
                String text = texts[k].trim();
                if (text.equals("")) continue;
                if (text.charAt(0) == '\"' && text.charAt(text.length() - 1) == '\"') {
                    text = text.substring(1, text.length() - 1);
                }
                VText<Object> g = new VText<Object>(x, y + 1L + (long)(texts.length * interline / 2) - (long)((k + 1) * (interline - 1)), 1, color, text.replaceAll("\\\\", ""), 1);
                g.setFont(Font.decode(fontname + "-PLAIN-" + s));
                vs.addGlyph(g);
                g.setOwner(owner);
            }
        }
    }

    private static void createEdgesGlyphs(Edge[] edges, VirtualSpaceManager vsm, VirtualSpace vs) {
        if (edges != null) {
            for (int i = 0; i < edges.length; ++i) {
                Edge edge = edges[i];
                if (edge.pos != null) {
                    Glyph arrow;
                    Point[] points = edge.pos.getControls();
                    DPath pathGlyph = edge.color == null ? new DPath(points[0].coords[0], points[0].coords[1], 1, Colors.black) : new DPath(points[0].coords[0], points[0].coords[1], 1, edge.color[0]);
                    for (int j = 1; j < points.length; j += 3) {
                        pathGlyph.addCbCurve(points[j + 2].coords[0], points[j + 2].coords[1], points[j].coords[0], points[j].coords[1], points[j + 1].coords[0], points[j + 1].coords[1], true);
                    }
                    vs.addGlyph(pathGlyph);
                    if (edge.pos.startingPoint != null && (arrow = ZgrReader.createArrow(points[0], edge.pos.startingPoint, edge.tail, edge)) != null) {
                        vs.addGlyph(arrow);
                    }
                    if (edge.pos.endingPoint != null && (arrow = ZgrReader.createArrow(points[points.length - 1], edge.pos.endingPoint, edge.head, edge)) != null) {
                        vs.addGlyph(arrow);
                    }
                }
                if (edge.lp == null) continue;
                double size = edge.labelfontsize < 0.0 ? edge.fontsize : edge.labelfontsize;
                Color color = edge.labelfontcolor == null ? edge.fontcolor : edge.labelfontcolor;
                String name = edge.labelfontname == null ? edge.fontname : edge.labelfontname;
                ZgrReader.createLabel(edge.label, edge.lp.coords[0], edge.lp.coords[1], size, color, name, vsm, vs, edge);
            }
        }
    }

    private static Glyph createArrow(Point start, Point point, ArrowEnd end, Edge edge) {
        Glyph arrow = null;
        double x = point.coords[0] - start.coords[0];
        double y = point.coords[1] - start.coords[1];
        double angle = Math.atan(y / x);
        if (x < 0.0) {
            angle += Math.PI;
        }
        switch (end.outerShape.shape) {
            case 0: {
                arrow = new DPath<ArrowEnd>(start.coords[0], start.coords[1], 1, Color.red);
                ((DPath)arrow).addSegment(point.coords[0], point.coords[1], true);
                break;
            }
            case 1: {
                float[] norm = new float[]{1.0f, 0.5f, 0.5f};
                double taille = Math.sqrt(x * x + y * y) / 6.0;
                Color c = edge.color == null ? Color.black : edge.color[0];
                arrow = new VShape((long)((double)start.coords[0] + taille * Math.cos(angle)), (long)((double)start.coords[1] + taille * Math.sin(angle)), 1, (long)(5.0 * taille), norm, c, (float)angle);
                arrow.setBorderColor(c);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
        }
        if (arrow != null) {
            arrow.setOwner(end);
        }
        return arrow;
    }
}

