/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ui.debug;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.emf.mwe.ui.debug.model.MWEBreakpoint;
import org.eclipse.emf.mwe.ui.debug.processing.PluginAdapter;
import org.eclipse.emf.mwe.ui.workflow.util.PluginConfigurationElementUtil;
import org.eclipse.internal.xpand2.ast.Statement;
import org.eclipse.internal.xpand2.ast.TextStatement;
import org.eclipse.internal.xtend.expression.ast.BooleanOperation;
import org.eclipse.internal.xtend.expression.ast.Case;
import org.eclipse.internal.xtend.expression.ast.Cast;
import org.eclipse.internal.xtend.expression.ast.ChainExpression;
import org.eclipse.internal.xtend.expression.ast.CollectionExpression;
import org.eclipse.internal.xtend.expression.ast.FeatureCall;
import org.eclipse.internal.xtend.expression.ast.ISyntaxElement;
import org.eclipse.internal.xtend.expression.ast.IfExpression;
import org.eclipse.internal.xtend.expression.ast.LetExpression;
import org.eclipse.internal.xtend.expression.ast.ListLiteral;
import org.eclipse.internal.xtend.expression.ast.OperationCall;
import org.eclipse.internal.xtend.expression.ast.SwitchExpression;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.internal.xtend.expression.debug.BaseSpecialTreatment;
import org.eclipse.internal.xtend.expression.debug.EvaluatedElementWrapper;
import org.eclipse.internal.xtend.expression.debug.ExpressionModelPresentation;
import org.eclipse.internal.xtend.xtend.ast.Around;
import org.eclipse.internal.xtend.xtend.ast.CreateExtensionStatement;
import org.eclipse.internal.xtend.xtend.ast.ExpressionExtensionStatement;
import org.eclipse.internal.xtend.xtend.ast.ExtensionFile;
import org.eclipse.internal.xtend.xtend.ast.JavaExtensionStatement;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.shared.ui.core.IXtendXpandProject;
import org.eclipse.xtend.shared.ui.core.IXtendXpandResource;
import org.eclipse.xtend.ui.XtendEditorPlugin;
import org.eclipse.xtend.ui.editor.XtendEditor;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionPluginAdapter
implements PluginAdapter {
    protected ExpressionModelPresentation pres;
    protected Set<BaseSpecialTreatment> specials = new HashSet<BaseSpecialTreatment>();
    private Image icon = null;

    public ExpressionPluginAdapter() {
        this.pres = new ExpressionModelPresentation(this.specials);
    }

    protected String getRequiredExtension() {
        return "ext";
    }

    public boolean canHandleResourceExtension(String ext) {
        return this.getRequiredExtension().equals(ext);
    }

    public boolean canHandleType(String type) {
        return "expression".equals(type);
    }

    public String getEditorId() {
        return PluginConfigurationElementUtil.getConfigAttribute((String)("org.eclipse.ui.editors/editor[class=" + XtendEditor.class.getName() + "]/id"));
    }

    public boolean isToggleBpEnabled(IResource resource, int start, int end, int line) {
        ISyntaxElement element = this.findElementForPosition(resource, start, line);
        if (element == null) {
            return false;
        }
        return this.pres.getStart(element) <= start && this.pres.getStartingEndPosition(element) >= end;
    }

    public MWEBreakpoint createBreakpoint(IResource resource, int start, int end, int line) throws CoreException {
        ISyntaxElement element = this.findElementForPosition(resource, start, line);
        if (element == null || !(element instanceof FeatureCall) && !(element instanceof Statement) || element instanceof TextStatement || element.getEnd() == 0) {
            return null;
        }
        return new MWEBreakpoint(resource, element.getNameString(null), element.getLine(), element.getStart(), element.getEnd());
    }

    public IBreakpoint checkBreakpoints(IBreakpoint[] bps, IResource resource, int start, int end, int line) throws CoreException {
        ISyntaxElement element = this.findElementForPosition(resource, start, line);
        if (element == null) {
            return null;
        }
        IBreakpoint[] iBreakpointArray = bps;
        int n = bps.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint bp1 = iBreakpointArray[n2];
            MWEBreakpoint bp = (MWEBreakpoint)bp1;
            if (bp.getResource().equals(resource.getFullPath().toString()) && bp.getLine() == element.getLine()) {
                return bp;
            }
            ++n2;
        }
        return null;
    }

    protected ISyntaxElement findElementForPosition(IResource resource, int position, int line) {
        ISyntaxElement rootElem = this.getContainingRootElement(resource, position);
        if (rootElem == null) {
            return null;
        }
        ISyntaxElement body = this.getBodyOfRootElement(rootElem);
        if (body instanceof ChainExpression) {
            return this.getContainingElementOfChainExpression((ChainExpression)body, position);
        }
        if (body instanceof LetExpression) {
            return this.getContainingElementOfLetExpression((LetExpression)body, position);
        }
        if (body instanceof IfExpression) {
            return this.getContainingElementOfIfExpression((IfExpression)body, position);
        }
        return this.getContainingElement((SyntaxElement)body, position);
    }

    private boolean containsPosition(ISyntaxElement elem, int position) {
        return elem.getStart() <= position && elem.getEnd() > position;
    }

    protected int shiftPositionIfInside(int currentPosition, SyntaxElement lowerBound, SyntaxElement upperBound) {
        return currentPosition >= lowerBound.getStart() && currentPosition <= upperBound.getStart() ? upperBound.getStart() : currentPosition;
    }

    protected ISyntaxElement getContainingElement(SyntaxElement se, int position) {
        if (!this.containsPosition((ISyntaxElement)se, position)) {
            return null;
        }
        if (se instanceof ChainExpression) {
            return this.getContainingElementOfChainExpression((ChainExpression)se, position);
        }
        if (se instanceof LetExpression) {
            return this.getContainingElementOfLetExpression((LetExpression)se, position);
        }
        if (se instanceof SwitchExpression) {
            return this.getContainingElementOfSwitchExpression((SwitchExpression)se, position);
        }
        if (se instanceof ListLiteral) {
            return this.getContainingElementOfListLiteral((ListLiteral)se, position);
        }
        if (se instanceof IfExpression) {
            return this.getContainingElementOfIfExpression((IfExpression)se, position);
        }
        if (se instanceof CollectionExpression) {
            return this.getContainingElementOfCollectionExpression((CollectionExpression)se, position);
        }
        if (se instanceof BooleanOperation) {
            return this.getContainingElementOfBooleanOperation((BooleanOperation)se, position);
        }
        if (se instanceof FeatureCall) {
            return this.getContainingElementOfFeatureCall((FeatureCall)se, position);
        }
        return null;
    }

    protected ISyntaxElement getContainingChild(SyntaxElement parent, Collection<SyntaxElement> children, int position) {
        if (!this.containsPosition((ISyntaxElement)parent, position)) {
            return null;
        }
        ISyntaxElement result = null;
        int newPosition = position;
        SyntaxElement lastElem = parent;
        for (SyntaxElement child : children) {
            if (child == null) continue;
            this.fixBoundaries(child);
            if (child.getEnd() == 0) {
                System.out.println(String.valueOf(child.getClass().getSimpleName()) + "  " + child.toString());
            }
            if ((result = this.getContainingElement(child, newPosition = this.shiftPositionIfInside(newPosition, lastElem, child))) != null) {
                return result;
            }
            lastElem = child;
        }
        return parent;
    }

    private ISyntaxElement getContainingElementOfLetExpression(LetExpression le, int position) {
        ArrayList<SyntaxElement> children = new ArrayList<SyntaxElement>();
        children.add((SyntaxElement)le.getVarExpression());
        children.add((SyntaxElement)le.getTargetExpression());
        return this.getContainingChild((SyntaxElement)le, children, position);
    }

    private ISyntaxElement getContainingElementOfIfExpression(IfExpression ie, int position) {
        ArrayList<SyntaxElement> children = new ArrayList<SyntaxElement>();
        children.add((SyntaxElement)ie.getCondition());
        children.add((SyntaxElement)ie.getThenPart());
        children.add((SyntaxElement)ie.getElsePart());
        return this.getContainingChild((SyntaxElement)ie, children, position);
    }

    private ISyntaxElement getContainingElementOfCollectionExpression(CollectionExpression ce, int position) {
        ArrayList<SyntaxElement> children = new ArrayList<SyntaxElement>();
        children.add((SyntaxElement)ce.getClosure());
        return this.getContainingChild((SyntaxElement)ce, children, position);
    }

    private SyntaxElement fixBoundaries(SyntaxElement e) {
        if (e.getStart() != 0 || e.getEnd() != 0) {
            return e;
        }
        if (e instanceof BooleanOperation) {
            BooleanOperation be = (BooleanOperation)e;
            SyntaxElement l = this.fixBoundaries((SyntaxElement)be.getLeft());
            SyntaxElement r = this.fixBoundaries((SyntaxElement)be.getRight());
            be.setLine(l.getLine());
            be.setStart(l.getStart());
            be.setEnd(r.getEnd());
        }
        return e;
    }

    private ISyntaxElement getContainingElementOfBooleanOperation(BooleanOperation be, int position) {
        this.fixBoundaries((SyntaxElement)be);
        ArrayList<SyntaxElement> children = new ArrayList<SyntaxElement>();
        children.add((SyntaxElement)be.getLeft());
        children.add((SyntaxElement)be.getRight());
        return this.getContainingChild((SyntaxElement)be, children, position);
    }

    private ISyntaxElement getContainingElementOfFeatureCall(FeatureCall fe, int position) {
        FeatureCall fc;
        if (!this.containsPosition((ISyntaxElement)fe, position)) {
            return null;
        }
        Stack<FeatureCall> fcStack = new Stack<FeatureCall>();
        FeatureCall e = fe;
        do {
            fc = e;
            fcStack.push(fc);
        } while ((e = fc.getTarget()) instanceof FeatureCall);
        FeatureCall fallback = (FeatureCall)fcStack.peek();
        while (!fcStack.isEmpty()) {
            FeatureCall fc2 = (FeatureCall)fcStack.pop();
            if (fc2 instanceof OperationCall) {
                ISyntaxElement result = this.getContainingElementOfOperationCall((OperationCall)fc2, position);
                if (result == null) continue;
                return result;
            }
            if (!(fc2 instanceof CollectionExpression) || !this.containsPosition((ISyntaxElement)fc2, position)) continue;
            return this.getContainingElement((SyntaxElement)((CollectionExpression)fc2).getClosure(), position);
        }
        return fallback;
    }

    private ISyntaxElement getContainingElementOfOperationCall(OperationCall oe, int position) {
        if (this.isFunctionCall(oe)) {
            return oe;
        }
        ArrayList<SyntaxElement> children = new ArrayList<SyntaxElement>(oe.getParamsAsList());
        return this.getContainingChild((SyntaxElement)oe, children, position);
    }

    private boolean isFunctionCall(OperationCall op) {
        char[] name = op.getName().toString().toCharArray();
        if (name.length == 0) {
            return false;
        }
        int i = 0;
        while (i < name.length) {
            if (i == 0 ? !Character.isJavaIdentifierStart(name[i]) : !Character.isJavaIdentifierPart(name[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private ISyntaxElement getContainingElementOfListLiteral(ListLiteral ll, int position) {
        ArrayList<SyntaxElement> children = new ArrayList<SyntaxElement>(ll.getElementsAsList());
        return this.getContainingChild((SyntaxElement)ll, children, position);
    }

    private ISyntaxElement getContainingElementOfSwitchExpression(SwitchExpression se, int position) {
        ArrayList<SyntaxElement> children = new ArrayList<SyntaxElement>();
        children.add((SyntaxElement)se.getSwitchExpr());
        for (Case caze : se.getCases()) {
            children.add((SyntaxElement)caze.getCondition());
            children.add((SyntaxElement)caze.getThenPart());
        }
        children.add((SyntaxElement)se.getDefaultExpr());
        return this.getContainingChild((SyntaxElement)se, children, position);
    }

    private ISyntaxElement getContainingElementOfChainExpression(ChainExpression ce, int position) {
        ArrayList<SyntaxElement> children = new ArrayList<SyntaxElement>();
        children.add((SyntaxElement)ce.getFirst());
        children.add((SyntaxElement)ce.getNext());
        return this.getContainingChild((SyntaxElement)ce, children, position);
    }

    protected ISyntaxElement getContainingRootElement(IResource resource, int position) {
        IXtendXpandResource file = this.getXtendXpandResource(resource);
        List<ISyntaxElement> elems = this.collectFirstLevelElements(file);
        for (ISyntaxElement elem : elems) {
            if (!this.containsPosition(elem, position)) continue;
            return elem;
        }
        return null;
    }

    private IXtendXpandResource getXtendXpandResource(IResource resource) {
        IXtendXpandProject project = Activator.getExtXptModelManager().findProject(resource.getProject().getFullPath());
        if (project != null) {
            IXtendXpandResource[] iXtendXpandResourceArray = project.getAllRegisteredResources();
            int n = iXtendXpandResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IXtendXpandResource res = iXtendXpandResourceArray[n2];
                if (resource.equals((Object)res.getUnderlyingStorage())) {
                    return res;
                }
                ++n2;
            }
        }
        return null;
    }

    protected List<ISyntaxElement> collectFirstLevelElements(IXtendXpandResource res) {
        ExtensionFile file = (ExtensionFile)res.getExtXptResource();
        ArrayList<ISyntaxElement> result = new ArrayList<ISyntaxElement>();
        result.addAll(file.getArounds());
        result.addAll(file.getChecks());
        for (ISyntaxElement ext : file.getExtensions()) {
            if (ext instanceof JavaExtensionStatement) continue;
            result.add(ext);
        }
        return result;
    }

    protected ISyntaxElement getBodyOfRootElement(ISyntaxElement elem) {
        if (elem instanceof ExpressionExtensionStatement) {
            return ((ExpressionExtensionStatement)elem).getExpression();
        }
        if (elem instanceof CreateExtensionStatement) {
            return ((CreateExtensionStatement)elem).getExpression();
        }
        if (elem instanceof Around) {
            return ((Around)elem).getExpression();
        }
        return null;
    }

    protected List<ISyntaxElement> getBody(ISyntaxElement exp) {
        IfExpression op;
        ISyntaxElement[] body = new ISyntaxElement[]{};
        if (exp instanceof IfExpression) {
            op = (IfExpression)exp;
            body = new ISyntaxElement[]{op.getCondition(), op.getThenPart(), op.getElsePart()};
        } else if (exp instanceof OperationCall) {
            op = (OperationCall)exp;
            ArrayList<Object> kids = new ArrayList<Object>();
            kids.add(op.getTarget());
            kids.add(new EvaluatedElementWrapper((ISyntaxElement)op));
            kids.addAll(op.getParamsAsList());
            body = kids.toArray(new ISyntaxElement[0]);
        } else if (exp instanceof FeatureCall) {
            body = new ISyntaxElement[]{((FeatureCall)exp).getTarget(), new EvaluatedElementWrapper(exp)};
        } else if (exp instanceof ExpressionExtensionStatement) {
            body = new ISyntaxElement[]{((ExpressionExtensionStatement)exp).getExpression()};
        } else if (exp instanceof CreateExtensionStatement) {
            body = new ISyntaxElement[]{((CreateExtensionStatement)exp).getExpression()};
        } else if (exp instanceof Around) {
            body = new ISyntaxElement[]{((Around)exp).getExpression()};
        } else if (exp instanceof BooleanOperation) {
            op = (BooleanOperation)exp;
            body = new ISyntaxElement[]{op.getLeft(), op.getRight()};
        } else if (exp instanceof SwitchExpression) {
            op = (SwitchExpression)exp;
            body = new ISyntaxElement[]{op.getSwitchExpr(), op.getDefaultExpr()};
        } else if (exp instanceof ChainExpression) {
            op = (ChainExpression)exp;
            body = new ISyntaxElement[]{op.getFirst(), op.getNext()};
        } else if (exp instanceof LetExpression) {
            op = (LetExpression)exp;
            body = new ISyntaxElement[]{op.getVarExpression(), op.getTargetExpression()};
        } else if (exp instanceof Cast) {
            op = (Cast)exp;
            body = new ISyntaxElement[]{op.getTarget()};
        }
        ArrayList<ISyntaxElement> result = new ArrayList<ISyntaxElement>();
        ISyntaxElement[] iSyntaxElementArray = body;
        int n = body.length;
        int n2 = 0;
        while (n2 < n) {
            ISyntaxElement element = iSyntaxElementArray[n2];
            if (element != null) {
                result.add(element);
            }
            ++n2;
        }
        return result;
    }

    protected boolean isValidReturnElement(ISyntaxElement se) {
        return se instanceof OperationCall || se instanceof ChainExpression;
    }

    public Image getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        Path path = new Path("/icons/extensionfile.gif");
        InputStream is = null;
        try {
            is = FileLocator.openStream((Bundle)XtendEditorPlugin.getDefault().getBundle(), (IPath)path, (boolean)false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (is != null) {
            ImageData iData = new ImageData(is);
            this.icon = new Image((Device)Display.getCurrent(), iData);
            return this.icon;
        }
        return null;
    }
}

