/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.parser;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.help.internal.webapp.utils.JSonHelper;

public class ParseElement {
    private Properties props;
    private ArrayList<ParseElement> children = new ArrayList();
    private ParseElement parent;

    public ParseElement(Properties props, ParseElement parent) {
        this.props = props;
        this.parent = parent;
    }

    public ParseElement(Properties props) {
        this(props, null);
    }

    public void updateParseElement(Properties props) {
        this.props = props;
    }

    public Properties getProps() {
        return this.props;
    }

    public ParseElement getParent() {
        return this.parent;
    }

    public String getProperty(String key) {
        return this.props != null ? this.props.getProperty(key) : "";
    }

    public String toString() {
        return this.props != null ? this.props.toString() : "";
    }

    public void addChild(ParseElement elem) {
        this.children.add(elem);
    }

    public int getChildrenCount() {
        return this.children.size();
    }

    public String toJSON(int level) {
        StringBuffer buff = new StringBuffer();
        String space = "   ";
        int s = 0;
        while (s < level) {
            space = String.valueOf(space) + "   ";
            ++s;
        }
        buff.append("\n" + space);
        buff.append("{");
        if (this.props != null) {
            Enumeration<Object> enumObj = this.props.keys();
            while (enumObj.hasMoreElements()) {
                String key = (String)enumObj.nextElement();
                String val = this.props.getProperty(key);
                buff.append("\n" + space + "   ");
                buff.append(JSonHelper.getQuotes(key));
                buff.append(":");
                try {
                    val = URLEncoder.encode(val, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                buff.append(JSonHelper.getQuotes(val));
                buff.append(",");
            }
        }
        if (this.children.size() <= 0) {
            int len = buff.length();
            char ch = buff.charAt(len - 1);
            if (ch == ',') {
                buff.deleteCharAt(len - 1);
                buff.append("\n" + space);
            }
        } else {
            buff.append("\n" + space + "   ");
            buff.append(JSonHelper.getQuotes("children"));
            buff.append(":");
            buff.append("[");
            int i = 0;
            while (i < this.children.size()) {
                if (i > 0) {
                    buff.append(",");
                }
                ParseElement element = this.children.get(i);
                buff.append(element.toJSON(level + 2));
                ++i;
            }
            buff.append("\n" + space + "   ");
            buff.append("]");
            buff.append("\n" + space);
        }
        buff.append("}");
        return buff.toString();
    }

    public String toJSON() {
        StringBuffer buff = new StringBuffer();
        if (this.props != null) {
            Enumeration<Object> enumObj = this.props.keys();
            while (enumObj.hasMoreElements()) {
                String key = (String)enumObj.nextElement();
                String val = this.props.getProperty(key);
                buff.append("\n   ");
                buff.append(JSonHelper.getQuotes(key));
                buff.append(":");
                try {
                    val = URLEncoder.encode(val, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                buff.append(JSonHelper.getQuotes(val));
                buff.append(",");
            }
        }
        if (this.children.size() <= 0) {
            int len = buff.length();
            char ch = buff.charAt(len - 1);
            if (ch == ',') {
                buff.deleteCharAt(len - 1);
                buff.append("\n");
            }
        } else {
            buff.append("\n   ");
            buff.append(JSonHelper.getQuotes("items"));
            buff.append(":");
            buff.append("[");
            int i = 0;
            while (i < this.children.size()) {
                if (i > 0) {
                    buff.append(",");
                }
                ParseElement child = this.children.get(i);
                buff.append(child.toJSON(1));
                ++i;
            }
            buff.append("\n   ");
            buff.append("]");
            buff.append("\n");
        }
        return buff.toString();
    }
}

