/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ejb.config.EjbTimerService;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvent;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
public class EJBTimerServiceConfigListener
implements ConfigListener {
    private static final Logger _logger = LogDomains.getLogger(EJBTimerServiceConfigListener.class, (String)"jakarta.enterprise.system.container.ejb");
    @Inject
    private EjbTimerService ejbt;

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        ArrayList<UnprocessedChangeEvent> unprocessedEvents = new ArrayList<UnprocessedChangeEvent>();
        for (PropertyChangeEvent event : events) {
            if (!(event.getSource() instanceof EjbTimerService)) continue;
            Object oldValue = event.getOldValue();
            Object newValue = event.getNewValue();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Got EjbTimerService change event ==== " + event.getSource() + " " + event.getPropertyName() + " " + oldValue + " " + newValue);
            }
            if (oldValue != null && oldValue.equals(newValue)) {
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, "Event " + event.getPropertyName() + " did not change existing value of " + oldValue);
                continue;
            }
            unprocessedEvents.add(new UnprocessedChangeEvent(event, "Restart required to reconfigure EJB Timer Service"));
        }
        return unprocessedEvents.size() > 0 ? new UnprocessedChangeEvents(unprocessedEvents) : null;
    }
}

