/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.validation.ConstraintViolationException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.resources.AbstractResource;
import org.glassfish.admin.rest.resources.TemplateRestResource;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.results.OptionsResult;
import org.glassfish.admin.rest.utils.ResourceUtil;
import org.glassfish.admin.rest.utils.Util;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.RestRedirect;
import org.glassfish.config.support.Create;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.TransactionFailure;

public abstract class TemplateListOfResource
extends AbstractResource {
    private static final Logger LOG = Logger.getLogger(TemplateListOfResource.class.getName());
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(TemplateListOfResource.class);
    @Context
    protected ServiceLocator injector;
    protected List<Dom> entity;
    protected Dom parent;
    protected String tagName;

    @GET
    @Produces(value={"text/html", "application/json;qs=0.5", "application/xml;qs=0.5"})
    public Response get(@QueryParam(value="expandLevel") @DefaultValue(value="1") int expandLevel) {
        return Response.ok().entity((Object)this.buildActionReportResult()).build();
    }

    @POST
    @Produces(value={"text/html", "application/json;qs=0.5", "application/xml;qs=0.5"})
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public Response createResource(HashMap<String, String> data) {
        if (data == null) {
            data = new HashMap();
        }
        try {
            if (data.containsKey("error")) {
                String errorMessage = localStrings.getLocalString("rest.request.parsing.error", "Unable to parse the input entity. Please check the syntax.");
                ActionReportResult arr = ResourceUtil.getActionReportResult(ActionReport.ExitCode.FAILURE, errorMessage, this.requestHeaders, this.uriInfo);
                return Response.status((int)400).entity((Object)arr).build();
            }
            ResourceUtil.purgeEmptyEntries(data);
            String commandName = this.getPostCommand();
            String resourceToCreate = this.uriInfo.getAbsolutePath() + "/";
            if (commandName == null) {
                ActionReportResult arr = ResourceUtil.getActionReportResult(ActionReport.ExitCode.FAILURE, "No CRUD Create possible.", this.requestHeaders, this.uriInfo);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)arr).build();
            }
            ResourceUtil.adjustParameters(data);
            resourceToCreate = data.containsKey("name") ? resourceToCreate + data.get("name") : resourceToCreate + data.get("DEFAULT");
            RestActionReporter actionReport = ResourceUtil.runCommand(commandName, data, this.getSubject());
            ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
            if (exitCode == ActionReport.ExitCode.FAILURE) {
                String errorMessage = actionReport.getMessage();
                LOG.log(Level.SEVERE, errorMessage, actionReport.getFailureCause());
                ActionReportResult result = ResourceUtil.getActionReportResult(actionReport, errorMessage, this.requestHeaders, this.uriInfo);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)result).build();
            }
            String successMessage = localStrings.getLocalString("rest.resource.create.message", "\"{0}\" created successfully.", new Object[]{resourceToCreate});
            ActionReportResult arr = ResourceUtil.getActionReportResult(actionReport, successMessage, this.requestHeaders, this.uriInfo);
            return Response.ok((Object)arr).build();
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    public Response post(FormDataMultiPart formData) {
        HashMap<String, String> data = TemplateRestResource.createDataBasedOnForm(formData);
        return this.createResource(data, data.get("name"));
    }

    @OPTIONS
    @Produces(value={"application/json", "text/html", "application/xml"})
    public Response options() {
        return Response.ok().entity((Object)this.buildActionReportResult()).build();
    }

    public void setEntity(List<Dom> p) {
        this.entity = p;
    }

    public List<Dom> getEntity() {
        return this.entity;
    }

    public void setParentAndTagName(Dom parent, String tagName) {
        this.parent = parent;
        this.tagName = tagName;
        if (parent != null) {
            this.entity = parent.nodeElements(tagName);
        }
    }

    public String getPostCommand() {
        ConfigModel.Property p = this.parent.model.getElement(this.tagName);
        if (p == null) {
            ConfigModel.Property childElement = this.parent.model.getElement("*");
            if (childElement != null) {
                ConfigModel.Node node = (ConfigModel.Node)childElement;
                ConfigModel childModel = node.getModel();
                List<ConfigModel> subChildConfigModels = ResourceUtil.getRealChildConfigModels(childModel, this.parent.document);
                for (ConfigModel subChildConfigModel : subChildConfigModels) {
                    if (!subChildConfigModel.getTagName().equals(this.tagName)) continue;
                    return ResourceUtil.getCommand(RestRedirect.OpType.POST, subChildConfigModel);
                }
            }
        } else {
            ConfigModel.Node n = (ConfigModel.Node)p;
            String command = ResourceUtil.getCommand(RestRedirect.OpType.POST, n.getModel());
            if (command != null) {
                return command;
            }
            Class<?> cbp = null;
            try {
                cbp = this.parent.model.classLoaderHolder.loadClass(this.parent.model.targetTypeName);
            }
            catch (MultiException e) {
                return null;
            }
            Create create = null;
            for (Method m : cbp.getMethods()) {
                ConfigModel.Property pp = this.parent.model.toProperty(m);
                if (pp == null || !pp.xmlName.equals(this.tagName) || !m.isAnnotationPresent(Create.class)) continue;
                create = m.getAnnotation(Create.class);
                break;
            }
            if (create != null) {
                return create.value();
            }
        }
        return null;
    }

    public String[][] getCommandResourcesPaths() {
        return new String[0][];
    }

    public static Class<? extends ConfigBeanProxy> getElementTypeByName(Dom parentDom, String elementName) throws ClassNotFoundException {
        DomDocument document = parentDom.document;
        ConfigModel.Property a = parentDom.model.getElement(elementName);
        if (a != null) {
            if (a.isLeaf()) {
                return null;
            }
            ConfigModel childModel = ((ConfigModel.Node)a).getModel();
            return childModel.classLoaderHolder.loadClass(childModel.targetTypeName);
        }
        ConfigModel model = document.getModelByElementName(elementName);
        if (model != null) {
            return model.classLoaderHolder.loadClass(model.targetTypeName);
        }
        return null;
    }

    protected ActionReportResult buildActionReportResult() {
        if (this.entity == null) {
            String errorMessage = localStrings.getLocalString("rest.resource.erromessage.noentity", "Resource not found.");
            return ResourceUtil.getActionReportResult(ActionReport.ExitCode.FAILURE, errorMessage, this.requestHeaders, this.uriInfo);
        }
        RestActionReporter ar = new RestActionReporter();
        String typeKey = Util.decode(Util.getName(this.uriInfo.getPath(), '/'));
        ar.setActionDescription(typeKey);
        OptionsResult optionsResult = new OptionsResult(Util.getResourceName(this.uriInfo));
        Map<String, MethodMetaData> mmd = this.getMethodMetaData();
        optionsResult.putMethodMetaData("GET", mmd.get("GET"));
        optionsResult.putMethodMetaData("POST", mmd.get("POST"));
        ResourceUtil.addMethodMetaData((ActionReport)ar, mmd);
        ar.getExtraProperties().put("childResources", ResourceUtil.getResourceLinks(this.getEntity(), this.uriInfo));
        ar.getExtraProperties().put("commands", ResourceUtil.getCommandLinks(this.getCommandResourcesPaths()));
        return new ActionReportResult(ar, optionsResult);
    }

    private Response createResource(HashMap<String, String> data, String resourceToCreate) {
        try {
            if (data.containsKey("error")) {
                String errorMessage = localStrings.getLocalString("rest.request.parsing.error", "Unable to parse the input entity. Please check the syntax.");
                return Response.status((int)400).entity((Object)ResourceUtil.getActionReportResult(ActionReport.ExitCode.FAILURE, errorMessage, this.requestHeaders, this.uriInfo)).build();
            }
            ResourceUtil.purgeEmptyEntries(data);
            String commandName = this.getPostCommand();
            ResourceUtil.defineDefaultParameters(data);
            if (resourceToCreate == null || ((String)resourceToCreate).equals("")) {
                String newResourceName = data.get("DEFAULT");
                if (newResourceName != null) {
                    if (newResourceName.contains("/")) {
                        newResourceName = Util.getName(newResourceName, '/');
                    } else if (newResourceName.contains("\\")) {
                        newResourceName = Util.getName(newResourceName, '\\');
                    }
                    resourceToCreate = this.uriInfo.getAbsolutePath() + "/" + newResourceName;
                }
            } else {
                resourceToCreate = this.uriInfo.getAbsolutePath() + "/" + (String)resourceToCreate;
            }
            if (null != commandName) {
                RestActionReporter actionReport = ResourceUtil.runCommand(commandName, data, this.getSubject());
                ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
                if (exitCode != ActionReport.ExitCode.FAILURE) {
                    String successMessage = localStrings.getLocalString("rest.resource.create.message", "\"{0}\" created successfully.", new Object[]{resourceToCreate});
                    return Response.ok().entity((Object)ResourceUtil.getActionReportResult(actionReport, successMessage, this.requestHeaders, this.uriInfo)).build();
                }
                String errorMessage = actionReport.getMessage();
                return Response.status((int)400).entity((Object)ResourceUtil.getActionReportResult(actionReport, errorMessage, this.requestHeaders, this.uriInfo)).build();
            }
            String message = localStrings.getLocalString("rest.resource.post.forbidden", "POST on \"{0}\" is forbidden.", new Object[]{resourceToCreate});
            return Response.status((int)403).entity((Object)ResourceUtil.getActionReportResult(ActionReport.ExitCode.FAILURE, message, this.requestHeaders, this.uriInfo)).build();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    private Map<String, MethodMetaData> getMethodMetaData() {
        TreeMap<String, MethodMetaData> map = new TreeMap<String, MethodMetaData>();
        map.put("GET", new MethodMetaData());
        String command = this.getPostCommand();
        if (command != null) {
            MethodMetaData postMethodMetaData = ResourceUtil.getMethodMetaData(command, this.locatorBridge.getRemoteLocator());
            if (Util.getResourceName(this.uriInfo).equals("Application")) {
                postMethodMetaData.setIsFileUploadOperation(true);
            }
            map.put("POST", postMethodMetaData);
        }
        return map;
    }

    private WebApplicationException handleException(Exception e) {
        TransactionFailure failure;
        LOG.log(Level.SEVERE, "Create resource call failed", e);
        if (e instanceof TransactionFailure && (failure = (TransactionFailure)((Object)e)).getCause() instanceof ConstraintViolationException) {
            return new WebApplicationException((Throwable)failure, Response.Status.BAD_REQUEST);
        }
        return new WebApplicationException((Throwable)e);
    }
}

