/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool;

import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.appserv.connectors.internal.spi.MCFLifecycleListener;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.allocator.ResourceAllocator;
import com.sun.enterprise.resource.listener.PoolLifeCycle;
import com.sun.enterprise.resource.pool.AbstractPoolManager;
import com.sun.enterprise.resource.pool.PoolStatus;
import com.sun.enterprise.resource.pool.ResourcePool;
import com.sun.enterprise.resource.pool.ResourcePoolFactoryImpl;
import com.sun.enterprise.resource.rm.LazyEnlistableResourceManagerImpl;
import com.sun.enterprise.resource.rm.NoTxResourceManagerImpl;
import com.sun.enterprise.resource.rm.ResourceManager;
import com.sun.enterprise.resource.rm.ResourceManagerImpl;
import com.sun.enterprise.resource.rm.SystemResourceManagerImpl;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.DissociatableManagedConnection;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.RetryableUnavailableException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.Transaction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.ComponentInvocationHandler;
import org.glassfish.api.invocation.InvocationException;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.jvnet.hk2.annotations.Service;

@Service
public class PoolManagerImpl
extends AbstractPoolManager
implements ComponentInvocationHandler {
    private static final Logger LOG = LogDomains.getLogger(PoolManagerImpl.class, (String)"jakarta.enterprise.resource.resourceadapter");
    private static final StringManager MESSAGES = StringManager.getManager(PoolManagerImpl.class);
    private final ConcurrentHashMap<PoolInfo, ResourcePool> poolTable = new ConcurrentHashMap();
    private final ResourceManager resourceManager = new ResourceManagerImpl();
    private final ResourceManager sysResourceManager = new SystemResourceManagerImpl();
    private final ResourceManager noTxResourceManager = new NoTxResourceManagerImpl();
    private final LazyEnlistableResourceManagerImpl lazyEnlistableResourceManager = new LazyEnlistableResourceManagerImpl();
    @Inject
    private Provider<ConnectorRuntime> connectorRuntimeProvider;
    private ConnectorRuntime runtime;
    private PoolLifeCycle listener;

    @Override
    public void createEmptyConnectionPool(PoolInfo poolInfo, ConnectorConstants.PoolType pooltype, Hashtable env) throws PoolingException {
        this.createAndInitPool(poolInfo, pooltype, env);
        ManagedConnectionFactory managedConnectionFactory = ConnectorRegistry.getInstance().getManagedConnectionFactory(poolInfo);
        if (managedConnectionFactory != null && managedConnectionFactory instanceof MCFLifecycleListener) {
            ((MCFLifecycleListener)managedConnectionFactory).mcfCreated();
        }
        if (this.listener != null) {
            try {
                this.listener.poolCreated(poolInfo);
            }
            catch (RuntimeException ex) {
                LOG.log(Level.SEVERE, "Listener " + this.listener + " failed for " + poolInfo, ex);
            }
        }
    }

    private ResourcePool createAndInitPool(PoolInfo poolInfo, ConnectorConstants.PoolType poolType, Hashtable env) throws PoolingException {
        ResourcePool pool = this.getPool(poolInfo);
        if (pool == null) {
            pool = ResourcePoolFactoryImpl.newInstance(poolInfo, poolType, env);
            this.addPool(pool);
            LOG.log(Level.INFO, "Created connection pool and added it to PoolManager: {0}", pool);
        }
        return pool;
    }

    @Override
    public Object getResource(ResourceSpec resourceSpec, ResourceAllocator resourceAllocator, ClientSecurityInfo clientSecurityInfo) throws PoolingException, RetryableUnavailableException {
        ResourceHandle resourceHandle;
        Transaction transaction = null;
        boolean transactional = resourceAllocator.isTransactional();
        if (transactional) {
            transaction = this.getResourceManager(resourceSpec).getTransaction();
        }
        if (!(resourceHandle = this.getResourceFromPool(resourceSpec, resourceAllocator, clientSecurityInfo, transaction)).supportsLazyAssociation()) {
            resourceSpec.setLazyAssociatable(false);
        }
        if (resourceSpec.isLazyAssociatable() && resourceSpec.getConnectionToAssociate() != null) {
            try {
                Object connection = resourceSpec.getConnectionToAssociate();
                ManagedConnection managedConnection = (ManagedConnection)resourceHandle.getResource();
                managedConnection.associateConnection(connection);
            }
            catch (ResourceException e) {
                this.putbackDirectToPool(resourceHandle, resourceSpec.getPoolInfo());
                throw new PoolingException(e.getMessage(), (Exception)((Object)e));
            }
        }
        if (!resourceHandle.supportsLazyEnlistment()) {
            resourceSpec.setLazyEnlistable(false);
        }
        resourceHandle.setResourceSpec(resourceSpec);
        try {
            if (resourceHandle.getResourceState().isUnenlisted()) {
                this.getResourceManager(resourceSpec).enlistResource(resourceHandle);
            }
        }
        catch (Exception e) {
            this.putbackDirectToPool(resourceHandle, resourceSpec.getPoolInfo());
            LOG.log(Level.WARNING, "poolmgr.err_enlisting_res_in_getconn", resourceSpec.getPoolInfo());
            LOG.fine("rm.enlistResource threw Exception. Returning resource to pool");
            throw new PoolingException(e);
        }
        return resourceHandle.getUserConnection();
    }

    @Override
    public void putbackDirectToPool(ResourceHandle resourceHandle, PoolInfo poolInfo) {
        ResourcePool pool;
        if (poolInfo != null && (pool = this.poolTable.get(poolInfo)) != null) {
            pool.resourceClosed(resourceHandle);
        }
    }

    @Override
    public ResourceHandle getResourceFromPool(ResourceSpec resourceSpec, ResourceAllocator resourceAllocator, ClientSecurityInfo info, Transaction transaction) throws PoolingException, RetryableUnavailableException {
        return this.getPool(resourceSpec.getPoolInfo()).getResource(resourceSpec, resourceAllocator, transaction);
    }

    @Override
    public boolean switchOnMatching(PoolInfo poolInfo) {
        ResourcePool pool = this.getPool(poolInfo);
        if (pool == null) {
            return false;
        }
        pool.switchOnMatching();
        return true;
    }

    private void addPool(ResourcePool pool) {
        LOG.log(Level.FINE, "Adding pool {0} to pooltable", pool.getPoolInfo());
        this.poolTable.put(pool.getPoolInfo(), pool);
    }

    private ResourceManager getResourceManager(ResourceSpec resourceSpec) {
        if (resourceSpec.isNonTx()) {
            LOG.fine("Returning noTxResourceManager");
            return this.noTxResourceManager;
        }
        if (resourceSpec.isPM()) {
            LOG.fine("Returning sysResourceManager");
            return this.sysResourceManager;
        }
        if (resourceSpec.isLazyEnlistable()) {
            LOG.fine("Returning LazyEnlistableResourceManager");
            return this.lazyEnlistableResourceManager;
        }
        LOG.fine("Returning resourceManager");
        return this.resourceManager;
    }

    private void addSyncListener(Transaction transaction) {
        try {
            transaction.registerSynchronization((Synchronization)new SynchronizationListener(transaction));
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, () -> "Error adding syncListener : " + (ex.getMessage() != null ? ex.getMessage() : " "));
        }
    }

    @Override
    public void transactionCompleted(Transaction transaction, int status) throws IllegalStateException {
        Set pools = ((JavaEETransaction)transaction).getAllParticipatingPools();
        for (PoolInfo poolInfo : pools) {
            ResourcePool pool = this.getPool(poolInfo);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("calling transactionCompleted on " + pool.getPoolInfo());
            }
            pool.transactionCompleted(transaction, status);
        }
    }

    public void resourceEnlisted(Transaction transaction, com.sun.appserv.connectors.internal.api.ResourceHandle internalHandle) throws IllegalStateException {
        ResourcePool pool;
        ResourceHandle resourceHandle = (ResourceHandle)internalHandle;
        PoolInfo poolInfo = resourceHandle.getResourceSpec().getPoolInfo();
        try {
            JavaEETransaction javaEETransaction = (JavaEETransaction)transaction;
            if (poolInfo != null && javaEETransaction.getResources((Object)poolInfo) == null) {
                this.addSyncListener(transaction);
            }
        }
        catch (ClassCastException e) {
            this.addSyncListener(transaction);
        }
        if (poolInfo != null && (pool = this.getPool(poolInfo)) != null) {
            pool.resourceEnlisted(transaction, resourceHandle);
        }
    }

    @Override
    public void lazyEnlist(ManagedConnection mc) throws ResourceException {
        this.lazyEnlistableResourceManager.lazyEnlist(mc);
    }

    private ConnectorRuntime getConnectorRuntime() {
        if (this.runtime == null) {
            this.runtime = (ConnectorRuntime)this.connectorRuntimeProvider.get();
        }
        return this.runtime;
    }

    public void registerResource(com.sun.appserv.connectors.internal.api.ResourceHandle internalHandle) throws PoolingException {
        ResourceHandle resourceHandle = (ResourceHandle)internalHandle;
        this.getResourceManager(resourceHandle.getResourceSpec()).registerResource(resourceHandle);
    }

    @Override
    public void registerPoolLifeCycleListener(PoolLifeCycle poolListener) {
        this.listener = poolListener;
    }

    @Override
    public void unregisterPoolLifeCycleListener() {
        this.listener = null;
    }

    public void unregisterResource(com.sun.appserv.connectors.internal.api.ResourceHandle internalResource, int xaresFlag) {
        ResourceHandle resourceHandle = (ResourceHandle)internalResource;
        this.getResourceManager(resourceHandle.getResourceSpec()).unregisterResource(resourceHandle, xaresFlag);
    }

    @Override
    public void resourceClosed(ResourceHandle resource) {
        this.getResourceManager(resource.getResourceSpec()).delistResource(resource, 0x4000000);
        this.putbackResourceToPool(resource, false);
    }

    @Override
    public void badResourceClosed(ResourceHandle resource) {
        this.getResourceManager(resource.getResourceSpec()).delistResource(resource, 0x4000000);
        this.putbackBadResourceToPool(resource);
    }

    @Override
    public void resourceErrorOccurred(ResourceHandle resource) {
        this.putbackResourceToPool(resource, true);
    }

    @Override
    public void resourceAbortOccurred(ResourceHandle resource) {
        this.getResourceManager(resource.getResourceSpec()).delistResource(resource, 0x4000000);
        this.putbackResourceToPool(resource, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putbackBadResourceToPool(ResourceHandle resourceHandle) {
        ResourcePool pool;
        PoolInfo poolInfo = resourceHandle.getResourceSpec().getPoolInfo();
        if (poolInfo != null && (pool = this.poolTable.get(poolInfo)) != null) {
            ResourcePool resourcePool = pool;
            synchronized (resourcePool) {
                pool.resourceClosed(resourceHandle);
                resourceHandle.setConnectionErrorOccurred();
                pool.resourceErrorOccurred(resourceHandle);
            }
        }
    }

    @Override
    public void putbackResourceToPool(ResourceHandle resourceHandle, boolean errorOccurred) {
        ResourcePool pool;
        PoolInfo poolInfo = resourceHandle.getResourceSpec().getPoolInfo();
        if (poolInfo != null && (pool = this.poolTable.get(poolInfo)) != null) {
            if (errorOccurred) {
                pool.resourceErrorOccurred(resourceHandle);
            } else {
                pool.resourceClosed(resourceHandle);
            }
        }
    }

    @Override
    public ResourcePool getPool(PoolInfo poolInfo) {
        if (poolInfo == null) {
            return null;
        }
        return this.poolTable.get(poolInfo);
    }

    @Override
    public void killPool(PoolInfo poolInfo) {
        LOG.log(Level.FINEST, "killPool(poolInfo={0})", poolInfo);
        ResourcePool pool = this.poolTable.get(poolInfo);
        if (pool != null) {
            ManagedConnectionFactory managedConnectionFactory;
            pool.cancelResizerTask();
            pool.emptyPool();
            LOG.log(Level.CONFIG, "Removing pool {0} from pooltable", pool);
            this.poolTable.remove(poolInfo);
            if (this.listener != null) {
                this.listener.poolDestroyed(poolInfo);
            }
            if ((managedConnectionFactory = ConnectorRegistry.getInstance().getManagedConnectionFactory(poolInfo)) != null && managedConnectionFactory instanceof MCFLifecycleListener) {
                ((MCFLifecycleListener)managedConnectionFactory).mcfDestroyed();
            }
        }
    }

    @Override
    public void killFreeConnectionsInPools() {
        LOG.fine("Killing all free connections in pools");
        for (ResourcePool pool : this.poolTable.values()) {
            PoolInfo poolInfo = pool.getPoolStatus().getPoolInfo();
            try {
                if (poolInfo == null) continue;
                ResourcePool poolToKill = this.poolTable.get(poolInfo);
                if (poolToKill != null) {
                    pool.emptyFreeConnectionsInPool();
                }
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("Now killing free connections in pool : " + poolInfo);
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("Error killing pool : " + poolInfo + " :: " + (e.getMessage() == null ? " " : e.getMessage()));
            }
        }
    }

    @Override
    public ResourceReferenceDescriptor getResourceReference(SimpleJndiName jndiName, SimpleJndiName logicalName) {
        Set descriptors = this.getConnectorRuntime().getResourceReferenceDescriptor();
        ArrayList<ResourceReferenceDescriptor> matchingRefs = new ArrayList<ResourceReferenceDescriptor>();
        if (descriptors != null) {
            for (ResourceReferenceDescriptor descriptor : descriptors) {
                SimpleJndiName name = descriptor.getJndiName();
                if (!jndiName.equals((Object)name)) continue;
                matchingRefs.add(descriptor);
            }
        }
        if (matchingRefs.size() == 1) {
            return (ResourceReferenceDescriptor)matchingRefs.get(0);
        }
        if (matchingRefs.size() > 1) {
            for (ResourceReferenceDescriptor resourceReferenceDescriptor : matchingRefs) {
                String refName = resourceReferenceDescriptor.getName();
                if (refName == null || logicalName == null || !PoolManagerImpl.getJavaName(new SimpleJndiName(refName)).equals((Object)PoolManagerImpl.getJavaName(logicalName))) continue;
                return resourceReferenceDescriptor;
            }
        }
        return null;
    }

    private static SimpleJndiName getJavaName(SimpleJndiName name) {
        if (name == null || name.hasJavaPrefix()) {
            return name;
        }
        return new SimpleJndiName("java:comp/env/" + name);
    }

    public void beforePreInvoke(ComponentInvocation.ComponentInvocationType invType, ComponentInvocation prevInv, ComponentInvocation newInv) throws InvocationException {
    }

    public void afterPreInvoke(ComponentInvocation.ComponentInvocationType invType, ComponentInvocation prevInv, ComponentInvocation curInv) throws InvocationException {
    }

    public void beforePostInvoke(ComponentInvocation.ComponentInvocationType invType, ComponentInvocation prevInv, ComponentInvocation curInv) throws InvocationException {
    }

    public void afterPostInvoke(ComponentInvocation.ComponentInvocationType invType, ComponentInvocation prevInv, ComponentInvocation curInv) throws InvocationException {
        this.postInvoke(curInv);
    }

    private void postInvoke(ComponentInvocation curInv) {
        ComponentInvocation invToUse = curInv;
        if (invToUse == null) {
            return;
        }
        Object comp = invToUse.getInstance();
        if (comp == null) {
            return;
        }
        this.handleLazilyAssociatedConnectionPools(comp, invToUse);
    }

    private void handleLazilyAssociatedConnectionPools(Object comp, ComponentInvocation invToUse) {
        ResourceHandle[] handles;
        JavaEETransactionManager jJavaEETransactionManager = this.getConnectorRuntime().getTransactionManager();
        List list = jJavaEETransactionManager.getExistingResourceList(comp, invToUse);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (ResourceHandle resourceHandle : handles = (ResourceHandle[])list.toArray(ResourceHandle[]::new)) {
            if (resourceHandle == null) {
                LOG.log(Level.WARNING, "lazy_association.lazy_association_resource_handle");
                continue;
            }
            ResourceSpec spec = resourceHandle.getResourceSpec();
            if (spec == null) {
                LOG.log(Level.WARNING, "lazy_association.lazy_association_resource_spec");
                continue;
            }
            if (!spec.isLazyAssociatable()) continue;
            if (resourceHandle.getResource() != null) {
                DissociatableManagedConnection managedConnection = (DissociatableManagedConnection)resourceHandle.getResource();
                if (resourceHandle.isEnlisted()) {
                    this.getResourceManager(spec).delistResource(resourceHandle, 0x4000000);
                }
                try {
                    managedConnection.dissociateConnections();
                    continue;
                }
                catch (ResourceException re) {
                    throw new InvocationException(re.getMessage(), (Throwable)re);
                }
                finally {
                    if (resourceHandle.getResourceState().isBusy()) {
                        this.putbackDirectToPool(resourceHandle, spec.getPoolInfo());
                    }
                }
            }
            LOG.log(Level.WARNING, "lazy_association.lazy_association_resource");
        }
    }

    @Override
    public void reconfigPoolProperties(ConnectorConnectionPool connectorConnectionPool) throws PoolingException {
        ResourcePool pool = this.getPool(connectorConnectionPool.getPoolInfo());
        if (pool != null) {
            pool.reconfigurePool(connectorConnectionPool);
        }
    }

    @Override
    public boolean flushConnectionPool(PoolInfo poolInfo) throws PoolingException {
        ResourcePool pool = this.getPool(poolInfo);
        if (pool == null) {
            throw new PoolingException("Flush Connection Pool did not happen as pool " + poolInfo + " is not initialized");
        }
        return pool.flushConnectionPool();
    }

    @Override
    public PoolStatus getPoolStatus(PoolInfo poolInfo) {
        ResourcePool pool = this.poolTable.get(poolInfo);
        if (pool != null) {
            return pool.getPoolStatus();
        }
        return null;
    }

    class SynchronizationListener
    implements Synchronization {
        private final Transaction transaction;

        SynchronizationListener(Transaction transaction) {
            this.transaction = transaction;
        }

        public void afterCompletion(int status) {
            try {
                PoolManagerImpl.this.transactionCompleted(this.transaction, status);
            }
            catch (Exception ex) {
                LOG.log(Level.FINE, () -> "Exception in afterCompletion : " + (ex.getMessage() == null ? " " : ex.getMessage()));
            }
        }

        public void beforeCompletion() {
        }
    }
}

