/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.login;

import com.sun.enterprise.security.auth.login.PasswordLoginModule;
import com.sun.enterprise.security.auth.realm.ldap.LDAPRealm;
import com.sun.enterprise.util.Utility;
import javax.security.auth.login.LoginException;

public class LDAPLoginModule
extends PasswordLoginModule {
    private LDAPRealm _ldapRealm;

    @Override
    protected void authenticate() throws LoginException {
        if (!(this._currentRealm instanceof LDAPRealm)) {
            String msg = sm.getString("ldaplm.badrealm");
            throw new LoginException(msg);
        }
        this._ldapRealm = (LDAPRealm)this._currentRealm;
        if (Utility.isEmpty((Object)this.getPasswordChar())) {
            throw new LoginException(sm.getString("ldaplm.emptypassword", (Object)this._username));
        }
        String mode = this._currentRealm.getProperty("mode");
        if (!"find-bind".equals(mode)) {
            throw new LoginException(sm.getString("ldaplm.badmode", (Object)mode));
        }
        String[] groups = this._ldapRealm.findAndBind(this._username, this.getPasswordChar());
        this.commitAuthentication(this._username, this.getPasswordChar(), this._currentRealm, groups);
    }
}

