/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaspic.config.factory;

import com.sun.jaspic.config.factory.EntryInfo;
import com.sun.jaspic.config.factory.RegistrationContextImpl;
import jakarta.security.auth.message.config.AuthConfigFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RegStoreFileParser {
    private static final Logger LOG = Logger.getLogger("com.sun.logging.enterprise.system.jaspic.config", "com.sun.jaspic.config.helper.LogMessages");
    private static final String SEP = ":";
    private static final String CON_ENTRY = "con-entry";
    private static final String REG_ENTRY = "reg-entry";
    private static final String REG_CTX = "reg-ctx";
    private static final String LAYER = "layer";
    private static final String APP_CTX = "app-ctx";
    private static final String DESCRIPTION = "description";
    private static final String[] INDENT = new String[]{"", "  ", "    "};
    private final File confFile;
    private List<EntryInfo> entries;
    private final List<EntryInfo> defaultEntries;

    public RegStoreFileParser(String pathParent, String pathChild, List<EntryInfo> defaultEntries) {
        this.confFile = new File(pathParent, pathChild);
        this.defaultEntries = defaultEntries == null ? new ArrayList() : defaultEntries;
        try {
            this.loadEntries();
        }
        catch (IOException | IllegalArgumentException e) {
            LOG.log(Level.WARNING, "jmac.factory_could_not_read", e);
        }
    }

    List<EntryInfo> getPersistedEntries() {
        return this.entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store(String className, AuthConfigFactory.RegistrationContext ctx, Map properties) {
        File file = this.confFile;
        synchronized (file) {
            if (this.checkAndAddToList(className, ctx, properties)) {
                try {
                    this.writeEntries();
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "jmac.factory_could_not_persist", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(AuthConfigFactory.RegistrationContext ctx) {
        File file = this.confFile;
        synchronized (file) {
            if (this.checkAndRemoveFromList(ctx)) {
                try {
                    this.writeEntries();
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "jmac.factory_could_not_persist", e);
                }
            }
        }
    }

    private boolean checkAndAddToList(String className, AuthConfigFactory.RegistrationContext ctx, Map props) {
        EntryInfo newEntry;
        EntryInfo entry;
        if (props != null && props.isEmpty()) {
            props = null;
        }
        if ((entry = this.getMatchingRegEntry(newEntry = new EntryInfo(className, (Map<String, String>)props, ctx))) == null) {
            this.entries.add(newEntry);
            return true;
        }
        if (entry.getRegContexts().contains(ctx)) {
            return false;
        }
        entry.getRegContexts().add(new RegistrationContextImpl(ctx));
        return true;
    }

    private boolean checkAndRemoveFromList(AuthConfigFactory.RegistrationContext target) {
        boolean retValue = false;
        try {
            ListIterator<EntryInfo> lit = this.entries.listIterator();
            while (lit.hasNext()) {
                EntryInfo info = lit.next();
                if (info.isConstructorEntry()) continue;
                Iterator<AuthConfigFactory.RegistrationContext> iter = info.getRegContexts().iterator();
                while (iter.hasNext()) {
                    AuthConfigFactory.RegistrationContext ctx = iter.next();
                    if (!ctx.equals(target)) continue;
                    iter.remove();
                    if (info.getRegContexts().isEmpty()) {
                        lit.remove();
                    }
                    retValue = true;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return retValue;
    }

    private EntryInfo getMatchingRegEntry(EntryInfo target) {
        for (EntryInfo info : this.entries) {
            if (info.isConstructorEntry() || !info.matchConstructors(target)) continue;
            return info;
        }
        return null;
    }

    private void writeEntries() throws IOException {
        if (this.confFile.exists() && !this.confFile.canWrite()) {
            LOG.log(Level.WARNING, "jmac.factory_cannot_write_file", this.confFile);
        }
        this.clearExistingFile();
        PrintWriter out = new PrintWriter(this.confFile);
        int indent = 0;
        for (EntryInfo info : this.entries) {
            if (info.isConstructorEntry()) {
                this.writeConEntry(info, out, indent);
                continue;
            }
            this.writeRegEntry(info, out, indent);
        }
        out.close();
    }

    private void writeConEntry(EntryInfo info, PrintWriter out, int i) {
        out.println(INDENT[i++] + "con-entry {");
        out.println(INDENT[i] + info.getClassName());
        Map<String, String> props = info.getProperties();
        if (props != null) {
            for (Map.Entry<String, String> val : props.entrySet()) {
                out.println(INDENT[i] + val.getKey() + SEP + val.getValue());
            }
        }
        out.println(INDENT[--i] + "}");
    }

    private void writeRegEntry(EntryInfo info, PrintWriter out, int i) {
        out.println(INDENT[i++] + "reg-entry {");
        if (info.getClassName() != null) {
            this.writeConEntry(info, out, i);
        }
        for (AuthConfigFactory.RegistrationContext ctx : info.getRegContexts()) {
            out.println(INDENT[i++] + "reg-ctx {");
            if (ctx.getMessageLayer() != null) {
                out.println(INDENT[i] + "layer:" + ctx.getMessageLayer());
            }
            if (ctx.getAppContext() != null) {
                out.println(INDENT[i] + "app-ctx:" + ctx.getAppContext());
            }
            if (ctx.getDescription() != null) {
                out.println(INDENT[i] + "description:" + ctx.getDescription());
            }
            out.println(INDENT[--i] + "}");
        }
        out.println(INDENT[--i] + "}");
    }

    private void clearExistingFile() throws IOException {
        boolean newCreation;
        boolean bl = newCreation = !this.confFile.exists();
        if (!newCreation && !this.confFile.delete()) {
            throw new IOException();
        }
        if (newCreation) {
            LOG.log(Level.INFO, "jmac.factory_creating_conf_file", this.confFile);
        }
        if (!this.confFile.createNewFile()) {
            throw new IOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadEntries() throws IOException {
        File file = this.confFile;
        synchronized (file) {
            this.entries = new ArrayList<EntryInfo>();
            if (this.confFile.exists()) {
                try (BufferedReader reader = new BufferedReader(new FileReader(this.confFile));){
                    String line = reader.readLine();
                    while (line != null) {
                        String trimLine = line.trim();
                        if (trimLine.startsWith(CON_ENTRY)) {
                            this.entries.add(this.readConEntry(reader));
                        } else if (trimLine.startsWith(REG_ENTRY)) {
                            this.entries.add(this.readRegEntry(reader));
                        }
                        line = reader.readLine();
                    }
                }
            } else {
                LOG.log(Level.FINER, "jmac.factory_file_not_found", this.confFile);
                for (EntryInfo e : this.defaultEntries) {
                    this.entries.add(new EntryInfo(e));
                }
            }
        }
    }

    private EntryInfo readConEntry(BufferedReader reader) throws IOException {
        String className = reader.readLine();
        if (className != null) {
            className = className.trim();
        }
        Map<String, String> properties = this.readProperties(reader);
        return new EntryInfo(className, properties);
    }

    private Map<String, String> readProperties(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line != null) {
            line = line.trim();
        }
        if ("}".equals(line)) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        while (!"}".equals(line)) {
            properties.put(line.substring(0, line.indexOf(SEP)), line.substring(line.indexOf(SEP) + 1, line.length()));
            line = reader.readLine();
            if (line == null) continue;
            line = line.trim();
        }
        return properties;
    }

    private EntryInfo readRegEntry(BufferedReader reader) throws IOException {
        String className = null;
        Map<String, String> properties = null;
        ArrayList<AuthConfigFactory.RegistrationContext> ctxs = new ArrayList<AuthConfigFactory.RegistrationContext>();
        String line = reader.readLine();
        if (line != null) {
            line = line.trim();
        }
        while (!"}".equals(line)) {
            if (line.startsWith(CON_ENTRY)) {
                EntryInfo conEntry = this.readConEntry(reader);
                className = conEntry.getClassName();
                properties = conEntry.getProperties();
            } else if (line.startsWith(REG_CTX)) {
                ctxs.add(this.readRegContext(reader));
            }
            if ((line = reader.readLine()) == null) continue;
            line = line.trim();
        }
        return new EntryInfo(className, properties, ctxs);
    }

    private AuthConfigFactory.RegistrationContext readRegContext(BufferedReader reader) throws IOException {
        String layer = null;
        String appCtx = null;
        String description = null;
        String line = reader.readLine();
        if (line != null) {
            line = line.trim();
        }
        while (!"}".equals(line)) {
            String value = line.substring(line.indexOf(SEP) + 1, line.length());
            if (line.startsWith(LAYER)) {
                layer = value;
            } else if (line.startsWith(APP_CTX)) {
                appCtx = value;
            } else if (line.startsWith(DESCRIPTION)) {
                description = value;
            }
            if ((line = reader.readLine()) == null) continue;
            line = line.trim();
        }
        return new RegistrationContextImpl(layer, appCtx, description, true);
    }
}

