/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment;

import com.sun.enterprise.deploy.shared.AbstractArchiveHandler;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.loader.ASURLClassLoader;
import com.sun.enterprise.security.perms.PermsArchiveDelegate;
import com.sun.enterprise.security.perms.SMGlobalPolicyUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveDetector;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.ejb.LogFacade;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.jvnet.hk2.annotations.Service;

@Service(name="ejb")
public class EjbJarHandler
extends AbstractArchiveHandler {
    private static final LocalStringManagerImpl I18N = new LocalStringManagerImpl(EjbJarHandler.class);
    private static final Logger LOG = LogFacade.getLogger();
    @Inject
    @Named(value="ejb")
    private ArchiveDetector detector;

    public String getArchiveType() {
        return "ejb";
    }

    public boolean handles(ReadableArchive archive) throws IOException {
        return this.detector.handles(archive);
    }

    public String getVersionIdentifier(ReadableArchive archive) {
        String versionIdentifier = null;
        try {
            GFEjbJarXMLParser gfXMLParser = new GFEjbJarXMLParser(archive);
            versionIdentifier = gfXMLParser.extractVersionIdentifierValue(archive);
        }
        catch (XMLStreamException e) {
            LOG.log(Level.SEVERE, e.getMessage());
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage());
        }
        return versionIdentifier;
    }

    public ClassLoader getClassLoader(ClassLoader parent, DeploymentContext context) {
        PrivilegedAction<ASURLClassLoader> action = () -> new ASURLClassLoader(parent);
        ASURLClassLoader cloader = AccessController.doPrivileged(action);
        try {
            SunEjbJarXMLParser sunEjbJarXMLParser;
            GFEjbJarXMLParser gfEjbJarXMLParser;
            String compatProp = context.getAppProps().getProperty("compatibility");
            if (compatProp == null && (compatProp = (gfEjbJarXMLParser = new GFEjbJarXMLParser(context.getSource())).getCompatibilityValue()) != null) {
                context.getAppProps().put("compatibility", compatProp);
            }
            if (compatProp == null && (compatProp = (sunEjbJarXMLParser = new SunEjbJarXMLParser(context.getSourceDir())).getCompatibilityValue()) != null) {
                context.getAppProps().put("compatibility", compatProp);
            }
            if (compatProp != null && compatProp.equals("v2")) {
                List moduleRootLibraries = ASClassLoaderUtil.getURLsAsList(null, (File[])new File[]{context.getSourceDir()}, (boolean)true);
                Iterator iterator = moduleRootLibraries.iterator();
                while (iterator.hasNext()) {
                    URL url = (URL)iterator.next();
                    cloader.addURL(url);
                }
            }
            cloader.addURL(context.getSource().getURI().toURL());
            cloader.addURL(context.getScratchDir("ejb").toURI().toURL());
            for (URL url : this.getManifestLibraries(context)) {
                cloader.addURL(url);
            }
            try {
                DeploymentContext dc = context;
                ASURLClassLoader cl = cloader;
                AccessController.doPrivileged(new PermsArchiveDelegate.SetPermissionsAction(SMGlobalPolicyUtil.CommponentType.ejb, dc, (ClassLoader)cl));
            }
            catch (PrivilegedActionException e) {
                throw new SecurityException(e.getException());
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage());
            throw new RuntimeException(e);
        }
        return cloader;
    }

    private static class GFEjbJarXMLParser {
        private XMLStreamReader parser;
        private String compatValue;

        GFEjbJarXMLParser(ReadableArchive archive) throws FileNotFoundException, IOException {
            InputStream input = null;
            File runtimeAltDDFile = (File)archive.getArchiveMetaData("runtimealtdd", File.class);
            if (runtimeAltDDFile != null && runtimeAltDDFile.getPath().indexOf("glassfish-") != -1 && runtimeAltDDFile.exists() && runtimeAltDDFile.isFile()) {
                DOLUtils.validateRuntimeAltDDPath((String)runtimeAltDDFile.getPath());
                input = new FileInputStream(runtimeAltDDFile);
            } else {
                input = archive.getEntry("META-INF/glassfish-ejb-jar.xml");
            }
            if (input != null) {
                try {
                    this.read(input);
                }
                catch (Throwable t) {
                    String msg = I18N.getLocalString("ejb.deployment.exception_parsing_glassfishejbjarxml", "Error in parsing glassfish-ejb-jar.xml for archive [{0}]: {1}", new Object[]{archive.getURI(), t.getMessage()});
                    throw new RuntimeException(msg);
                }
                finally {
                    if (this.parser != null) {
                        try {
                            this.parser.close();
                        }
                        catch (Exception exception) {}
                    }
                    try {
                        input.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String extractVersionIdentifierValue(ReadableArchive archive) throws XMLStreamException, IOException {
            InputStream input = null;
            String versionIdentifierValue = null;
            String rootElement = null;
            try {
                File runtimeAltDDFile = (File)archive.getArchiveMetaData("runtimealtdd", File.class);
                if (runtimeAltDDFile != null && runtimeAltDDFile.getPath().indexOf("glassfish-") != -1 && runtimeAltDDFile.exists() && runtimeAltDDFile.isFile()) {
                    DOLUtils.validateRuntimeAltDDPath((String)runtimeAltDDFile.getPath());
                    input = new FileInputStream(runtimeAltDDFile);
                } else {
                    input = archive.getEntry("META-INF/glassfish-ejb-jar.xml");
                }
                rootElement = "glassfish-ejb-jar";
                if (input != null) {
                    this.parser = EjbJarHandler.getXMLInputFactory().createXMLStreamReader(input);
                    int event = 0;
                    this.skipRoot(rootElement);
                    while (this.parser.hasNext() && (event = this.parser.next()) != 8) {
                        if (event != 1) continue;
                        String name = this.parser.getLocalName();
                        if ("version-identifier".equals(name)) {
                            versionIdentifierValue = this.parser.getElementText();
                            continue;
                        }
                        this.skipSubTree(name);
                    }
                }
            }
            finally {
                if (this.parser != null) {
                    try {
                        this.parser.close();
                    }
                    catch (Exception exception) {}
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return versionIdentifierValue;
        }

        private void read(InputStream input) throws XMLStreamException {
            this.parser = EjbJarHandler.getXMLInputFactory().createXMLStreamReader(input);
            int event = 0;
            boolean done = false;
            this.skipRoot("glassfish-ejb-jar");
            while (!done && (event = this.parser.next()) != 8) {
                if (event != 1) continue;
                String name = this.parser.getLocalName();
                if ("compatibility".equals(name)) {
                    this.compatValue = this.parser.getElementText();
                    done = true;
                    continue;
                }
                this.skipSubTree(name);
            }
        }

        private void skipRoot(String name) throws XMLStreamException {
            int event;
            while ((event = this.parser.next()) != 1) {
            }
            if (!name.equals(this.parser.getLocalName())) {
                throw new XMLStreamException();
            }
        }

        private void skipSubTree(String name) throws XMLStreamException {
            int event;
            do {
                if ((event = this.parser.next()) != 8) continue;
                throw new XMLStreamException();
            } while (event != 2 || !name.equals(this.parser.getLocalName()));
        }

        String getCompatibilityValue() {
            return this.compatValue;
        }
    }

    private static class SunEjbJarXMLParser {
        private XMLStreamReader parser;
        private String compatValue;

        SunEjbJarXMLParser(File baseDir) throws FileNotFoundException {
            FileInputStream input = null;
            File f = new File(baseDir, "META-INF/sun-ejb-jar.xml");
            if (f.exists()) {
                input = new FileInputStream(f);
                try {
                    this.read(input);
                }
                catch (Throwable t) {
                    String msg = I18N.getLocalString("ejb.deployment.exception_parsing_sunejbjarxml", "Error in parsing sun-ejb-jar.xml for archive [{0}]: {1}", new Object[]{baseDir, t.getMessage()});
                    throw new RuntimeException(msg);
                }
                finally {
                    if (this.parser != null) {
                        try {
                            this.parser.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (input != null) {
                        try {
                            ((InputStream)input).close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }

        private void read(InputStream input) throws XMLStreamException {
            this.parser = EjbJarHandler.getXMLInputFactory().createXMLStreamReader(input);
            int event = 0;
            boolean done = false;
            this.skipRoot("sun-ejb-jar");
            while (!done && (event = this.parser.next()) != 8) {
                if (event != 1) continue;
                String name = this.parser.getLocalName();
                if ("compatibility".equals(name)) {
                    this.compatValue = this.parser.getElementText();
                    done = true;
                    continue;
                }
                this.skipSubTree(name);
            }
        }

        private void skipRoot(String name) throws XMLStreamException {
            int event;
            while ((event = this.parser.next()) != 1) {
            }
            if (!name.equals(this.parser.getLocalName())) {
                throw new XMLStreamException();
            }
        }

        private void skipSubTree(String name) throws XMLStreamException {
            int event;
            do {
                if ((event = this.parser.next()) != 8) continue;
                throw new XMLStreamException();
            } while (event != 2 || !name.equals(this.parser.getLocalName()));
        }

        String getCompatibilityValue() {
            return this.compatValue;
        }
    }
}

