/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.security.PrincipalGroupFactory;
import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.security.auth.login.LoginCallbackHandler;
import com.sun.enterprise.security.auth.login.common.PasswordCredential;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.util.i18n.StringManager;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.glassfish.internal.api.Globals;
import org.glassfish.security.common.Group;
import org.glassfish.security.common.UserNameAndPassword;
import org.glassfish.security.common.UserPrincipal;

public abstract class BasePasswordLoginModule
implements LoginModule {
    protected Subject _subject;
    protected Map _sharedState;
    protected Map _options;
    protected String _username;
    @Deprecated
    protected String _password;
    protected char[] _passwd;
    protected Realm _currentRealm;
    protected boolean _succeeded = false;
    protected boolean _commitSucceeded = false;
    protected UserPrincipal _userPrincipal;
    protected String[] _groupsList = null;
    protected static final Logger _logger = SecurityLoggerInfo.getLogger();
    protected static final StringManager sm = StringManager.getManager(LoginCallbackHandler.class);
    private LoginModule userDefinedLoginModule;

    public final void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this._subject = subject;
        this._sharedState = sharedState;
        this._options = options;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Login module initialized: " + this.getClass().toString());
        }
    }

    @Override
    public final boolean login() throws LoginException {
        this.extractCredentials();
        this.authenticateUser();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "JAAS login complete.");
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this._succeeded) {
            return false;
        }
        String realm_name = this._currentRealm.getName();
        PrincipalGroupFactory factory = (PrincipalGroupFactory)Globals.getDefaultHabitat().getService(PrincipalGroupFactory.class, new Annotation[0]);
        this._userPrincipal = factory == null ? new UserNameAndPassword(this.getUsername()) : factory.getPrincipalInstance(this.getUsername(), realm_name);
        Set<Principal> principalSet = this._subject.getPrincipals();
        if (!principalSet.contains(this._userPrincipal)) {
            principalSet.add((Principal)this._userPrincipal);
        }
        for (int i = 0; i < this._groupsList.length; ++i) {
            if (this._groupsList[i] == null) continue;
            Group g = factory != null ? factory.getGroupInstance(this._groupsList[i], realm_name) : new Group(this._groupsList[i]);
            if (!principalSet.contains(g)) {
                principalSet.add((Principal)g);
            }
            this._groupsList[i] = null;
        }
        this._groupsList = null;
        this.setUsername(null);
        this.setPassword(null);
        this.setPasswordChar(null);
        this._commitSucceeded = true;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "JAAS authentication committed.");
        }
        return true;
    }

    @Override
    public final boolean abort() throws LoginException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "JAAS authentication aborted.");
        }
        if (!this._succeeded) {
            return false;
        }
        if (this._succeeded && !this._commitSucceeded) {
            this._succeeded = false;
            this.setUsername(null);
            this.setPassword(null);
            this.setPasswordChar(null);
            this._userPrincipal = null;
            for (int i = 0; i < this._groupsList.length; ++i) {
                this._groupsList[i] = null;
            }
            this._groupsList = null;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public final boolean logout() throws LoginException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "JAAS logout for: " + this._subject.toString());
        }
        this._subject.getPrincipals().clear();
        this._subject.getPublicCredentials().clear();
        this._subject.getPrivateCredentials().clear();
        this._succeeded = false;
        this._commitSucceeded = false;
        this.setUsername(null);
        this.setPassword(null);
        this._userPrincipal = null;
        if (this._groupsList != null) {
            for (int i = 0; i < this._groupsList.length; ++i) {
                this._groupsList[i] = null;
            }
            this._groupsList = null;
        }
        return true;
    }

    public final void commitUserAuthentication(String[] groups) {
        String[] groupsListCopy = groups == null ? null : Arrays.copyOf(groups, groups.length);
        this._groupsList = groupsListCopy;
        this._succeeded = true;
    }

    public Subject getSubject() {
        return this._subject;
    }

    public final void extractCredentials() throws LoginException {
        if (this._subject == null) {
            String msg = sm.getString("pwdlm.noinfo");
            _logger.log(Level.SEVERE, msg);
            throw new LoginException(msg);
        }
        PasswordCredential pwdCred = null;
        try {
            Iterator<Object> i = this._subject.getPrivateCredentials().iterator();
            while (i.hasNext() && pwdCred == null) {
                Object privCred = i.next();
                if (!(privCred instanceof PasswordCredential)) continue;
                pwdCred = (PasswordCredential)privCred;
            }
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "NCLS-SECURITY-01104", e.toString());
        }
        if (pwdCred == null) {
            _logger.log(Level.SEVERE, "NCLS-SECURITY-01105");
            String msg = sm.getString("pwdlm.nocreds");
            throw new LoginException(msg);
        }
        String realm = null;
        try {
            realm = pwdCred.getRealm();
            this._currentRealm = Realm.getInstance(realm);
        }
        catch (Exception e) {
            String msg = sm.getString("pwdlm.norealm", (Object)realm);
            _logger.log(Level.SEVERE, msg);
            throw new LoginException(msg);
        }
        this.setUsername(pwdCred.getUser());
        this.setPasswordChar(pwdCred.getPassword());
        this.setPassword(new String(pwdCred.getPassword()));
    }

    protected abstract void authenticateUser() throws LoginException;

    public void setLoginModuleForAuthentication(LoginModule userDefinedLoginModule) {
        this.userDefinedLoginModule = userDefinedLoginModule;
    }

    public String getUsername() {
        return this._username;
    }

    private void setUsername(String username) {
        this._username = username;
    }

    @Deprecated
    public String getPassword() {
        return this._password;
    }

    @Deprecated
    private void setPassword(String password) {
        this._password = password;
    }

    public char[] getPasswordChar() {
        return Arrays.copyOf(this._passwd, this._passwd.length);
    }

    private void setPasswordChar(char[] password) {
        this._passwd = password;
    }

    public Realm getCurrentRealm() {
        return this._currentRealm;
    }

    public boolean isSucceeded() {
        return this._succeeded;
    }

    public boolean isCommitSucceeded() {
        return this._commitSucceeded;
    }

    public UserPrincipal getUserPrincipal() {
        return this._userPrincipal;
    }

    public String[] getGroupsList() {
        return Arrays.copyOf(this._groupsList, this._groupsList.length);
    }
}

