/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jmac.config;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.security.jmac.config.ConfigHelper;
import com.sun.enterprise.security.jmac.config.GFServerConfigProvider;
import com.sun.enterprise.security.jmac.config.HandlerContext;
import com.sun.enterprise.security.web.integration.WebSecurityManager;
import jakarta.security.auth.message.config.AuthConfigProvider;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;

public class HttpServletHelper
extends ConfigHelper {
    private String realmName = null;
    public static final String AUTH_TYPE = "jakarta.servlet.http.authType";

    public HttpServletHelper(String appContext, Map map, CallbackHandler cbh, String realmName, boolean isSystemApp, String defaultSystemProviderID) {
        WebBundleDescriptor webBundle = null;
        if (map != null && (webBundle = (WebBundleDescriptor)map.get("WEB_BUNDLE")) != null) {
            LoginConfiguration loginConfig = webBundle.getLoginConfiguration();
            this.realmName = loginConfig != null && "CLIENT-CERT".equals(loginConfig.getAuthenticationMethod()) ? "certificate" : realmName;
        }
        this.init("HttpServlet", appContext, map, cbh);
        if (webBundle != null) {
            String policyContextId = WebSecurityManager.getContextID(webBundle);
            map.put("jakarta.security.jacc.PolicyContext", policyContextId);
            SunWebApp sunWebApp = webBundle.getSunDescriptor();
            String pid = sunWebApp != null ? sunWebApp.getAttributeValue("HttpServletSecurityProvider") : null;
            boolean nullConfigProvider = false;
            if (!(!isSystemApp || pid != null && pid.length() != 0 || (pid = defaultSystemProviderID) != null && pid.length() != 0)) {
                nullConfigProvider = true;
            }
            if ((pid != null && pid.length() > 0 || nullConfigProvider) && !this.hasExactMatchAuthProvider()) {
                GFServerConfigProvider configProvider = nullConfigProvider ? null : new GFServerConfigProvider(new HashMap<String, String>(), null);
                String jmacProviderRegisID = factory.registerConfigProvider((AuthConfigProvider)configProvider, "HttpServlet", appContext, "GlassFish provider: HttpServlet:" + appContext);
                this.setJmacProviderRegisID(jmacProviderRegisID);
            }
        }
    }

    @Override
    protected HandlerContext getHandlerContext(Map map) {
        final String fRealmName = this.realmName;
        return new HandlerContext(){

            @Override
            public String getRealmName() {
                return fRealmName;
            }
        };
    }
}

