/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction.startup;

import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.enterprise.transaction.config.TransactionService;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.api.naming.NamingObjectProxy;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service
@RunLevel(value=10)
public class TransactionLifecycleService
implements PostConstruct,
PreDestroy {
    private static final Logger LOG = LogDomains.getLogger(TransactionLifecycleService.class, (String)"jakarta.enterprise.resource.jta", (boolean)false);
    private static final SimpleJndiName USER_TX_NO_JAVA_COMP = new SimpleJndiName("UserTransaction");
    @Inject
    ServiceLocator loader;
    @Inject
    Events events;
    @Inject
    @Optional
    GlassfishNamingManager nm;
    private JavaEETransactionManager tm;

    public void postConstruct() {
        EventListener glassfishEventListener = new EventListener(){

            public void event(EventListener.Event event) {
                if (event.is(EventTypes.SERVER_READY)) {
                    LOG.fine("TM LIFECYCLE SERVICE - ON READY");
                    TransactionLifecycleService.this.onReady();
                } else if (event.is(EventTypes.PREPARE_SHUTDOWN)) {
                    LOG.fine("TM LIFECYCLE SERVICE - ON SHUTDOWN");
                    TransactionLifecycleService.this.onShutdown();
                }
            }
        };
        this.events.register(glassfishEventListener);
        if (this.nm != null) {
            try {
                this.nm.publishObject(USER_TX_NO_JAVA_COMP, (Object)new NamingObjectProxy.InitializationNamingObjectProxy(){

                    public Object create(Context ic) throws NamingException {
                        ActiveDescriptor descriptor = TransactionLifecycleService.this.loader.getBestDescriptor((Filter)BuilderHelper.createContractFilter((String)"jakarta.transaction.UserTransaction"));
                        if (descriptor == null) {
                            return null;
                        }
                        return TransactionLifecycleService.this.loader.getServiceHandle(descriptor).getService();
                    }
                }, false);
            }
            catch (NamingException e) {
                LOG.log(Level.SEVERE, "Can't bind \"UserTransaction\" in JNDI", e);
            }
        }
    }

    public void preDestroy() {
        if (this.nm != null) {
            try {
                this.nm.unpublishObject(USER_TX_NO_JAVA_COMP);
            }
            catch (NamingException e) {
                LOG.log(Level.SEVERE, "Can't unbind \"UserTransaction\" in JNDI", e);
            }
        }
    }

    public void onReady() {
        boolean isAutomaticRecovery;
        LOG.fine("ON TM READY STARTED");
        TransactionService txnService = (TransactionService)this.loader.getService(TransactionService.class, new Annotation[0]);
        if (txnService != null && (isAutomaticRecovery = Boolean.parseBoolean(txnService.getAutomaticRecovery()))) {
            LOG.fine("ON TM RECOVERY START");
            this.tm = (JavaEETransactionManager)this.loader.getService(JavaEETransactionManager.class, new Annotation[0]);
            this.tm.initRecovery(false);
            LOG.fine("ON TM RECOVERY END");
        }
        LOG.fine("ON TM READY FINISHED");
    }

    public void onShutdown() {
        ServiceHandle handle;
        if (this.tm == null && (handle = this.loader.getServiceHandle(JavaEETransactionManager.class, new Annotation[0])) != null && handle.isActive()) {
            this.tm = (JavaEETransactionManager)handle.getService();
        }
        if (this.tm != null) {
            LOG.fine("ON TM SHUTDOWN STARTED");
            this.tm.shutdown();
            LOG.fine("ON TM SHUTDOWN FINISHED");
        }
    }
}

