/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.connector;

import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.deployment.GenericSniffer;
import org.glassfish.weld.connector.WeldUtils;
import org.jvnet.hk2.annotations.Service;

@Service(name="weld")
@Singleton
public class WeldSniffer
extends GenericSniffer {
    private static final String[] containers = new String[]{"org.glassfish.weld.WeldContainer"};
    private static final Logger logger = Logger.getLogger(WeldSniffer.class.getName());

    public WeldSniffer() {
        super("weld", null, null);
    }

    public boolean supportsArchiveType(ArchiveType archiveType) {
        return archiveType.toString().equals("war") || archiveType.toString().equals("ejb") || archiveType.toString().equals("rar");
    }

    public boolean handles(DeploymentContext context) {
        ArchiveType archiveType = this.habitat.getService(ArchiveType.class, context.getArchiveHandler().getArchiveType(), new Annotation[0]);
        if (archiveType != null && !this.supportsArchiveType(archiveType)) {
            return false;
        }
        ReadableArchive archive = context.getSource();
        boolean isWeldArchive = false;
        if (this.isEntryPresent(archive, "WEB-INF")) {
            boolean bl = isWeldArchive = this.isArchiveCDIEnabled(context, archive, "WEB-INF/beans.xml") || this.isArchiveCDIEnabled(context, archive, "WEB-INF/classes/META-INF/beans.xml");
            if (!isWeldArchive && this.isEntryPresent(archive, "WEB-INF/lib")) {
                isWeldArchive = this.scanLibDir(context, archive, "WEB-INF/lib");
            }
            if (!isWeldArchive) {
                isWeldArchive = WeldUtils.hasExtension(archive);
            }
        }
        String archiveName = archive.getName();
        if (!isWeldArchive && archiveName != null && archiveName.endsWith("_jar")) {
            isWeldArchive = this.isArchiveCDIEnabled(context, archive, "META-INF/beans.xml");
        }
        if (!isWeldArchive && this.isArchiveCDIEnabled(context, archive, "META-INF/beans.xml")) {
            isWeldArchive = true;
        }
        if (!isWeldArchive && archiveName != null && archiveName.endsWith("_rar") && !(isWeldArchive = this.isArchiveCDIEnabled(context, archive, "META-INF/beans.xml"))) {
            isWeldArchive = this.scanLibDir(context, archive, "");
        }
        return isWeldArchive;
    }

    public String[] getContainersNames() {
        return containers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAnnotationNames(DeploymentContext context) {
        InputStream beansXmlInputStream = WeldUtils.getBeansXmlInputStream(context);
        if (beansXmlInputStream != null) {
            try {
                String beanDiscoveryMode = WeldUtils.getBeanDiscoveryMode(beansXmlInputStream);
                if (beanDiscoveryMode.equals("none")) {
                    String[] stringArray = null;
                    return stringArray;
                }
            }
            finally {
                try {
                    beansXmlInputStream.close();
                }
                catch (IOException notignore) {
                    logger.log(Level.FINE, "", notignore);
                }
            }
        }
        if (!WeldUtils.isValidBdaBasedOnExtensionAndBeansXml(context.getSource())) {
            return null;
        }
        return WeldUtils.isImplicitBeanDiscoveryEnabled(context) ? WeldUtils.getCDIEnablingAnnotations(context) : null;
    }

    private boolean scanLibDir(DeploymentContext context, ReadableArchive archive, String libLocation) {
        boolean entryPresent = false;
        if (libLocation != null) {
            Enumeration<String> entries = archive.entries(libLocation);
            while (entries.hasMoreElements() && !entryPresent) {
                String entryName = entries.nextElement();
                if (!entryName.endsWith(".jar") || entryName.indexOf(47, libLocation.length() + 1) != -1) continue;
                try (ReadableArchive jarInLib = archive.getSubArchive(entryName);){
                    entryPresent = this.isArchiveCDIEnabled(context, jarInLib, "META-INF/beans.xml");
                }
                catch (IOException e) {
                    logger.log(Level.FINE, "", e);
                }
            }
        }
        return entryPresent;
    }

    protected boolean isEntryPresent(ReadableArchive archive, String entry) {
        boolean entryPresent = false;
        try {
            entryPresent = archive.exists(entry);
        }
        catch (IOException e) {
            logger.log(Level.FINE, "", e);
        }
        return entryPresent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isArchiveCDIEnabled(DeploymentContext context, ReadableArchive archive, String relativeBeansXmlPath) {
        InputStream beansXmlInputStream;
        String beanDiscoveryMode;
        block17: {
            beanDiscoveryMode = null;
            beansXmlInputStream = null;
            try {
                beansXmlInputStream = archive.getEntry(relativeBeansXmlPath);
                if (beansXmlInputStream == null) break block17;
                try {
                    beanDiscoveryMode = WeldUtils.getBeanDiscoveryMode(beansXmlInputStream);
                }
                finally {
                    try {
                        beansXmlInputStream.close();
                    }
                    catch (Exception notignore) {
                        logger.log(Level.FINE, "", notignore);
                    }
                }
            }
            catch (IOException notignore) {
                // empty catch block
            }
        }
        if (beansXmlInputStream == null) {
            try {
                return WeldUtils.isImplicitBeanArchive(context, archive);
            }
            catch (IOException e) {
                return false;
            }
        }
        if (beanDiscoveryMode == null) {
            return true;
        }
        if (beanDiscoveryMode.equals("annotated") || beanDiscoveryMode.equals("all")) {
            return true;
        }
        if (beanDiscoveryMode.equals("none")) {
            return false;
        }
        try {
            return WeldUtils.isImplicitBeanArchive(context, archive);
        }
        catch (IOException e) {
            return false;
        }
    }
}

