/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.descriptor.JspConfigDescriptor;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.Set;
import org.apache.catalina.Globals;
import org.apache.catalina.core.ApplicationContext;

public final class ApplicationContextFacade
implements ServletContext {
    private final ApplicationContext context;

    public ApplicationContextFacade(ApplicationContext context) {
        this.context = context;
    }

    @Override
    public String getContextPath() {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<String> action = this.context::getContextPath;
            return AccessController.doPrivileged(action);
        }
        return this.context.getContextPath();
    }

    @Override
    public ServletContext getContext(String uripath) {
        ServletContext theContext;
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<ServletContext> action = () -> this.context.getContext(uripath);
            theContext = AccessController.doPrivileged(action);
        } else {
            theContext = this.context.getContext(uripath);
        }
        if (theContext instanceof ApplicationContext) {
            return ((ApplicationContext)theContext).getFacade();
        }
        return theContext;
    }

    @Override
    public int getMajorVersion() {
        return this.context.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return this.context.getMinorVersion();
    }

    @Override
    public int getEffectiveMajorVersion() {
        return this.context.getEffectiveMajorVersion();
    }

    @Override
    public int getEffectiveMinorVersion() {
        return this.context.getEffectiveMinorVersion();
    }

    @Override
    public String getMimeType(String file) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<String> action = () -> this.context.getMimeType(file);
            return AccessController.doPrivileged(action);
        }
        return this.context.getMimeType(file);
    }

    @Override
    public Set<String> getResourcePaths(String path) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<Set> action = () -> this.context.getResourcePaths(path);
            return AccessController.doPrivileged(action);
        }
        return this.context.getResourcePaths(path);
    }

    @Override
    public URL getResource(String path) throws MalformedURLException {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedExceptionAction<URL> action = () -> this.context.getResource(path);
            try {
                return AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                throw (MalformedURLException)e.getCause();
            }
        }
        return this.context.getResource(path);
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<InputStream> action = () -> this.context.getResourceAsStream(path);
            return AccessController.doPrivileged(action);
        }
        return this.context.getResourceAsStream(path);
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<RequestDispatcher> action = () -> this.context.getRequestDispatcher(path);
            return AccessController.doPrivileged(action);
        }
        return this.context.getRequestDispatcher(path);
    }

    @Override
    public RequestDispatcher getNamedDispatcher(String name) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<RequestDispatcher> action = () -> this.context.getNamedDispatcher(name);
            return AccessController.doPrivileged(action);
        }
        return this.context.getNamedDispatcher(name);
    }

    @Override
    public void log(String msg) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<Void> action = () -> {
                this.context.log(msg);
                return null;
            };
            AccessController.doPrivileged(action);
        } else {
            this.context.log(msg);
        }
    }

    @Override
    public void log(String message, Throwable throwable) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<Void> action = () -> {
                this.context.log(message, throwable);
                return null;
            };
            AccessController.doPrivileged(action);
        } else {
            this.context.log(message, throwable);
        }
    }

    @Override
    public String getRealPath(String path) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<String> action = () -> this.context.getRealPath(path);
            return AccessController.doPrivileged(action);
        }
        return this.context.getRealPath(path);
    }

    @Override
    public String getServerInfo() {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<String> action = this.context::getServerInfo;
            return AccessController.doPrivileged(action);
        }
        return this.context.getServerInfo();
    }

    @Override
    public String getInitParameter(String name) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<String> action = () -> this.context.getInitParameter(name);
            return AccessController.doPrivileged(action);
        }
        return this.context.getInitParameter(name);
    }

    @Override
    public Enumeration<String> getInitParameterNames() {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<Enumeration> action = this.context::getInitParameterNames;
            return AccessController.doPrivileged(action);
        }
        return this.context.getInitParameterNames();
    }

    @Override
    public boolean setInitParameter(String name, String value) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<Void> action = () -> {
                this.context.setInitParameter(name, value);
                return null;
            };
            AccessController.doPrivileged(action);
        }
        return this.context.setInitParameter(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<Object> action = () -> this.context.getAttribute(name);
            return AccessController.doPrivileged(action);
        }
        return this.context.getAttribute(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<Enumeration> action = this.context::getAttributeNames;
            return AccessController.doPrivileged(action);
        }
        return this.context.getAttributeNames();
    }

    @Override
    public void setAttribute(String name, Object object) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<Void> action = () -> {
                this.context.setAttribute(name, object);
                return null;
            };
            AccessController.doPrivileged(action);
        } else {
            this.context.setAttribute(name, object);
        }
    }

    @Override
    public void removeAttribute(String name) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<Void> action = () -> {
                this.context.removeAttribute(name);
                return null;
            };
            AccessController.doPrivileged(action);
        } else {
            this.context.removeAttribute(name);
        }
    }

    @Override
    public String getServletContextName() {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<String> action = this.context::getServletContextName;
            return AccessController.doPrivileged(action);
        }
        return this.context.getServletContextName();
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<ServletRegistration.Dynamic> action = () -> this.context.addServlet(servletName, className);
            return AccessController.doPrivileged(action);
        }
        return this.context.addServlet(servletName, className);
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<ServletRegistration.Dynamic> action = () -> this.context.addServlet(servletName, servlet);
            return AccessController.doPrivileged(action);
        }
        return this.context.addServlet(servletName, servlet);
    }

    @Override
    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<ServletRegistration.Dynamic> action = () -> this.context.addServlet(servletName, servletClass);
            return AccessController.doPrivileged(action);
        }
        return this.context.addServlet(servletName, servletClass);
    }

    @Override
    public ServletRegistration.Dynamic addJspFile(String servletName, String jspFile) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<ServletRegistration.Dynamic> action = () -> this.context.addJspFile(servletName, jspFile);
            return AccessController.doPrivileged(action);
        }
        return this.context.addJspFile(servletName, jspFile);
    }

    @Override
    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedExceptionAction<Servlet> action = () -> this.context.createServlet(clazz);
            try {
                return (T)AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                throw (ServletException)e.getCause();
            }
        }
        return this.context.createServlet(clazz);
    }

    @Override
    public ServletRegistration getServletRegistration(String servletName) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<ServletRegistration> action = () -> this.context.getServletRegistration(servletName);
            return AccessController.doPrivileged(action);
        }
        return this.context.getServletRegistration(servletName);
    }

    @Override
    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<Map> action = this.context::getServletRegistrations;
            return AccessController.doPrivileged(action);
        }
        return this.context.getServletRegistrations();
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<FilterRegistration.Dynamic> action = () -> this.context.addFilter(filterName, className);
            return AccessController.doPrivileged(action);
        }
        return this.context.addFilter(filterName, className);
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<FilterRegistration.Dynamic> action = () -> this.context.addFilter(filterName, filter);
            return AccessController.doPrivileged(action);
        }
        return this.context.addFilter(filterName, filter);
    }

    @Override
    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<FilterRegistration.Dynamic> action = () -> this.context.addFilter(filterName, filterClass);
            return AccessController.doPrivileged(action);
        }
        return this.context.addFilter(filterName, filterClass);
    }

    @Override
    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedExceptionAction<Filter> action = () -> this.context.createFilter(clazz);
            try {
                return (T)AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                throw (ServletException)e.getCause();
            }
        }
        return this.context.createFilter(clazz);
    }

    @Override
    public FilterRegistration getFilterRegistration(String filterName) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<FilterRegistration> action = () -> this.context.getFilterRegistration(filterName);
            return AccessController.doPrivileged(action);
        }
        return this.context.getFilterRegistration(filterName);
    }

    @Override
    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<Map> action = this.context::getFilterRegistrations;
            return AccessController.doPrivileged(action);
        }
        return this.context.getFilterRegistrations();
    }

    @Override
    public SessionCookieConfig getSessionCookieConfig() {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<SessionCookieConfig> action = this.context::getSessionCookieConfig;
            return AccessController.doPrivileged(action);
        }
        return this.context.getSessionCookieConfig();
    }

    @Override
    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<Void> action = () -> {
                this.context.setSessionTrackingModes(sessionTrackingModes);
                return null;
            };
            AccessController.doPrivileged(action);
        } else {
            this.context.setSessionTrackingModes(sessionTrackingModes);
        }
    }

    @Override
    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<Set> action = this.context::getDefaultSessionTrackingModes;
            return AccessController.doPrivileged(action);
        }
        return this.context.getDefaultSessionTrackingModes();
    }

    @Override
    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<Set> action = this.context::getEffectiveSessionTrackingModes;
            return AccessController.doPrivileged(action);
        }
        return this.context.getEffectiveSessionTrackingModes();
    }

    @Override
    public void addListener(String className) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<Void> action = () -> {
                this.context.addListener(className);
                return null;
            };
            AccessController.doPrivileged(action);
        } else {
            this.context.addListener(className);
        }
    }

    @Override
    public <T extends EventListener> void addListener(T listener) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<Void> action = () -> {
                this.context.addListener(listener);
                return null;
            };
            AccessController.doPrivileged(action);
        } else {
            this.context.addListener(listener);
        }
    }

    @Override
    public void addListener(Class<? extends EventListener> listenerClass) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<Void> action = () -> {
                this.context.addListener(listenerClass);
                return null;
            };
            AccessController.doPrivileged(action);
        } else {
            this.context.addListener(listenerClass);
        }
    }

    @Override
    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedExceptionAction<EventListener> action = () -> this.context.createListener(clazz);
            try {
                return (T)AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                throw (ServletException)e.getCause();
            }
        }
        return this.context.createListener(clazz);
    }

    @Override
    public JspConfigDescriptor getJspConfigDescriptor() {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<JspConfigDescriptor> action = this.context::getJspConfigDescriptor;
            return AccessController.doPrivileged(action);
        }
        return this.context.getJspConfigDescriptor();
    }

    @Override
    public ClassLoader getClassLoader() {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<ClassLoader> action = this.context::getClassLoader;
            return AccessController.doPrivileged(action);
        }
        return this.context.getClassLoader();
    }

    @Override
    public void declareRoles(String ... roleNames) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<Void> action = () -> {
                this.context.declareRoles(roleNames);
                return null;
            };
            AccessController.doPrivileged(action);
        } else {
            this.context.declareRoles(roleNames);
        }
    }

    @Override
    public String getVirtualServerName() {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<String> action = this.context::getVirtualServerName;
            return AccessController.doPrivileged(action);
        }
        return this.context.getVirtualServerName();
    }

    @Override
    public int getSessionTimeout() {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<Integer> action = this.context::getSessionTimeout;
            return AccessController.doPrivileged(action);
        }
        return this.context.getSessionTimeout();
    }

    @Override
    public void setSessionTimeout(int sessionTimeout) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<Void> action = () -> {
                this.context.setSessionTimeout(sessionTimeout);
                return null;
            };
            AccessController.doPrivileged(action);
        } else {
            this.context.setSessionTimeout(sessionTimeout);
        }
    }

    @Override
    public String getRequestCharacterEncoding() {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<String> action = this.context::getRequestCharacterEncoding;
            return AccessController.doPrivileged(action);
        }
        return this.context.getRequestCharacterEncoding();
    }

    @Override
    public void setRequestCharacterEncoding(String encoding) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<Void> action = () -> {
                this.context.setRequestCharacterEncoding(encoding);
                return null;
            };
            AccessController.doPrivileged(action);
        } else {
            this.context.setRequestCharacterEncoding(encoding);
        }
    }

    @Override
    public String getResponseCharacterEncoding() {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<String> action = this.context::getResponseCharacterEncoding;
            return AccessController.doPrivileged(action);
        }
        return this.context.getResponseCharacterEncoding();
    }

    @Override
    public void setResponseCharacterEncoding(String encoding) {
        if (Globals.IS_SECURITY_ENABLED) {
            PrivilegedAction<Void> action = () -> {
                this.context.setResponseCharacterEncoding(encoding);
                return null;
            };
            AccessController.doPrivileged(action);
        } else {
            this.context.setResponseCharacterEncoding(encoding);
        }
    }

    public String toString() {
        return super.toString() + "[context=" + this.context + "]";
    }
}

