/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.security.AppCNonceCacheMap;
import com.sun.enterprise.security.CNonceCacheFactory;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.WebSecurityDeployerProbeProvider;
import com.sun.enterprise.security.auth.digest.api.DigestAlgorithmParameter;
import com.sun.enterprise.security.auth.digest.api.Key;
import com.sun.enterprise.security.auth.digest.impl.DigestParameterGenerator;
import com.sun.enterprise.security.auth.digest.impl.HttpAlgorithmParameterImpl;
import com.sun.enterprise.security.auth.digest.impl.NestedDigestAlgoParamImpl;
import com.sun.enterprise.security.auth.login.DigestCredentials;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.enterprise.security.integration.RealmInitializer;
import com.sun.enterprise.security.jmac.config.HttpServletHelper;
import com.sun.enterprise.security.web.integration.WebPrincipal;
import com.sun.enterprise.security.web.integration.WebSecurityManager;
import com.sun.enterprise.security.web.integration.WebSecurityManagerFactory;
import com.sun.enterprise.util.Utility;
import com.sun.enterprise.util.net.NetUtils;
import com.sun.web.security.HttpRequestWrapper;
import com.sun.web.security.HttpResponseWrapper;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.config.ServerAuthContext;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.realm.RealmBase;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.NetworkListeners;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.security.common.CNonceCache;
import org.glassfish.security.common.NonceInfo;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class RealmAdapter
extends RealmBase
implements RealmInitializer,
PostConstruct {
    public static final String SECURITY_CONTEXT = "SecurityContext";
    public static final String BASIC = "BASIC";
    public static final String FORM = "FORM";
    private static final Logger _logger = Logger.getLogger(RealmAdapter.class.getName(), "org.glassfish.main.web.security.LogMessages");
    private static final ResourceBundle resourceBundle = _logger.getResourceBundle();
    private static final String SERVER_AUTH_CONTEXT = "__jakarta.security.auth.message.ServerAuthContext";
    private static final String MESSAGE_INFO = "__jakarta.security.auth.message.MessageInfo";
    private static final WebSecurityDeployerProbeProvider websecurityProbeProvider = new WebSecurityDeployerProbeProvider();
    private static final String SYSTEM_HTTPSERVLET_SECURITY_PROVIDER = "system_httpservlet_security_provider";
    private WebBundleDescriptor webBundleDescriptor;
    private HashMap<String, String> runAsPrincipals;
    private String realmName;
    protected static final String name = "J2EE-RI-RealmAdapter";
    private String contextId;
    private Container virtualServer;
    protected volatile WebSecurityManager webSecurityManager;
    protected boolean isCurrentURIincluded = false;
    protected final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private boolean contextEvaluated = false;
    private String loginPage;
    private String errorPage;
    private static final SecurityConstraint[] emptyConstraints = new SecurityConstraint[0];
    private static String defaultSystemProviderID = RealmAdapter.getDefaultSystemProviderID();
    private String moduleID;
    private boolean isSystemApp;
    private HttpServletHelper helper;
    @Inject
    private ServerContext serverContext;
    @Inject
    private Provider<AppCNonceCacheMap> appCNonceCacheMapProvider;
    @Inject
    private Provider<CNonceCacheFactory> cNonceCacheFactoryProvider;
    @Inject
    @Named(value="default-instance-name")
    private NetworkConfig networkConfig;
    @Inject
    protected WebSecurityManagerFactory webSecurityManagerFactory;
    private CNonceCacheFactory cNonceCacheFactory;
    private CNonceCache cnonces;
    private AppCNonceCacheMap haCNonceCacheMap;
    private NetworkListeners networkListeners;
    private static ThreadLocal<byte[]> reentrancyStatus = ThreadLocal.withInitial(() -> new byte[]{0});
    private static final String PROXY_AUTH_TYPE = "PLUGGABLE_PROVIDER";

    public RealmAdapter() {
    }

    public RealmAdapter(String realmName, String moduleID) {
        this.realmName = realmName;
        this.moduleID = moduleID;
    }

    public void initializeRealm(Object descriptor, boolean isSystemApp, String initialRealmName) {
        this.isSystemApp = isSystemApp;
        this.webBundleDescriptor = (WebBundleDescriptor)descriptor;
        this.realmName = this.findRealmName(initialRealmName);
        this.contextId = WebSecurityManager.getContextID((WebBundleDescriptor)this.webBundleDescriptor);
        this.moduleID = this.webBundleDescriptor.getModuleID();
        this.collectRunAsPrincipals();
    }

    public boolean isSecurityExtensionEnabled(ServletContext context) {
        if (this.helper == null) {
            this.initConfigHelper(context);
        }
        try {
            return this.helper.getServerAuthConfig() != null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public SecurityConstraint[] findSecurityConstraints(HttpRequest request, Context context) {
        return this.findSecurityConstraints(context);
    }

    public SecurityConstraint[] findSecurityConstraints(String requestPathMB, String httpMethod, Context context) {
        return this.findSecurityConstraints(context);
    }

    public boolean hasUserDataPermission(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints) throws IOException {
        return this.hasUserDataPermission(request, response, constraints, null, null);
    }

    public boolean hasUserDataPermission(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints, String uri, String method) throws IOException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        if (httpServletRequest.getServletPath() == null) {
            request.setServletPath(this.getResourceName(httpServletRequest.getRequestURI(), httpServletRequest.getContextPath()));
        }
        _logger.fine(() -> "[Web-Security][ hasUserDataPermission ] Principal: " + httpServletRequest.getUserPrincipal() + " ContextPath: " + httpServletRequest.getContextPath());
        if (request.getRequest().isSecure()) {
            _logger.fine(() -> "[Web-Security] request.getRequest().isSecure(): " + request.getRequest().isSecure());
            return true;
        }
        WebSecurityManager webSecurityManager = this.getWebSecurityManager(true);
        if (webSecurityManager == null) {
            return false;
        }
        int isGranted = 0;
        try {
            isGranted = webSecurityManager.hasUserDataPermission(httpServletRequest, uri, method);
        }
        catch (IllegalArgumentException e) {
            _logger.log(Level.WARNING, "realmAdapter.badRequestWithId", e);
            ((HttpServletResponse)response.getResponse()).sendError(400, resourceBundle.getString("realmAdapter.badRequestWithId"));
            return false;
        }
        if (isGranted == -1) {
            _logger.fine(() -> "[Web-Security] redirecting using SSL");
            return this.redirect(request, response);
        }
        if (isGranted == 0) {
            ((HttpServletResponse)response.getResponse()).sendError(403, resourceBundle.getString("realmBase.forbidden"));
            return false;
        }
        return true;
    }

    public int preAuthenticateCheck(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints, boolean disableProxyCaching, boolean securePagesWithPragma, boolean ssoEnabled) throws IOException {
        boolean isGranted = false;
        try {
            if (!this.isRequestAuthenticated(request)) {
                SecurityContext.setUnauthenticatedContext();
            }
            if (this.isJakartaAuthenticationEnabled()) {
                return 1;
            }
            isGranted = this.invokeWebSecurityManager(request, response, constraints);
        }
        catch (IOException iex) {
            throw iex;
        }
        catch (Throwable ex) {
            _logger.log(Level.SEVERE, "Authentication passed, but authorization failed.", ex);
            ((HttpServletResponse)response.getResponse()).sendError(503);
            response.setDetailMessage(resourceBundle.getString("realmBase.forbidden"));
            return -1;
        }
        if (isGranted) {
            if (this.isRequestAuthenticated(request)) {
                this.disableProxyCaching(request, response, disableProxyCaching, securePagesWithPragma);
                if (ssoEnabled) {
                    HttpServletRequest httpServletRequest = (HttpServletRequest)request.getRequest();
                    if (!this.getWebSecurityManager(true).permitAll(httpServletRequest)) {
                        httpServletRequest.getSession(true);
                    }
                }
            }
            return 0;
        }
        if (this.isRequestAuthenticated(request)) {
            ((HttpServletResponse)response.getResponse()).sendError(403);
            response.setDetailMessage(resourceBundle.getString("realmBase.forbidden"));
            return -1;
        }
        this.disableProxyCaching(request, response, disableProxyCaching, securePagesWithPragma);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invokeAuthenticateDelegate(HttpRequest request, HttpResponse response, Context context, Authenticator authenticator, boolean calledFromAuthenticate) throws IOException {
        LoginConfig config = context.getLoginConfig();
        if (this.isJakartaAuthenticationEnabled()) {
            try {
                context.fireContainerEvent("beforeAuthentication", null);
                RequestFacade requestFacade = (RequestFacade)request.getRequest();
                SecurityContext.getCurrent().setSessionPrincipal(requestFacade.getRequestPrincipal());
                boolean bl = this.validate(request, response, config, authenticator, calledFromAuthenticate);
                return bl;
            }
            finally {
                SecurityContext.getCurrent().setSessionPrincipal(null);
                context.fireContainerEvent("afterAuthentication", null);
            }
        }
        return ((AuthenticatorBase)authenticator).authenticate(request, response, config);
    }

    protected String getName() {
        return name;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setVirtualServer(Object container) {
        this.virtualServer = (Container)container;
    }

    public void updateWebSecurityManager() {
        if (this.webSecurityManager == null) {
            this.webSecurityManager = this.getWebSecurityManager(true);
        }
        if (this.webSecurityManager != null) {
            try {
                this.webSecurityManager.release();
                this.webSecurityManager.destroy();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.webSecurityManager = this.webSecurityManagerFactory.createManager(this.webBundleDescriptor, true, this.serverContext);
            _logger.fine(() -> "WebSecurityManager for " + this.contextId + " has been updated");
        }
    }

    public Principal authenticate(HttpRequest request, String username, char[] password) {
        _logger.fine(() -> "Tomcat callback for authenticate user/password");
        _logger.fine(() -> "usename = " + username);
        if (this.authenticate((HttpServletRequest)request, username, password, null, null)) {
            return new WebPrincipal(username, password, SecurityContext.getCurrent());
        }
        return null;
    }

    public Principal authenticate(HttpServletRequest httpServletRequest) {
        DigestCredentials digestCredentials = this.generateDigestCredentials(httpServletRequest);
        if (digestCredentials != null && this.authenticate(httpServletRequest, null, null, digestCredentials, null)) {
            return new WebPrincipal(digestCredentials.getUserName(), (char[])null, SecurityContext.getCurrent());
        }
        return null;
    }

    public Principal authenticate(HttpRequest request, X509Certificate[] certificates) {
        if (this.authenticate((HttpServletRequest)request, null, null, null, certificates)) {
            return new WebPrincipal(certificates, SecurityContext.getCurrent());
        }
        return null;
    }

    public boolean hasResourcePermission(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints, Context context) throws IOException {
        boolean isGranted = false;
        try {
            isGranted = this.invokeWebSecurityManager(request, response, constraints);
        }
        catch (IOException iex) {
            throw iex;
        }
        catch (Throwable ex) {
            _logger.log(Level.SEVERE, "Authentication passed, but authorization failed.", ex);
            ((HttpServletResponse)response.getResponse()).sendError(503);
            response.setDetailMessage(resourceBundle.getString("realmBase.forbidden"));
            return isGranted;
        }
        if (isGranted) {
            return isGranted;
        }
        ((HttpServletResponse)response.getResponse()).sendError(403);
        response.setDetailMessage(resourceBundle.getString("realmBase.forbidden"));
        this.invokePostAuthenticateDelegate(request, response, context);
        return isGranted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invokePostAuthenticateDelegate(HttpRequest request, HttpResponse response, Context context) throws IOException {
        boolean result;
        block11: {
            result = false;
            ServerAuthContext serverAuthContext = null;
            try {
                HttpServletRequest httpServletRequest;
                MessageInfo messageInfo;
                if (this.helper == null || (messageInfo = (MessageInfo)(httpServletRequest = (HttpServletRequest)request.getRequest()).getAttribute(MESSAGE_INFO)) == null || (serverAuthContext = (ServerAuthContext)messageInfo.getMap().get(SERVER_AUTH_CONTEXT)) == null) break block11;
                try {
                    context.fireContainerEvent("beforePostAuthentication", null);
                    AuthStatus authStatus = serverAuthContext.secureResponse(messageInfo, null);
                    result = AuthStatus.SUCCESS.equals(authStatus);
                }
                finally {
                    context.fireContainerEvent("afterPostAuthentication", null);
                }
            }
            catch (AuthException ex) {
                throw new IOException(ex);
            }
            finally {
                if (this.helper != null && serverAuthContext != null) {
                    if (request instanceof HttpRequestWrapper) {
                        request.removeNote("__jakarta.security.auth.message.request");
                    }
                    if (response instanceof HttpResponseWrapper) {
                        request.removeNote("__jakarta.security.auth.message.response");
                    }
                }
            }
        }
        return result;
    }

    public boolean hasRole(HttpRequest request, HttpResponse response, Principal principal, String role) {
        WebSecurityManager webSecurityManager = this.getWebSecurityManager(true);
        if (webSecurityManager == null) {
            return false;
        }
        String servletName = this.getCanonicalName(request);
        boolean isGranted = webSecurityManager.hasRoleRefPermission(servletName, role, principal);
        _logger.fine(() -> "Checking if servlet " + servletName + " with principal " + principal + " has role " + role + " isGranted: " + isGranted);
        return isGranted;
    }

    public void destroy() {
        super.destroy();
        if (this.helper != null) {
            this.helper.disable();
        }
    }

    public WebBundleDescriptor getWebDescriptor() {
        return this.webBundleDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebSecurityManager getWebSecurityManager(boolean logNull) {
        if (this.webSecurityManager == null && this.webSecurityManagerFactory != null) {
            RealmAdapter realmAdapter = this;
            synchronized (realmAdapter) {
                this.webSecurityManager = this.webSecurityManagerFactory.getManager(this.contextId);
            }
            if (this.webSecurityManager == null && logNull) {
                _logger.log(Level.WARNING, "realmAdapter.noWebSecMgr", this.contextId);
            }
        }
        return this.webSecurityManager;
    }

    public boolean hasRole(String servletName, Principal principal, String role) {
        WebSecurityManager secMgr = this.getWebSecurityManager(true);
        if (secMgr == null) {
            return false;
        }
        return secMgr.hasRoleRefPermission(servletName, role, principal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void logout(HttpRequest httpRequest) {
        boolean securityExtensionEnabled = this.isSecurityExtensionEnabled(httpRequest.getRequest().getServletContext());
        byte[] alreadyCalled = reentrancyStatus.get();
        if (securityExtensionEnabled && this.helper != null && alreadyCalled[0] == 0) {
            alreadyCalled[0] = 1;
            MessageInfo messageInfo = (MessageInfo)httpRequest.getRequest().getAttribute(MESSAGE_INFO);
            if (messageInfo == null) {
                messageInfo = new HttpMessageInfo((HttpServletRequest)httpRequest.getRequest(), (HttpServletResponse)httpRequest.getResponse().getResponse());
            }
            messageInfo.getMap().put("jakarta.security.auth.message.MessagePolicy.isMandatory", Boolean.TRUE.toString());
            try {
                Subject subject;
                ServerAuthContext serverAuthContext = this.helper.getServerAuthContext(messageInfo, null);
                if (serverAuthContext == null) return;
                SecurityContext securityContext = SecurityContext.getCurrent();
                Subject subject2 = subject = securityContext.didServerGenerateCredentials() ? new Subject() : securityContext.getSubject();
                if (subject == null) {
                    subject = new Subject();
                }
                if (subject.isReadOnly()) {
                    _logger.log(Level.WARNING, "Read-only subject found during logout processing");
                }
                try {
                    httpRequest.getContext().fireContainerEvent("beforePostAuthentication", null);
                    serverAuthContext.cleanSubject(messageInfo, subject);
                    return;
                }
                finally {
                    httpRequest.getContext().fireContainerEvent("afterPostAuthentication", null);
                }
            }
            catch (AuthException ex) {
                throw new RuntimeException(ex);
            }
            finally {
                this.doLogout(httpRequest, true);
                alreadyCalled[0] = 0;
            }
        } else {
            this.doLogout(httpRequest, alreadyCalled[0] == 1);
        }
    }

    private void doLogout(HttpRequest request, boolean extensionEnabled) {
        Context context = request.getContext();
        Authenticator authenticator = null;
        if (context != null) {
            authenticator = context.getAuthenticator();
        }
        if (authenticator == null) {
            throw new RuntimeException("Context or Authenticator is null");
        }
        try {
            if (extensionEnabled) {
                AuthenticatorProxy proxy = new AuthenticatorProxy(authenticator, null, null);
                proxy.logout(request);
            } else {
                authenticator.logout(request);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.logout();
    }

    public void logout() {
        this.setSecurityContext(null);
        final WebSecurityManager webSecurityManager = this.getWebSecurityManager(false);
        if (webSecurityManager != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    webSecurityManager.onLogout();
                    return null;
                }
            });
        }
    }

    public boolean authenticate(HttpServletRequest request, WebPrincipal principal) {
        if (principal.isUsingCertificate()) {
            return this.authenticate(request, null, null, null, principal.getCertificates());
        }
        return this.authenticate(request, principal.getName(), principal.getPassword(), null, null);
    }

    private boolean authenticate(final HttpServletRequest request, String username, char[] password, DigestCredentials digestCredentials, X509Certificate[] certificates) {
        try {
            if (certificates != null) {
                LoginContextDriver.doX500Login((Subject)this.generateX500Subject(certificates), (String)this.moduleID);
            } else if (digestCredentials != null) {
                LoginContextDriver.login((DigestCredentials)digestCredentials);
            } else {
                LoginContextDriver.login((String)username, (char[])password, (String)this.realmName);
            }
            _logger.log(Level.FINE, () -> "Web login succeeded for: " + SecurityContext.getCurrent().getCallerPrincipal());
            final WebSecurityManager webSecurityManager = this.getWebSecurityManager(false);
            if (webSecurityManager != null) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        webSecurityManager.onLogin(request);
                        return null;
                    }
                });
            }
            return true;
        }
        catch (Exception le) {
            _logger.log(Level.WARNING, "WEB9102: Web Login Failed", le);
            return false;
        }
    }

    public void preSetRunAsIdentity(ComponentInvocation componentInvocation) {
        if (Utility.isEmpty(this.runAsPrincipals)) {
            return;
        }
        String servletName = this.getServletName(componentInvocation);
        if (servletName == null) {
            return;
        }
        String runAs = this.runAsPrincipals.get(servletName);
        if (runAs != null) {
            componentInvocation.setOldSecurityContext((Object)this.getSecurityContext());
            this.loginForRunAs(runAs);
            _logger.log(Level.FINE, () -> "run-as principal for " + servletName + " set to: " + runAs);
        }
    }

    private String getServletName(ComponentInvocation componentInvocation) {
        HttpServlet thisServlet;
        ServletConfig servletConfig;
        String servletName = componentInvocation.getInstanceName();
        if (servletName != null) {
            return servletName;
        }
        Object invocationInstance = componentInvocation.getInstance();
        if (invocationInstance instanceof HttpServlet && (servletConfig = (thisServlet = (HttpServlet)invocationInstance).getServletConfig()) != null) {
            return thisServlet.getServletName();
        }
        return null;
    }

    public void postSetRunAsIdentity(ComponentInvocation inv) {
        if (this.runAsPrincipals != null && this.runAsPrincipals.isEmpty()) {
            return;
        }
        String servletName = this.getServletName(inv);
        if (servletName == null) {
            return;
        }
        String runAs = this.runAsPrincipals.get(servletName);
        if (runAs != null) {
            this.setSecurityContext((SecurityContext)inv.getOldSecurityContext());
        }
    }

    private void loginForRunAs(String principal) {
        LoginContextDriver.loginPrincipal((String)principal, (String)this.realmName);
    }

    private SecurityContext getSecurityContext() {
        return SecurityContext.getCurrent();
    }

    private void setSecurityContext(SecurityContext sc) {
        SecurityContext.setCurrent((SecurityContext)sc);
    }

    private boolean principalSetContainsOnlyAnonymousPrincipal(Set<Principal> principalSet) {
        boolean rvalue = false;
        Principal defaultPrincipal = SecurityContext.getDefaultCallerPrincipal();
        if (defaultPrincipal != null && principalSet != null) {
            rvalue = principalSet.contains(defaultPrincipal);
        }
        if (rvalue) {
            for (Principal element : principalSet) {
                if (element.equals(defaultPrincipal)) continue;
                return false;
            }
        }
        return rvalue;
    }

    protected char[] getPassword(String username) {
        throw new IllegalStateException("Should not reach here");
    }

    protected Principal getPrincipal(String username) {
        throw new IllegalStateException("Should not reach here");
    }

    public Principal createFailOveredPrincipal(String username) {
        _logger.log(Level.FINEST, "IN createFailOveredPrincipal ({0})", username);
        this.loginForRunAs(username);
        SecurityContext securityContext = SecurityContext.getCurrent();
        _logger.log(Level.FINE, "Security context is {0}", securityContext);
        WebPrincipal principal = new WebPrincipal(username, (char[])null, securityContext);
        _logger.log(Level.INFO, "Principal created for FailOvered user {0}", principal);
        return principal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invokeWebSecurityManager(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints) throws IOException {
        WebSecurityManager webSecurityManager;
        HttpServletRequest httpServletRequest;
        boolean evaluated = false;
        try {
            this.rwLock.readLock().lock();
            evaluated = this.contextEvaluated;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        if (!evaluated) {
            try {
                this.rwLock.writeLock().lock();
                if (!this.contextEvaluated) {
                    Context context = (Context)this.getContainer();
                    LoginConfig config = context.getLoginConfig();
                    if (config != null && FORM.equals(config.getAuthMethod())) {
                        this.loginPage = config.getLoginPage();
                        this.errorPage = config.getErrorPage();
                    }
                    this.contextEvaluated = true;
                }
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        }
        if (this.loginPage != null || this.errorPage != null) {
            String requestURI = request.getRequestPathMB().toString();
            _logger.log(Level.FINE, () -> "[Web-Security]  requestURI: " + requestURI + " loginPage: " + this.loginPage);
            if (this.loginPage != null && this.loginPage.equals(requestURI)) {
                _logger.log(Level.FINE, () -> " Allow access to login page " + this.loginPage);
                return true;
            }
            if (this.errorPage != null && this.errorPage.equals(requestURI)) {
                _logger.log(Level.FINE, () -> " Allow access to error page " + this.errorPage);
                return true;
            }
            if (requestURI.endsWith("/j_security_check")) {
                _logger.fine(" Allow access to username/password submission");
                return true;
            }
        }
        if ((httpServletRequest = (HttpServletRequest)request).getServletPath() == null) {
            request.setServletPath(this.getResourceName(httpServletRequest.getRequestURI(), httpServletRequest.getContextPath()));
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("[Web-Security] [ hasResourcePermission ] Principal: " + httpServletRequest.getUserPrincipal() + " ContextPath: " + httpServletRequest.getContextPath());
        }
        if ((webSecurityManager = this.getWebSecurityManager(true)) == null) {
            return false;
        }
        return webSecurityManager.hasResourcePermission(httpServletRequest);
    }

    private List<String> getHostAndPort(HttpRequest request) throws IOException {
        boolean isHostPortNullOrEmpty;
        boolean isWebServerRequest = false;
        Enumeration headerNames = ((HttpServletRequest)request.getRequest()).getHeaderNames();
        String[] hostPort = null;
        boolean isHeaderPresent = false;
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (!headerName.equalsIgnoreCase("Host")) continue;
            String hostVal = ((HttpServletRequest)request.getRequest()).getHeader(headerName);
            isHeaderPresent = true;
            hostPort = hostVal.split(":");
        }
        if (hostPort == null) {
            throw new ProtocolException(resourceBundle.getString("missing_http_header.host"));
        }
        boolean bl = isHostPortNullOrEmpty = hostPort.length <= 1 || hostPort[1] == null || hostPort[1].trim().isEmpty();
        if (!isHeaderPresent) {
            isWebServerRequest = false;
        } else if (isHostPortNullOrEmpty) {
            isWebServerRequest = true;
        } else {
            boolean breakFromLoop = false;
            for (NetworkListener nwListener : this.networkListeners.getNetworkListener()) {
                String nwAddress = nwListener.getAddress();
                if (nwAddress == null || nwAddress.equals("0.0.0.0")) {
                    nwAddress = NetUtils.getCanonicalHostName();
                    if (!nwAddress.equals(hostPort[0])) {
                        InetAddress[] localHostAdresses = NetUtils.getHostAddresses();
                        InetAddress hostAddress = InetAddress.getByName(hostPort[0]);
                        for (InetAddress inetAdress : localHostAdresses) {
                            if (!inetAdress.equals(hostAddress)) continue;
                            String nwPort = nwListener.getPort();
                            if (nwPort.equals(hostPort[1])) {
                                isWebServerRequest = false;
                                breakFromLoop = true;
                                break;
                            }
                            isWebServerRequest = true;
                        }
                    } else {
                        String nwPort = nwListener.getPort();
                        if (!nwPort.equals(hostPort[1])) {
                            isWebServerRequest = true;
                        } else {
                            isWebServerRequest = false;
                            breakFromLoop = true;
                        }
                    }
                }
                if (!breakFromLoop || isWebServerRequest) continue;
                break;
            }
        }
        String serverHost = request.getRequest().getServerName();
        int redirectPort = request.getConnector().getRedirectPort();
        if (isWebServerRequest) {
            serverHost = hostPort[0];
            redirectPort = isHostPortNullOrEmpty ? -1 : Integer.parseInt(hostPort[1]);
        }
        ArrayList<String> hostAndPort = new ArrayList<String>();
        hostAndPort.add(serverHost);
        hostAndPort.add(String.valueOf(redirectPort));
        return hostAndPort;
    }

    private boolean redirect(HttpRequest request, HttpResponse response) throws IOException {
        String queryString;
        HttpServletRequest hrequest = (HttpServletRequest)request.getRequest();
        HttpServletResponse hresponse = (HttpServletResponse)response.getResponse();
        int redirectPort = request.getConnector().getRedirectPort();
        if (redirectPort <= 0) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.fine("[Web-Security]  SSL redirect is disabled");
            }
            hresponse.sendError(403, URLEncoder.encode(hrequest.getRequestURI(), "UTF-8"));
            return false;
        }
        String protocol = "https";
        StringBuffer file = new StringBuffer(hrequest.getRequestURI());
        String requestedSessionId = hrequest.getRequestedSessionId();
        if (requestedSessionId != null && hrequest.isRequestedSessionIdFromURL()) {
            file.append(";jsessionid=");
            file.append(requestedSessionId);
        }
        if ((queryString = hrequest.getQueryString()) != null) {
            file.append('?');
            file.append(queryString);
        }
        URL url = null;
        List<String> hostAndPort = this.getHostAndPort(request);
        String serverHost = hostAndPort.get(0);
        redirectPort = Integer.parseInt(hostAndPort.get(1));
        try {
            url = new URL(protocol, serverHost, redirectPort, file.toString());
            hresponse.sendRedirect(url.toString());
            return false;
        }
        catch (MalformedURLException e) {
            hresponse.sendError(500, URLEncoder.encode(hrequest.getRequestURI(), "UTF-8"));
            return false;
        }
    }

    private String getCanonicalName(HttpRequest currentRequest) {
        return currentRequest.getWrapper().getServletName();
    }

    private String getResourceName(String uri, String contextPath) {
        if (contextPath.length() < uri.length()) {
            return uri.substring(contextPath.length());
        }
        return "";
    }

    public void setRealmName(String realmName) {
    }

    private HttpServletHelper getConfigHelper(ServletContext servletContext) {
        HashMap<String, WebBundleDescriptor> map = new HashMap<String, WebBundleDescriptor>();
        map.put("WEB_BUNDLE", this.webBundleDescriptor);
        return new HttpServletHelper(this.getAppContextID(servletContext), map, null, this.realmName, this.isSystemApp, defaultSystemProviderID);
    }

    private String getAppContextID(ServletContext servletContext) {
        if (!servletContext.getVirtualServerName().equals(this.virtualServer.getName())) {
            _logger.log(Level.WARNING, "Virtual server name from ServletContext: {0} differs from name from virtual.getName(): {1}", new Object[]{servletContext.getVirtualServerName(), this.virtualServer.getName()});
        }
        if (!servletContext.getContextPath().equals(this.webBundleDescriptor.getContextRoot())) {
            _logger.log(Level.WARNING, "Context path from ServletContext: {0} differs from path from bundle: {1}", new Object[]{servletContext.getContextPath(), this.webBundleDescriptor.getContextRoot()});
        }
        return servletContext.getVirtualServerName() + " " + servletContext.getContextPath();
    }

    private boolean validate(HttpRequest request, HttpResponse response, LoginConfig config, Authenticator authenticator, boolean calledFromAuthenticate) throws IOException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request.getRequest();
        HttpServletResponse httpServletResponse = (HttpServletResponse)response.getResponse();
        Subject subject = new Subject();
        HttpMessageInfo messageInfo = new HttpMessageInfo(httpServletRequest, httpServletResponse);
        boolean rvalue = false;
        boolean isMandatory = true;
        try {
            ServerAuthContext serverAuthContext;
            WebSecurityManager webSecurityManager = this.getWebSecurityManager(true);
            boolean bl = isMandatory = !webSecurityManager.permitAll(httpServletRequest);
            if (isMandatory || calledFromAuthenticate) {
                messageInfo.getMap().put("jakarta.security.auth.message.MessagePolicy.isMandatory", Boolean.TRUE.toString());
            }
            if ((serverAuthContext = this.helper.getServerAuthContext((MessageInfo)messageInfo, null)) == null) {
                throw new AuthException("null ServerAuthContext");
            }
            AuthStatus authStatus = serverAuthContext.validateRequest((MessageInfo)messageInfo, subject, null);
            rvalue = AuthStatus.SUCCESS.equals(authStatus);
            if (rvalue) {
                messageInfo.getMap().put(SERVER_AUTH_CONTEXT, serverAuthContext);
                httpServletRequest.setAttribute(MESSAGE_INFO, (Object)messageInfo);
            }
        }
        catch (AuthException ae) {
            _logger.log(Level.FINE, "Jakarta Authentication: http msg authentication fail", ae);
            httpServletResponse.setStatus(500);
        }
        catch (RuntimeException e) {
            _logger.log(Level.SEVERE, "Jakarta Authentication: Exception during validateRequest", e);
            httpServletResponse.sendError(500);
        }
        if (rvalue) {
            block18: {
                Set<Principal> principalSet = subject.getPrincipals();
                if (principalSet != null && !principalSet.isEmpty() && !this.principalSetContainsOnlyAnonymousPrincipal(principalSet)) {
                    SecurityContext ctx = new SecurityContext(subject);
                    SecurityContext.setCurrent((SecurityContext)ctx);
                    Principal principal = ctx.getCallerPrincipal();
                    WebPrincipal webPrincipal = new WebPrincipal(principal, ctx);
                    try {
                        String authType = (String)messageInfo.getMap().get("jakarta.servlet.http.authType");
                        if (authType == null && config != null && config.getAuthMethod() != null) {
                            authType = config.getAuthMethod();
                        }
                        if (this.shouldRegister(messageInfo.getMap())) {
                            AuthenticatorProxy proxy = new AuthenticatorProxy(authenticator, (Principal)webPrincipal, authType);
                            proxy.authenticate(request, response, config);
                            break block18;
                        }
                        request.setAuthType(authType == null ? PROXY_AUTH_TYPE : authType);
                        request.setUserPrincipal((Principal)webPrincipal);
                    }
                    catch (LifecycleException le) {
                        _logger.log(Level.SEVERE, "[Web-Security] unable to register session", le);
                    }
                } else {
                    if (((HttpServletRequest)messageInfo.getRequestMessage()).getUserPrincipal() != null) {
                        request.setUserPrincipal(null);
                        request.setAuthType(null);
                    }
                    if (isMandatory) {
                        rvalue = false;
                    }
                }
            }
            if (rvalue) {
                HttpServletResponse newResponse;
                HttpServletRequest newRequest = (HttpServletRequest)messageInfo.getRequestMessage();
                if (newRequest != httpServletRequest) {
                    request.setNote("__jakarta.security.auth.message.request", (Object)new HttpRequestWrapper(request, newRequest));
                }
                if ((newResponse = (HttpServletResponse)messageInfo.getResponseMessage()) != httpServletResponse) {
                    request.setNote("__jakarta.security.auth.message.response", (Object)new HttpResponseWrapper(response, newResponse));
                }
            }
        }
        return rvalue;
    }

    private boolean shouldRegister(Map map) {
        return map.containsKey("com.sun.web.RealmAdapter.register") || this.mapEntryToBoolean("jakarta.servlet.http.registerSession", map);
    }

    private boolean mapEntryToBoolean(String propName, Map map) {
        Object value;
        if (map.containsKey(propName) && (value = map.get(propName)) != null && value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return false;
    }

    private static String getDefaultSystemProviderID() {
        String p = System.getProperty(SYSTEM_HTTPSERVLET_SECURITY_PROVIDER);
        if (p != null && (p = p.trim()).length() == 0) {
            p = null;
        }
        return p;
    }

    protected void configureSecurity(WebBundleDescriptor webBundleDescriptor, boolean isSystem) {
        try {
            this.webSecurityManagerFactory.createManager(webBundleDescriptor, true, this.serverContext).commitPolicy();
            String contextId = WebSecurityManager.getContextID((WebBundleDescriptor)webBundleDescriptor);
            if (isSystem && contextId.equals("__admingui/__admingui")) {
                websecurityProbeProvider.policyCreationEvent(contextId);
            }
        }
        catch (Exception ce) {
            throw new RuntimeException("Policy configuration failed!", ce);
        }
    }

    private SecurityContext getSecurityContextForPrincipal(final Principal principal) {
        if (principal == null) {
            return null;
        }
        if (principal instanceof WebPrincipal) {
            return ((WebPrincipal)principal).getSecurityContext();
        }
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                Subject s = new Subject();
                s.getPrincipals().add(principal);
                return new SecurityContext(principal.getName(), s);
            }
        });
    }

    public void setCurrentSecurityContextWithWebPrincipal(Principal principal) {
        if (principal instanceof WebPrincipal) {
            SecurityContext.setCurrent((SecurityContext)this.getSecurityContextForPrincipal(principal));
        }
    }

    public void setCurrentSecurityContext(Principal principal) {
        SecurityContext.setCurrent((SecurityContext)this.getSecurityContextForPrincipal(principal));
    }

    public synchronized void initConfigHelper(ServletContext servletContext) {
        if (this.helper != null) {
            return;
        }
        this.helper = this.getConfigHelper(servletContext);
    }

    public void postConstruct() {
        this.networkListeners = this.networkConfig.getNetworkListeners();
    }

    private String findRealmName(String initialRealmName) {
        String candidateRealmName = this.webBundleDescriptor.getApplication().getRealm();
        LoginConfiguration loginConfig = this.webBundleDescriptor.getLoginConfiguration();
        if (candidateRealmName == null && loginConfig != null) {
            candidateRealmName = loginConfig.getRealmName();
        }
        if (initialRealmName != null && Utility.isEmpty((String)candidateRealmName)) {
            candidateRealmName = initialRealmName;
        }
        return candidateRealmName;
    }

    private void collectRunAsPrincipals() {
        this.runAsPrincipals = new HashMap();
        for (WebComponentDescriptor componentDescriptor : this.webBundleDescriptor.getWebComponentDescriptors()) {
            RunAsIdentityDescriptor runAsDescriptor = componentDescriptor.getRunAsIdentity();
            if (runAsDescriptor == null) continue;
            String principal = runAsDescriptor.getPrincipal();
            String servlet = componentDescriptor.getCanonicalName();
            if (Utility.isAnyNull((Object[])new Object[]{principal, servlet})) {
                _logger.warning("WEB8080: Null run-as principal or servlet, ignoring run-as element.");
                continue;
            }
            this.runAsPrincipals.put(servlet, principal);
            _logger.fine(() -> "Servlet " + servlet + " will run-as: " + principal);
        }
    }

    private SecurityConstraint[] findSecurityConstraints(Context context) {
        WebSecurityManager webSecurityManager;
        if (this.helper == null) {
            this.initConfigHelper(context.getServletContext());
        }
        if ((webSecurityManager = this.getWebSecurityManager(false)) != null && webSecurityManager.hasNoConstrainedResources() && !this.isSecurityExtensionEnabled(context.getServletContext())) {
            return null;
        }
        return emptyConstraints;
    }

    private boolean isRequestAuthenticated(HttpRequest httpRequest) {
        return ((HttpServletRequest)httpRequest).getUserPrincipal() != null;
    }

    private boolean isJakartaAuthenticationEnabled() throws IOException {
        try {
            return this.helper != null && this.helper.getServerAuthConfig() != null;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    private Subject generateX500Subject(X509Certificate[] x509Certificates) {
        Subject x500Subject = new Subject();
        x500Subject.getPublicCredentials().add(x509Certificates[0].getSubjectX500Principal());
        x500Subject.getPublicCredentials().add(Arrays.asList(x509Certificates));
        return x500Subject;
    }

    private DigestCredentials generateDigestCredentials(HttpServletRequest httpServletRequest) {
        try {
            DigestAlgorithmParameter[] digestParameters = this.generateDigestParameters(httpServletRequest);
            this.validateDigestParameters(digestParameters);
            Key key = this.findDigestKey(digestParameters);
            return new DigestCredentials(this.realmName, key.getUsername(), digestParameters);
        }
        catch (Exception le) {
            _logger.log(Level.WARNING, "WEB9102: Web Login Failed", le);
            return null;
        }
    }

    private DigestAlgorithmParameter[] generateDigestParameters(HttpServletRequest httpServletRequest) throws InvalidAlgorithmParameterException {
        return DigestParameterGenerator.getInstance((String)"HttpDigest").generateParameters((AlgorithmParameterSpec)new HttpAlgorithmParameterImpl(httpServletRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateDigestParameters(DigestAlgorithmParameter[] digestParameters) {
        NonceInfo nonceInfo;
        if (this.cnonces == null) {
            String appName = this.webBundleDescriptor.getApplication().getAppName();
            RealmAdapter realmAdapter = this;
            synchronized (realmAdapter) {
                if (this.haCNonceCacheMap == null) {
                    this.haCNonceCacheMap = this.appCNonceCacheMapProvider.get();
                }
                if (this.haCNonceCacheMap != null) {
                    this.cnonces = (CNonceCache)this.haCNonceCacheMap.get((Object)appName);
                }
                if (this.cnonces == null) {
                    if (this.cNonceCacheFactory == null) {
                        this.cNonceCacheFactory = this.cNonceCacheFactoryProvider.get();
                    }
                    this.cnonces = this.cNonceCacheFactory.createCNonceCache(this.webBundleDescriptor.getApplication().getAppName(), null, null, null);
                }
            }
        }
        String cnonce = null;
        String nc = null;
        for (DigestAlgorithmParameter digestParameter : digestParameters) {
            if (digestParameter instanceof NestedDigestAlgoParamImpl) {
                DigestAlgorithmParameter[] nestedParameters;
                NestedDigestAlgoParamImpl np = (NestedDigestAlgoParamImpl)digestParameter;
                for (DigestAlgorithmParameter nestedParameter : nestedParameters = (DigestAlgorithmParameter[])np.getNestedParams()) {
                    if ("cnonce".equals(nestedParameter.getName())) {
                        cnonce = new String(nestedParameter.getValue());
                    } else if ("nc".equals(nestedParameter.getName())) {
                        nc = new String(nestedParameter.getValue());
                    }
                    if (cnonce != null && nc != null) break;
                }
                if (cnonce != null && nc != null) break;
            }
            if ("cnonce".equals(digestParameter.getName())) {
                cnonce = new String(digestParameter.getValue());
                continue;
            }
            if (!"nc".equals(digestParameter.getName())) continue;
            nc = new String(digestParameter.getValue());
        }
        long currentTime = System.currentTimeMillis();
        long count = this.getCount(nc);
        CNonceCache cNonceCache = this.cnonces;
        synchronized (cNonceCache) {
            nonceInfo = (NonceInfo)this.cnonces.get(cnonce);
        }
        if (nonceInfo == null) {
            nonceInfo = new NonceInfo();
        } else if (count <= nonceInfo.getCount()) {
            throw new RuntimeException("Invalid Request : Possible Replay Attack detected ?");
        }
        nonceInfo.setCount(count);
        nonceInfo.setTimestamp(currentTime);
        cNonceCache = this.cnonces;
        synchronized (cNonceCache) {
            this.cnonces.put((Object)cnonce, (Object)nonceInfo);
        }
    }

    private long getCount(String nc) {
        try {
            return Long.parseLong(nc, 16);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException(nfe);
        }
    }

    private Key findDigestKey(DigestAlgorithmParameter[] digestParameters) {
        for (DigestAlgorithmParameter digestParameter : digestParameters) {
            if (!"A1".equals(digestParameter.getName()) || !(digestParameter instanceof Key)) continue;
            return (Key)digestParameter;
        }
        throw new RuntimeException("No key found in parameters");
    }

    private static class HttpMessageInfo
    implements MessageInfo {
        private Object request = null;
        private Object response = null;
        private final Map map = new HashMap();

        HttpMessageInfo() {
        }

        HttpMessageInfo(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public Object getRequestMessage() {
            return this.request;
        }

        public Object getResponseMessage() {
            return this.response;
        }

        public void setRequestMessage(Object request) {
            this.request = request;
        }

        public void setResponseMessage(Object response) {
            this.response = response;
        }

        public Map getMap() {
            return this.map;
        }
    }

    static class AuthenticatorProxy
    extends AuthenticatorBase {
        private final AuthenticatorBase authBase;
        private final Principal principal;
        private final String authType;

        public boolean getCache() {
            return this.authBase.getCache();
        }

        public Container getContainer() {
            return this.authBase.getContainer();
        }

        AuthenticatorProxy(Authenticator authenticator, Principal p, String authType) throws LifecycleException {
            this.authBase = (AuthenticatorBase)authenticator;
            this.principal = p;
            this.authType = authType == null ? RealmAdapter.PROXY_AUTH_TYPE : authType;
            this.setCache(this.authBase.getCache());
            this.setContainer(this.authBase.getContainer());
            this.start();
        }

        public boolean authenticate(HttpRequest request, HttpResponse response, LoginConfig config) throws IOException {
            if (this.cache) {
                this.getSession(request, true);
            }
            this.register(request, response, this.principal, this.authType, this.principal.getName(), null);
            return true;
        }

        public String getAuthMethod() {
            return this.authType;
        }
    }
}

