/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm.certificate;

import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.auth.login.DistinguishedPrincipalCredential;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.IASRealm;
import com.sun.enterprise.security.auth.realm.InvalidOperationException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.util.Utility;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.x500.X500Principal;
import org.glassfish.security.common.Group;
import org.jvnet.hk2.annotations.Service;

@Service
public final class CertificateRealm
extends IASRealm {
    public static final String AUTH_TYPE = "certificate";
    private List<String> defaultGroups = new LinkedList<String>();

    @Override
    public String getAuthType() {
        return AUTH_TYPE;
    }

    @Override
    protected void init(Properties props) throws BadRealmException, NoSuchRealmException {
        String jaasCtx;
        super.init(props);
        Object[] groups = this.addAssignGroups(null);
        if (!Utility.isEmpty((Object[])groups)) {
            this.defaultGroups.addAll(Arrays.asList(groups));
        }
        if ((jaasCtx = props.getProperty("jaas-context")) != null) {
            this.setProperty("jaas-context", jaasCtx);
        }
    }

    public void authenticate(Subject subject, X500Principal principal) {
        String name = principal.getName();
        _logger.log(Level.FINE, () -> "Certificate realm setting up security context for: " + name);
        if (this.defaultGroups != null) {
            Set<Principal> principalSet = subject.getPrincipals();
            for (String groupName : this.defaultGroups) {
                principalSet.add((Principal)new Group(groupName));
            }
        }
        if (!subject.getPrincipals().isEmpty()) {
            subject.getPublicCredentials().add(new DistinguishedPrincipalCredential(principal));
        }
        SecurityContext.setCurrent(new SecurityContext(name, subject));
    }

    @Override
    public Enumeration<String> getGroupNames(String username) throws NoSuchUserException, InvalidOperationException {
        return Collections.enumeration(this.defaultGroups);
    }

    public static final class AppContextCallback
    implements Callback {
        private String moduleID;

        public String getModuleID() {
            return this.moduleID;
        }

        public void setModuleID(String moduleID) {
            this.moduleID = moduleID;
        }
    }
}

