/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaspic.config.jaas;

import com.sun.security.auth.login.ConfigFile;
import java.lang.reflect.Field;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.login.AppConfigurationEntry;

public class ExtendedConfigFile
extends ConfigFile {
    private static final Logger LOG = Logger.getLogger("com.sun.logging.enterprise.system.jaspic.config", "com.sun.jaspic.config.helper.LogMessages");

    public ExtendedConfigFile() {
    }

    public ExtendedConfigFile(URI uri) {
        super(uri);
    }

    public String[] getAppNames(final Class[] authModuleClass) {
        Set nameSet;
        try {
            nameSet = (Set)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Field field = ConfigFile.class.getDeclaredField("configuration");
                    field.setAccessible(true);
                    HashMap map = (HashMap)field.get(ExtendedConfigFile.this);
                    return map.keySet();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new SecurityException(pae.getCause());
        }
        if (authModuleClass != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        String[] names;
                        ClassLoader loader = Thread.currentThread().getContextClassLoader();
                        for (String id : names = nameSet.toArray(new String[nameSet.size()])) {
                            boolean hasAuthModule = false;
                            AppConfigurationEntry[] entry = ExtendedConfigFile.this.getAppConfigurationEntry(id);
                            block3: for (int i = 0; i < entry.length && !hasAuthModule; ++i) {
                                String clazz = entry[i].getLoginModuleName();
                                try {
                                    Class<?> c = Class.forName(clazz, true, loader);
                                    for (Class required : authModuleClass) {
                                        if (!required.isAssignableFrom(c)) continue;
                                        hasAuthModule = true;
                                        continue block3;
                                    }
                                    continue;
                                }
                                catch (Throwable t) {
                                    LOG.log(Level.WARNING, "Skipping unloadable class: " + clazz + " of entry: " + id);
                                }
                            }
                            if (hasAuthModule) continue;
                            nameSet.remove(id);
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw new SecurityException(pae.getCause());
            }
        }
        return nameSet.toArray(new String[nameSet.size()]);
    }
}

