/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.web.integration;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.security.WebSecurityDeployerProbeProvider;
import com.sun.enterprise.security.authorize.PolicyContextHandlerImpl;
import com.sun.enterprise.security.factory.SecurityManagerFactory;
import com.sun.enterprise.security.web.integration.LogUtils;
import com.sun.enterprise.security.web.integration.WebSecurityManager;
import jakarta.inject.Singleton;
import jakarta.security.jacc.PolicyContextException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.security.common.Group;
import org.glassfish.security.common.UserPrincipal;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class WebSecurityManagerFactory
extends SecurityManagerFactory {
    private static Logger logger = LogUtils.getLogger();
    private final WebSecurityDeployerProbeProvider probeProvider = new WebSecurityDeployerProbeProvider();
    final PolicyContextHandlerImpl pcHandlerImpl = PolicyContextHandlerImpl.getInstance();
    private final Map<String, UserPrincipal> adminPrincipals = new ConcurrentHashMap<String, UserPrincipal>();
    private final Map<String, Group> adminGroups = new ConcurrentHashMap<String, Group>();
    private final Map<String, ArrayList<String>> CONTEXT_IDS = new HashMap<String, ArrayList<String>>();
    private final Map<String, Map<String, WebSecurityManager>> SECURITY_MANAGERS = new HashMap<String, Map<String, WebSecurityManager>>();

    public WebSecurityManager getManager(String ctxId) {
        return (WebSecurityManager)this.getManager(this.SECURITY_MANAGERS, ctxId, null, false);
    }

    public WebSecurityManager getManager(String ctxId, boolean remove) {
        return (WebSecurityManager)this.getManager(this.SECURITY_MANAGERS, ctxId, null, remove);
    }

    public <T> ArrayList<WebSecurityManager> getManagers(String ctxId, boolean remove) {
        return this.getManagers(this.SECURITY_MANAGERS, ctxId, remove);
    }

    public <T> ArrayList<WebSecurityManager> getManagersForApp(String appName, boolean remove) {
        return this.getManagersForApp(this.SECURITY_MANAGERS, this.CONTEXT_IDS, appName, remove);
    }

    public <T> String[] getContextsForApp(String appName, boolean remove) {
        return this.getContextsForApp(this.CONTEXT_IDS, appName, remove);
    }

    public WebSecurityManager createManager(WebBundleDescriptor webBundleDescriptor, boolean register, ServerContext context) {
        String contextId = WebSecurityManager.getContextID(webBundleDescriptor);
        WebSecurityManager manager = null;
        if (register) {
            manager = this.getManager(contextId, false);
        }
        if (manager == null || !register) {
            try {
                this.probeProvider.securityManagerCreationStartedEvent(webBundleDescriptor.getModuleID());
                manager = new WebSecurityManager(webBundleDescriptor, context, this, register);
                this.probeProvider.securityManagerCreationEndedEvent(webBundleDescriptor.getModuleID());
                if (register) {
                    String applicationName = webBundleDescriptor.getApplication().getRegistrationName();
                    this.addManagerToApp(contextId, null, applicationName, manager);
                    this.probeProvider.securityManagerCreationEvent(contextId);
                }
            }
            catch (PolicyContextException e) {
                logger.log(Level.FINE, "[Web-Security] FATAL Exception. Unable to create WebSecurityManager: " + e.getMessage());
                throw new RuntimeException(e);
            }
        }
        return manager;
    }

    public <T> void addManagerToApp(String ctxId, String name, String appName, WebSecurityManager manager) {
        this.addManagerToApp(this.SECURITY_MANAGERS, this.CONTEXT_IDS, ctxId, name, appName, manager);
    }

    public UserPrincipal getAdminPrincipal(String username, String realmName) {
        return this.adminPrincipals.get(realmName + username);
    }

    public void putAdminPrincipal(String realmName, UserPrincipal principal) {
        this.adminPrincipals.put(realmName + principal.getName(), principal);
    }

    public Group getAdminGroup(String group, String realmName) {
        return this.adminGroups.get(realmName + group);
    }

    public void putAdminGroup(String group, String realmName, Group principal) {
        this.adminGroups.put(realmName + group, principal);
    }
}

