/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jmac.callback;

import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.auth.login.DistinguishedPrincipalCredential;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.enterprise.security.auth.login.common.LoginException;
import com.sun.enterprise.security.common.AppservAccessController;
import com.sun.enterprise.security.jmac.config.CallbackHandlerConfig;
import com.sun.enterprise.security.jmac.config.GFServerConfigProvider;
import com.sun.enterprise.security.jmac.config.HandlerContext;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.security.web.integration.WebPrincipal;
import com.sun.enterprise.server.pluggable.SecuritySupport;
import com.sun.logging.LogDomains;
import jakarta.security.auth.message.callback.CallerPrincipalCallback;
import jakarta.security.auth.message.callback.CertStoreCallback;
import jakarta.security.auth.message.callback.GroupPrincipalCallback;
import jakarta.security.auth.message.callback.PasswordValidationCallback;
import jakarta.security.auth.message.callback.PrivateKeyCallback;
import jakarta.security.auth.message.callback.SecretKeyCallback;
import jakarta.security.auth.message.callback.TrustStoreCallback;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.x500.X500Principal;
import org.glassfish.internal.api.Globals;
import org.glassfish.security.common.Group;
import org.glassfish.security.common.MasterPassword;
import org.glassfish.security.common.UserNameAndPassword;

abstract class BaseContainerCallbackHandler
implements CallbackHandler,
CallbackHandlerConfig {
    private static final String DEFAULT_DIGEST_ALGORITHM = "SHA-1";
    private static final String CLIENT_SECRET_KEYSTORE = "com.sun.appserv.client.secretKeyStore";
    private static final String CLIENT_SECRET_KEYSTORE_PASSWORD = "com.sun.appserv.client.secretKeyStorePassword";
    private static final Logger LOG = LogDomains.getLogger(BaseContainerCallbackHandler.class, (String)"jakarta.enterprise.system.core.security", (boolean)false);
    protected HandlerContext handlerContext;
    protected final SSLUtils sslUtils;
    protected final SecuritySupport securitySupport;
    protected final MasterPassword masterPasswordHelper;

    protected BaseContainerCallbackHandler() {
        if (Globals.getDefaultHabitat() == null) {
            this.sslUtils = new SSLUtils();
            this.securitySupport = SecuritySupport.getDefaultInstance();
            this.masterPasswordHelper = null;
            this.sslUtils.postConstruct();
        } else {
            this.sslUtils = Globals.getDefaultHabitat().getService(SSLUtils.class, new Annotation[0]);
            this.securitySupport = Globals.getDefaultHabitat().getService(SecuritySupport.class, new Annotation[0]);
            this.masterPasswordHelper = Globals.getDefaultHabitat().getService(MasterPassword.class, "Security SSL Password Provider Service", new Annotation[0]);
        }
    }

    @Override
    public void setHandlerContext(HandlerContext handlerContext) {
        this.handlerContext = handlerContext;
    }

    protected abstract boolean isSupportedCallback(Callback var1);

    protected abstract void handleSupportedCallbacks(Callback[] var1) throws IOException, UnsupportedCallbackException;

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks == null) {
            return;
        }
        for (Callback callback : callbacks) {
            if (this.isSupportedCallback(callback)) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "JMAC: UnsupportedCallback : " + callback.getClass().getName());
            }
            throw new UnsupportedCallbackException(callback);
        }
        this.handleSupportedCallbacks(callbacks);
    }

    protected void processCallback(Callback callback) throws UnsupportedCallbackException {
        if (callback instanceof CallerPrincipalCallback) {
            this.processCallerPrincipal((CallerPrincipalCallback)callback);
        } else if (callback instanceof GroupPrincipalCallback) {
            this.processGroupPrincipal((GroupPrincipalCallback)callback);
        } else if (callback instanceof PasswordValidationCallback) {
            this.processPasswordValidation((PasswordValidationCallback)callback);
        } else if (callback instanceof PrivateKeyCallback) {
            this.processPrivateKey((PrivateKeyCallback)callback);
        } else if (callback instanceof TrustStoreCallback) {
            TrustStoreCallback tstoreCallback = (TrustStoreCallback)callback;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "JMAC: In TrustStoreCallback Processor");
            }
            tstoreCallback.setTrustStore(this.sslUtils.getMergedTrustStore());
        } else if (callback instanceof CertStoreCallback) {
            this.processCertStore((CertStoreCallback)callback);
        } else if (callback instanceof SecretKeyCallback) {
            this.processSecretKey((SecretKeyCallback)callback);
        } else {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "JMAC: UnsupportedCallback : " + callback.getClass().getName());
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    private boolean reuseWebPrincipal(final Subject fs, final WebPrincipal wp) {
        SecurityContext sc = wp.getSecurityContext();
        final Subject wps = sc != null ? sc.getSubject() : null;
        final Principal callerPrincipal = sc != null ? sc.getCallerPrincipal() : null;
        final Principal defaultPrincipal = SecurityContext.getDefaultCallerPrincipal();
        return AppservAccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                if (callerPrincipal == null || callerPrincipal.equals(defaultPrincipal) || wps == null) {
                    return Boolean.FALSE;
                }
                boolean hasObject = false;
                Set<DistinguishedPrincipalCredential> distinguishedCreds = wps.getPublicCredentials(DistinguishedPrincipalCredential.class);
                if (distinguishedCreds.size() == 1) {
                    for (DistinguishedPrincipalCredential cred : distinguishedCreds) {
                        if (!cred.getPrincipal().equals(callerPrincipal)) continue;
                        hasObject = true;
                    }
                }
                if (!hasObject) {
                    return Boolean.FALSE;
                }
                hasObject = wps.getPrincipals().contains(callerPrincipal);
                if (!hasObject) {
                    return Boolean.FALSE;
                }
                if (wp.getName() == null || !wp.getName().equals(callerPrincipal.getName())) {
                    return Boolean.FALSE;
                }
                Iterator<Object> iter = fs.getPublicCredentials().iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (!(obj instanceof DistinguishedPrincipalCredential)) continue;
                    iter.remove();
                }
                fs.getPrincipals().addAll(wps.getPrincipals());
                fs.getPublicCredentials().addAll(wps.getPublicCredentials());
                fs.getPrivateCredentials().addAll(wps.getPrivateCredentials());
                return Boolean.TRUE;
            }
        });
    }

    private void processCallerPrincipal(CallerPrincipalCallback cpCallback) {
        WebPrincipal webPrincipalFromSession;
        Principal sessionPrincipal;
        final Subject fs = cpCallback.getSubject();
        Object principal = cpCallback.getPrincipal();
        if (principal != null && !(principal instanceof WebPrincipal) && (sessionPrincipal = SecurityContext.getCurrent().getSessionPrincipal()) instanceof WebPrincipal && (webPrincipalFromSession = (WebPrincipal)((Object)sessionPrincipal)).getCustomPrincipal() == principal) {
            principal = webPrincipalFromSession;
        }
        if (principal instanceof WebPrincipal) {
            Principal cp;
            WebPrincipal wp = (WebPrincipal)principal;
            if (this.reuseWebPrincipal(fs, wp)) {
                return;
            }
            Principal dp = SecurityContext.getDefaultCallerPrincipal();
            SecurityContext sc = wp.getSecurityContext();
            Principal principal2 = cp = sc != null ? sc.getCallerPrincipal() : null;
            if (wp.getName() == null || wp.equals(dp) || cp == null || cp.equals(dp)) {
                principal = null;
            }
        }
        String realmName = null;
        if (this.handlerContext != null) {
            realmName = this.handlerContext.getRealmName();
        }
        boolean isCertRealm = "certificate".equals(realmName);
        if (principal == null) {
            principal = cpCallback.getName() != null ? (isCertRealm ? new X500Principal(cpCallback.getName()) : new UserNameAndPassword(cpCallback.getName())) : SecurityContext.getDefaultCallerPrincipal();
        }
        if (isCertRealm) {
            if (principal instanceof X500Principal) {
                LoginContextDriver.jmacLogin(fs, (X500Principal)principal);
            }
        } else if (!principal.equals(SecurityContext.getDefaultCallerPrincipal())) {
            LoginContextDriver.jmacLogin(fs, principal.getName(), realmName);
        }
        Object fprin = principal;
        DistinguishedPrincipalCredential fdpc = new DistinguishedPrincipalCredential((Principal)principal);
        AppservAccessController.doPrivileged(new PrivilegedAction<Subject>(){
            final /* synthetic */ Principal val$fprin;
            final /* synthetic */ DistinguishedPrincipalCredential val$fdpc;
            {
                this.val$fprin = principal;
                this.val$fdpc = distinguishedPrincipalCredential;
            }

            @Override
            public Subject run() {
                fs.getPrincipals().add(this.val$fprin);
                Iterator<Object> iter = fs.getPublicCredentials().iterator();
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (!(obj instanceof DistinguishedPrincipalCredential)) continue;
                    iter.remove();
                }
                fs.getPublicCredentials().add(this.val$fdpc);
                return fs;
            }
        });
    }

    private void processGroupPrincipal(GroupPrincipalCallback gpCallback) {
        final Subject fs = gpCallback.getSubject();
        final String[] groups = gpCallback.getGroups();
        if (groups != null && groups.length > 0) {
            AppservAccessController.doPrivileged(new PrivilegedAction<Subject>(){

                @Override
                public Subject run() {
                    for (String group : groups) {
                        fs.getPrincipals().add((Principal)new Group(group));
                    }
                    return fs;
                }
            });
        } else if (groups == null) {
            AppservAccessController.doPrivileged(new PrivilegedAction<Subject>(){

                @Override
                public Subject run() {
                    Set<Principal> principalSet = fs.getPrincipals();
                    principalSet.removeAll(fs.getPrincipals(Group.class));
                    return fs;
                }
            });
        }
    }

    private void processPasswordValidation(PasswordValidationCallback pwdCallback) {
        if (SecurityServicesUtil.getInstance().isACC()) {
            LOG.log(Level.FINE, "JMAC: In PasswordValidationCallback Processor for appclient - will do nothing");
            pwdCallback.setResult(true);
            return;
        }
        String username = pwdCallback.getUsername();
        char[] passwd = pwdCallback.getPassword();
        LOG.log(Level.FINE, "JMAC: In PasswordValidationCallback Processor");
        try {
            String realmName = null;
            if (this.handlerContext != null) {
                realmName = this.handlerContext.getRealmName();
            }
            Subject s = LoginContextDriver.jmacLogin(pwdCallback.getSubject(), username, passwd, realmName);
            GFServerConfigProvider.setValidateRequestSubject(s);
            LOG.log(Level.FINE, "JMAC: authentication succeeded for user = {0}", username);
            if (passwd != null) {
                for (int i = 0; i < passwd.length; ++i) {
                    passwd[i] = 32;
                }
            }
            pwdCallback.setResult(true);
        }
        catch (LoginException le) {
            LOG.log(Level.INFO, "JMAC: login failed for {0}", username);
            pwdCallback.setResult(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPrivateKey(PrivateKeyCallback privKeyCallback) {
        Certificate[] certificateChain;
        PrivateKey privateKey;
        block22: {
            KeyStore[] keyStores = this.securitySupport.getKeyStores();
            LOG.log(Level.FINE, "JMAC: In PrivateKeyCallback Processor");
            if (keyStores == null || keyStores.length == 0) {
                privKeyCallback.setKey(null, null);
                return;
            }
            PrivateKeyCallback.Request request = privKeyCallback.getRequest();
            privateKey = null;
            certificateChain = null;
            if (request == null) {
                KeyStore.PrivateKeyEntry privateKeyEntry = this.getDefaultPrivateKeyEntry(keyStores);
                if (privateKeyEntry != null) {
                    privateKey = privateKeyEntry.getPrivateKey();
                    certificateChain = privateKeyEntry.getCertificateChain();
                }
                privKeyCallback.setKey(privateKey, certificateChain);
                return;
            }
            try {
                if (request instanceof PrivateKeyCallback.AliasRequest) {
                    PrivateKeyCallback.AliasRequest aliasRequest = (PrivateKeyCallback.AliasRequest)request;
                    String alias = aliasRequest.getAlias();
                    KeyStore.PrivateKeyEntry privKeyEntry = alias == null ? this.getDefaultPrivateKeyEntry(keyStores) : this.sslUtils.getPrivateKeyEntryFromTokenAlias(alias);
                    if (privKeyEntry != null) {
                        privateKey = privKeyEntry.getPrivateKey();
                        certificateChain = privKeyEntry.getCertificateChain();
                    }
                    break block22;
                }
                if (request instanceof PrivateKeyCallback.IssuerSerialNumRequest) {
                    PrivateKeyCallback.IssuerSerialNumRequest issuerSerialNumRequest = (PrivateKeyCallback.IssuerSerialNumRequest)request;
                    X500Principal issuer = issuerSerialNumRequest.getIssuer();
                    BigInteger serialNum = issuerSerialNumRequest.getSerialNum();
                    if (issuer != null && serialNum != null) {
                        boolean found = false;
                        for (int i = 0; i < keyStores.length && !found; ++i) {
                            Enumeration<String> aliases = keyStores[i].aliases();
                            while (aliases.hasMoreElements() && !found) {
                                Certificate[] certificates;
                                X509Certificate eeCert;
                                String nextAlias = aliases.nextElement();
                                PrivateKey key = this.securitySupport.getPrivateKeyForAlias(nextAlias, i);
                                if (key == null || !(eeCert = (X509Certificate)(certificates = keyStores[i].getCertificateChain(nextAlias))[0]).getIssuerX500Principal().equals(issuer) || !eeCert.getSerialNumber().equals(serialNum)) continue;
                                privateKey = key;
                                certificateChain = certificates;
                                found = true;
                            }
                        }
                    }
                    break block22;
                }
                if (request instanceof PrivateKeyCallback.SubjectKeyIDRequest) {
                    PrivateKeyCallback.SubjectKeyIDRequest subjectKeyIDRequest = (PrivateKeyCallback.SubjectKeyIDRequest)request;
                    byte[] subjectKeyID = subjectKeyIDRequest.getSubjectKeyID();
                    if (subjectKeyID != null) {
                        boolean found = false;
                        X509CertSelector selector = new X509CertSelector();
                        selector.setSubjectKeyIdentifier(this.toDerOctetString(subjectKeyID));
                        for (int i = 0; i < keyStores.length && !found; ++i) {
                            Enumeration<String> aliases = keyStores[i].aliases();
                            while (aliases.hasMoreElements() && !found) {
                                Certificate[] certificates;
                                String nextAlias = aliases.nextElement();
                                PrivateKey key = this.securitySupport.getPrivateKeyForAlias(nextAlias, i);
                                if (key == null || !selector.match((certificates = keyStores[i].getCertificateChain(nextAlias))[0])) continue;
                                privateKey = key;
                                certificateChain = certificates;
                                found = true;
                            }
                        }
                    }
                    break block22;
                }
                if (request instanceof PrivateKeyCallback.DigestRequest) {
                    PrivateKeyCallback.DigestRequest digestRequest = (PrivateKeyCallback.DigestRequest)request;
                    byte[] digest = digestRequest.getDigest();
                    String algorithm = digestRequest.getAlgorithm();
                    KeyStore.PrivateKeyEntry privateKeyEntry = null;
                    if (digest == null) {
                        privateKeyEntry = this.getDefaultPrivateKeyEntry(keyStores);
                    } else {
                        if (algorithm == null) {
                            algorithm = DEFAULT_DIGEST_ALGORITHM;
                        }
                        MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
                        privateKeyEntry = this.getPrivateKeyEntry(keyStores, messageDigest, digest);
                    }
                    if (privateKeyEntry != null) {
                        privateKey = privateKeyEntry.getPrivateKey();
                        certificateChain = privateKeyEntry.getCertificateChain();
                    }
                    break block22;
                }
                if (!LOG.isLoggable(Level.FINE)) break block22;
                LOG.log(Level.FINE, "invalid request type: " + request.getClass().getName());
            }
            catch (Exception e) {
                try {
                    LOG.log(Level.FINE, "JMAC: In PrivateKeyCallback Processor: Error reading key !", e);
                }
                catch (Throwable throwable) {
                    privKeyCallback.setKey(privateKey, certificateChain);
                    throw throwable;
                }
                privKeyCallback.setKey(privateKey, certificateChain);
            }
        }
        privKeyCallback.setKey(privateKey, certificateChain);
    }

    private byte[] toDerOctetString(byte[] value) throws IOException {
        ByteArrayOutputStream subjectOutputStream = new ByteArrayOutputStream();
        subjectOutputStream.write(4);
        subjectOutputStream.write(this.length2Bytes(value.length));
        subjectOutputStream.write(value);
        return subjectOutputStream.toByteArray();
    }

    private byte[] length2Bytes(int length) {
        if (length <= 127) {
            return new byte[]{(byte)length};
        }
        int byteCount = 1;
        int lengthValue = length;
        while ((lengthValue >>>= 8) != 0) {
            ++byteCount;
        }
        byte[] lengthBytes = new byte[byteCount + 1];
        lengthBytes[0] = (byte)(byteCount | 0x80);
        int pos = 1;
        for (int i = (byteCount - 1) * 8; i >= 0; i -= 8) {
            lengthBytes[pos] = (byte)(length >> i);
            ++pos;
        }
        return lengthBytes;
    }

    private KeyStore.PrivateKeyEntry getDefaultPrivateKeyEntry(KeyStore[] keyStores) {
        PrivateKey privateKey = null;
        Certificate[] certificates = null;
        try {
            for (int i = 0; i < keyStores.length && privateKey == null; ++i) {
                Enumeration<String> aliases = keyStores[i].aliases();
                while (aliases.hasMoreElements() && privateKey == null) {
                    String nextAlias = aliases.nextElement();
                    privateKey = null;
                    certificates = null;
                    PrivateKey key = this.securitySupport.getPrivateKeyForAlias(nextAlias, i);
                    if (key == null) continue;
                    privateKey = key;
                    certificates = keyStores[i].getCertificateChain(nextAlias);
                }
            }
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "Exception in getDefaultPrivateKeyEntry", e);
        }
        return new KeyStore.PrivateKeyEntry(privateKey, certificates);
    }

    private KeyStore.PrivateKeyEntry getPrivateKeyEntry(KeyStore[] kstores, MessageDigest md, byte[] digest) {
        Certificate[] certs;
        PrivateKey privKey;
        block4: {
            privKey = null;
            certs = null;
            try {
                for (int i = 0; i < kstores.length && privKey == null; ++i) {
                    Enumeration<String> aliases = kstores[i].aliases();
                    while (aliases.hasMoreElements() && privKey == null) {
                        String nextAlias = aliases.nextElement();
                        privKey = null;
                        certs = null;
                        PrivateKey key = this.securitySupport.getPrivateKeyForAlias(nextAlias, i);
                        if (key == null) continue;
                        certs = kstores[i].getCertificateChain(nextAlias);
                        md.reset();
                        byte[] cDigest = md.digest(certs[0].getEncoded());
                        if (!Arrays.equals(digest, cDigest)) continue;
                        privKey = key;
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block4;
                LOG.log(Level.FINE, "Exception in getPrivateKeyEntry for Digest", e);
            }
        }
        return new KeyStore.PrivateKeyEntry(privKey, certs);
    }

    private void processCertStore(CertStoreCallback certStoreCallback) {
        block10: {
            KeyStore certStore;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "JMAC: In CertStoreCallback Processor");
            }
            if ((certStore = this.sslUtils.getMergedTrustStore()) == null) {
                certStoreCallback.setCertStore(null);
            }
            ArrayList<Certificate> list = new ArrayList<Certificate>();
            try {
                if (certStore != null) {
                    Enumeration<String> enu = certStore.aliases();
                    while (enu.hasMoreElements()) {
                        String alias = enu.nextElement();
                        if (!certStore.isCertificateEntry(alias)) continue;
                        try {
                            Certificate cert = certStore.getCertificate(alias);
                            list.add(cert);
                        }
                        catch (KeyStoreException kse) {
                            if (!LOG.isLoggable(Level.FINE)) continue;
                            LOG.log(Level.FINE, "JMAC: Cannot retrieve certificate for alias " + alias);
                        }
                    }
                }
                CollectionCertStoreParameters ccsp = new CollectionCertStoreParameters(list);
                CertStore certstore = CertStore.getInstance("Collection", ccsp);
                certStoreCallback.setCertStore(certstore);
            }
            catch (KeyStoreException kse) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "JMAC:  Cannot determine truststore aliases", kse);
                }
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException nsape) {
                if (!LOG.isLoggable(Level.FINE)) break block10;
                LOG.log(Level.FINE, "JMAC:  Cannot instantiate CertStore", nsape);
            }
        }
    }

    private void processSecretKey(SecretKeyCallback secretKeyCallback) {
        String alias;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "JMAC: In SecretKeyCallback Processor");
        }
        if ((alias = ((SecretKeyCallback.AliasRequest)secretKeyCallback.getRequest()).getAlias()) != null) {
            try {
                PasswordAdapter passwordAdapter = null;
                passwordAdapter = SecurityServicesUtil.getInstance().isACC() ? new PasswordAdapter(System.getProperty(CLIENT_SECRET_KEYSTORE), System.getProperty(CLIENT_SECRET_KEYSTORE_PASSWORD).toCharArray()) : this.masterPasswordHelper.getMasterPasswordAdapter();
                secretKeyCallback.setKey(passwordAdapter.getPasswordSecretKeyForAlias(alias));
            }
            catch (Exception e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "JMAC: In SecretKeyCallback Processor:  Error reading key ! for alias " + alias, e);
                }
                secretKeyCallback.setKey(null);
            }
        } else {
            secretKeyCallback.setKey(null);
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "No support to read Principals in SecretKeyCallback.");
            }
        }
    }
}

