/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import com.sun.ejb.codegen.Generator;
import com.sun.ejb.codegen.GeneratorException;
import com.sun.ejb.containers.InternalEJBContainerException;
import com.sun.ejb.containers.RemoteBusinessObject;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.LinkedList;
import org.glassfish.pfl.dynamic.codegen.spi.Type;
import org.glassfish.pfl.dynamic.codegen.spi.Wrapper;

public final class RemoteGenerator
extends Generator {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(RemoteGenerator.class);
    private Class<?> businessInterface;
    private final Method[] methodsToGenerate;
    private final String remoteInterfacePackageName;
    private final String remoteInterfaceSimpleName;
    private final String remoteInterfaceName;

    public static String getGeneratedRemoteIntfName(String businessIntf) {
        String packageName = RemoteGenerator.getPackageName(businessIntf);
        String simpleName = RemoteGenerator.getBaseName(businessIntf);
        String generatedSimpleName = "_" + simpleName + "_Remote";
        return packageName == null ? generatedSimpleName : packageName + "." + generatedSimpleName;
    }

    public RemoteGenerator(ClassLoader classLoader, String businessIntf) throws GeneratorException {
        super(classLoader);
        try {
            this.businessInterface = classLoader.loadClass(businessIntf);
        }
        catch (ClassNotFoundException ex) {
            throw new GeneratorException(localStrings.getLocalString("generator.remote_interface_not_found", "Remote interface not found "));
        }
        this.remoteInterfaceName = RemoteGenerator.getGeneratedRemoteIntfName(this.businessInterface.getName());
        this.remoteInterfacePackageName = RemoteGenerator.getPackageName(this.remoteInterfaceName);
        this.remoteInterfaceSimpleName = RemoteGenerator.getBaseName(this.remoteInterfaceName);
        this.methodsToGenerate = this.removeRedundantMethods(this.businessInterface.getMethods());
    }

    @Override
    public String getPackageName() {
        return this.remoteInterfacePackageName;
    }

    @Override
    public String getGeneratedClassName() {
        return this.remoteInterfaceName;
    }

    @Override
    public Class<?> getAnchorClass() {
        return this.businessInterface;
    }

    @Override
    public void defineClassBody() {
        Wrapper._interface((int)1, (String)this.remoteInterfaceSimpleName, (Type[])new Type[]{Wrapper._t((String)Remote.class.getName()), Wrapper._t((String)RemoteBusinessObject.class.getName())});
        for (Method method : this.methodsToGenerate) {
            this.printMethod(method);
        }
        Wrapper._end();
    }

    private void printMethod(Method m) {
        boolean throwsRemoteException = false;
        LinkedList<Type> exceptionList = new LinkedList<Type>();
        for (Class<?> exception : m.getExceptionTypes()) {
            exceptionList.add(Type.type(exception));
            if (!exception.getName().equals("java.rmi.RemoteException")) continue;
            throwsRemoteException = true;
        }
        if (!throwsRemoteException) {
            exceptionList.add(Wrapper._t((String)"java.rmi.RemoteException"));
        }
        exceptionList.add(Wrapper._t((String)InternalEJBContainerException.class.getName()));
        Wrapper._method((int)1025, (Type)Type.type(m.getReturnType()), (String)m.getName(), exceptionList);
        int i = 0;
        for (Class<?> param : m.getParameterTypes()) {
            Wrapper._arg((Type)Type.type(param), (String)("param" + i));
            ++i;
        }
        Wrapper._end();
    }
}

